/*****************************************************************
 * "Copyright (C) 1985, Digital Research, Inc.  All Rights       *
 * Reserved.  The Software Code contained in this listing is     *
 * proprietary to Digital Research Inc., Monterey, California    *
 * and is covered by U.S. and other copyright protection.        *
 * Unauthorized copying, adaptation, distribution, use or        *
 * display is prohibited and may be subject to civil and         *
 * criminal penalties.  Disclosure to others is prohibited.  For *
 * the terms and conditions of software code use refer to the    *
 * appropriate Digital Research License Agreement."              *
 *****************************************************************/

/*===============================================================*
 *   Version 1.6	IIFDPHY.C                                *
 *                      Contains the Physical Access routines for*
 *                      the ports,etc.                           *
 *---------------------------------------------------------------*
 *    VERSION   DATE    BY      CHANGE/COMMENTS                  *
 *---------------------------------------------------------------*
 *    1.0       6/12/85 reb     rewritten/added to system        *
 *    1.1       6/17/85 reb     changed calls yabnc to _bmove    *
 *    1.2	6/12/86 mei	High C port.			 *
 *    1.3	7/07/86 FRH	Fix Lattice Bug introduced in HC *
 *				Port.                            *
 *    1.4       11/11/86 KPB     Cast FDG_Ubuff to long to work  *
 *                              around a metaware bug. That      *
 *                              causes a GP.                     *
 *    1.5       01/23/87 KPB    Added KillTime and INPW to slow  *
 *                              down floppy. Also OUTPW          *
 *    1.6	10/07/87 glp	fdc_specify was not forming hlt  *
 *				and nd correctly.  fd_reset was	 *
 *				not setting up CurTF.		 *
 *===============================================================*
 *  INCLUDES:                                                    */
VOID KillTime()
{
}

/************************************************************************
*                               FDPHYS                                  *
*               routines to do the physical dirty work                  *
*                                                                       *
************************************************************************/


/*********************************************************************
*  fd_pgfault -
*       handles condition where the i/o will cross a page boundary.
*       The calling routines should have split up the i/o so that
*       the offending i/o request is only for 1 sector.
*/

VOID    fd_pgfault()
{
        IORB    *i ;
        WORD    nb1 ;

        i = &FDU->fu_iorb ;

        FDG_PGFAULT = TRUE ;
        FDG_Ubuff = (BYTE*)i->io_buffer ;       /*  save users buffer addr  */

        /*  M0011  */

        nb1 = FDU->fu_lddp->ld_mdb.md_secsiz ;

        if( i->io_op == DKWRITE )               /*  [1]  */
{
                mapu( FDU->fu_b_pdaddr ) ;
                _bmove( FDG_Ubuff, SPC_BUFF , (WORD)nb1 ) ;
                unmapu() ;
}

        i->io_buffer = (SYSADDR) SPC_BUFF ;     /*  use this addr for i/o  */
        i->io_dmaddr = PADDR( (SYSADDR) SPC_BUFF ) ;    /*  cvrt for dma   */
        i->io_dmcount = nb1 ;                   /*  1 sector's worth       */
}

/*
** [1]  if this is a write, we must copy the user's buffer into the page 
**      page buffer.  We must also call mapu to ensure that the requesting
**      process' memory is in context.  We do NOT worry about the possibility
**      of the process being SWAPPED OUT of memory (mapu returns an emask).
*/

/*********************************************************************
*  fd_pgend -
*       cleans up mess caused by page fault.
*/

VOID    fd_pgend()
{
        IORB    *i ;
        WORD    bytecount ;

        i = &FDU->fu_iorb ;

        if (! i->io_error) {
                if  (i->io_op == DKREAD)  {

                  /*  no error, and this was a read; copy data into users buffer [2] */
                  bytecount = i->io_dmcount ;
                  mapu( FDU->fu_b_pdaddr ) ;
                  _bmove( (BYTE *)(i->io_buffer - bytecount), FDG_Ubuff  , bytecount ) ;
                  unmapu() ;
                  i->io_buffer = (LONG) (FDG_Ubuff + bytecount) ;       /*  [1]  */
                }
                if (i->io_op == DKWRITE ) {             /* (reb) bugfix */
                  i->io_buffer = (LONG) ((LONG) FDG_Ubuff + i->io_dmcount ) ;
                }
        }

        /*  M0011  */
        FDG_PGFAULT = FALSE ;                   /*  no more fault          */
}

/*
** [1]  we update the buffer pointer here because the pointer which was 
**      updated in fd_io() was the buffer the data was read into; in this
**      case, the page buffer (PGBUFF).  We must update the user's buffer
**      pointer so that normal i/o can continue.
**
** [2]  we call mapu to ensure that the requesting process' memory is in 
**      context.  We do NOT worry about the possibility of the process being 
**      SWAPPED OUT of memory (mapu returns an emask).
*/

/*********************************************************************
*  buildtf -
*       build the task file
*/

VOID	buildtf( f , i , l )
FDTF    *f ;
IORB    *i ;
LDD     *l ;
{
        /**********/

        /*
        *  iogap -
        *  table for i/o gaps.  indexed by (dens,N) where dens is 0 if the
        *  density is FM format, and 1 if MFM format; and N is the bytes per
        *  sector indicator.
        */ 
#if ( MACHINE == XMACHINE )
        static BYTE     iogap[2][6] = 
                { 
                  { 0x10, 0x18, 0x46, 0xc8, 0xc8, 0x00 },
                  { 0x00, 0x20, 0x2a, 0x80, 0xc8, 0xc8 }
                } ;
#endif
#if ( MACHINE == COMPUPRO )
        static BYTE     iogap[2][6] = 
                { 
                  { 0x07, 0x0e, 0x1b, 0x35, 0xc8, 0xc8 },
                  { 0x0e, 0x1b, 0x35, 0x35, 0xc8, 0xc8 }
                } ;
#endif

        BYTE
                *cf,    /*  pointer to command file in task file        */
                cc,     /*  command code                                */
                N ;     /*  temp for N variable in command file         */

        WORD    j ;     /*  loop counter                                */

        /**********/


        cf = &f->fd_cmd[0] ;    /*  cf => command file          */
        cc = CmdCode(i->io_op) ;        /*  cc = fdc opcode             */
        if( l->ld_ddens )               /*  if double density           */
                cc |= FCMMFM ;          /*      turn on mfm bit         */
        *cf = cc ;                      /*  store cmd code in cmd file  */

        *++cf = (i->io_dkaddr.hsc_head << 2) | FDDRIVE ;/*  select byte */

        *++cf =                         /*  fd_cmd[2] = C       */
          (BYTE) i->io_dkaddr.hsc_cyl ; /*  (starting cyl nbr)  */

        *++cf =                         /*  fd_cmd[3] = H       */
          i->io_dkaddr.hsc_head;        /*  (starting head nbr) */

        *++cf =                         /*  fd_cmd[4] = R       */
          i->io_dkaddr.hsc_sector;      /*  (starting rec (sec))*/

        *++cf = N =                     /*  bytes per sector    */
          bpsi(l->ld_mdb.md_secsiz) ;   /*    indicator         */

        *++cf =                         /*  fd_cmd[6] = EOT     */
          i->io_dkaddr.hsc_sector + i->io_nsecs - 1 ;
                                        /* (Ending Sector Nbr)*/

        *++cf = 
          iogap[ (l->ld_ddens ? 1 : 0) ][ N ] ;

        *++cf =                         /*  fd_cmd[8] = DTL     */
          ( N ? 0xff : 128 ) ;          

        for (j = RFMAX , cf = &f->fd_res[0] ; j-- ; )
                *cf++ = 0 ;             /*  clear result file   */

}

/******************************************************************************
*  fd_BCHRN -
*       Build the CHRN buffer from either the starting sector number and nbr of
*       sectors per track (opt == 0) or the sector list (opt == 1).
*/

BOOLEAN fd_BCHRN( u )
FDLUTE  *u ;
{
        WORD    *Rptr ;         /*  ptr to sector list (if that's the case) */
        IORB    *i ;            /*  ptr to i/o request block                */
        BYTE    *b ;
        WORD    nsecs, cnt ;    /*  nbr of sectors, and sector count        */
        BYTE    C,H,R,N ;       /*  Cyl, Head, Record# (sector), bytsec ind */
        BOOLEAN br ;            /*  boolean return code                     */

        br = FALSE ;            /*  pessimistic initialization              */
        i = &u->fu_iorb ;
        b = (BYTE*) i->io_buffer ;
        cnt = nsecs = i->io_nsecs ;     /*  sectrk in io_nsecs field    */

        C = i->io_dkaddr.hsc_cyl ;
        H = i->io_dkaddr.hsc_head ;
        N = bpsi( (WORD) i->io_stssn  ) ;       /*  bytsec in io_stssn  */

        if(  ( H > 1 )  || (!N)  ||  (!(N+1))  )        /*  [1] */
                GOTO fdB_return ;               

        if(  i->io_op == DKFMT )                /*  not list format       */
        {
                for( R = i->io_dkaddr.hsc_sector ; cnt-- ; )
                {
                        *b++ = C ; *b++ = H ; *b++ = (BYTE) R++ ; *b++ = N ;
                        if( R > nsecs ) 
                                R = 1 ;
                }
        }       
        else                                    /*  list format         */
        {
                for( Rptr = (WORD*) i->io_totnsecs ; cnt-- ; )
                {
                        *b++ = C ;  *b++ = H ; 
                        *b++ = (BYTE) *Rptr++ ; 
                        *b++ = N ;
                }
        }

        br = TRUE ;

fdB_return:
        return(br) ;
}


/*
*  [1]  (N == -1) means illegal bytes per sector.  
*       (N ==  0) menas 128 bytes per sector, not supported in this version
*/


/**************************************************************************
*  FOutCmd2Fdc -
*       Output a high level disk command to the fdc.  The number of
*       bytes required for each command is contained in the CmdLen
*       table.  the f parm is a pointer to the appropriate
*       task file.
*
*/

BOOLEAN FOutCmd2Fdc( f )
FDTF    *f ;            /*  ptr to Task File                    */
{
        /**********/

        /*
         *      This table is used to quickly find out the
         *      length of the command to be output.
         */

        static BYTE     CmdLen[] = 
          { 0,0,9,3,2,9,9,2,1,9,2,0,9,6,0,3,0,9,0,0,0,0,0,0,0,9,0,0,0,9,0,0 } ;

        BYTE    *c ;            /*  ptr to Command task file string     */
        WORD    ccnt ;          /*  command count                       */

        /**********/

#if     (MACHINE == XMACHINE)
        OUTPW( XPORT , xval[ FDDRIVE ] ) ;
#endif

        CurTF = f ;

        for( c = &f->fd_cmd[0] , ccnt = CmdLen[*c & 0x0f] ; ccnt-- ; )
        {
                if( ! (FOutByte2Fdc(*c++))  )
                {
                        /*  error in output  */
                        StuckFdc = TRUE ;
                        return( FALSE ) ;
                }
        }
        return( TRUE ) ;
}


/**************************************************************************
*  FInResFromFdc -
*       input the result data from the fdc during the result phase (after
*       command execution).  The f parm is a pointer to the appropriate
*       task file.
*/

BOOLEAN FInResFromFdc( f )
FDTF    *f ;    /*  ptr to task file                            */
{
        /**********/
        WORD    rc ;    /*  result count                                */
        BYTE    *r ;    /*  pointer to result file in task file         */
        BYTE    s  ;    /*  status from input byte routine              */

        BYTE    charbuf, *b = &charbuf ;        /*  for input byte rtn  */

        /**********/


        r = &f->fd_res[0] ;

        for( rc = 0 ; rc < RFMAX ; rc++ )
        {
                if( (s = FInByteFromFdc(b))  == 0 ) /*  error       */
                {
                        return( FALSE ) ;
                }
                if( s == FCOMPLETE )                    /*  end of res  */
                {
                        return( TRUE ) ;
                }
                *r++ = *b ;             /*  copy into result file       */
        }

        
        if((s = INPW(FSTPORT))  &  (FSTFBSY + FSTDIO)) {
                /*  fdc is still busy or still wants us to input something  */
                /*  that's bad, cause we have no intention of doing something about it */
                return( FALSE );
                }
        else {  
                return( TRUE ) ;
        }
}


/************************************************************************
*  fdc_specify -
*       output specify parameters to fdc.
*/

ERROR   fdc_specify( srt , hut , hlt , nd )
BYTE
        srt ,           /*  step rate                                   */
        hut ,           /*  head unload time                            */
        hlt ,           /*  head load time                              */
        nd ;            /*  no dma mode                                 */
{
        ERROR   r ;

        r = (ED_DISK | E_DKATTACH);      /*  default error               */

        if(  FOutByte2Fdc( FCMSPEC )  )

            if(  FOutByte2Fdc(  srt << 4  |  hut  )  )

                if(  FOutByte2Fdc(  (hlt << 1) |  nd  )  )

                    r = SUCCESS ;

        return( r ) ;
}

/**************************************
**  fd_IntStatus -
**      output a sense interrupt cmd 
**      and read in the result file
*/

BOOLEAN fd_IntStatus( f )
FDTF    *f ;
{

                if( !FOutByte2Fdc(FCMSIS) || !FInResFromFdc(f) )
                        return( FALSE ) ;
                return( TRUE ) ;
}

/**************************************
**  fd_DriveStatus -
**      output a sense drive status cmd 
**      and read in the result file
*/

BOOLEAN fd_DriveStatus( d , f )
BYTE    d ;                     /*  drive on which to sense status      */
FDTF    *f ;                    /*  ptr to task file to use for command */
{
        f->fd_cmd[0] = FCMSDS ;         /*  sense drive status cmd      */
        f->fd_cmd[1] = d ;              /*  drive number                */

        return(   FOutCmd2Fdc( f )  &&  FInResFromFdc( f )   ) ; }

/**************************************
**  fd_reset -					Called by ASRs and a ISR
**      reset the FDC and curr cyl.
**
*/
VOID    fd_reset()
{

static	FDTF	ResetTF ;		/* task file for reset command	*/

	CurTF = &ResetTF ;		/* flop_interrupt assumes CurTF is
					pointing to a Task File		*/
        OUTPW(FDCPORT, dor_image & ~(0x04)) ;/*  enab intrs, dma, reset	*/
        OUTPW( FDCPORT , dor_image ) ;       /*  same, but disab reset	*/
        CurCyl[ 0 ] = CurCyl[ 1 ] = -1 ;    /*  force recals on next io */
        IoInProg = FALSE ;
}

/************************************************************************
 *                                                                      *
 *                      Floppy Driver Primitives                        *
 *                                                                      *
 ************************************************************************/



/**************************************************************************
 *  FOutByte2Fdc -
 *      Output a single command/parm byte to the fdc.
 *
 */

BOOLEAN FOutByte2Fdc( byte )
BYTE    byte ;
{
        if( ! Frdy4cmd()  )
                return( FALSE );
        
        OUTPW( FCMPORT , byte ) ;
        return( TRUE ) ;
}


/**************************************************************************
 *  FInByteFromFdc -
 *      Input a single result byte from the fdc. 
 *
 */

BYTE    FInByteFromFdc( b )
BYTE    *b ;            /*  place to put input byte                     */
{
        /**********/
        BYTE    s ;     /*  status returned from Frdy4res               */

        /**********/


        if( (s = Frdy4res())  == 0 ) 
                return( FALSE );

        if( s == FCOMPLETE )
                return( FCOMPLETE ) ;

        *b = INPW(FDAPORT) ;
        return(TRUE) ;
}


/**************************************************************************
 *  Frdy4cmd -
 *      wait until fdc is ready to receive command / parameter bytes
 *      in the command phase.  The fdc is ready to receive cmd bytes when
 *      the RQM flag is high and thef DIO flag is low.
 *
 *      exit:  TRUE:    fdc is ready for command
 *              FALSE:  fdc is not ready for command, it is ready for status
 */

BOOLEAN Frdy4cmd()
{
        md_tburn(0) ;   /*  RQM takes a while                           */
        
        /*  wait for RQM  */
        while(     ! (INPW(FSTPORT)  &  FSTRQM)       ) ;        /*  M0017 */

        if(  !  (INPW( FSTPORT )  &  FSTDIO)    )
                return( TRUE ) ;
        else
                return( FALSE ) ;

}

/**************************************************************************
 *  Frdy4res -
 *      wait until the fdc is ready to return data bytes in the result
 *      phase.  The fdc is ready to return a result byte when the RQM and
 *      DIO flags are both high.  
 *
 *      According to the Intel manuals, "The busy flag in the main status 
 *      register will remain set until the last data byte of the result 
 *      phase has been read by the processor."  This is not always true,
 *      as when an abnormal termination of a command occurs, the FDC may
 *      show not busy, even though one of the Drives do show busy.  When
 *      the Sense Interrupt Status command is given, and the first byte
 *      of the result stream is read, the Drive busy flag drops, and the
 *      only indication that the FDC needs to be read is the DIO flag.  So..
 *
 *      returns:
 *              TRUE            if both RQM and DIO are high
 *              FALSE           if RQM is low and FDC is not busy (error!)
 *              FCOMPLETE       if RQM is high and DIO is low
 */

BYTE    Frdy4res()
{
        BYTE    r ;     /*  return code  */
        BYTE    s ;     /*  status as read from fdc status port */


        md_tburn(0) ;   /*  RQM takes a while                           */

        s = INPW(FSTPORT) ;

        switch( s & (FSTDIO + FSTRQM) )
        {
                case 0:                         /*  neither */
                case FSTDIO:                    /*  No RQM  [1] */
                        if( !( s & FSTFBSY )  ) 
                                r = FALSE ;
                        else
                        {
                                /*  fdc is busy, it should be through   */
                                /*  in just a silli milli second        */
                                while( (INPW(FSTPORT) & FSTFBSY)  ) ;
                                r = Frdy4res() ;
                        }
                        break ;

                case FSTRQM:                    /*  RQM only */
                        r = FCOMPLETE ;
                        break ;                                         

                case (FSTRQM + FSTDIO):         /*  both  */
                        r = TRUE ;
                        break ;
        }
        return(r) ;
}

/*  [1] -  This whole business about testing the RQM bit separately from
        the DIO bit looks a little fishy to me...  But it is in every Intel
        sample code I've seen... as if they expect it to come up micro 
        seconds before DIO... If you suspect the while loop to cause
        an indefinite wait, by all means, yank it out.
                        - ktb 6/24/84
*/


/**************************************************************************
*  CmdCode -
*       translate a command code into an fdc operation code.
*/

BYTE    CmdCode(op)
BYTE    op ;
{
        switch(op)
        {
                case DKREAD:    return( FCMRD ) ;
                case DKVFY:     return( FCMRD ) ;       /* (reb) added verify support */
                case DKWRITE:   return( FCMWR ) ;
                case DKRDID:    return( FCMRDID ) ;
                case DKRDTRK:   return( FCMRTRK ) ;
                case DKFMT:     
                case DKFMTLST:  return( FCMFMT ) ;
                case DKRECAL:   return( FCMRECAL ) ;
                default:        return( 0 ) ;
        }
}
/**************************************************************************
*  bpsi -
*       returns bytes per sector indicator, given a word value of the number
*       of bytes per sector (1,2,...).
*/
BYTE    bpsi( n )
WORD    n ;
{
        static BYTE     bpsa[18] =
        {
        /*      0   1   2   3   4   5   6   7   8                       */
                0,  1,  2, -1,  3, -1, -1, -1,  4,
               -1, -1, -1, -1, -1, -1, -1, -1,  5
        } ;

        BYTE    n1 ;

        n1 = n / 256 ;                  /*  shift:  128 -> 0, 256 -> 1, ... */
        return( bpsa[ n1 ] ) ;
        
}


/*****************************************************************************
*  md_tburn -
*       burn up time for the fdc.  
*/

#define TB0VAL  0x10
#define TBN0VAL 0x1000

VOID    md_tburn( lc )
WORD    lc ;            /*  loop count                                  */
{
      long    i ;

	if( !lc )
                for( i = TB0VAL ; i-- ; )
                        ;
        else while( lc-- )                      
 		for( i = 0x1000 ; --i ; )
                        ;
}
