/*****************************************************************
 * "Copyright (C) 1985  Digital Research, Inc.  All Rights       *
 * Reserved.  The Software Code contained in this listing is     *
 * proprietary to Digital Research Inc., Monterey, California    *
 * and is covered by U.S. and other copyright protection.        *
 * Unauthorized copying, adaptation, distribution, use or        *
 * display is prohibited and may be subject to civil and         *
 * criminal penalties.  Disclosure to others is prohibited.  For *
 * the terms and conditions of software code use refer to the    *
 * appropriate Digital Research License Agreement."              *
 *****************************************************************/

/*======================================================================*
 *   Version 1.5.00     IIFDTIM.C                                	*
 *                      Contains Timer routines for timeouts etc.	*
 *----------------------------------------------------------------------*
 *    VERSION   DATE    BY      CHANGE/COMMENTS                  	*
 *----------------------------------------------------------------------*
 *  1.5.01	88Jan24 glp	Removed change 1.5.00 88Jan19 as we no longer
 				use fd_poll to aid in resetting the DCL.
				*** 1.5.01 88Jan24 ***
 *  1.5.00	88Jan19	glp	On time outs clear dcl_next, just in case
 				fd_poll is running. SPR 1862.
				*** 1.5.00 88Jan19 ***
 *    1.5	10/1/87 KPB	Fix for SPR #IF00060 in line 164. If the event
 				completes before we cancel it then we must get
 				the return code, to free the event mask. See
				fd_ClearTimer.
 *    1.4       3/10/87 KPB     Added Cancel Clean up            	*
 *    1.3       1/27/87 KPB     Added INPW and OUTPW for386      	*
 *    1.2	6/12/86 mei	High C port.			 	*
 *    1.1       6/20/85 reb     corrected error set in fd_timesup	*
 *    1.0       6/12/85 reb     rewritten/added to system        	*
 *======================================================================*
 *  INCLUDES:                                                    	*/

/***************************************************************************
**                              fdtimer
**          contains code that accomplishes timeout support when writing to
 (reading from) the FDC
**
***************************************************************************/

/*
**  CONSTANTS
*/

#define RELTIME                 0
#define ABSTIME                 1


/*
**  EXTERNALS
*/

EXTERN  FDLUTE  *FDU ;
EXTERN  IORB    *FDI ;
EXTERN  BYTE    FDDRIVE ;

EXTERN  BOOLEAN StuckFdc ;
EXTERN  FDTF    *CurTF ;
EXTERN  FDLUTE  *FDGLUT ;

EXTERN  ERROR   fd_ErrorAnal() ;
EXTERN	BYTE 	INPW();

/*
**  GLOBALS
*/

EMASK   TimerEmask = 0 ;
LONG    NbrOfTimeOuts = 0 ;



/**************************************
** fd_SetTimer -
**      set a timer to interrupt us if
**      the operation does not generate
**      an interrupt
*/

#if     TIMEOUTS

VOID    fd_SetTimer( s )
WORD    s ;                             /*  number of seconds   */
{
        DOASR( fd_asettime , (LONG) (s * 1000) , 0L , 199 ) ;   /*  [1]  */
}

#else

VOID    fd_SetTimer()
{}

#endif


/*
** [1]  must be at a higher priority (lower value) than the timer ASR (spun 
**      off by the tick interrupt handler).
*/



/**************************************
*  fd_asettime -
*       async portion of set timer [1]
*/

VOID    fd_asettime( time )
LONG    time ;
{
#if     TIMEOUTS

        EXTERN	ENUM    e_timer() ;

        TimerEmask = e_timer( 0L , RELTIME , time ) ;
        NEXTASR( TimerEmask , fd_TimesUp , 0L , 0L , 250 ) ;/* [2] */

#else

        return ;

#endif
}
/*
** [1]  must be run in asr context.  note that some of the routines which 
**      call fd_SetTime() are run in ISR context.
** 
** [2]  priority needs to be lower (higher value) than the ASRs spun off by
**      the floppy ISR, because if we get the interrupt, we want to shut off 
**      the alarm; since we can't cancel the alarm in ISR mode, we must spin 
**      off an ASR to do it, and we must ensure that this ASR runs before the
**      TimesUp ASR, even if the specified time should pass between the time
**      we get the interrupt and the time the ASR with the cancel in it is 
**      run.  
*/

/**************************************
**  fd_ClearTimer -
**      cancel the timer.
*/

VOID    fd_ClearTimer()
{

#if     (TIMEOUTS == FALSE)
        return ;
#else
        DOASR( fd_acleartime , 0L , 0L , 199 ) ;  
#endif
}



/*  see notes in fd_asettime */

#if     TIMEOUTS
/**************************************
*  fd_acleartime -
*       async portion of cancel timer.
*/

VOID    fd_acleartime()
{

        if(TimerEmask)
        {
/*	    s_cancel( TimerEmask );	*/
            if( s_cancel( TimerEmask ) != 0L )  /* Line 1 KB - 10/01/87  */
		ARET( TimerEmask );		/* Line 2 KB - 10/01/87  */

            TimerEmask = 0L;
        }
           
}
#endif



#if     TIMEOUTS

/**************************************
** fd_TimesUp - 
**      Timer has expired.
*/

VOID    fd_TimesUp( ) 
{
        /**********/
        static FDTF             TimeTF;

        LONG                    r ;
        WORD                    i ;
        BYTE                    s ;
        BYTE                    LastCmd ;
        /**********/

         if(!TimerEmask)
           return;

        /*  desired interrupt was never detected  */

        NbrOfTimeOuts++ ;               /*  debug               */
        ARET( TimerEmask ) ;            /*  clear event         */
                                        /*  M0007               */

#if 0				/* 1.5.01 88Jan24 */

/* 1.5.00 88Jan19 (start) */
	if (!dcl_next)
	{	  /* On timeouts while doing reset_dcl, fake a
		  happy DC so that we do not have to worry about
		  canceling ASRs that do the reset_dcl.		*/
	        CurCyl[ FDDRIVE ] =  -1 ;	/* Indicate a need for recal */
		dcl_next = TRUE;		/* Hd_poll will like this    */
		return;
	}
/* 1.5.00 88Jan19 (end) */

#endif				/* 1.5.01 88Jan24 */

        LastCmd = CurTF->fd_cmd[0] & 0x1f ;
        r = 0L ;


        if( FDCBUSY )                   /*  [7]                 */
        {
#if     (MACHINE == XMACHINE)
                r = (ED_DISK | E_READY ) ;
#endif
                GOTO tu_dkexit ;
        }

        if( StuckFdc )                  /*  [6]                 */
        {
                StuckFdc = FALSE ;
                GOTO tu_dkexit ;
        }


        s = Frdy4res() ;                /*  see if FDC wants to be read  */

        if( ! s )                       /*  RQM low and FDC is not busy */
        {
                GOTO tu_dkexit ;
        }

        if( s == TRUE )                 /*  careful! [1]                */
        {
                /*  if s == TRUE , then the FDC wants to be read        */
                /*  input result file   */

                if(  ! FInResFromFdc( &TimeTF )  ) 
                        GOTO tu_dkexit ;

                if( ( r = fd_ErrorAnal( &TimeTF ) ) != NULLPTR  )
                        GOTO tu_dkexit ;        
        }

        if( ! fd_IntStatus(&TimeTF)  )  /*  get intr status     */
                GOTO tu_dkexit ;


        /* 15 may (gam) remover do { } while loop & modified error check */
        if( TimeTF.fd_res[0] & 0xc0 != 0x80 )   /*  error in res file   */
                for ( i = 15; TimeTF.fd_res[0] & 0xc0 != 0x80; i--)
                {
                        /*  
                        **  intr occurred for overlapped oper'n 
                        **      and we missed it ! [2]          
                        */

                        if( ! fd_IntStatus(&TimeTF)  )
                          GOTO tu_dkexit ;
                        r = (ED_DISK |E_DKATTACH);                /*  [3]  */
                        
                } 
        else
        {
                /*  
                **  no interrupt from controller/drive  
                **  interrogate the drive               
                */

                if( ! fd_DriveStatus( FDDRIVE , &TimeTF )  )
                        GOTO tu_dkexit ;

                s = TimeTF.fd_res[0] ;

                /*
                **      check for read or write fault
                */

                if( s & 0x80 )                  /*  fault flag  */
                {
                        r = (ED_DISK | E_READFAULT);     
                        if( LastCmd != FCMRD )
                        {
                            r = (ED_DISK | E_WRITEFAULT);   
                            if( LastCmd != FCMWR && LastCmd != FCMFMT )
                                r = (ED_DISK | E_GENERAL);
                        }
                }

                /*
                **      check for write protection on write or format
                */

                else if                         /*  write prot  */
                (  
                (s & 0x40) && ( (LastCmd == FCMWR) || (LastCmd == FCMFMT) )
                )
                        r = (ED_DISK | E_WPROT);

                /*
                **      check for drive not ready
                */

                else if( ! (s & 0x20) )         /*  ready flag  */

                        r = (ED_DISK | E_READY);

        } /*  end else - no missing interrupts  */

tu_dkexit:
        fd_reset() ;
		FDI->io_error = r ;
        if( !r ) 
        FDI->io_error = (ED_DISK | E_DKATTACH) ;    /* so, set error code     */
        flop_iocomp();
}

#endif



/*
** [1]  Frdy4res returns three possible values, TRUE is only one of the 
**      two non-zero possible return values.
**        returns:
**              TRUE            if both RQM and DIO are high
**              FALSE           if RQM is low and FDC is not busy (error!)
**              FCOMPLETE       if RQM is high and DIO is low
**
**
** [2]  if we output an interrupt status command and don't get an invalid 
**      command status returned, then an interrupt has occurred, but was never
**      serviced.  
**
** [3]  now, other errors may have occurred but the important thing is that 
**      we missed an interrupt.  We will report this as attatch failed 
**
**      IGNORE [4] for now...
** [4]  if fd_ErrorAnal reports no errors, then it would seem we have missed an
**      interrupt... therefore the error returned should indicate a lost 
**      interrupt of some sort.
**      END IGNORE [4]
**
** [5]  Pick an error... Dos doesn't seem to have a fault error for operations
**      other than read or write.
**
** [6]  StuckFdc is set when OutCmd2Fdc determines that the FDC has gotten
**      "stuck".
**
**      A StuckFdc overides the FDCBUSY test for dooropen, which is rather 
**      dubious anyway (however, it's all we got).
**
** [7]  For the XMACHINE...
**      The FDC will be busy if the door is open when an i/o command is output.
**      It will stay busy until the drive goes ready again.  If 
**      the FDC is busy, no commands may be output to it, and no status can
**      be read (except busy status).  On the XMACHINE, we must reset the 
**      FDC via the Digital Input Register reset line.  
**
**      For the COMPUPRO...
**      assume the fdc is stuck.
*/
