/********************************************************************
 *	POLYLINE.C -- Sample program                                *
 *------------------------------------------------------------------*
 *	From: GEM Virtual Device Interface Reference Guide, p.2-18  *
 *==================================================================*
 *	INCLUDES:                                                   */ 
#include "portab.h"
#include "vdibind.h"
#include "vdilib.h"

EXTERN	LONG	s_open(), s_close();

	VOID	main();

	WORD	work_in[11];
	WORD	work_out[57];
	WORD	pxyarray[12];
	WORD	max_length;

	WORD	echo_mode;
	WORD	echo_xy[2];
	WORD	string[1];

	LONG gdvr;
	BYTE *GDRV = "vdi01:";
	WORD handle;
	WORD contrl[12], intin[50], ptsin[50], intout[50], ptsout[50];

VOID main()
{
	int	i;

/* Open a virtual console graphics full plane, put it on top */

    gdvr = s_open(0, GDRV);

	for( i = 0; i < 11; i++ )
	    work_in[i] = 0;

	work_in[0] = 1;
	work_in[1] = 1;
	work_in[2] = 1;
	work_in[10] = 0;

	v_opnwk( work_in, &handle, work_out );

	pxyarray[0] = 12000;
	pxyarray[1] = 12000;
	pxyarray[2] = 12000;
	pxyarray[3] = 20000;
	pxyarray[4] = 14000;
	pxyarray[5] = 24000;
	pxyarray[6] = 16000;
	pxyarray[7] = 20000;
	pxyarray[8] = 16000;
	pxyarray[9] = 12000;
	pxyarray[10] = 12000;
	pxyarray[11] = 12000;

	v_pline( handle, 6, pxyarray );

	max_length = sizeof( string );

	echo_mode = 0;
	echo_xy[0] = 12000;
	echo_xy[1] = 12000;

	vrq_string( handle, max_length, echo_mode, echo_xy, &string );

	v_clswk( handle );

	s_close( 0, gdvr );

}
