echo off
cls
echo Ŀ
echo                                                                          
echo         CONFIG.BAT -- FlexOS System Configuration Batch File             
echo                                                                          
echo             Standard Drivers installed in FlexOS:                        
echo                                                                          
echo                 fd0:    - floppy diskette driver     ( A: )              
if not exist hd0: goto portecho
echo                 hd0:    - hard disk driver           ( C: )              
:portecho
echo                 pt0:    - port device sub-driver                         
rem
rem  ---------------------------------------------------------------------
rem    NOTE: The traditional IBM PORT format is not the same
rem          in FlexOS, i.e.,
rem
rem              PT0: is equivalent to COM2:
rem              PT1: is equivalent to COM1:
rem  ---------------------------------------------------------------------
rem
echo                 con0:   - console device driver                          
echo                                                                          
echo             Optional Drivers loaded by FlexOS via CONFIG.BAT:            
echo                                                                          

rem 
rem  ---------------------------------------------------------------------
rem  NOTE:  This file uses standard FlexOS batch file and device driver 
rem  commands, and the DEFINE command to automatically configure the system.
rem  For a complete explanation of each command used in this file, see the 
rem  User's Reference Guide, and the Configuration Guide.
rem  ---------------------------------------------------------------------
rem
rem  Define the dash (-) as the default separator for command-line 
rem  options in FlexOS commands.
rem
     define switchar = -
rem
rem  The following commands set up the required directories depending on 
rem  whether your system boots from floppy diskette or from the hard disk.
rem
     if exist hd0: goto HARDDISK
rem
rem  ---------------- Booting from Floppy Disk Defines -------------------
rem
rem  Define the system, boot, and default directories for a floppy disk
rem  bootable system:
rem
     define -s system: = fd0:\bin\
     define -s boot:   = fd0:
     define -s drv:    = fd0:\drivers\
     define default:   = a:

goto PROCDEFS

:HARDDISK
rem  ----------------- Booting from Hard Disk Defines --------------------
rem
rem  Define the system, boot, and default directories for a hard disk 
rem  bootable system:
rem
     define -s system: = hd0:\bin\
     define -s boot:   = hd0:
     define -s drv:    = hd0:\drivers\
     define default:   = c:

:PROCDEFS
rem  ---------------------------------------------------------------------
rem  Establish various PROCESS LEVEL definitions using DEFINE commands.
rem  ---------------------------------------------------------------------
rem
rem  Define the logical name for the main system console.
rem
     define con = con:console
rem
rem  Define the default directory search path. 
rem
     define path = default: system:
rem
rem  Define the default search order for file type (suffix).
rem
     define order = 286 exe bat

rem
rem  ---------------------------------------------------------------------
rem  The following 3 defines will be redefined by LOGON.286 according to
rem  USER.TAB if the system-level define PROTECT is set to ON.  If PROTECT
rem  is set to OFF, then the following 3 defines will remain as is.
rem  ---------------------------------------------------------------------
rem
rem  Define the default Window Manager.
rem
     define wmanager = system:wmex.286    
rem
rem  Define the default shell program for handling user input/output.
rem
     define shell = boot:command.286
rem
rem  Define a default HOME: directory.  AUTOEXEC.BAT is always loaded
rem  from logical directory defined to be HOME:
rem
     define home: = system:
rem
rem  ---------------------------------------------------------------------
rem  Establish various SYSTEM LEVEL definitions using DEFINE commands.
rem  ---------------------------------------------------------------------
rem
rem  Define an external software version number that can be used to identify 
rem  incremental development systems.
rem
     define -s version = DRI-V1.42
rem
rem  Define REN as the system-level logical name for the RENAME command.
rem
     define -s ren = rename
rem
rem  Define CONFIG as the system-level logical name for CONFIG.286.
rem
     define -s config = system:config.286
rem
rem  Define ED as the system-level logical name for the DREDIX text editor.
rem
     define -s ed = system:dredix.286
rem
rem  Define NUL as the system-level logical name for the NULL: device driver.
rem
     define -s nul = null:
rem
rem  Enable a system-level LOGON procedure so FlexOS prompts users for 
rem  user names and passwords.
rem
     define -s protect = ON
rem
rem  Set the default help level for reporting system error messages at 
rem  level 4 (display as much information as possible).
rem
     define -s helplvl = 4
rem
rem  Assign the system-level logical name PRN to the default printer device.
rem
     define -s prn = prn:
rem
rem  Assign system-level logical names to physical devices as follows:
rem
rem  assign A: to FD0: (floppy diskette drive 1)
rem  assign B: to FD1: (floppy diskette drive 2)
rem  assign C: to HD0: (hard disk drive 1)
rem  assign D: to HD1: (hard disk drive 2)
rem  assign E: to HD2: (hard disk drive 3)
rem
     define -s a: = fd0:
     define -s b: = fd1:
     define -s c: = hd0:
     define -s d: = hd1:
     define -s e: = hd2:
rem
rem  The SECURITY command below defines the default file security level: 
rem
rem  Owner = Read, Write, Execute, Delete/Set
rem  Group = Read, Execute
rem  World = Read, Execute
rem
     security -O=RWED -G=RE -W=RE
rem
rem  ---------------------------------------------------------------------
rem  ------------------  DRIVER INSTALLATIONS  ---------------------------
rem  ---------------------------------------------------------------------
rem
rem  The following commands install device drivers applicable to your 
rem  hardware configuration.
rem
rem  ----------------------  FLOPPY DISK  --------------------------------
rem
rem  The DVRUNIT command below installs FD1: as a second unit of FD0:. 
rem  The unit is installed with the following options:
rem  
rem      L - Lockable (the device can be locked by a single user)
rem      N - Shared access (two or more users can share the device
rem      R - Raw read access allowed
rem      W - Raw write access allowed
rem      S - Raw set access allowed
rem
     dvrunit fd0: fd1: lnrws

echo                 fd1:    - floppy diskette driver     ( B: )              

rem
rem  ------------------------  HARD DISK  -------------------------------
rem
rem  The following command determins if the hard disk is already linked into
rem  the system.  If it is not installed, install it now.
rem
     if exist hd0: goto HDUNITS
rem
rem  ---------------------  HD0: ( Drive C: )  ---------------------------
rem  
rem  The DVRLOAD command below installs the hard disk driver contained in 
rem  the file HD.DRV in the subdirectory \DRIVERS.  The driver is 
rem  installed with the following options:
rem  
rem      L - Lockable (the device can be locked by a single user)
rem      N - Shared access (two or more users can share the device
rem      R - Raw read access allowed
rem      W - Raw write access allowed
rem      S - Raw set access allowed
rem      M - Multiple partitions allowed
rem
     if exist drv:hd.drv dvrload hd0: drv:hd.drv lnwrsm >* null:
     if not exist hd0: goto DISKEND

echo                 hd0:    - hard disk driver           ( C: )              

:HDUNITS
rem  -------------------- Hard Disk Units --------------------------------
rem
rem  The DVRUNIT command controlled by the FOR command below installs
rem  multiple disk units, if the unit can be installed.   The disk unit
rem  attempted to be installed is that of number in the ( ITEM-SET ).
rem
rem      1 - HD1: ( drive D: )
rem      2 - HD2: ( drive E: )
rem
rem  ( See the FOR command in the FlexOS User's Guide for detailed information )
rem
rem  The installation options are identical to HD0:.
rem

for %n in ( 1 2 ) do if exist hd0: dvrunit hd0: hd%n: lnrwsm  >* null:

     if not exist hd1: goto DISKEND

echo                 hd1:    - hard disk driver           ( D: )              

     if not exist hd2: goto DISKEND

echo                 hd2:    - hard disk driver           ( E: )              

:DISKEND
rem  ---------------------------  LPT0:  ---------------------------------
rem
rem  The following command determines if the printer driver is already linked
rem  into the system.  If it isn't linked in, install it now.
rem
     if exist lpt0: goto PT1
rem
rem  The DVRLOAD command below installs the printer driver contained in the
rem  file PRINTINT.DRV in the subdirectory \DRIVERS.  The driver is 
rem  installed with the following options: 
rem  
rem      L - Lockable (the device can be locked by a single user)
rem      N - Shared access (two or more users can share the device
rem      R - Raw read access allowed
rem      W - Raw write access allowed
rem      S - Raw set access allowed
rem
     if exist drv:printint.drv dvrload lpt0: drv:printint.drv lnrws >* null:

     if not exist lpt0: goto PT1
     define -s prn: = lpt0:

echo                 lpt0:   - printer device driver      ( PRN: )            

:PT1
rem  ----------------------------  PT1   ---------------------------------
rem
rem  The following command determines if port driver 1 is already linked into
rem  the system.  If it isn't linked in, install it now.
rem
     if exist pt1: goto CON1
rem
rem  The DVRUNIT command below installs port PT1: as a second unit of port
rem  PT0:. The unit is installed with the following options:
rem  
rem      L - Lockable (the device can be locked by a single user)
rem      N - Shared access (two or more users can share the device
rem      R - Raw read access allowed
rem      W - Raw write access allowed
rem      S - Raw set access allowed
rem
     if exist pt0: dvrunit pt0: pt1: lnrws >* null:
     if not exist pt1: goto CON1

echo                 pt1:    - port device sub-driver                         

:CON1
rem  --------------------------  CON1  -----------------------------------
rem
rem  The following command determines if the console driver is already linked
rem  into the system.  If it isn't linked in, install it now.
rem
     if exist con1: goto SER
rem
rem  The DVRUNIT command below installs console CON1: as a second unit of
rem  console CON0:. The unit is installed with the following options:
rem  
rem      L - Lockable (the device can be locked by a single user)
rem      N - Shared access (two or more users can share the device
rem      R - Raw read access allowed
rem      W - Raw write access allowed
rem      S - Raw set access allowed
rem
     if exist con0: dvrunit con0: con1: lnrws >* null:
     if not exist con1: goto SER

echo                 con1:   - console device driver                          

:SER
rem  ---------------------------  SER  -----------------------------------
rem
rem  The following command determines if the serial port driver is already
rem  linked into the system.  If it isn't linked in, install it now.
rem
    if exist ser: goto LINKPORTS
rem
rem  The DVRLOAD command below installs the serial port driver contained
rem  in the file SDRV.DRV in the subdirectory \DRIVERS. The driver is 
rem  installed with the following options:
rem  
rem      L - Lockable (the device can be locked by a single user)
rem      N - Shared access (two or more users can share the device
rem      R - Raw read access allowed
rem      W - Raw write access allowed
rem      S - Raw set access allowed
rem
    if exist drv:sdrv.drv dvrload ser: drv:sdrv.drv lnrws >* null:
    if not exist ser: goto LINKPORTS

echo                 ser:    - serial port driver                             

:LINKPORTS

echo                                                                          
echo 

rem
rem  -------------------------  LINK PORTS  ------------------------------
rem
rem  The DVRLINK commands below link the sub-drivers SER: and CON1:
rem  to the port driver units PT0: and PT1: respectively.
rem
     if exist pt0: dvrlink ser: pt0:
     if exist pt1: dvrlink con1: pt1:

rem  ---------------------------------------------------------------------
rem  --------------------------  LOGON  ----------------------------------
rem  ---------------------------------------------------------------------

rem
rem
rem  ------------------------  SINGLE USER  ------------------------------
rem
rem  Assign the logical name CON to the physical console device, and
rem  initiate the system-level LOGON process as a background task.
rem
     define con: = con0: !  back system:logon
rem
rem
rem  ------------------------  MULTI USER   ------------------------------
rem
rem  NOTE: To install multiple users (if applicable), remove "rem"
rem  in front of the DEFINE and BACK commands.
rem
rem  Assign the logical name CON to the physical console device, and
rem  initiate the system-level LOGON process as a background task.
rem
rem     define con: = con1:
rem     back system:logon
rem
rem
rem **********************      End of CONFIG.BAT   ***********************

