h03536
s 00143/00000/00000
d D 1.1 83/03/15 21:13:49 tes 1 0
c date and time created 83/03/15 21:13:49 by tes
e
u
4
U
t
T
I 1
/****************************************************************
* csconst.c -- constant declarations for the Control Systems	*
* Artist I device driver. This includes #defines and static	*
* array declarations that are not routine specific. Another	*
* file (csmit.c) contains definitions of monitor-dependent	*
* values that can be changed to customize the driver for	*
* different monitors.						*
****************************************************************/
 
#define LNTYPES 7
#define MKTYPES 5
#define FILLPATS 5
#define MXCOLOR 15
#define HOLLOW 0
#define SOLID 1
#define PATTERN 2
#define HATCH 3
#define DMreplace 1             /* writing mode defines */
#define DMover 2
#define DMxor 3
#define DMblank 4
 
int alpharow, alphacol;         /* current alpha cursor row and column */
int chDy[8]={ 1, 1, 0,-1,-1,-1, 0, 1};
int chDx[8]={ 0, 1, 1, 1, 0,-1,-1,-1};
int ncolmp[MXCOLOR+1]={		/* permanent color map */
	0,	/* 0 = black */
	9,	/* 1 = red */
	12,	/* 2 = green */
	10,	/* 3 = blue */
	14,	/* 4 = cyan */
	13,	/* 5 = yellow */
	11,	/* 6 = magenta */
	15,	/* 7 = white */
	8,	/* 8 = dk. gray */
	1,	/* 9 = dk. red */
	4,	/* 10 = dk. green */
	2,	/* 11 = dk. blue */
	6,	/* 12 = dk. cyan */
	5,	/* 13 = dk. yellow */
	3,	/* 14 = dk. magenta */
	7	/* 15 = gray */
	};
 
int ninvmp[MXCOLOR+1]={		/* inverse of color map */
	0,9,11,14,10,13,12,15,8,1,3,6,2,5,4,7};
 
/* RGB values of mapped colors:  blk  red  grn  blu  cyn  yel  mag  wht */
int   redMap[MXCOLOR+1]={	   0,1000,   0,   0,   0,1000,1000,1000,
				 333, 666, 333, 333, 333, 666, 666, 666};
int greenMap[MXCOLOR+1]={	   0,   0,1000,   0,1000,1000,   0,1000,
				 333, 333, 666, 333, 666, 666, 333, 666};
int  blueMap[MXCOLOR+1]={	   0,   0,   0,1000,1000,   0,1000,1000,
				 333, 333, 333, 666, 666, 333, 666, 666};
 
int pats[8*(FILLPATS+2)] = {
	0xFF,0xFF,0x00,0x00,	/* 1 = horiz. stripes */
	0x00,0x00,0xFF,0xFF,
 
	0xC3,0xC3,0xC3,0xC3,	/* 2 = vert. stripes */
	0xC3,0xC3,0xC3,0xC3,
 
	0xC3,0xE1,0xF0,0x78,	/* 3 = -45 diagonal */
	0x3C,0x1E,0x0F,0x87,
 
	0x87,0x0F,0x1E,0x3C,	/* 4 = +45 diagonal */
	0x78,0xF0,0xE1,0xC3,
 
	0x99,0x99,0x66,0x66,	/* 5 = dithered */
	0x99,0x99,0x66,0x66,
 
	0xFF,0xFF,0xFF,0xFF,	/* solid (for internal use -- not available) */
	0xFF,0xFF,0xFF,0xFF,
 
	0x00,0x00,0x00,0x00,	/* empty (for internal use) */
	0x00,0x00,0x00,0x00
	};
 
int lineStyles[2*LNTYPES] = {
	0xFF,0xFF,		/* solid:	---------------- */
	0xF0,0x0F,		/* long dash:	----        ---- */
	0x88,0x88,		/* dots:	-   -   -   -    */
	0xE1,0x0F,		/* dash dot:	---    -    ---- */
	0xC3,0xC3,		/* med. dash:	--    ----    -- */
	0xE2,0x47,		/* two dot:	---   -  -   --- */
	0x99,0x99		/* short dash:	-  --  --  --  - */
	};
 
int iniino[45]= { /* used to return initial values to ini[] array */
	MAXX,			/* max x */
	MAXY,			/* max y */
	1,			/* CRT type device */
	VERTMM*1000/LEN,	/* 165mm vertical for Mitsubishi monitor */
	HORIZMM*1000/WID,	/* 200mm horizontal */
	16,			/* number of character sizes */
	LNTYPES,		/* number of line types */
	1,			/* number of line widths */
	MKTYPES,		/* number of marker types */
	16,			/* number of marker sizes */
	1,			/* number of fonts */
	FILLPATS,		/* number of patterns */
	FILLPATS,		/* number of hatch styles */
	MXCOLOR+1,		/* number of colors simultaneously */
	1,			/* number of GDPs */
	1,-1,-1,-1,-1,-1,-1,-1,-1,-1, /* GDP numbers (bar is only one) */
	3,-1,-1,-1,-1,-1,-1,-1,-1,-1, /* GDP attributes */
	1,			/* color capability */
	1,			/* text rotation capability (sort of) */
	0,			/* fill area capability */
	1,			/* pixel operations capability */
	MXCOLOR+1,		/* number of colors in pallette */
	1,			/* locator device */
	0,			/* no valuator devices */
	1,			/* choice device */
	1,			/* string device */
	2			/* input/output device */
	};
 
int inipto[12]={ /* point values to return during initialization */
	0,7,			/* min character height */
	0,15,			/* max character height */
	1,0,			/* min line width */
	1,0,			/* max line width */
	0,5,			/* min marker size */
	0,15*5			/* max marker size */
	};
 
char inikeys[] = { ESC, ':', ';', ESC, 'p', 0,   /* PFK 1 = ESC p */
                          ESC, ':', '<', ESC, 'q', 0,   /* PFK 2 = ESC q */
                          ESC, ':', '=', ESC, 'r', 0,   /* PFK 3 = ESC r */
                          ESC, ':', '>', ESC, 's', 0,   /* PFK 4 = ESC s */
                          ESC, ':', '?', ESC, 't', 0,   /* PFK 5 = ESC t */
                          ESC, ':', '@', ESC, 'u', 0,   /* PFK 6 = ESC u */
                          ESC, ':', 'A', ESC, 'v', 0,   /* PFK 7 = ESC v */
                          ESC, ':', 'B', ESC, 'w', 0,   /* PFK 8 = ESC w */
                          ESC, ':', 'C', ESC, 'x', 0,   /* PFK 9 = ESC x */
                          ESC, ':', 'D', ESC, 'y', 0,   /* PFK 10= ESC y */
                          ESC, ':', 'H', ESC, 'A', 0,   /* up arrow      */
                          ESC, ':', 'K', ESC, 'D', 0,   /* left arrow    */
                          ESC, ':', 'M', ESC, 'C', 0,   /* right arrow   */
                          ESC, ':', 'P', ESC, 'B', 0,   /* down arrow    */
                          ESC, ':', 'R', ESC, 'R', 0 }; /* ins key is for*/
						   /* rate change in GIN */
E 1
