h37394
s 00007/00005/00131
d D 1.4 83/02/02 11:17:01 tes 4 3
c Added DIF interfaces
e
s 00072/00036/00064
d D 1.3 83/01/31 12:42:31 tes 3 2
c modified nxtcmd to pass in terminator character for logical lines
e
s 00001/00001/00099
d D 1.2 83/01/26 14:51:57 mjb 2 1
c fixed bug that did not allow getting of next command
e
s 00100/00000/00000
d D 1.1 83/01/20 11:13:19 tes 1 0
c date and time created 83/01/20 11:13:19 by tes
e
u
tes
mjb
U
t
T
I 1
D 3
subroutine nxtcmd (fildes, buffer)
E 3
I 3
subroutine nxtcmd (fildes, buffer, trmin8)
E 3
########################################################################
#                                                                      #
#          THIS MATERIAL IS CONFIDENTIAL AND IS FURNISHED UNDER        #
#          A WRITTEN LICENSE AGREEMENT.  IT MAY NOT BE USED,           #
#          COPIED OR DISCLOSED TO OTHERS EXCEPT IN ACCORDANCE          #
#          WITH THE TERMS OF THAT AGREEMENT.                           #
#                                                                      #
#          COPYRIGHT (C) 1982 GRAPHIC SOFTWARE SYSTEMS INC.            #
#          ALL RIGHTS RESERVED.                                        #
#                                                                      #
#     Function: Get next menu item/command from a menu file            #
#                                                                      #
#     Input Parameters:                                                #
#            fildes  - (integer) file descriptor of menu file          #
I 3
#            trmin8  - (integer) ade value of line terminator          #
E 3
#                                                                      #
#     Output Parameters:                                               #
#            buffer  - (byte) buffer containing next command           #
#                                                                      #
#     Routines Called:                                                 #
#            gdseek - move file read/write pointer                     #
#            gdread - read n bytes from a file                         #
#                                                                      #
########################################################################
D 3
integer fildes
E 3
I 3
integer fildes, trmin8
E 3
SHORTINT buffer(1)

D 3
integer c, coment, count, last
integer igtbyt, nxtbyt
E 3
I 3
SHORTINT c, cterm, coment, count, last, igtbyt, nxtbyt
E 3

D 4
include(`mnucom')

E 4
buffer(1) = 0
coment = 0
count = 0
last = 0
D 3
   while (igtbyt(fildes, nxtbyt) > 0) {
      c = nxtbyt
      if (coment == 0) {   # are we currently scanning a comment  
         if (c >= BLANK) {    # throw away all control characters  
	    if (last == SLASH & c == STAR) {   # check for a comment  
	       coment = 1
	       buffer(count) = 0
	       count = count - 1
	       }
	    else {   # add character to output buffer  
D 2
	       if (c == BLANK & count > 0) {
E 2
I 2
	       if (count > 0 | c != BLANK) {
E 2
	          last = c
                  count = count + 1
	          if (c == SEMICOL) {
		     buffer(count) = 0
		     break
		     }
	          else
                     buffer(count) = c
E 3
I 3
cterm = trmin8

# Loop through the input file characters obtaining the next logical input
#   line of data. The line is terminated by the input parameter 'trmin8'
#
while (igtbyt(fildes, nxtbyt) > 0) {
   c = nxtbyt

   # Commenys are of the form '/* .... */'
   #   We search for the terminator string '*/' or NEWLINE
   #
   if (coment == 0) {

      # Throw away all control characters
      #
      if (c >= BLANK) {

	 # Check for the beginning of a comment string '/*'
	 #
         if (last == SLASH & c == STAR) {
            coment = 1
	    buffer(count) = 0
	    count = count - 1
	    }
	 else {

	    # Throw leading blanks away
	    #
	    if (count > 0 | c != BLANK) {
	       last = c
               count = count + 1

	       # Check for terminator character, otherwise stuff character
	       #   into output buffer
	       #
	       if (c == cterm) {
		  buffer(count) = 0
		  break
E 3
		  }
D 3
               }
E 3
I 3
	       else
                  buffer(count) = c
	       }
E 3
            }
	 }
D 3
      else {   # search to end of comment  
	 if (c == SLASH & last == STAR) {
	    coment = 0
	    last = 0
	    }
	 else {
	    last = c
	    }
E 3
I 3

      # Check for terminator character
      #
      else if (c == cterm) {
         count = count + 1
	 buffer(count) = 0
         break
         }
      }
   else {
      
      # Check for end of comment string, '*/'
      #
      if (c == SLASH & last == STAR) {
         coment = 0
	 last = 0
E 3
	 }
I 3
      else {
	 last = c
	 }
E 3
      }
I 3
   }
E 3

return
end
D 3
integer function igtbyt (fildes, nbyte)
integer fildes, nbyte
integer kbytes, nxtbyt
E 3
I 3
SHORTINT function igtbyt (fildes, nbyte)
SHORTINT nbyte
integer fildes

integer kbytes
SHORTINT nxtbyt
E 3
integer gdread

D 4
include(`mnucom')
E 4
I 4
integer floc(2), fbfknt
E 4

I 4
include(`gphcom')

common /mnuiob/ floc, fbfknt

E 4
igtbyt = 0
fbfknt = fbfknt + 1
if (fbfknt > floc(1)) {

   # read the next byte  
D 4
   kbytes = gdread (fildes, dtabfr, 512)
E 4
I 4
   kbytes = gdread (fildes, anobuf, 896)
E 4
   if (kbytes <= 0) return
   floc(1) = kbytes
   fbfknt = 1
   }
D 4
nbyte = nxtbyt (fbfknt, dtabfr)
E 4
I 4
nbyte = nxtbyt (fbfknt, anobuf)
E 4
igtbyt = 1
return
end
D 3
integer function nxtbyt (count, dtabfr)
E 3
I 3
SHORTINT function nxtbyt (count, dtabfr)
E 3
integer count
ifdef(`UNIX',`character*(*) dtabfr',`SHORTINT dtabfr(1)')

ifdef(`UNIX',`nxtbyt = dtabfr(count:count)',`nxtbyt = dtabfr(count)')
return
end
E 1
