h57167
s 00001/00001/00116
d D 1.4 83/03/09 01:27:18 mjb 4 3
c 
e
s 00002/00002/00115
d D 1.3 83/02/03 00:50:55 tes 3 2
c modified apdata interface to include last item to display
e
s 00008/00001/00109
d D 1.2 83/02/02 11:16:48 tes 2 1
c Added DIF interfaces
e
s 00110/00000/00000
d D 1.1 83/01/31 12:41:09 tes 1 0
c date and time created 83/01/31 12:41:09 by tes
e
u
tes
mjb
U
t
T
I 1
subroutine opndif (fildes)
########################################################################
#                                                                      #
#          THIS MATERIAL IS CONFIDENTIAL AND IS FURNISHED UNDER        #
#          A WRITTEN LICENSE AGREEMENT.  IT MAY NOT BE USED,           #
#          COPIED OR DISCLOSED TO OTHERS EXCEPT IN ACCORDANCE          #
#          WITH THE TERMS OF THAT AGREEMENT.                           #
#                                                                      #
#          COPYRIGHT (C) 1982 GRAPHIC SOFTWARE SYSTEMS INC.            #
#          ALL RIGHTS RESERVED.                                        #
#                                                                      #
#     Function: Open and position a DIF file for reading data          #
#                                                                      #
#     Input Parameters:                                                #
#            None                                                      #
#                                                                      #
#     Output Parameters:                                               #
#            fildes - file descriptor of input file                    #
#                                                                      #
#     Routines Called:                                                 #
#            rdwrit - read or write to a file                          #
#                                                                      #
########################################################################
integer fildes

integer i, done
SHORTINT buffer(80), dtastr(4), fname(14), escape
ifdef(`UNIX',`character*14 ufname')

integer gdopen, gdclos

I 2
integer floc(2), fbfknt

common /mnuiob/ floc, fbfknt

E 2
data dtastr /BIGD, BIGA, BIGT, BIGA/

done = -1
fildes = 0
I 2
fbfknt = 0
floc(1) = 0
floc(2) = 0
E 2
repeat {

   call setmod (ON)
D 3

E 3
   call apmenu (RESTORExFILExNAMExPROMPT, YES)
D 3
   call apdata (1)
E 3
I 3
   call apdata (1, FOREVER)

E 3
D 4
   escape = LF
E 4
I 4
   ifdef(`UNIX',`escape = LF',`escape = CR')
E 4
   call managd (escape)

   call setmod (OFF)

   call qgeta (1, fname) # get the user's file name

   # If the user typed a return, don't open anything and exit
   #
   if (fname(1) == NUL) return

   ifdef(`UNIX',`
      do i = 1,14 {
         ufname(i:i) = char (fname(i))
         }
      ')
   ifdef(`UNIX',
      `fildes = gdopen (ufname, ASCIIxREAD)',
      `fildes = gdopen (fname, ASCIIxREAD)')

D 2
   if (fildes <= 0) {                 # Cannot open file
E 2
I 2
   if (fildes < 0) {                 # Cannot open file
E 2
      call errmsg (PAUSE, CANNOTxOPENxFILExERROR)
      }

   else {

      # loop through the input file searching for the string DATA
      #   which preceeds the data in a DIF file. The DATA tuple consists
      #   of the following:
      #       (1) DATA
      #       (2) 0,0
      #       (3) ""
      #
      repeat {
	 call nxtcmd (fildes, buffer, NEWLINE)
	 if (buffer(1) == NUL) break
         for (i=1; i<=4; i=i+1) {
	    if (buffer(i) != dtastr(i)) break
	    }
	 if (i == 5) done = 0
	 call nxtcmd (fildes, buffer, NEWLINE)
	 if (buffer(1) == NUL) break
	 call nxtcmd (fildes, buffer, NEWLINE)
	 if (buffer(1) == NUL) break
	 } until (done == 0)

      # If we did not find the DATA string then close the file and return
      #   a NUL file descriptor
      #
      if (done != 0) {
	 i = gdclos (fildes)
	 fildes = 0
	 done = 0
	 }
      else {

         # The DATA three tuple is followed by a two tuple defining the
         #    beginning of data as follows:
         #       (1) -1,0
         #       (2) BOT
         #
	 call nxtcmd (fildes, buffer, NEWLINE)
	 call nxtcmd (fildes, buffer, NEWLINE)
	 }
      }
   } until (done == 0)

return
end
E 1
