h02996
s 00015/00001/00125
d D 1.7 83/03/30 22:43:33 mjb 7 6
c changed clipping 
e
s 00019/00027/00107
d D 1.6 83/03/09 14:00:16 tes 6 5
c modified for integer clipping and speedup
e
s 00039/00032/00095
d D 1.5 83/03/02 15:37:35 mjb 5 4
c modified clipping interface
e
s 00002/00001/00125
d D 1.4 83/03/02 11:33:31 tes 4 3
c fixed bug...changed integer*1 statement to SHORTINT
e
s 00061/00114/00065
d D 1.3 83/02/14 12:54:52 mjb 3 2
c special changes for GRAPH, removed rotation etc.
e
s 00003/00004/00176
d D 1.2 83/01/20 20:54:09 tes 2 1
c Modified hershy font interface for viewport sizing
e
s 00180/00000/00000
d D 1.1 83/01/20 11:23:11 tes 1 0
c date and time created 83/01/20 11:23:11 by tes
e
u
tes
mjb
U
t
T
I 1
subroutine text (numchr, string)
########################################################################
#                                                                      #
#          THIS MATERIAL IS CONFIDENTIAL AND IS FURNISHED UNDER        #
#          A WRITTEN LICENSE AGREEMENT.  IT MAY NOT BE USED,           #
#          COPIED OR DISCLOSED TO OTHERS EXCEPT IN ACCORDANCE          #
#          WITH THE TERMS OF THAT AGREEMENT.                           #
#                                                                      #
#          COPYRIGHT (C) 1982 GRAPHIC SOFTWARE SYSTEMS INC.            #
#          ALL RIGHTS RESERVED.                                        #
#                                                                      #
#     Function: Output text at the current cursor position             #
#                                                                      #
#     Input Parameters:                                                #
#            numchr - number of characters in string                   #
#            string - array of ADE characters                          #
#                                                                      #
#     Output Parameters:                                               #
#            none                                                      #
#                                                                      #
#     Routines Called:                                                 #
#            gzddop - device independent device interface              #
D 5
#            txclip - clip text to proper boundary                     #
E 5
I 5
#            lnclip - clip line to proper boundary                     #
E 5
#            gpn2dc - convert a coordinate from (0-1) to (0,32K)       #
#                                                                      #
########################################################################
integer numchr, string(1)

integer opcd, nchr, contrl(5), idummy(1), ptsin(2), ptsout(1)
I 5
D 6
integer kout, kstart, kend
real cjx, cjy, x, y, xsave, line1(2), line2(2), strlng, xmax, ymax, delta
logical q1move, q2move, qgone
E 6
I 6
integer kout, kstart, kend, xmax, ymax, delta, xmin, ymin
integer gimnmx, x1, x2, width
I 7
integer start, end
E 7
real cjx, cjy, x, y, xsave, strlng
I 7
real xyin(2), xyout(2), min(2), max(2)
E 7
E 6
E 5

D 3
integer kout, kstart, kend, ddc(2), dxdc, dydc, start1, start2, 
	stop1, stop2, i
E 3
I 3
D 5
integer kout, kstart, kend, start1, start2, stop1, stop2
E 3

D 3
real cjx, cjy, delta, x, y, dx, dy, xoff, yoff, 
     xsave, ysave, line1(4), line2(4), temp

D 2
integer str(41)
integer khshfn, khshts
E 2
I 2
SHORTINT str(41)
E 3
I 3
real cjx, cjy, x, y, xsave, line1(4), line2(4), temp
D 4
integer*1 str(41)
E 4
I 4

E 5
SHORTINT str(41)
E 4
E 3
integer khshfn
E 2

include(`pltcom')

D 2
common /hshext/ khshfn, khshts
E 2
I 2
common /hshext/ khshfn
E 2

# The following equivalences are made to reduce code size
#
#       contrl(1) :: opcd
#       contrl(4) :: nchr
D 3
#       ddc(1) :: dxdc
#       ddc(2) :: dydc
E 3

D 3
equivalence (contrl(1), opcd), (contrl(4), nchr), 
	    (ddc(1), dxdc), (ddc(2), dydc)

   if (numchr > 0 ) {
      if (khshfn > 1) {
	 call hshjst (txtjh*50, (4 - txtjv)*25)
D 2
	 call hshsiz (khshts, khshts)
E 2
	 do i=1, numchr { str(i) = string(i) }
	 str(numchr+1) = NUL
	 call gpn2dc (zxabsl, zyabsl, ptsin)
	 call hshtxt (khshfn-2, str, ptsin(1), ptsin(2))
	 }
      else {
E 3
I 3
equivalence (contrl(1), opcd), (contrl(4), nchr)
E 3
 
D 3
      dx = zchwdt * zdx   #determine the x and y deltas for one character
      dy = zchhgt * zdy 
      temp = zchhgt * zdx
      xoff = dx * numchr
      yoff = dy * numchr 
E 3
I 3
   if (khshfn > 1)  {   # Use emulated fonts
      call hshjst (txtjh*50, txtjv*50)
      do nchr = 1, numchr   { str(nchr) = string(nchr) }
      str(numchr+1) = NUL
      call gpn2dc (zxabsl, zyabsl, ptsin)
D 7
      call hshtxt (khshfn-2, str, ptsin(1), ptsin(2))
E 7
I 7
      xyin(1) = ptsin(1)
      xyin(2) = ptsin(2)
      min(1) = xvwmin
      min(2) = yvwmin
      max(1) = xvwmin + xvwlng
      max(2) = yvwmin + yvwlng
      call hstclp (khshfn-2, xyin, str, min, max, start, end, xyout)
      if (end >= start) {
         str(end+1) = NUL
         ptsin(1) = xyout(1)
         ptsin(2) = xyout(2)
         call hshtxt (khshfn-2, str(start), ptsin(1), ptsin(2))
         }
E 7
      }
E 3

D 3
      if (txtpre == CHARACTERxPRECISION & ntxtrt == NO) {
	 dy = dy * zchhgt / zchwdt
	 }

      if (txtpre == STRINGxPRECISION) {
         dx = zchwdt 
         dy = 0.0
         }

E 3
I 3
   else  { # Use hardware text
E 3
      # x,y is the lower left corner of the first character cell. We adjust
      #   the position according to the specified text justification, 
      #        txtjh - horizontal:
      #                   0=left, 1=center, 2=right
      #        txtjv - vertical:
D 3
      #                   0=top, 1=CAP, 2=center, 3=base, 4=bottom
E 3
I 3
      #                   2=top, 1=center, 0=bottom
E 3
      cjx = .5*txtjh 
D 3
      cjy = 1. - .5*(float((2*txtjv)/3)) 
E 3
I 3
      cjy = .5*txtjv
E 3
 
D 3
      x = (zxabsl + cjy*dy) - cjx*xoff
      y = (zyabsl - cjy*temp) - cjx*yoff
E 3
I 3
D 5
      temp = zchwdt*numchr   # length of the string
      x = zxabsl - cjx*temp
E 5
I 5
      strlng = zchwdt*numchr   # length of the string
      x = zxabsl - cjx*strlng
E 5
      y = zyabsl - cjy*zchhgt
E 3
      
D 3
      # Text Clipping is done by clipping the rectangle which encloses the  
      #   text string. We use the base line and Caps line to clip against.
      #   If any portion of either line is clipped the character is 
      #   considered clipped.
 
      # Define two (2) lines: 1) define the lower extention of the text
      #    string and 2) the upper extention of the text string
      line1(1) = x
      line1(2) = y
      line1(3) = x + xoff
      line1(4) = y + yoff
      line2(1) = x - dy
      line2(2) = y + dx
      line2(3) = line2(1) + xoff       
      line2(4) = line2(2) + yoff       

      # 'delta' is the distance along the base line of one (1) character
      delta = sqrt(dx*dx + dy*dy)
      
E 3
      # initialize the end of the string variables to the full character
      #    string length
I 3
D 5
      start1 = 1
      start2 = 1
E 3
      stop1 = numchr
      stop2 = numchr
E 5
I 5
      kstart = 1
      kend = numchr
E 5

D 3
      # Clip each the string base line and the cap line and then determine
      #    where in the string to start and end output
      call txclip (line1, delta, start1, stop1)
      call txclip (line2, delta, start2, stop2)
E 3
I 3
      if (nclip == YES)  {
         # Text Clipping is done by clipping the rectangle which encloses the  
D 5
         #   text string. We use the base line and Caps line to clip against.
         #   If any portion of either line is clipped the character is 
E 5
I 5
         #   text string. We use two strings, the cap, and base separately
         #   If any portion of the line is clipped the character is 
E 5
         #   considered clipped.
 
D 5
         # Define two (2) lines: 1) define the lower extention of the text
         #    string and 2) the upper extention of the text string
E 5
I 5
	 # Define a line which is the cap of the string
D 6
	 ymax = y + zchhgt
	 xmax = x + strlng
E 6
I 6
	 ymax = (y + zchhgt)*400.
	 ymin = y*400.
E 6

D 6
	 line1(1) = x
	 line1(2) = ymax
	 line2(1) = xmax
	 line2(2) = ymax
	 call lnclip (line1, line2, q1move, q2move, qgone)
	 if (qgone)  return    # string was entirely clipped in y
E 6
I 6
         if (ymax > 400 | ymax < 0) return
	 if (ymin > 400 | ymin < 0) return
E 6

         # Define a line which is the baseline of the string
E 5
D 6
         line1(1) = x
         line1(2) = y
D 5
         line1(3) = x + temp
         line1(4) = y
         line2(1) = x
         line2(2) = y + zchhgt
         line2(3) = line1(3)
         line2(4) = line2(2)
E 5
I 5
         line2(1) = xmax
         line2(2) = y
E 6
I 6
         xmin = x*400.
	 xmax = (x + strlng)*400.
	 x1 = gimnmx (xmin, 0, 400)
	 x2 = gimnmx (xmax, 0, 400)
	 if ((x1 - x2) == 0) return
E 6
E 5
E 3

D 3
      # if start1 and start2 are greater than 0, then there is at least one
      #    character to be output
      if ((start1 > 0) & (start2 > 0)) {
E 3
I 3
D 5
         # Clip each the string base line and the cap line and then determine
         #    where in the string to start and end output
         call txclip (line1, zchwdt, start1, stop1)
         call txclip (line2, zchwdt, start2, stop2)
E 5
I 5
D 6
	 call lnclip (line1, line2, q1move, q2move, qgone)
E 6
I 6
         width = zchwdt*400.
	 if (xmin != x1)  {  # The left edge was clipped
	    delta = x1 - xmin
E 6
E 5

D 5
         # if start1 and start2 are greater than 0, then there is at least one
         #    character to be output
         if ((start1 <= 0) | (start2 <= 0)) return
E 5
I 5
D 6
	 if (qgone)  return    # string was entirely clipped in y

	 # Now check each x edge and reduce if needed
	 if (q1move)  {  # The left edge was clipped
	    delta = line1(1) - x

E 6
	    # 2 is because index starts at 1 and something else was clipped
D 6
	    kstart = delta/zchwdt + 2
E 6
I 6
	    kstart = delta/width + 2
E 6
	    }
D 6
	 if (q2move) { # The right edge was clipped
	    delta = xmax - line2(1)
	    kend = kend - delta/zchwdt - 1
E 6
I 6
	 if (xmax != x2) { # The right edge was clipped
	    delta = xmax - x2
	    kend = kend - delta/width - 1
E 6
	    }
D 6

E 6
E 5
	 }
E 3
	
D 3
	 # determine the extents of the string to be output
	 kstart = max0 (start1, start2)
	 kend = min0 (stop1, stop2)
E 3
I 3
D 5
      # determine the extents of the string to be output
      kstart = max0 (start1, start2)
      kend = min0 (stop1, stop2)
E 3
        
E 5
D 3
	 # determine the total string length to be output
	 kout = (kend - kstart) + 1
E 3
I 3
      # determine the total string length to be output
      kout = (kend - kstart) + 1
E 3
	
D 3
	 # calculate the position of the first character to be output
	 xsave = x + (kstart-1)*dx
	 ysave = y + (kstart-1)*dy
	
	 # calculate the delta 'x' and delta 'y' for each character in
	 #   device coordinates
	 call gpn2dc (dx, dy, ddc)
	 }
      else {
	 kout = 0
	 }

      if (kout > 0 ) {
         # Set the string length for CHARxPRECISION initially, then if STRING
         #    is being used adjust the loop control parameter KOUT so we loop
         #    only once.
E 3
I 3
      # calculate the position of the first character to be output
      xsave = x + (kstart-1)*zchwdt
E 3
 
D 3
        # contrl(1) = TEXT
        opcd = TEXT      
	contrl(2) = 1   # One xy point
	# Contrl(4) = 1
        nchr = 1
	# ptsin(1) and ptsin(2) = x, y starting postion
	call gpn2dc (xsave, ysave, ptsin)
E 3
I 3
      # contrl(1) = TEXT
      opcd = TEXT      
      contrl(2) = 1   # One xy point
      # Contrl(4) = 1
      nchr = kout
      # ptsin(1) and ptsin(2) = x, y starting postion
      call gpn2dc (xsave, y, ptsin)
E 3

D 3
         if (txtpre == STRINGxPRECISION) {
	     # Contrl(4) = kout
             nchr = kout
             kend = kstart
             }
 
	 # Output the text string begining with the KSTART character in the
         #    string and ending with KEND.
         for (i=kstart; i<=kend; i=i+1) {
	    
	    # Output the character or string
	    call gzddop (contrl, string(i), ptsin, idummy, ptsout)
            
	    # Increment the character position to the next position
	    ptsin(1) = ptsin(1) + dxdc
            ptsin(2) = ptsin(2) + dydc
            }

         }
     }
     }
 
E 3
I 3
      # Output the character or string
      call gzddop (contrl, string(kstart), ptsin, idummy, ptsout)
      }
E 3
   return
end
E 1
