h02827
s 00000/00000/00067
d D 1.2 83/03/31 12:29:09 mmm 2 1
c 
e
s 00067/00000/00000
d D 1.1 83/03/15 21:35:59 tes 1 0
c date and time created 83/03/15 21:35:59 by tes
e
u
4
U
t
T
I 1
subroutine giagdp (wktype,np,errind,nmgdp,gdpl,atrtab)
########################################################################
#                                                                      #
#          THIS MATERIAL IS CONFIDENTIAL AND IS FURNISHED UNDER        #
#          A WRITTEN LICENSE AGREEMENT.  IT MAY NOT BE USED,           #
#          COPIED OR DISCLOSED TO OTHERS EXCEPT IN ACCORDANCE          #
#          WITH THE TERMS OF THAT AGREEMENT.                           #
#                                                                      #
#          COPYRIGHT (C) 1982 GRAPHIC SOFTWARE SYSTEMS INC.            #
#          ALL RIGHTS RESERVED.                                        #
#                                                                      #
#     Function: Inquire list of GDP primitives                         #
#                                                                      #
#     Input Parameters:                                                #
#            wktype - workstation type                                 #
#            np     - dimension of array GDPL and ATRTAB               #
#     Output Parameters:                                               #
#            errind - error indicator                                  #
#            nmgdp   - number of available GDP's                       #
#            gdpl   - list of GDP identifiers                          #
#            atrtab - list of assoc. attributes used                   #
#                     (0=polyline,1=polymarker,2=text,3=fill area,     #
#                      4=none)                                         #
#                                                                      #
#     Errors:                                                          #
#            7  GKS not in proper state: GKS must be in one of the     #
#               states WSOP, WSAC, or SGOP                             #
#           22  Specified workstation type is invalid                  #
#           23  Specified workstation does not exist                   #
#           37  Specified workstation is neither an output             #
#               station nor an output/input workstation                #
#                                                                      #
#     Routines Called:                                                 #
#            errchk - perform appropriate error checking               #
#            arycon - array initializer                                #
#            arysgn - array initializer                                #
#                                                                      #
########################################################################
integer  wktype, np, errind, nmgdp, gdpl(np), atrtab(np)

ifdef(`ERROR_ON',`
   integer errchk, ierdum, ierary(1), erary1
   ')

include(`gkscom')

ifdef(`ERROR_ON',`
   equivalence (ierary(1), erary1)
   ')

   # In all inquiry routines, initialize errind to 0 (zero).
   errind = 0
   ifdef(`ERROR_ON',`
      rounum = GIAGDP
      #   ierary(1) = wktype
      erary1 = wktype
      errind = errchk(ierdum, ierary)
      if (errind != 0) return
      ')

   nmgdp = ngdp     # Get current value from workstation table   

   call arysgn (nmgdp,lgdp, gdpl)
   call arysgn (nmgdp, gdpbun, atrtab)

   return
end
E 1
