h24162
s 00004/00004/00072
d D 1.2 83/03/31 12:33:17 mmm 2 1
c 
e
s 00076/00000/00000
d D 1.1 83/03/15 21:39:11 tes 1 0
c date and time created 83/03/15 21:39:11 by tes
e
u
4
U
t
T
I 1
subroutine giwkt (wkid,errind,tus,rwwind,cwwind,rwvwpt,cwvwpt)
########################################################################
#                                                                      #
#          THIS MATERIAL IS CONFIDENTIAL AND IS FURNISHED UNDER        #
#          A WRITTEN LICENSE AGREEMENT.  IT MAY NOT BE USED,           #
#          COPIED OR DISCLOSED TO OTHERS EXCEPT IN ACCORDANCE          #
#          WITH THE TERMS OF THAT AGREEMENT.                           #
#                                                                      #
#          COPYRIGHT (C) 1982 GRAPHIC SOFTWARE SYSTEMS INC.            #
#          ALL RIGHTS RESERVED.                                        #
#                                                                      #
#     Function: Inquire workstation transformation                     #
#                                                                      #
#     Input Parameters:                                                #
#            wkid   - workstation identifier                           #
#     Output Parameters:                                               #
#            errind - error indicator                                  #
#            tus    - workstation transformation update state          #
#            rwwind - requested workstation window NDC                 #
#            cwwind - current workstation window NDC                   #
#            rwvwpt - requested workstation viewport DC                #
#            cwvwpt - current workstation viewport DC                  #
#                                                                      #
#     Errors:                                                          #
#            7  GKS not in proper state: GKS must be in one of the     #
#               states WSOP, WSAC, or SGOP                             #
#           20  Specified workstation identifier is invalid            #
#           25  specified workstation is not open                      #
#                                                                      #
#     Routines Called:                                                 #
#               arysnr - copy real input array to output array         #
#               errchk - perform appropriate error checking            #
#                                                                      #
########################################################################
integer  wkid, errind, tus
real rwwind(4), cwwind(4), rwvwpt(4), cwvwpt(4)

integer i
real twvwpt(4)

ifdef(`ERROR_ON',`
   integer errchk, ierdum(1)
   ')
 
include(`gkscom')

   # In all inquiry routines, initialize errind to 0 (zero).
   errind = 0
   ifdef(`ERROR_ON',`
      rounum = GIWKT
      errind = errchk (wkid, ierdum)
      if (errind != 0) return
      ')

   # Get values from workstation list common
   tus = NOTPENDING 
   
   if (devcor == METERS) {   # Convert to meters   
      do i = 1, 2 {
         twvwpt(i) = cwrkvw(i) * sptszx
	 twvwpt(i+2) = cwrkvw(i+2) * sptszy
	 }
      }
   else {
      call arysnr (4, cwrkvw, twvwpt)
      }

   do i = 1, 4 {     # Put back into user format reals
D 2
      PUTREAL(cwrkwn(i), rwwind(i))
      PUTREAL(cwrkwn(i), cwwind(i))
      PUTREAL(twvwpt(i), rwvwpt(i))
      PUTREAL(twvwpt(i), cwvwpt(i))
E 2
I 2
      call ptreal (cwrkwn(i), i-1, rwwind)
      call ptreal (cwrkwn(i), i-1, cwwind)
      call ptreal (twvwpt(i), i-1, rwvwpt)
      call ptreal (twvwpt(i), i-1, cwvwpt)
E 2
      } 

   return
end
E 1
