h49061
s 00002/00002/00085
d D 1.7 83/03/16 16:30:31 mrk 7 6
c bug to fix grids on 8080 version
e
s 00005/00001/00082
d D 1.6 83/03/09 14:02:02 tes 6 5
c fixed viewport problem and line color problem with hershy text
e
s 00010/00013/00073
d D 1.5 83/03/08 20:20:43 tes 5 4
c modified axis pipeline for integer calculations
e
s 00001/00001/00085
d D 1.4 83/03/02 00:43:17 mrk 4 3
c make these work always in (0-1) space, removed all (0-100) references
e
s 00004/00008/00082
d D 1.3 83/03/01 23:52:51 mrk 3 2
c cut down on some overhead
e
s 00006/00008/00084
d D 1.2 83/01/28 13:51:37 tes 2 1
c initial_internal_update
e
s 00092/00000/00000
d D 1.1 83/01/28 13:02:14 tes 1 0
c date and time created 83/01/28 13:02:14 by tes
e
u
tes
mjb
mrk
mmm
U
t
T
I 1
subroutine gpgntc (index, xloc, itic)
########################################################################
#                                                                      #
#          THIS MATERIAL IS CONFIDENTIAL AND IS FURNISHED UNDER        #
#          A WRITTEN LICENSE AGREEMENT.  IT MAY NOT BE USED,           #
#          COPIED OR DISCLOSED TO OTHERS EXCEPT IN ACCORDANCE          #
#          WITH THE TERMS OF THAT AGREEMENT.                           #
#                                                                      #
#          COPYRIGHT (C) 1982 GRAPHIC SOFTWARE SYSTEMS INC.            #
#          ALL RIGHTS RESERVED.                                        #
#                                                                      #
#     Function: Generate a tic mark at the given location              #
#                                                                      #
#     Input Parameters:                                                #
#            index  - axis to generate tic on (1=x, 2=y)               #
#            xloc   - location on axis to generate tic                 #
#            itic   - tic type (1=minor, 2=major)                      #
#                                                                      #
#     Output Parameters:                                               #
#            none                                                      #
#                                                                      #
#     Routines Called:                                                 #
D 3
#            gpdraw - draw a line in absolute 2D world space           #
E 3
I 3
#            idraw  - draw a line in absolute 2D world space           #
E 3
#            imove  - modify current position for later action         #
#            gpsatt - Set an attribute on the current device           #
#                                                                      #
########################################################################
D 5
integer index, itic
real xloc
E 5
I 5
integer index, xloc, itic
E 5

integer i, k, kstyle, iout
D 3
real p(2), ticsiz(2), savwid
E 3
I 3
D 5
real p(2), ticsiz(2)
E 5
I 5
integer gimnmx, p(2), ticsiz(2)
E 5
E 3
 
D 5
integer gimnmx
 
E 5
include(`pltcom')
 
D 5
data ticsiz /.012, .02/
E 5
I 5
data ticsiz /393, 655/
E 5
 
DxB write (DEBUGxUNIT, 100) index, xloc
DxB 100 format (' gpgntc:', i5, f10.5)
 
D 5
   p(1) = zplmin(1)
   p(2) = zplmin(2)
E 5
I 5
   p(1) = nplmin(1)
   p(2) = nplmin(2)
E 5
D 4
   p(index) = xloc/100.
E 4
I 4
   p(index) = xloc
E 4
D 5
   call imove (ABSOLUTE, p(1), p(2))   # Move to the appropriate axis position
E 5
I 5
   call gpzmov (ABSOLUTE, p(1), p(2))   # Move to the appropriate axis position
E 5
   i = 1                      # Determine which axis is being drawn
   if (index == 1) i = 2
 
   # The algorithm to determine if a grid line is to be drawn is as follows:
   #    value = (tic type[1-2]) + (grid status [0-2])
   #    If the value is greater than or equal to 3, a grid line is to be
   #    drawn.
   #                          none  major only   all
   #               (ngstat)    0        1        2
   #                (itic)
   #        minor     1        1        2        3
   #        major     2        2        3        4
 
D 2
   k = ngstat(index)
   if (k > 0) k = k + 1
   k =  k + itic + gimnmx(ntstat(index), 0, 1)
E 2
I 2
   k =  ngstat(index) + itic + gimnmx(ntstat(index), 0, 1)
E 2
 
I 2
D 3
   if (ngstat(index) > 0) # set the appropriate line color
E 3
I 3
   if (ngstat(index) > 0) # set the appropriate line color for grid line
E 3
D 6
	   call gpsatt (SETxPOLYLINExCOLORxINDEX, ngdclr(index), iout)
E 6
I 6
      kstyle = ngdclr(index)
   else
      kstyle = nlcolr

   call gpsatt (SETxPOLYLINExCOLORxINDEX, kstyle, iout)
E 6

E 2
D 3
   savwid = zlwid
E 3
   if (k < 4) {  # Draw just a tic
      if (ntstat(index) == 0) return   # No tic marks
      kstyle = 1
      p(i) = p(i) + ticsiz(itic)     # The tic is either 2. or 1.2 units long
      }
   else {    # Put out a grid line
 
      #  If we are at the extremes of the plot area don't output grid
D 2
 
      if (p(index) == zplmin(index) | p(index) == zplmax(index)) return
E 2
I 2
D 5
      if (abs(p(index)-zplmin(index)) < ZEPS | 
	  abs(p(index)-zplmax(index)) < ZEPS) return
E 5
I 5
D 7
      if (abs(p(index)-nplmin(index)) < 10 | 
	  abs(p(index)-nplmax(index)) < 10) return
E 7
I 7
      if (iabs(p(index)-nplmin(index)) < 10 | 
	  iabs(p(index)-nplmax(index)) < 10) return
E 7
E 5
E 2
      
D 2
      # set the appropriate line color and style
      call gpsatt (SETxPOLYLINExCOLORxINDEX, ngdclr(index), iout)

E 2
      # set the line style
      kstyle = ngdstl(index)
D 5
      p(i) = zplmax(i)               # Draw a grid line
E 5
I 5
      p(i) = nplmax(i)               # Draw a grid line
E 5
      }

   # set the line style
   call gpsatt (SETxPOLYLINExLINETYPE, kstyle, iout)

D 3
   zlwid = 0.0
   call gpdraw (p(1), p(2))   # Draw the tic mark or grid line
   zlwid = savwid
 
E 3
I 3
D 5
   call idraw (ABSOLUTE, p(1), p(2))   # Draw the tic mark or grid line
E 5
I 5
   call gpzdrw (ABSOLUTE, p(1), p(2))   # Draw the tic mark or grid line
E 5
E 3
   return
end
E 1
