h18684
s 00001/00001/00045
d D 1.2 83/01/28 13:59:24 tes 2 1
c initial_internal_update
e
s 00046/00000/00000
d D 1.1 83/01/28 13:04:13 tes 1 0
c date and time created 83/01/28 13:04:13 by tes
e
u
tes
mjb
mrk
mmm
U
t
T
I 1
subroutine gptenv (index, lstart, lend, labels)
########################################################################
#                                                                      #
#          THIS MATERIAL IS CONFIDENTIAL AND IS FURNISHED UNDER        #
#          A WRITTEN LICENSE AGREEMENT.  IT MAY NOT BE USED,           #
#          COPIED OR DISCLOSED TO OTHERS EXCEPT IN ACCORDANCE          #
#          WITH THE TERMS OF THAT AGREEMENT.                           #
#                                                                      #
#          COPYRIGHT (C) 1982 GRAPHIC SOFTWARE SYSTEMS INC.            #
#          ALL RIGHTS RESERVED.                                        #
#                                                                      #
#     Function: set up the ticking environment                         #
#                                                                      #
#     Input Parameters:                                                #
#            index  - index of axis, 1=x, 2=y                          #
#            lstart - label starting value                             #
#            lend   - label ending value                               #
#            labels - number of labels on axis                         #
#                                                                      #
#     Output Parameters:                                               #
#            none                                                      #
#                                                                      #
#     Routines Called:                                                 #
#            none                                                      #
#                                                                      #
########################################################################
integer index, labels
real lstart, lend
 
integer gimnmx
 
include(`pltcom')
 
DxB write (DEBUGxUNIT, 100) lstart, lend, labels
DxB 100 format (' gptenv:', 2f10.5, i5)
 
   # NMAJOR is the number of major divisions to be output
   # If value is 0, no tics and labels will be displayed on the axis
   nmajor = gimnmx ((labels - 1), 0, 32767)
   # NMINOR if the number of minor divisions between each major division
   nminor = gimnmx (ntstat(index), 1, 32767)
   # ZLINCR is the label increment between major tics
D 2
   zlincr = (lend - lstart)/nmajor
E 2
I 2
   if  (nmajor != 0) zlincr = (lend - lstart)/nmajor
E 2
 
   return
end
E 1
