TITLE 'DAISY-II.ASM - PALANTIR PRINTDEF TRS-80 DAISY WHEEL II 03/15/83'

*	modification history:
*
*	01/27/83 (fcm)	Adapted from C ITOH PRO WRITER
*

PRINTDEF equ	1000h

	org	PRINTDEF

VERSION	DB	3

; Printer Name for display -- must be exactly 16 characters
;		'................',0
prname	db	'DAISY WHEEL II  ',0

initflag db	0	;Has printer been initialized? (must be 0)


;	The following 2 parameters specify the number of increments per inch
;	that the printer can recognize, horizontally and vertically.  If the
;	printer has only fixed pitch, these should be the actual number of
;	characters and lines per inch that it prints.  If it supports full
;	incremental positioning, these would be actual increments -- typically
;	60 or 120 points horizontally and 24 or 48 vertically.	If the printer
;	can handle discrete pitches but not individual points, say 10 or 12
;	characters per inch but nothing else, the setting for 'incrh' should
;	be a common multiple of the various pitches -- 120, for example.  The
;	controls for HMI and VMI will adapt to the size closest to the pitch
;	required for formatting.  (Some printers may use one method for
;	horizontal pitch and another for vertical).

INCRH	DW	10	; MUST BE 10 TO FORCE MULTI-PITCHES TO CHARSIZE=1
INCRV	DW	12	; 6 LPI and 1/2 Spacing


;	The next 2 parameters indicate the maximum width allowable for a
;	single character or line feed.	If more movement is required, the
;	WP generates additional spacing.  If the printer is fully incremental,
;	the values are its specified maximum settings.	If it supports only
;	a single pitch, the value is 1.  If multiple fixed settings are
;	available, use the largest number of increments supported.

MAXH	DB	01		; Maximum character size supported
MAXV	DB	02		; Maximum line size supported one (1 ln @ 6LPI)


;	The following data is established and maintained by the WP.
;	Only the space need be reserved, as shown.


SETH	db	0	;Currently set character size
SETV	DB	0	;Currently set line size

posh	dw	0	;Horizontal position, in increments
posv	dw	0	;Vertical position, in increments

pdir	dw	1	;Current print direction


;	Hardware Implementation Data


*******************************************************************************
*									      *
*	Initialization Logic Command Control Block			      *
*									      *
DFINIT	DB	2		; Method 2 - use predefined sequence          *
	DW	SQINIT		; Address of initialization sequence	      *
HDWARE	DB	0		; Initial Hardware Attribute Status	      *
*									      *
*******************************************************************************

;	Printer Output Logic

dfout	db	80h	;Data Output Method
	dw	sqout	;Address of custom routine or status port or address
	db	0,0	;Status Mask AND and OR
	db	0	;Data Ready Pattern
	dw	0	;Output port or address


;	Printer Status Input Logic

dfinp	db	0	;Printer Input Method, if Applicable
	dw	0	;Address of custom routine or status port or address
	db	0,0	;Status Mask AND and OR
	db	0	;Data Ready Pattern
	dw	0	;Input Port or Address


;	Handshaking Protocol

dfhand	db	0	;Handshaking Method (none if by timing or hardware)
	dw	0	;Address of custom routine or actual codes to send/rcv
	db	0	;Buffer half-size (0 to send at logical eol)

;	Timing Delay Controls

dfnull	db	0	;Method for timing delays (if needed)
	dw	0	;Address of custom rtn or timing constant

*******************************************************************************
*									      *
*	Horizontal Motion Index Command Control Block  			      *
*									      *
DFHORT	DB	80H		; Method 80 - Execute CUSTOM ROUTINE	      *
	DW	SQHORT		; Address of pitch/sequence address table     *
	DW	0		; ------ not used at this time		      *
	DB	0		; ------ not used at this time 		      *
	DB	0		; ------ not used at this time 		      *
	DW	0		; ------ not used at this time		      *
*									      *
*******************************************************************************


*******************************************************************************
*									      *
*	Vertical Motion Index Command Control Block			      *
*									      *
DFVERT	DB	02h		; Method 2 - send code sequence		      *
	DW	SQVERT		; Address of code			      *
	DW	0		; ------- not used for code 2 method	      *
	DB	0		; Offset to apply to VMI not required         *
	DB	0FFH		; Format of VMI 255 = BINARY		      *
	DW	0		; Address of suffix sequence not required     *
*									      *
*******************************************************************************


*******************************************************************************
*									      *
*	Page Feed Logic Command Control Block				      *
*									      *
DFPAGE	DB	0		; Method 0 - Use Line Feeds to Reach EOP      *
	DW	SQPAGE		; Address of command sequence		      *
*									      *
*******************************************************************************


*******************************************************************************
*									      *
*	Line Feed Logic	Command Control Block				      *
*									      *
DFNEWL	DB	80h		; Method 2 - Execute LF command sequence      *
	DW	SQNEWL		; Address of command sequence 		      *
	db	0		; ------ not used at this time		      *
*									      *
*******************************************************************************


*******************************************************************************
*									      *
*	End-of-Line Logic Command Control Block				      *
*									      *
DFEOL	DB	2		; Method 2 - Execute CR command sequence      *
	DW	SQEOL		; Address of command sequence 		      *
	db	0		; ------ not used at this time		      *
*									      *
*******************************************************************************


;	Backspace Logic

dfbksp	db	0	;Method for implementing backspace
	dw	0	;Address of code sequence or timing count

;	Bidirectional Print Logic

dfbidi	db	0	;Method for implementing reverse print
	dw	0	;Address of code sequence to reverse print
	dw	0	;Address of code sequence to restore print forward
	db	0	; Reserved


*******************************************************************************
*									      *
*	Attribute: Boldface (Enhanced-print-mode)			      *
*									      *
DFBOLD	DB	0		; Method 2 - Execute command sequence	      *
	DW	0		; Address of Boldface-On sequence	      *
	DW	0		; Address of Boldface-Off sequence	      *
	DB	0		; Flag - must be zero to suppress shadow prnt *
*									      *
*******************************************************************************


*******************************************************************************
*									      *
*	Attribute: Under Score						      *
*									      *
DFUNDER	DB	2		; Method 2 - Execute command sequence	      *
	DW	SQUNDRON	; Address for Underscore-On sequence	      *
	DW	SQUNDROF	; Address for Underscore-Off sequence	      *
	DB	7fh		; Used to indicate Solid Underline	      *
*									      *
*******************************************************************************


*******************************************************************************
*									      *
*	Attribute: Doublescore Command Control Block (DOUBLE WIDE PRINT)      *
*									      *
DFDBLS	DB	0		; Method 2 - Execute DOUBLE-WIDE-PRINT seq.   *
	DW	0		; Address of Doublewide ON sequence	      *
	DW	0		; Address of Doublewide OFF sequence	      *
	DB	0		; ------ not used at this time		      *
*									      *
*******************************************************************************


;	Attribute: Strikethrough
dfthru	db	0	;Method for implementing strikethru
	dw	0	;Address for Sequence-On
	dw	0	;Address for Sequence Off
	db	0	; Reserved


*******************************************************************************
*									      *
*	Attribute: Ribbon Shift	Command Control Block (Graphics characters)   *
*									      *
DFRIBN	DB	2		; Method 2 - Execute CUSTOM SEQUENCE          *
	DW	nullsq		; Address of Emphasized-print ON sequence     *
	DW	nullsq		; Address of Emphasized-print OFF sequence    *
	DB	0		; ------ Not used at this time		      *
*									      *
*******************************************************************************


*******************************************************************************
*									      *
*	Attribute: Extended Character Set Command Control Block (Greek/Math)  *
*									      *
DFEXT	DB	0		; Method 2 - Execute CUSTOM SEQUENCE	      *
	DW	0		; Address for Sequence-On		      *
	DW	0		; Address of Sequence-Off		      *
	DB	'@'		; ------ Not used at this time		      *
*									      *
*******************************************************************************


*******************************************************************************
*									      *
*	Attribute: Alternate Font Command Control Block (Proportional print)  *
*									      *
DFFONT	DB	80H		; Method 80 - Execute CUSTOM ROUTINE	      *
	DW	SQFONTON	; Address for sequence-on		      *
	DW	SQFONTOF	; Address for sequence-off		      *
	DB	0		; ------ Not used at this time		      *
*									      *
*******************************************************************************


;	CONTROL BLOCK: CARRIAGE SHIFT SEQUENCE

dfshft	db	0			; METHOD FOR IMPLEMENTATION
	dw	0			; ADDRESS FOR SEQUENCE ON
	dw	0			; ADDRESS FOR SEQWUENCE OFF
	db	0			; FLAG BYTE FOR SHIFT STATUS

;	CONTROL BLOCK: PROPORTIONAL PRINT CONTROL

dfprop	db	80h			; METHOD FOR IMPLEMENTATION
	dw	sqfonton		; ADDRESS FOR SEQUENCE ON
	dw	sqfontof		; ADDRESS FOR SEQUENCE OFF
	db	127			; FLAG BYTE
	db	0,255,0,0		; OPEN

;	CONTROL BLOCK: RESERVED FOR EXPANSION
; END OF DOC, SEND CTRL Z
DFEDOC	DB	2
	DW	SQEDOC
	DW	0
	DB	01	;SEND AFTER TOF
dfxtra	EQU	$
	DB	0,0,0,0,0,0
	DB	0,0,0,0,0,0


***********************************************************************
*								      *
*	USER COMMUNICATIONS AREA FOR CUSTOM ROUTINE IMPLEMENTATION    *
*								      *
***********************************************************************
*								      *
DOCUPTR	DS	2		; POINT TO DOCUMENT HEADER AREA	      *
FORMPTR	DS	2		; POINT TO FORMAT HEADER AREA	      *
TEXTPTR	DS	2		; POINT TO EXPANDED TEXT ARRAY	      *
ATTRPTR	DS	2		; POINT TO ATTRIBUTE ARRAY	      *
SIZEPTR	DS	2		; POINT TO CHARACTER WIDTH ARRAY      *
FONTPTR	DS	2		; POINT TO FONT DEFINITION TABLE      *
	DS	2		; REESERVED POINTER		      *
	DS	2		; REESERVED POINTER		      *
	DS	2		; REESERVED POINTER		      *
	DS	2		; REESERVED POINTER		      *
INDX	DS	2		; CURRENT VALUE OF ARRAY OFFSET	      *
*								      *
CHAR	DS	1		; CURRENT PRINTABLE CHARACTER (INPUT) *
ATTR	DS	1		; ATTRIBUTES FOR THIS CHARACTER	      *
WDTH	DS	1		; CHARACTER WIDTH (HMI & HAMMER INTS) *
OPCHAR	DS	1		; CURRENT PRINTABLE CHARACTER (OUTPT) *
OPWDTH	DS	1		; HMI SETTING FOR OUTPUT CHARACTER    *
BKMASK	DS	1		; REPRINT REQ'D MASK BITS	      *
BKCHAR	DS	1		; CHARACTER TO OVERPRINT AFTER BKSP   *
UNDR	DS	1  		; UNDERSCORE CHAR FOR THIS POSITION   *
OVER	DS	1		; OVERSTRIKE CHAR FOR THIS POSITION   *
TYPE	DS	1		; LINE TYPE (SUPER,BASE,SUB)	      *
*								      *
*								      *
*		END OF COMMUNICATIONS AREA			      *
*								      *
***********************************************************************


;	CODE SEQUENCES AND CUSTOM ROUTINES SHOULD FOLLOW HERE



***********************************************************************
*								      *
SQINIT	DB	00,04,27,21,27,15	; ENABLE CR ONLY, 6 LPI	      *
*								      *
************************************************************************


***********************************************************************
*								      *
SQPAGE	DB	00,01,12	; FORMFEED SEQUENCE		      *
*								      *
***********************************************************************

***********************************************************************
*								      *
SQVERT	DB	00,00,00	; DUMMY VERTICAL MOTION SET	      *
*								      *
***********************************************************************

***********************************************************************
*								      *
SQEOL	DB	00,01,13	; CARRIAGE-RETURN SEQUENCE	      *
*								      *
***********************************************************************

***********************************************************************
*								      *
*	Set Horizontal Spacing Command Sequences		      *
*								      *
SQHORT	EQU	$		;				      *
	lhld	1366h		; formcur$fcpi			      *
	mov	a,h		;				      *
	ora	l		;				      *
	jz	sqhort0		;				      *
      	LDA	ATTR		; TEST FOR ALTERNATE FONT ON	      *
	ANI	80H		;				      *
	JZ	SQHORTY		;				      *
sqhort0	LDA	OPCHAR		; EXIT IF NOT BLANK		      *
	CPI	' '		;				      *
	JNZ	SQHORTW		;				      *
	LDA	OPWDTH		; PICK UP CHARACTER WIDTH FOR SPACE   *
	sta	sqhort$savea	;				      *
sqhorta	lda	sqhort$savea	; EXIT IF WIDTH GOES ZERO	      *
	ana	a		;				      *
	JZ	SQHORTW		;				      *
	sui	5		; REDUCE WIDTH BY SIZE OF SPACE	      *
	sta	sqhort$savea	;				      *
	jm	sqhortb		;				      *
	mvi	A,' '		; OUTPUT A SPACE (WIDTH=5)	      *
	CALL	SYSOUT		;				      *
	JMP	SQHORTA		;				      *
sqhortb	adi	05h		; RESTORE PARTIAL SPACE SIZE (1-6)    *
	STA	sqhort$savea	;				      *
 	MVI	A,27		; OUTPUT AN ESCAPE SEQ FOR PARTIAL    *
 	CALL	SYSOUT		; SEND ESC TO CP/M		      *
	lda	sqhort$savea	; RESTORE PARTIAL SPACE SIZE	      *
	call	SYSOUT		; SEND # OF 'DOTS' TO CP/M	      *
SQHORTW	MVI	A,80H		; RESTORE CUSTOM EXIT FLAG	      *
	RET			; & RETURN TO WPEDPRNT		      *
sqhort$savea db 0		;				      *
SQHORTY	MVI	A,04		; DISCRETE CPI SETTING FLAG	      *
	LXI	H,DFHORTXX	; SECONDARY CONTROL BLOCK	      *
	RET			; LET WPEDPRNT DO IT		      *
*								      *
DFHORTXX DB	04		; SECONDARY CTL BLK FOR CPI SETTINGS  *
	 DW	SQHORTXX	;				      *
*								      *
SQHORTXX DW	0000AH		; arguement word - Pitch = 10 CPI     *
	 DW	SQHORT10	; -- set 10 cpi sequence address      *
	 DW	0FFFFH		; last arguement MUST be x'FFFF'      *
	 DW	SQHORT12	; -- set 17 cpi sequence address      *
SQHORT10 DB	00,02,27,15	; Null count, string length, sequence *
SQHORT12 DB	00,02,27,14	; Null count, string length, sequence *
*								      *
***********************************************************************


***********************************************************************
*								      *
*	Set VMI Command Sequence				      *
*								      *
***********************************************************************

***********************************************************************
*								      *
SQUNDRON DB	00,01,15	; Underline mode ON sequence	      *
SQUNDROF DB	00,01,14	; Underline mode OFF sequence	      *
*								      *
***********************************************************************


***********************************************************************
*								      *
*	TURN ON PROPORTIONAL PRINT AND RESET MAX CHAR SIZE	      *
*								      *
SQFONTON MVI	A,7Fh		; FORCE MAX CHAR SIZE HIGH	      *
	JMP	SQFONTOF+2	;				      *
SQFONTOF MVI	A,01		; FORCE MAX CHAR SIZE HIGH	      *
	STA	MAXH		;				      *
	MVI	A,02H		; USE GENPROC TO SEND OUTPUT SEQ      *
	LXI	H,DFFONTXX	; DUMMY DF BLOCK		      *
	RET			;				      *
*								      *
DFFONTXX DB	02		;				      *
	 DW	SQFONTONXX	;				      *
	 DW	SQFONTOFXX	;				      *
	 DB	0		;				      *
*								      *
SQFONTONXX DB	00,02,27,17	; ENTER PROPORTIONAL PRINT MODE       *
SQFONTOFXX DB	00,02,27,15	; RETURN TO 10 CPI FROM PROPORTIONAL  *
*								      *
***********************************************************************

***********************************************************************
*								      *
*	Trap Output and save line lize, either 01 or 02		      *
*								      *
SQOUT	MOV	A,E		;				      *
	CPI	01		;				      *
	JZ	SQOUTA		;				      *
	CPI	02		;				      *
	JZ	SQOUTA		;				      *
	lda	ATTR		; SEE IF ITS PROPORTIONAL-EXTENDED    *
	ANI	0A0H
	CPI	0A0H		;				      *
	MOV	A,E
	JNZ	SQOUT0		;				      *
	SUI	'@'
	RLC
	ANI	0FEH
	MOV	E,A
	MVI	D,0
	LHLD	FONTPTR
	DAD	D
	INX	H
	MOV	A,M
SQOUT0	CALL	SYSOUT		;				      *
	JMP	SQOUTB		;				      *
				;				      *
SQOUTA	STA	LINESZ		;				      *
SQOUTB	MVI	A,80H		;				      *
	RET			;				      *
*								      *
***********************************************************************


***********************************************************************
*								      *
*	SEND 1/2 OR FULL LINE SPACE BASED ON LINE SIZE		      *
*								      *
SQNEWL	LDA	LINESZ		;				      *
	LXI	H,SQNEWL1	;				      *
	CPI	02		;				      *
	JZ	SQNEWLA		;				      *
	LXI	H,SQNEWL2	;				      *
SQNEWLA	MVI	A,02		;				      *
	RET			;				      *
SQNEWL1	DB	02		;				      *
	DW	SQNEWL1S	;				      *
SQNEWL1S DB	00,01,10	;				      *
SQNEWL2	DB	02		;				      *
	DW	SQNEWL2S	;				      *
SQNEWL2S DB	00,02,27,28	;				      *
LINESZ	DB	2		;				      *
*								      *
***********************************************************************

***********************************************************************
*								      *
*	CALL SYSTEM OUTPUT TO LST OR PUN DEVICE			      *
*								      *
SYSOUT	EQU	$		;				      *
	MOV	E,A		;				      *
	LXI	H,DFOUT+5	;				      *
	MVI	A,5		;				      *
	SUB	M		;				      *
	MOV	C,A		;				      *
	CALL	5		;				      *
	RET			;				      *
*								      *
***********************************************************************
SQEDOC	DB	0,1,26	;CTRL Z AT END OF DOC
	org	11f0h
nullsq	db	0,0,0

	end
=!z{w#
% w!P͠
y͓}*w#"͌
@.@<!Eͷ~P
!