; M712DC.ASM		Paul Mennen	14-Nov-83
;
; MDM712 overlay for the PDP-11 or LSI-11 with the DECMATION CP/M card.
;

; Edit this file for your preferences then follow the "TO USE:" example
; shown below.
;
;	TO USE: First edit this file filling in answers for your own
;		equipment.  Then assemble with ASM.COM or equivalent
;		assembler.  Then use DDT to overlay the the results
;		of this program to the original .COM file:
;
;		A>DDT MDM712.COM
;		DDT VERS 2.2
;		NEXT  PC
;		4300 0100
;		-IM712DC.HEX		(note the "I" command)
;		-R			("R" loads in the .HEX file)
;		NEXT  PC
;		4300 0000
;		-G0			(return to CP/M)
;		A>SAVE 66 MDM712.COM	(now have a modified .COM file)
;
;
BELL:		EQU	07H		;bell
CR:		EQU	0DH		;carriage return
ESC:		EQU	1BH		;escape
LF:		EQU	0AH		;linefeed
;
YES:		EQU	0FFH
NO:		EQU	0
;
;
; Change the following information to match your equipment
;
		ORG	100H
;
;
; Change the clock speed to suit your system
;
		DS	3	;(for  "JMP  START" instruction)
;
PMMIMODEM:	DB	NO	;yes=PMMI S-100 Modem			103H
SMARTMODEM:	DB	YES	;yes=HAYES Smartmodem, no=non-PMMI	104H
TOUCHPULSE:	DB	'T'	;T=touch, P=pulse (Smartmodem-only)	105H
CLOCK:		DB	1	;clock speed in MHz x10, 25.5 MHz max.	106H
				;20=2 MHz, 37=3.68 MHz, 40=4 MHz, etc.
				;[PM] .1 Mhz effective rate due to the
				;unusally long reciever ready sequence
MSPEED:		DB	5	;0=110 1=300 2=450 3=600 4=710 5=1200	107H
				;6=2400 7=4800 8=9600 9=19200 default
BYTDLY:		DB	5	;0=0 delay  1=10ms  5=50 ms - 9=90 ms	108H
				;default time to send character in ter-
				;minal mode file transfer for slow BBS.
CRDLY:		DB	5	;0=0 delay 1=100 ms 5=500 ms - 9=900 ms 109H
				;default time for extra wait after CRLF
				;in terminal mode file transfer
NOOFCOL:	DB	5	;number of DIR columns shown		10AH
SETUPTST:	DB	NO	;yes=user-added Setup routine		10BH
SCRNTEST:	DB	YES	;Cursor control routine			10CH
ACKNAK:	 	DB	YES	;yes=resend a record after any non-ACK	10DH
				;no=resend a record after a valid-NAK
BAKUPBYTE:	DB	NO	;yes=change any file same name to .BAK	10EH
CRCDFLT:	DB	YES	;yes=default to CRC checking		10FH
TOGGLECRC:	DB	YES	;yes=allow toggling of CRC to Checksum	110H
CONVBKSP:	DB	NO	;yes=convert backspace to rub		111H
TOGGLEBK:	DB	YES	;yes=allow toggling of bksp to rub	112H
ADDLF:		DB	NO	;no=no LF after CR to send file in	113H
				;terminal mode (added by remote echo)
TOGGLELF:	DB	YES	;yes=allow toggling of LF after CR	114H
TRANLOGON:	DB	YES	;yes=allow transmission of logon	115H
				;write logon sequence at location LOGON
SAVCCP:		DB	YES	;yes=do not overwrite CCP		116H
LOCONEXTCHR:	DB	NO	;yes=local command if EXTCHR precedes	117H
				;no=external command if EXTCHR precedes
TOGGLELOC:	DB	YES	;yes=allow toggling of LOCONEXTCHR	118H
LSTTST:		DB	YES	;yes=printer available on printer port	119H
XOFFTST:	DB	NO	;yes=checks for XOFF from remote while	11AH
				;sending a file in terminal mode
XONWAIT:	DB	NO	;yes=wait for XON after CR while	11BH
				;sending a file in terminal mode
TOGXOFF:	DB	YES	;yes=allow toggling of XOFF checking	11CH
IGNORCTL:	DB	YES	;yes=CTL-chars above ^M not displayed	11DH
EXTRA1:		DB	0	;for future expansion			11EH
EXTRA2:		DB	0	;for future expansion			11FH
BRKCHR:		DB	'@'-40H ;^@ = Send 300 ms. break tone		120H
NOCONNCT:	DB	'N'-40H ;^N = Disconnect from the phone line	121H
LOGCHR:		DB	'L'-40H ;^L = Send logon			122H
LSTCHR:		DB	'P'-40H ;^P = Toggle printer			123H
UNSAVE:		DB	'R'-40H ;^R = Close input text buffer		124H
TRANCHR:	DB	'T'-40H ;^T = Transmit file to remote		125H
SAVECHR:	DB	'Y'-40H ;^Y = Open input text buffer		126H
EXTCHR:		DB	'^'-40H ;^^ = Send next character		127H
;
;
		DS	2		;				128H
;
IN$MODCTL1:	RET ! RET ! RET		;in modem control port		12AH
		DS	7
OUT$MODDATP:	JMP	OTDATP		;out modem data port		134H
		DS	7
IN$MODDATP:	JMP	INDATP		;in modem data port		13EH
		DS	7
ANI$MODRCVB:	RET ! RET ! RET		;bit to test for receive ready	148H

CPI$MODRCVR:	JMP	INCTLP		;value of rcv. bit when ready	14BH
ANI$MODSNDB:	RET ! RET ! RET		;bit to test for send ready	14EH
CPI$MODSNDR:	JMP	OTCTLP		;value of send bit when ready	151H
		DS	6		;				156H
;
OUT$MODCTL1:	RET ! RET ! RET		;out modem control port #1	15AH
OUT$MODCTL2:	RET ! RET ! RET		;out modem control port #2	15DH
;
LOGONPTR:	DW	LOGON		;for user message.		160H
		DS	6		;				162H
JMP$GOODBYE:	JMP	GOODBYE		;				168H
JMP$INITMOD:	JMP	INITMOD		;go to user written routine	16BH
		RET  !  NOP  !  NOP	;(by-passes PMMI routine)	16EH
		RET  !  NOP  !  NOP	;(by-passes PMMI routine)	171H
		RET  !  NOP  !  NOP	;(by-passes PMMI routine)	174H
JMP$SETUPR:	JMP	SETUPR		;				177H
JMP$SPCLMENU:	JMP	SPCLMENU	;				17AH
JMP$SYSVER:	JMP	SYSVER		;				17DH
JMP$BREAK:	JMP	SENDBRK		;				180H
;
;
; Do not change the following six lines.
;
JMP$ILPRT:	DS	3		;				183H
JMP$INBUF	DS	3		;				186H
JMP$INLNCOMP:	DS	3		;				189H
JMP$INMODEM	DS	3		;				18CH
JMP$NXTSCRN:	DS	3		;				18FH
JMP$TIMER	DS	3		;				192H
;
; 
; Routine to clear to end of screen.  If using CLREOS and CLRSCRN, set
; SCRNTEST to YES at 010AH (above).
;
CLREOS:		CALL	JMP$ILPRT		;			195H
		DB	1Bh,5Bh,4Ah,0,0		;			198H
		RET				;			19DH
;
CLRSCRN:	CALL	JMP$ILPRT		;			19EH
		DB	1Bh,5Bh,23h,4Ah,0	;			1A1H
		RET				;			1A6H
	
;
SYSVER:		CALL	JMP$ILPRT		;			1A7H
		DB	'Version for Decmation D100QU'
		DB	CR,LF,0
		RET
;.....
;
;
;-----------------------------------------------------------------------
;
; NOTE:	You can change the SYSVER message to be longer or shorter.  The
;	end of your last routine should terminate by 0400H (601 bytes
;	available after start of SYSVER) if using the Hayes Smartmodem
;	or by address 0C00H (2659 bytes) otherwise.
;
;-----------------------------------------------------------------------
;
; You can put in a message at this location which can be called up with
; CTL-O if TRANLOGON has been set TRUE.  You can use several lines if
; desired.  End with a 0.
;
LOGON:		DB	'72366,417',CR,LF,0
;
;
; Add your own routine here to send a break tone to reset some time-share
; computers, if desired.
;
SENDBRK:	RET
;.....
;
SETUPR:		RET
GOODBYE:	RET
;
;
; If using the Hayes Smartmodem this is unavailable without a special
; change.
;
SPCLMENU:	RET
;
;
MDMOUT	EQU	0FA45H		;[PM] Modem output BIOS call location
MDMIN	EQU	0FA48H		;[PM] Modem input BIOS call location
INCNT	DB	0		;[PM] Input character count (Local copy)
OUTCNT	DB	0		;[PM] # of bytes free space in Output buffer
;
;
INITMOD:			; [PM] Initialize the modem serial port
	SUB	A
	STA	INCNT		; CLEAR LOCAL INPUT COUNTER
	STA	OUTCNT		; CLEAR LOCAL OUTPUT COUNTER
	MVI	B,2		; INITIALZE PORT ACTION CODE
	JMP	MDMOUT
;
RESETMOD:			; [PM] Reset the serial port
	MVI	B,3		; UNINITIALIZE PORT ACTION CODE
	JMP	MDMOUT
;
;	[PM] Routine to get a character from Modem
;
INDATP:
	PUSH	H
	PUSH	D
	PUSH	B
	LDA	INCNT
	DCR	A
	STA	INCNT		; DECREMENT LOCAL COUNTER
	MVI	B,1		; MODEM INPUT ACTION CODE
	CALL	MDMIN		; GET THE CHARACTER INTO REG A
	POP	B		; RESTORE REGISTERS
	POP	D
	POP	H
	RET
;
;	[PM] Routine to send a character to Modem
;
OTDATP:
	PUSH	H
	PUSH	D
	PUSH	B
	PUSH	PSW		; MUST RETURN WITH REG A UNCHANGED
	MOV	C,A		; SAVE CHARACTER TO SEND IN C
	LDA	OUTCNT
	DCR	A
	STA	OUTCNT		; DECREMENT LOCAL COUNTER
	MVI	B,1		; MODEM OUTPUT ACTION CODE
	CALL	MDMOUT		; SEND THE CHARACTER IN REG C
	POP	PSW		; RESTORE REGISTERS
	POP	B
	POP	D
	POP	H
	RET

;
;	INPUT STATUS FUNCTION [PM]
;
;	To determine if a character has been recieved by the modem use:
;		CALL	INCTLP
;	The zero flag will be set if a character has been recieved and will
;	be clear if no characters are available.
;
INCTLP:				; [PM] Input Control Function (Input status)
	LDA	INCNT		; GET LOCAL INPUT COUNTER
	ORA	A		; IS IT ZERO ?
	JZ	INCT3		; JUMP IF YES (LOCAL COUNTER SAYS EMPTY)
INCT2:	SUB	A		; COME HERE IF A CHARACTER IS AVAILABLE
	RET			; RETURN WITH ZERO BIT SET TO INDICATE READY
INCT3:	PUSH	H
	PUSH	D
	PUSH	B
	MVI	B,2		; ACTION CODE FOR INPUT STATUS FUNCTION
	CALL	MDMIN
	STA	INCNT		; UPDATE LOCAL COUNTER
	ORA	A		; IS THE NEW COUNTER ALSO ZERO ?
	JZ	INCT4		; JUMP IF YES (EVEN THE 11 SAYS ITS EMPTY)
	POP	B		; HERE IF CHARACTERS ARE AVAILABLE
	POP	D
	POP	H
	JMP	INCT2
INCT4:	POP	B
	POP	D
	POP	H
	ORI	1		; CLEAR THE ZERO BIT
	RET			; TO INDICATE NO CHARACTERS AVAILABLE

;
;	OUTPUT STATUS FUNCTION [PM]
;
;	To determine if the modem is ready to accept another character use:
;		CALL	OTCTLP
;	The zero flag will be set if the output buffer is full and no new
;	characters can be accepted.  The zero flag will be clear if the modem
;	is ready to recieve more characters.
;
OTCTLP:				; [PM] Output control function (Output status)
	LDA	OUTCNT		; GET LOCAL COUNTER
	ORA	A		; IS IT ZERO ?
	JNZ	OTCT3		; JUMP IF YES (LOCAL COUNTER SAYS FULL)
OTCT2:	SUB	A		; COME HERE IF THERE IS ROOM IN BUFFER
	RET			; CLEAR ZERO BIT TO INDICATE READY
OTCT3:	PUSH	H
	PUSH	D
	PUSH	B
	MVI	B,3		; OUTPUT STATUS ACTION CODE
	CALL	MDMIN
	STA	OUTCNT		; UPDATE LOCAL COUNTER
	ORA	A		; IS THE NEW COUNTER ALSO ZERO ?
	JZ	INCT4		; JUMP IF YES (EVEN THE 11 SAYS ITS FULL)
	POP	B		; HERE IF BUFFER NOT FULL
	POP	D
	POP	H
	JMP	OTCT2

; This patch causes the modem reset routine to be called just before the
; program exits to CP/M.  The GOODBYE routine cannot be used for this purpose
; since characters are sent to the modem after the GOODBYE routine is called.
;
PATCH:	CALL	RESETMOD	; RESET THE MODEM PORT
	LDA	SAVCCP		; REPLACE PATCHED OVER INSTRUCTION
	RET
;
; NOTE:	MUST TERMINATE PRIOR TO 0400H (with Smartmodem)
;				0C00H (without Smartmodem)
;.....

	ORG	268Fh		; LOCATION OF LDA SAVCCP INSTRUCTION
	CALL	PATCH		; INSERT THE PATCH INTO THE EXIT ROUTINE
;
		END
;
;

