; module RWS1.ASM used with RWS2.ASM to create RWS.COM
; for running WordStar version 3.3 with modified key assignments
;
	org	0100h	;code to relocate cp/m
	lxi	sp,0400h	;relocate stack pointer
	call	mvlin	;set up command line
	lxi	h,0980h	;where 63k cpm kept
	lxi	d,0e000h	;where going to
loop:	mov	a,m
	stax	d
	inx	h
	inx	d
	mov	a,d
	cpi	0fah	;done yet?
	jnz	loop
;cp/m now relocated, now start it up
	lxi	h,0fa00h-0400h+3	;new warm boot adr
	shld	1
	lxi	h,0ec06h-0400h	;new bdos adr
	shld	6
	lda	4	;boot disk num
	mov	c,a
	jmp	0e400h-0400h	;start ccp
; 
; subroutine to move the command line
; to internal line buffer in CP/M image
; when CP/M is started it executes the command
;
; if user types:
;
; A>DB	(does auto load of program at AUTOD)
; A>DB(space)	(no auto load, start aux bios)
; A>DB (command line)	(executes specified command line)
;
mvlin:	lda	080h	;count for command line
	cpi	1	;if single character (space)
	rz		;dont move command line
	cpi	0	;no user command line then
	jz	auto
	dcr	a	;count associated with leading space
	mov	c,a	;count to move
	lxi	h,082h	;data to move
mvl2:	lxi	d,0987h	;ccp buffer
	mov	a,c	;count to move
	stax	d	;to ccp buffer
	inx	d	;point to message area of ccp buffer
mvl3:	mov	a,m	;get char to move
	stax	d	;move it to ccp
	inx	h
	inx	d
	dcr	c
	jnz	mvl3	;loop to move line
	mvi	a,00H
	stax	d	;stick zero at end of string
	ret
;
;
auto:	lxi	h,autod	;pointer to fixed message
	mov	c,m	;count
	inx	h	;step to message text
	jmp	mvl2	;go move it
autod:	db	2,'WS'
