/*	Copyright (c) 1985,1986,1987  EXCELAN, INC. 	*/
/*	  All Rights Reserved.                         	*/

/*	The copyright notice above does not evidence any 	*/
/*	actual or intended publication. 			*/

/*	THIS IS UNPUBLISHED COMPUTER SOFTWARE CONTAINING TRADE SECRETS 	*/
/*	AND CONFIDENTIAL INFORMATION PROPRIETARY TO EXCELAN, INC. 	*/

/* $Header: client.h,v 1.4 87/04/28 15:59:11 davidb Exp $ */

#define NCLIENTS		2		/* No. of clients */

typedef long	EXaddr_t;

struct socket_info {
	short		client_id;
	short		soid;
	short		flags;
}; /* socket_info */

/* Flags field definition in struct socket_info */
#define SOCK_FREE		0	/* unallocated */
#define SOCK_IN_USE		1	/* allocated */
#define SOCK_SET		2	/* socket id has been set */
#define SOCK_WAITING		4	/* socket waiting for a bucket */
#define SOCK_RESET		8	/* socket has been reset */


struct client_info {
	EXaddr_t	low_addr;
	EXaddr_t	high_addr;
	VOID		(*intr_addr)();
	VOID		(*notify_addr)();
	VOID		(*reset_addr)();
	short		flags;			
			/* flags to indicate client waiting for bucket
			 * availability not related to ang specific socket.
			 */
}; /* struct client_info */

/* flags field definition in struct client_info 
 * Note that these definitons are in parallel match with
 * those in socket_info. This is for convenience of debugging;
 * Codes do not depend on this parallelism.
 */

#define CLIENT_FREE		0	/* not registered */
#define CLIENT_REGISTERED	1	/* client has registered */
#define CLIENT_RESERVED		2	/* Not used */
#define CLIENT_WAITING		4	/* client waiting for a bucket */



/* ----------------- IMPORTS FROM CLIENT_MODULE ------------------- */

#ifndef MODULE_CLIENT

#define intrpt_client( client_id, message ) { \
	IMPORT struct client_info	client_info[]; \
	if (client_info[ client_id ].intr_addr != 0) \
		(*(client_info[ client_id ].intr_addr))( message ); \
}
#endif /* MODULE_CLIENT */


#ifdef pcxenix

/*
 * We can do some type checking with xenix compiler
 */
#define EXbatype faddr_t
IMPORT int client_register( EXaddr_t, EXaddr_t, VOID (*)(), VOID (*)(),
	VOID (*)(), short * );
IMPORT int socket_alloc( short, short * );
IMPORT int socket_set( short, short, short );
IMPORT int socket_deallocate( short, short );
IMPORT int message_alloc( short, short, struct msg ** );
IMPORT int message_send( short, short, struct msg * );
IMPORT int board_rw( short, EXbatype, long, int, int );
IMPORT short userid_to_clientid( EXaddr_t );
IMPORT short soid_to_clientid( short );
IMPORT VOID board_reset();
IMPORT VOID wakeup_bucket_requestor();

#else
IMPORT int client_register();
IMPORT int socket_alloc();
IMPORT int socket_set();
IMPORT int socket_deallocate();
IMPORT int message_alloc();
IMPORT int message_send(); 
IMPORT int board_rw();
IMPORT short userid_to_client();
IMPORT short soid_to_client();
IMPORT VOID board_reset();
IMPORT VOID wakeup_bucket_requestor();
#endif /* pcxenix */

