/*	Copyright (c) 1985,1986,1987  EXCELAN, INC. 	*/
/*	  All Rights Reserved.                         	*/

/*	The copyright notice above does not evidence any 	*/
/*	actual or intended publication. 			*/

/*	THIS IS UNPUBLISHED COMPUTER SOFTWARE CONTAINING TRADE SECRETS 	*/
/*	AND CONFIDENTIAL INFORMATION PROPRIETARY TO EXCELAN, INC. 	*/

/* $Header: init.c,v 1.3 87/05/14 17:46:44 davidb Exp $ */
/* 

	@(#)init.c	1.1 8/16/85

	Filename:	init.c

	Compiler:	Lattice C

	Target Machine:	IBM PC

	Description:	this program runs on the PC and initializes
			the EXOS 205 board 

	Create Date:	031085 (clc)

	Edit History:


*/

#include	"def.h"
#include	"comn.h"
#ifdef LATICE
#include	"\lattice\ctype.h"
#include	"\lattice\stdio.h"
#else	/* LATICE */
#include	<stdio.h>
#include	<sys/exos205.h>

extern int ofd;
#endif	/* LATICE */

UBYTE2	compcode;
UBYTE2	debug,verbose,icedebug;
#ifdef LATICE
UBYTE	nxfn[] = "a:nx205.86";
#else
UBYTE	nxfn[] = NMFILE;
/* UBYTE	nxfn[] = "/net/NX205"; */
#endif	/* LATICE */
UBYTE	filnam[40];


/* check whether to continue executing the program */
/* if the test failed, prompt user whether to ignore the failure, 
retry the failed test, or abort the job */
BOOLEAN chk_go_on() 
{
int	ch;
int	ch2;

if (compcode==SUC) return(TRUE);
if (verbose==TRUE) {
	for (;;) {
		printf("\nIgnore, Retry, or Abort [i/r/a] :  ");
		ch = getchar();
		ch = tolower(ch);
		while( ch != EOF && (ch2 = getchar()) != '\n' && ch2 != EOF )
			;
		switch (ch) {
		case 'a': 
			exit(1);
		case 'i':
			return(TRUE);
		case 'r':
			return(FALSE);
		default:
			break;
		}
	} 
} else {
	exit(1);
}
}




main(argc,argv)
UBYTE2	argc;
ADDRESS	argv[];
{
ADDRESS	ss;
UBYTE	*s;
UBYTE	chr;

debug = FALSE;
verbose = FALSE;
icedebug = FALSE;
filnam[0] = NULL;
#ifdef LATICE
nxfn[0] = (bdos(0x19) & 0xff) + 'a';  /* get current default drive */

clrscrn();
#endif
printf("\nExcelan EXOS 205 INIT utility V 1.0  05/15/85\n");

while (argc > 1) {	/* parse parameters if any */
	++argv;
	--argc;
	ss = argv[0];
	prse(ss);
}
debparam();

exosopen();
if( ioctl( ofd, EXRESET205, (char *)0 ) < 0 ) {
	perror( "EXRESET205" );
	exit( 1 );
}
if( ioctl( ofd, EXDIRECTACCESS, (char *)0 ) < 0 ) {
	perror( "EXDIRECTACCESS" );
	exit( 1 );
}
ctlini();		/* initialize exos control port */

#ifdef TESTS
for (;;) {
	compcode = test_mem();	/* memory test */
	if (chk_go_on()==TRUE) break;
}

for (;;) {
	compcode = test_prty();	/* parity test */
	if (chk_go_on()==TRUE) break;
}

for (;;) {
	compcode = test_net();	/* 82586 test */
	if (chk_go_on()==TRUE) break;
}
#endif	/* TESTS */

if( verbose )
	printf( "\nclearing exos memory\n" );
clr_exo_mem();		/* clear exos memory */
if( verbose )
	printf( "clearing exos memory cleared\n" );

for (;;) {
	s = nxfn;
	if (filnam[0] != NULL)	s = filnam;
	if (verbose == TRUE)
		printf("\n\ndownloading %s on to the board...",s);
	compcode = load(s);
	if ((verbose == TRUE) && (compcode ==SUC))
		printf("\n%s loaded successfully",s);
	if (chk_go_on()==TRUE) break;
}
	
if ( (debug==TRUE) || (verbose) )
	printf("\n\ninitializing EXOS control...\n");

if( debug ) {
	printf( "<CR> to enable net:" );
	gets( &chr );
}
hst_ca();
enbl_net();		/* enable 82586 */
if( debug ) {
	printf( "<CR> to enable parity:" );
	gets( &chr );
}
/* vvvvvvvvvvvvvvvvvv
enbl_prty();		
 */
/* enable parity detection circuitry */
if( debug ) {
	printf( "<CR> to put 82586 in normal mode:" );
	gets( &chr );
}
nrml_net();		/* put 82586 to normal mode */
if( debug ) {
	printf( "<CR> to give 82586 CA to exos:" );
	gets( &chr );
}
exo_ca();		/* give 82586 CA to exos */
if( debug ) {
	printf( "<CR> to enable exos:" );
	gets( &chr );
}
enbl_exo();		/* enable exos */

if (icedebug==TRUE) {
	printf("\n\nNow start i2ice from 0ffff0, hit <CR> when ready:  "); 
	gets(&chr);
}

compcode = wait_rdy();	/* wait till the board is ready */
if (compcode==FAIL) exit(1);

set_ring();		/* set ring buffers below the high paragraph */
set_init_msg();		/* prepare init msg */
pass_init_ptr();	/* write init msg ptr to 1fff0 */
/* [1]	debhlp(); */
if( debug ) {
	printf( "<CR> to interupt board:" );
	gets( &chr );
}
int_exo();		/* interrupt exos */
compcode = wait_rpl();	/* wait for init reply from exos */
if (compcode==SUC) {
	 dspl_vrsn();
	exit( 0 );
}
exit(1 );

}

