/*	Copyright (c) 1985,1986,1987  EXCELAN, INC. 	*/
/*	  All Rights Reserved.                         	*/

/*	The copyright notice above does not evidence any 	*/
/*	actual or intended publication. 			*/

/*	THIS IS UNPUBLISHED COMPUTER SOFTWARE CONTAINING TRADE SECRETS 	*/
/*	AND CONFIDENTIAL INFORMATION PROPRIETARY TO EXCELAN, INC. 	*/

/* $Header: subr.c,v 1.3 87/05/14 17:46:47 davidb Exp $ */

/*
 * @(#)subr.c	1.1 8/16/85
 */


#include "def.h"
#include "comm.h"
#define  EXOSDEV "/dev/EXOS/xmem"

extern int debug;
extern int verbose;

int ofd;

exosopen()
{
	if( ( ofd = open(EXOSDEV, 2) ) < 0 ) {
		perror( "opening xmem" );
		exit( 1 );
	}
}

poke( segadr, offset, baddr, len )
unsigned short segadr;
unsigned short offset;
unsigned len;
char *baddr;
{
	long adr;

	adr = (long) segadr << 4;
	adr &= 0x3fff0L;
	adr += offset;
	if ( ((long)len + adr) > 0x3ffffL )
		len = 0x3ffffL - adr;
	if( len < 0 ) {
		perror( "bad length\n" );
		return;
	}
	if( debug )
		printf( "poke: adr = %lx\n", adr );
	lseek( ofd, adr, 0 );
	if( write( ofd, baddr, len ) != len ) {
		perror( "poke" );
		printf( "adr = %X\n", adr );
		exit( 1 );
	}
}

peek( segadr, offset, baddr, len )
unsigned short segadr;
unsigned short offset;
unsigned len;
char *baddr;
{
	long adr;

	adr = 0xffff0 & ( (long)segadr << 4 ) ;
	adr &= 0x3fff0L;
	adr +=  0xffff & offset;
	if ( ((long)len + adr) > 0x3ffffL )
		len = 0x3ffffL - adr;
	if( len < 0 ) {
		perror( "bad length\n" );
		return;
	}
	if( debug )
		printf( "peek: adr = %lx\n", adr );
	lseek( ofd, adr, 0 );
	if( read( ofd, baddr, len ) != len ) {
		perror( "peek" );
		printf( "adr = %X\n", adr );
		exit( 1 );
	}
}

clr_exo_mem()
{
	register int i;
	char a[1024];

	for( i = 0; i < 1024 ; ++i )
		a[i] = 0;
	lseek( ofd, (long)0, 0 );
	for( i = 0 ; i < 256 ; ++i ) {
		if( verbose )
			printf( "clearing block %d\n", i );
		if( write( ofd, a, sizeof( a ) ) != sizeof( a ) ) {
			perror( "clr_exo_mem" );
			break;
		}
	}
	if( debug ) {
		lseek( ofd, (long)0, 0 );
		for( i = 0 ; i < 256 ; ++i ) {
			if( read( ofd, a, sizeof( a ) ) != sizeof( a ) ) {
				perror( "clr_exo_mem" );
				break;
			}
			printf( "block %d, a[0] = %x\n", i, a[0] );
		}
	}
}
