;
; Copyright (C) 1986, Excelan, Inc.  All rights reserved.
;
; $Header: ex_access.s,v 1.2 87/04/24 14:07:24 davidb Exp $
;

;	Static Name Aliases
;
; @(#)ex_access.s	1.3 8/22/85
;
	TITLE	EX_ACCESS

DGROUP	GROUP	CONST,	_BSS,	_DATA
	ASSUME	CS: EX_ACCESS_TEXT, DS: DGROUP, SS: DGROUP, ES: DGROUP
EXTRN  _xm_sel:WORD
; EXTRN	picbit:BYTE
PUBLIC _xcopyo
PUBLIC _xcopyi
PUBLIC _xpeekb
PUBLIC _xpokeb
PUBLIC _xpeekw
PUBLIC _xpokew
PUBLIC _xpeekd
PUBLIC _xpoked
#include <sys/exos205.s.h>
_DATA	SEGMENT WORD PUBLIC	'DATA'
_DATA	ENDS
_BSS	SEGMENT WORD PUBLIC	'DATA'
_BSS	ENDS
CONST	SEGMENT WORD PUBLIC	'DATA'
CONST	ENDS
EX_ACCESS_TEXT	SEGMENT WORD PUBLIC	'CODE'
EVEN

;
; These routines move data from the exos window to kernel space
;
;	xcopyi( &sys, &board, count )
;	xcopyo( &board, &sys, count )

	PUBLIC _xcopyi
_xcopyi	 PROC FAR
	mov	bx,sp
	pushf
	push	si
	push	di
	push	ds		; save ds
	cli			; no interupts while ds screwed up
	cld			; direction flag upwards
;;	mov	dx,es		; save es
	mov	di,BXARGBAS[bx]	; &sys ( offset )
	mov	si,BXARGBAS+4[bx]	; &board
	mov	cx,BXARGBAS+6[bx]	; count
	mov	ax,BXARGBAS+2[bx]	; &sys ( segment )
	mov	es,ax
	mov	ax,_xm_sel
	mov	ds,ax
	mov	ax,si		; check for odd addresses or count
	or	ax,di
	or	ax,cx
	shr	ax,1
	jb	$odd		; yes something is odd
	shr	cx,1
	rep	movsw		; copy ds:si to es:di
	jmp	out
$odd:
	rep	movsb		; bytewise move ds:si to es:di
	jmp	out
	PUBLIC _xcopyo
_xcopyo	 PROC FAR
	mov	bx,sp
	pushf
	push	si
	push	di
	cli			; no interupts while ds screwed up
	cld			; copy upwards
;;	mov	dx,es		; save es
	mov	ax,_xm_sel
	mov	es,ax
	mov	di,BXARGBAS[bx]		; &board
	mov	si,BXARGBAS+2[bx]	; &sys (offset)
	mov	cx,BXARGBAS+6[bx]	; count
	push	ds			; save ds
	mov	ax,BXARGBAS+4[bx]	; &sys (segment)
	mov	ds,ax
	mov	ax,si
	or	ax,di
	or	ax,cx
	shr	ax,1
	jb	$oddo
	shr	cx,1
	rep	movsw
	jmp	out
$oddo:
	rep	movsb
out:
;;	mov	es,dx
	pop	ds
	pop	di
	pop	si
	popf
	RET
_xcopyo ENDP
_xcopyi	ENDP

;
; These routines peek and poke bytes, to and from the exos window
;
;	xpeekb(offset)
;	xpokeb(offset, byte)
;	xpeekw(offset)
;	xpokew(offset, word)
;	xpeekd(offset)
;	xpoked(offset, long)


	PUBLIC _xpeekb
_xpeekb	 PROC FAR
	mov	bx,sp
	pushf
	cli			; no interupts while accessing board
;;	mov	dx,es
	mov	bx,BXARGBAS[bx]
	mov	ax,_xm_sel
	mov	es,ax
	mov	al,es:[bx]
;;	mov	es,dx
	popf
	RET
_xpeekb	ENDP

	PUBLIC _xpokeb
_xpokeb	 PROC FAR
	mov	bx,sp
	pushf
	cli			; no interupts while accessing board
;;	push	es
	mov	ax,BXARGBAS+2[bx]
	mov	bx,BXARGBAS[bx]
	mov	dx,_xm_sel
	mov	es,dx
	mov	es:[bx],al
;;	pop	es
	popf
	RET
_xpokeb	ENDP

	PUBLIC _xpeekw
_xpeekw	 PROC FAR
	mov	bx,sp
	pushf
	cli			; no interupts while accessing board
;;	mov	dx,es
	mov	bx,BXARGBAS[bx]
	mov	ax,_xm_sel
	mov	es,ax
	mov	ax,es:[bx]
;;	mov	es,dx
	popf
	RET
_xpeekw ENDP

	PUBLIC _xpokew
_xpokew	 PROC FAR
	mov	bx,sp
	pushf
	cli			; no interupts while accessing board
;;	push	es
	mov	ax,BXARGBAS+2[bx]
	mov	bx,BXARGBAS[bx]
	mov	dx,_xm_sel
	mov	es,dx
	mov	es:[bx],ax
;;	pop	es
	popf
	RET
_xpokew ENDP

	PUBLIC _xpeekd
_xpeekd	 PROC FAR
	mov	bx,sp
	pushf
	cli			; no interupts while accessing board
;;	push	es
	mov	bx,BXARGBAS[bx]
	mov	ax,_xm_sel
	mov	es,ax
	mov	ax,es:[bx]
	mov	dx,es:2[bx]
;;	pop	es
	popf
	RET
_xpeekd	ENDP

	PUBLIC _xpoked
_xpoked	 PROC FAR
	mov	bx,sp
	pushf
	cli			; no interupts while accessing board
;;	push	es
	mov	dx,_xm_sel
	mov	es,dx
	mov	dx,BXARGBAS+4[bx]
	mov	ax,BXARGBAS+2[bx]
	mov	bx,BXARGBAS[bx]
	mov	es:[bx],ax
	mov	es:2[bx],dx
;;	pop	es
	popf
	RET
_xpoked	ENDP

;
; Clear an area in the exos window
;
	PUBLIC _xclear
_xclear	PROC FAR
	mov	bx,sp
	pushf
	cli			; no interupts while accessing board
	push	di
;;	mov	dx,es
	cld			; clear upwards
	mov	di,BXARGBAS[bx]		; &board
	mov	cx,BXARGBAS+2[bx]	; count
	mov	ax,_xm_sel
	mov	es,ax
	mov	ax,di		; check for odd
	or	ax,cx
	shr	ax,1
	jb	$oddc		; is odd
	shr	cx,1
	sub	ax,ax		; clear ax
	rep	stosw		; clear memory words
;;	mov	es,dx
	pop di
	popf
	RET
$oddc:
	sub	ax,ax
	rep	stosb		; clear memory bytes
;;	mov	es,dx
	pop	di
	popf
	RET
_xclear ENDP

EX_ACCESS_TEXT ENDS
END
