/*	Copyright (c) 1985,1986,1987  EXCELAN, INC. 	*/
/*	  All Rights Reserved.                         	*/

/*	The copyright notice above does not evidence any 	*/
/*	actual or intended publication. 			*/

/*	THIS IS UNPUBLISHED COMPUTER SOFTWARE CONTAINING TRADE SECRETS 	*/
/*	AND CONFIDENTIAL INFORMATION PROPRIETARY TO EXCELAN, INC. 	*/

/* $Header: mbuf.h,v 1.2 87/04/24 14:40:46 davidb Exp $ */
/*	@(#)mbuf.h	1.7	5/12/85	*/

/*
 * GAP 5/24/85:  First 5 fields in mbuf header are the same as an
 * NX 5.0 BD structure.  net_comp.a86 also depends on the offset to
 * m_act.  DO NOT CHANGE!!!!!
 */
struct mbuf {
/*00*/	u_short	m_next;		/* next buffer in chain */
/*02*/	u_short	m_nseg;			/* same as dataseg, for NX 5.0 BC */
/*04*/	u_short	m_off;			/* offset of data */
/*06*/	u_short	m_seg;			/* segment of data */
/*08*/	short	m_len;			/* amount of data in this mbuf */
/*10*/	short	m_type;			/* 0=free, usage, pntr, or xtnd */
/*12*/	u_short *m_act;		/* link in higher-level mbuf list */
#ifdef MBDEBUG
	u_short	m_user;			/* addr of the user of mbuf */
#endif
};

/*
 * The following types may all occur in a small mbuf.
 */
#define	MT_FREE		0	/* should be on free list */
#define	MT_DATA		1	/* dynamic (data) allocation */
#define	MT_HEADER	2	/* packet header */
#define	MT_SOCKET	3	/* socket structure */
#define	MT_PCB		4	/* protocol control block */
#define	MT_RTABLE	5	/* routing tables */
#define	MT_FTABLE	6	/* fragment reassembly header */
#define MT_TSBUF	7	/* telnet server data buffer */

#define	MT_MAX		16	/* all small mbuf type values < MT_MAX */
#define	MT_MASK		0xF	/* mask for type value */

/*
 * These types are associated exclusively with extended mbufs,
 * and pointer mbufs, respectively.  The only other valid type for
 * these is MT_FREE, when on the free list.
 */
#define	MT_XTND		32	/* extended mbuf */
#define	MT_PNTR		33	/* pointer mbuf */

/*
 * MSIZE MUST BE A POWER OF 2 for macros, eg, dtom, to work.
 */
#define MSIZE		128	/* size of a small mbuf */
#define MMINOFF	sizeof(struct mbuf)	/* smallest valid offset */
#define	MMAXOFF		MSIZE	/* offset where small mbuf data ends */
#define	MLEN (MSIZE-MMINOFF)	/* mbuf data length */

#define MXSIZE		1536	/* size of an extended mbuf */
#define MXMINOFF	0	/* smallest valid offset */
#define	MXMAXOFF 	MXSIZE	/* offset where extended mbuf data ends */
#define	MXLEN		MXSIZE	/* extended mbuf data length */

#define DMBUFSIZE sizeof(struct mbuf)	/* size of dinky mbuf */
#define PMBUFSIZE sizeof(struct mbuf)	/* size of pointer mbuf */

/*
 * Mbuf management structures.
 */

struct mbpool {			/* for small mbufs */
	short	mbp_mbufs;	/* total number in pool */
	short	mbp_free;	/* number unused */
	short	mbp_freep;	/* pointer to free list */
	short	mbp_start;	/* lowest address of pool */
	short	mbp_end;	/* first address beyond pool */
	short	mbp_lowat;	/* when to refuse MF_PARK requests */
	short	mbp_hiwat;	/* when to wakeup waiting clients */
	short	mbp_drops;	/* number of refusals */
	short	mbp_wakup;	/* someone is waiting for mbufs */
	short	mbp_usage[MT_MAX];	/* stats on usage */
};
#define NMBUF_MIN	64	/* minimum number of small mbufs */
#define	MBLOWAT		24	/* default value for mbpool.mbp_lowat */
#define	MBHIWAT		40	/* default value for mbpool.mbp_hiwat */
#define XMBLOWAT	02	/* large mbuf low water mark */ 

struct xmbpool {		/* for extended mbufs */
	short	xmb_mbufs;	/* total number in pool */
	short	xmb_free;	/* number unused */
	short	xmb_freep;	/* pointer to free list */
	short	xmb_start;	/* lowest address of dinky mbuf pool */
	short	xmb_end;	/* first address beyond dinky mbuf pool */
	short	xmb_drops;	/* numbeer of refusals */
	u_short	xmb_seg;	/* lowest segment address of extended buffers */
};
#define NXMBUF_MIN	12	/* minimum number of extended mbufs */

struct pmbpool {		/* for pointer mbufs */
	short	pmb_mbufs;	/* total number in pool */
	short	pmb_free;	/* number unused */
	short	pmb_freep;	/* pointer to free list */
	short	pmb_start;	/* lowest address of pool */
	short	pmb_end;	/* first address beyond pool */
	short	pmb_drops;	/* number of refusals */
};
#define NPMBUF_MIN	32	/* minimum number of pointer mbufs */
