/*	Copyright (c) 1985,1986,1987  EXCELAN, INC. 	*/
/*	  All Rights Reserved.                         	*/

/*	The copyright notice above does not evidence any 	*/
/*	actual or intended publication. 			*/

/*	THIS IS UNPUBLISHED COMPUTER SOFTWARE CONTAINING TRADE SECRETS 	*/
/*	AND CONFIDENTIAL INFORMATION PROPRIETARY TO EXCELAN, INC. 	*/

/* $Header: xspecial.h,v 1.2 87/04/24 14:43:35 davidb Exp $ */
/*
@(#)xspecial.h	1.8 5/7/85
flags for special files
*/
#define	FILE_NAME	50	/* file name argument is to be used (as is) */
#define CURRENT_DIR	51	/* current directory */
#define HOME_DIR	52	/* user's initial location in file system */
#define CD_RELATIVE	53	/* name is relative to current directory */
#define HM_RELATIVE	54	/* name is relative to home directory */
#define UP_DIRECTORY	55	/* parent directory (for xchdir) */
#define SERVICE_PARA	56	/* for file system operations where
				   service parameters are to be updated
				   or retrieved without consideration of
				   any particular file
				*/

/*
flags for psuedo-file objects
*/
#define LS		101	/* short directory listing */
#define LS_ARG		102	/* short listing of named directory */
#define LSLONG		103	/* long directory listing */
#define LSLONG_ARG	104	/* long listing of named directory */
#define PWD		105	/* return name of current directory */

/*
flags for file openning modes.
*/
#define XFREAD 		1	/* open for reading */
#define XFWRITE		2	/* open for writing */
#define XFAPPEND	8	/* add to an existing file (FWRITE also
					must be set) */
#define XFRECORD	0x40	/* file opened in record mode */
#define XFCREAT		0x80	/* create file, if it doesn't exist */
#define XFTRUNC		0x100	/* truncate file (FWRITE also must be set)*/
#define XFASCII		0x200	/* file is ascii (for systems which care) */
#define XRANDOM		0x400	/* open for random access */
#define XFFORCE		0x800	/* for eopen only, force file to be opened
				   according to supplied attributes,
				   or fail if that is not possible */
/*
Note: XFCREAT is a separate issue from XFTRUNC and XFAPPEND, which are
mutually exclusive.
*/

/*
Information for FTP style files
*/
#define RT_ASCII	1	/* ascii character set */
#define RT_EBCDIC	2	/* ebcdic character set */
#define RT_IMAGE	3	/* uninterpretted bit stream */
#define RT_LOCALBYTE	4	/* wierd sized bytes */

#define TF_NONPRINT	1	/* no imbedded carriage control */
#define TF_TELNET	2	/* telnet style data */
#define TF_FORTRAN	3	/* 1st collumn == carriage control */

#define IS_FILE		1	/* Unstructured file */
#define IS_RECORD	2	/* FTP record internal structure */
#define IS_PAGE		3	/* FTP page internal structure */

#define TM_STREAM	1	/* stream transmission */
#define TM_BLOCK	2	/* block transmission */
#define TM_COMPRESSED	3	/* data compressed */

struct ftp_attr {
	int rep_type;		/* data repesentation one of:
					RT_ASCII, RT_EBCDIC, RT_IMAGE or
					RT_LOCALBYTE */
	int format;		/* format for character files one of:
					TF_NONPRINT, TF_TELNET or
					TF_FORTRAN */
	int structure;		/* internal structure one of: IS_FILE,
					IS_RECORD, IS_PAGE */
	int trans_mode;		/* transmition mode one of: TM_STREAM,
					TM_BLOCK or TM_COMPRESSED */
	int byte_sz;		/* byte size if represetation type
					is RT_LOCALBYTE */
};


/*
Flags for setting terminal options with xsetterm.
*/
#define	XON_STERM	1	/* turn option on */
#define XOFF_STERM	0	/* turn option off */
#define	XECHO		1	/* local echo? */
#define XLINE_EDIT	2	/* driver handles line edit? */
#define X8BIT		4	/* allow 8 bit data path */
#define XXONXOFF	8	/* use local ^s ^q flow control */

/*
Flags for epassthru
*/
#define HASH_ONPASS	1	/* print # for each 1K transfered */
#define STATS_ONPASS	2	/* print transfer statistics */


#define MXNAMELEN	255	/* maximum length for file names
					( system dependent ) */

#ifdef zilog
/*
 * S8000 does setjmp() differently, and calls it setret().
 * Do NOT call setret() from routine which declares register variables!
 */
#define xsetjmp(x)	setret(x)
#else
#ifndef	vms
#define xsetjmp(x)	setjmp(x)	/* Unix only */
#endif
#endif
