/*	Copyright (c) 1985,1986,1987  EXCELAN, INC. 	*/
/*	  All Rights Reserved.                         	*/

/*	The copyright notice above does not evidence any 	*/
/*	actual or intended publication. 			*/

/*	THIS IS UNPUBLISHED COMPUTER SOFTWARE CONTAINING TRADE SECRETS 	*/
/*	AND CONFIDENTIAL INFORMATION PROPRIETARY TO EXCELAN, INC. 	*/

/* $Header: xstdio.h,v 1.2 87/04/24 14:44:03 davidb Exp $ */
/*
@(#)xstdio.h	1.5 6/4/85

Definitions for EXOS standard io objects 
	(useful for porting code to non-unix systems)
*/

/*
 save space on systems with limited data segment size.
 */
#ifdef xenix286
#define	XBUFSIZ	512
#else
#ifdef rsx
#define	XBUFSIZ	512
#else
#define	XBUFSIZ	1024
#endif
#endif

#define	_XNFILE	30
extern	struct	_xiobuf {
	int	_cnt;			/* number of bytes remaining in buffer*/
	char	*_ptr;			/* current location in buffer */
	char	*_base;			/* base of buffer */
	int	_bufsiz;		/* size of buffer */
	short	_flag;			/* state of object, see below */
	char	_file;			/* mapping to file object descriptor #*/
	struct _xiobuf *_succ;		/* forward link (added) */
	struct _xiobuf *_pred;		/* backward link (added) */
	char	*_sys_id;		/* system specific identifier (added) */
	int 	(*_read)();		/* low level read routine */
	int 	(*_write)();		/* low level write routine */
	int 	(*_ioctl)();		/* low level ioctl routine */
	long	(*_lseek)();		/* low level lseek routine */
	int 	(*_close)();		/* low level close routine */
	int	_odtype;		/*type identifier for os specific code*/
} _xiob[_XNFILE];

#define	_XIOREAD	01
#define	_XIOWRT	02
#define	_XIONBF	04
#define	_XIOMYBUF	010
#define	_XIOEOF	020
#define	_XIOERR	040
#define	_XIOSTRG	0100
#define	_XIOLBF	0200
#define	_XIORW	0400
#define _XPrimary 01000		/* primary copy of object */
#define _XUsed	  02000		/* on if object is in use */
#define _XIOSTR	04000		/* underlying object is structured */
#define _XIORNDOM 010000	/* random access ok */
#define	XNULL	0
#define	XFILE	struct _xiobuf
#define	XEOF	(-99)		/* shouldn't conflict with XEACCESS */
#define XSTDHANDLE	1	/* _sys_id field is standard type for os,
				if the _odtype field contains this value */
#define TELNET_OBJECT	1300	/* object is a telnet object */
#define FTP_OBJECT	1301	/* object is a FTP object */
#define XREAL_OD	(('r'<<8)| 1)	/* Otherwise, this xioctl command
					may be used to obtain the object
					descriptor which is one level lower */

#define	xstdin	(&_xiob[0])
#define	xstdout	(&_xiob[1])
#define	xstderr	(&_xiob[2])
#define	xgetc(p)		(--(p)->_cnt>=0? *(p)->_ptr++&0377:_xfilbuf(p))
#define	xgetchar()	xgetc(xstdin)
#define xputc(x,p) (--(p)->_cnt>=0? ((int)(*(p)->_ptr++=(unsigned)(x))):_xflsbf((unsigned)(x),p))
#define	xputchar(x)	xputc(x,xstdout)
#define	xfeof(p)		(((p)->_flag&_XIOEOF)!=0)
#define	xferror(p)	(((p)->_flag&_XIOERR)!=0)
#define	xfileno(p)	((p)->_file)

extern int xnofunc();
XFILE	*xodopen();
char	*xogets();
char	*xsprintf();		/* too painful to do right */
