/*	Copyright (c) 1985,1986,1987  EXCELAN, INC. 	*/
/*	  All Rights Reserved.                         	*/

/*	The copyright notice above does not evidence any 	*/
/*	actual or intended publication. 			*/

/*	THIS IS UNPUBLISHED COMPUTER SOFTWARE CONTAINING TRADE SECRETS 	*/
/*	AND CONFIDENTIAL INFORMATION PROPRIETARY TO EXCELAN, INC. 	*/

/* $Header: main.c,v 1.2 87/04/24 14:59:41 davidb Exp $ */
#ifndef lint
static char sccsid[] = " @(#)main.c	1.13 7/29/85";
#endif

/*
 * FTP User Program -- Command Interface.
 */
#include "ftpc.h"

#define	MAXCOMMANDS	100	/* maximum number of commands */
#define	AMBIGUOUS_CMD	"?Ambiguous command\n"
#define UNKNOWN_CMD	"?Unknown command\n"
#define NOTSUPPORT_CMD	"?Operation not supported\n"

int	intr();
extern	int data;
extern 	char *globerr;
extern char **xmkarglist();
extern char *xstrrchr();
extern struct cmd *xgetcmd();
extern struct filesystem *xgetfs();
extern struct filesystem *xgetfsp();
static struct cmd *getrealcmd();

xmain(argc, argv)
	char *argv[];
{
	/*
	 * Don't use register declarations in this procedure -- Zilog
	 * S8000 setret() (alias setjmp()) can't abide by them.
	 */
	char *cp;
	int top;
	char null = 0;
	char *null_pt = &null;

	margv = (char **)0;
	doglob = 1;
	interactive = 1;
	autologin = 1;
	abortxfer = 0;
	argc--, argv++;
	while (argc > 0 && **argv == '-') {
		for (cp = *argv + 1; *cp; cp++)
			switch (*cp) {

			case 'd':
				debug++;
				break;
			
			case 'v':
				verbose++;
				break;

/*	deleted, no -t option
			case 't':
				trace++;
				break;
*/

			case 'i':
				interactive = 0;
				break;

			case 'n':
				autologin = 0;
				break;

#ifndef	vms
			case 'g':
				doglob = 0;
				break;
#endif

			case 'f':
				force = 0;
				break;
			case 'x':
				xexitonerror = 1;
				break;

			default:
				xoprintf(xstderr,
				  "ftp: %c: unknown option\n", *cp);
				xexit(1);
			}
		argc--, argv++;
	}
	/*
	 * Set up the local context.
	 */
	lcontext = xgetfs( null_pt, null_pt, null_pt, null_pt, 0 );
	if( lcontext == XNULL ) {
		xoprintf( xstderr, "Cann't access local file system.\n" );
		xexit( 1 );
	}
	/*
	 * Set up the home directory in case we're globbing.
	 */
	if (argc > 0) {
		if (xsetjmp(toplevel))
			xexit(0);
		xint_term( intr );
		setpeer(argc + 1, argv - 1);
	}
	top = xsetjmp(toplevel);
	if (top == 0 || top == 1 ) {
		xint_term( intr );
		top = 1;
	}
	for (;;) {
		cmdscanner(top);
		top = 1;
	}
}

intr()
{

	xint_term( intr );
	++abortxfer;
}

extern struct cmd cmdtab[];
extern int help();
/*
 * Command parser.
 *
 * $Implementation:
 *	We need to handle the situation that we need to look at two different
 * command tables and flag ambiguous commands.  Another complication is that
 * some commands exist in both tables and are legitimate (e.g., status and
 * help).  It is decided that the LSB of flag2 in the local command should be
 * set if the command legitimately exists in both tables. 
 * 	
 * 	The algorithm in deciding which command to use follows:
 * 1. If connected, get the protocol-specific command table and use xgetcmd
 *    to get the command.  Note: we need to fake a help command to obtain the
 *    protocol-specific command table.
 *
 * $
 */
cmdscanner(top)
	int top;
{
	struct cmd *ftptable;	/* ftp command table */
	struct cmd *realcmd;	/* command to execute */
	int local;		/* whether local command is found */
	char *hargv[2];		/* used to obtain ftp command table */

	int rval;

	if (!top)
		xputchar('\n');
	for (;;) {
		if( abortxfer ) {
			eabort( ccontext );
			abortxfer = 0;
		}
		if (fromatty) {
			xoprintf(xstdout,"ftp> ");
			xfflush(xstdout);
		}
		if (xgets(line) == XNULL) {
			if( xfeof( xstdin ) ) {
				/*
				quit on end of input
				*/
				xprintf( "\n" );
				xexit(0);
			} else {
				break;
			}
		}
		if (line[0] == 0)
			break;
		if( margv )
			xdealglob( margv );
		margv = xmkarglist( line, &margc );
		if (margv == (char **) 0) {
			if (globerr) 
				xoprintf(xstdout, "%s: %s\n", line, globerr);
			break;
		};
		if (margc == 0)
			break;

		if( ccontext ) {
			/*
			Check if current connection is still good.
			*/
			xrelsfs( ccontext, 0 );
			ccontext = xgetfsp( ccontext );
			if( ccontext == XNULL )
				conned = 0;
		}

		if (conned) {	/* try to get ftp command table */
			hargv[0] = "help";
			hargv[1] = (char *) XNULL;
			rval = ecmd (1, hargv, ccontext);
			if (rval >= 0) {
				ftptable = (struct cmd *) hargv[0];
			} else
				ftptable = (struct cmd *) XNULL;
		} else
			ftptable = (struct cmd *) XNULL;

		realcmd = getrealcmd(margv[0], cmdtab, ftptable, &local);
			
		if (realcmd == (struct cmd *) -1) {
			xoprintf(xstdout, AMBIGUOUS_CMD);
			continue;
		};

		if (realcmd == (struct cmd *) XNULL) {
			xoprintf(xstdout, UNKNOWN_CMD);
			continue;
		};

		if (!conned && local && realcmd->c_conn) {
			/* local command but connection required */
			xoprintf(xstdout, "Not connected.\n");
			continue;
		};

		/* execute the command */
		if (local)
			rval = (*realcmd->c_handler)(margc, margv);
		else
			rval = ecmd(margc, margv, ccontext);

		if (rval == XEOPNOTSUPP) {
			xoprintf(xstdout, NOTSUPPORT_CMD);
			continue;
		} else if (rval < 0) {
			xperror(rval, margv[0]);
			if (xexitonerror) {
				xexit(1);
			};
		};

		if ((realcmd->c_flag2 & 1) && conned && local) {
			/* have both local and FTP command, do local first */
			/* now execute remote command */
			rval = ecmd(margc, margv, ccontext);
			if (rval == XEOPNOTSUPP) {
				xoprintf(xstdout, NOTSUPPORT_CMD);
				continue;
			} else if (rval < 0) {
				xperror(rval, margv[0]);
				if (xexitonerror) {
					xexit(1);
				};
			};
		};

		if (bell /* && c->c_bell */)
			xputchar(CTRL(g));
		if (realcmd->c_handler != help)
			break;
	}
	xlongjmp(toplevel, 0);
}

#define HELPINDENT (sizeof ("directory"))

/*
 * Help command.
 * Call each command handler with argc == 0 and argv[0] == name.
 *
 * $Implementation:
 *	If there is no argument, we need to form a super-list of commands
 *  which may comprise of the local command table and the protocol-specific
 *  command table and is sorted in alphabetical order.  THe super-list is 
 *  used to display the help messages.
 * $
 */
help(argc, argv)
	int argc;
	char *argv[];
{
	register struct cmd *c;
	struct cmd *ccmdtab;
	int ncmds;				/* total number of commands */
	char *hargv[2];
	int rval;
	struct cmd *cmdlist[MAXCOMMANDS];	/* command list */
	int nlocalcmd;				/* number of local commands */
	int nftpcmd;			/* number of FTP-specific commands */
	int localindex;			/* index to local command table */
	int ftpindex;			/* index to FTP command table */
	int index;
	int tmp;

	ccmdtab = 0;
	if( conned ) {
		hargv[0] = "help";
		hargv[1] = 0;
		rval = ecmd( 1, hargv, ccontext );
		if( rval >= 0 ) {
			ccmdtab = (struct cmd *)hargv[0];
		} 
	}
	if (argc == 1) {
		register int i, j, w;
		int columns, width = 0, lines;

		xoprintf(xstdout,
			"Commands may be abbreviated.  Commands are:\n\n");
	
		nlocalcmd = 0;
		nftpcmd = 0;
		for (c = cmdtab; c->c_name ; c++) {
			int len = xstrlen(c->c_name);

			++nlocalcmd;
			if (len > width)
				width = len;
		}
		if ( ccmdtab ) {
			for (c = ccmdtab; c->c_name ; c++) {
				int len = xstrlen(c->c_name);

				++nftpcmd;
				if (len > width)
					width = len;
			}
		}
		ncmds = nftpcmd + nlocalcmd;

		/* now we need to merge the two lists together */
		localindex = 0;
		ftpindex = 0;
		index = 0;
		while ((localindex < nlocalcmd) && (ftpindex < nftpcmd)) {
			/* something to sort/merge */
			tmp = xstrcmp(cmdtab[localindex].c_name,
				    ccmdtab[ftpindex].c_name);
			if (tmp == 0) {	/* both are the same */
				ncmds--;	/* eliminate duplicate */
				ftpindex++;
				cmdlist[index++] = &cmdtab[localindex++];
			} else if (tmp > 0) { /* ftp command is smaller */
				cmdlist[index++] = &ccmdtab[ftpindex++];
			} else {	/* local command is smaller */
				cmdlist[index++] = &cmdtab[localindex++];
			};
		};	/* done with the merge part */

		/* now handle the leftovers */
		while (localindex < nlocalcmd) {
			cmdlist[index++] = &cmdtab[localindex++];
		};	
		while (ftpindex < nftpcmd) {
			cmdlist[index++] = &ccmdtab[ftpindex++];
		};
		cmdlist[index] = (struct cmd *) XNULL;
				
		width = (width + 8) &~ 7;
		columns = 80 / width;
		if (columns == 0)
			columns = 1;
		lines = (ncmds + columns - 1) / columns;
		
		for (i = 0; i < lines; i++) {
			for (j = 0; j < columns; j++) {
				tmp = j * lines + i;
				c = cmdlist[tmp];
				xoprintf(xstdout,"%s", c->c_name);
				if (tmp + lines >= ncmds ) {
					xoprintf(xstdout,"\n");
					break;
				}
				w = xstrlen(c->c_name);
				while (w < width) {
					w = (w + 8) &~ 7;
					xputchar('\t');
				}
			}
		}
		return;
	}
	while (--argc > 0) {
		register char *arg;
		arg = *++argv;
		c = getrealcmd(arg,cmdtab, ccmdtab, &tmp);
		if (c == (struct cmd *)-1)
			xoprintf(xstdout,"?Ambiguous help command: %s\n", arg);
		else if (c == (struct cmd *)0) {
				xoprintf(xstdout,
					"?Invalid help command: %s\n", arg);
		} else
			xoprintf(xstdout,"%-*s\t%s\n", HELPINDENT,
				c->c_name, c->c_help);
	}
}

/* $Function: getrealcmd - get the real command that matches$ */

static struct cmd *getrealcmd(cmd, loctable, remtable, localflag)
char		*cmd;		/* command */
struct cmd	*loctable;	/* local command table */
struct cmd	*remtable;	/* remote command table, XNULL if no table*/
int		*localflag;	/* flag to show if command is local */

/* 
$Description:
	Based on the command name, return the appriopriate command entry.
$

$Return:
	0 : command not found
	-1: ambiguous command
	other: pointer to valid command entry
$

$Implementation:
	The algorithm is:
   1. Use xgetcmd to try to find the command in the local command table.
   2. If either xgetcmd returns -1 (ambiguous command), flag ambiguous command.
   3. If cannot find command in any of the table, flag as unknown command.
   4. If not connected, return the local command.
   5. If connected and there is no protocol-specific command, return the
      the local command.
   6. If connected and there is no local command, return the protocol-specific
      command.
   7. If connected, command found in both tables and LSB of c_flag2 of local
      command is 1, return the local command.
   8. If none of above conditions is satisfied, flag as ambiguous command.
$
*/
{

struct cmd	*loccmd;
struct cmd	*remcmd;

	*localflag = 1;	/* assume local */
	/* get the command from the appropriate table */
	loccmd = xgetcmd(cmd, loctable);
	if (conned && remtable) {
		remcmd = xgetcmd(cmd, remtable);
	} else
		remcmd = (struct cmd *)XNULL;
	
	/* now is time for decision of what to return */

	if ((remcmd == (struct cmd *) -1) || (loccmd == (struct cmd *) -1))
		return ((struct cmd *) -1);	
		
	if ((remcmd == (struct cmd *) XNULL) && 
	    (loccmd == (struct cmd *) XNULL)) 
		return ((struct cmd *) XNULL);

	if (!conned) {	/* not connected */
		return (loccmd);
	} else if (remcmd == (struct cmd *) XNULL) {
		/* no FTP command, return local */
		return (loccmd);
	} else if (loccmd == (struct cmd *) XNULL) {
		/* no local command, return FTP command */
		*localflag = 0;	/* remote command */
		return (remcmd);
	} else if (loccmd->c_flag2 & 1) {
		/* have both local and FTP command, and duplicate allowed*/
		return (loccmd);
  	} else if( !xstrcmp( loccmd->c_name, cmd ) ) {
  		/* exact match with local command. */
  		return(loccmd);
  	} else if( !xstrcmp( remcmd->c_name, cmd ) ) {
  		/* exact match with remote command */
  		*localflag = 0;
  		return( remcmd);
	} else {	/* ambiguous command */
		return ((struct cmd *) -1);
	};
}	/* get realcmd */
