
# line 12 "ftpcmd.y"

#ifndef lint
static char sccsid[] = "@(#)ftpcmd.y	1.16 8/15/85";
#endif

#define PARSER
#include "ftpd.h"

#ifdef	vms
#define	PARENT_DIRECTORY	"[-]"
#else
#define	PARENT_DIRECTORY	".."
#endif

/*
* MWP: 03/06/85
*  Make machines which have different sized ints and pointers happy.
*  (at least as far as the parser stack is concerned).
********************************************************************
*/
typedef char * YYSTDEF;
#define YYSTYPE YYSTDEF
YYSTYPE copy();
/*
********************************************************************
*/

extern	struct sockaddr_in data_dest;
extern	int logged_in;
extern	int guest;
extern	int logging;
extern	int type;
extern	int form;
extern	int stru;
extern	int mode;
extern	int bytesize;
extern	int debug;
extern	int timeout;
extern	int data;
extern	int abortxfer;
extern	char hostname[];
extern	char *globerr;
extern	char *xghome;
extern	int usedefault;
extern	char	**xglob();
extern	char	**nglob();
extern char **xmkarglist();
extern	char	*xrerror();
extern	int	poption();
extern	int	pescape();
static char	**globargs = 0;
static char	**rnf_glob = 0;
static char	*username = 0;
static char	*userpass = 0;
#ifdef	vms
static char	*userpass2 = (char *) 0;
#endif

static	int cmd_type = 0;
static	int cmd_form = 0;
static	int cmd_bytesz = 0;

char	*xstrchr();
extern XFILE *dataconn();
# define A 257
# define B 258
# define C 259
# define E 260
# define F 261
# define I 262
# define L 263
# define N 264
# define P 265
# define R 266
# define S 267
# define T 268
# define SP 269
# define CRLF 270
# define COMMA 271
# define STRING 272
# define NUMBER 273
# define USER 274
# define PASS 275
# define ACCT 276
# define REIN 277
# define QUIT 278
# define PORT 279
# define PASV 280
# define TYPE 281
# define STRU 282
# define MODE 283
# define RETR 284
# define STOR 285
# define APPE 286
# define MLFL 287
# define MAIL 288
# define MSND 289
# define MSOM 290
# define MSAM 291
# define MRSQ 292
# define MRCP 293
# define ALLO 294
# define REST 295
# define RNFR 296
# define RNTO 297
# define ABOR 298
# define DELE 299
# define CWD 300
# define LIST 301
# define NLST 302
# define SITE 303
# define STAT 304
# define HELP 305
# define NOOP 306
# define XMKD 307
# define XRMD 308
# define XPWD 309
# define XCUP 310
# define XEXC 311
# define LEXERR 312
#define yyclearin yychar = -1
#define yyerrok yyerrflag = 0
extern int yychar;
extern short yyerrflag;
#ifndef YYMAXDEPTH
#define YYMAXDEPTH 150
#endif
#ifndef YYSTYPE
#define YYSTYPE int
#endif
YYSTYPE yylval, yyval;
# define YYERRCODE 256

# line 747 "ftpcmd.y"


#ifdef zilog
extern ret_buf errcatch;
#else
extern jmp_buf errcatch;
#endif

#define	CMD	0	/* beginning of command */
#define	ARGS	1	/* expect miscellaneous arguments */
#define	STR1	2	/* expect SP followed by STRING */
#define	STR2	3	/* expect STRING */
#define	OSTR	4	/* optional STRING */

struct tab {
	char	*name;
	short	token;
	short	state;
	short	implemented;	/* 1 if command is implemented */
	char	*help;
};

struct tab cmdtab[] = {		/* In order defined in RFC 765 */
	{ "USER", USER, STR1, 1,	"<sp> username" },
	{ "PASS", PASS, STR1, 1,	"<sp> password" },
#ifdef	vms
	{ "ACCT", ACCT, STR1, 1,	"(specify account)" },
#else
	{ "ACCT", ACCT, STR1, 0,	"(specify account)" },
#endif
	{ "REIN", REIN, ARGS, 0,	"(reinitialize server state)" },
	{ "QUIT", QUIT, ARGS, 1,	"(terminate service)" },
	{ "PORT", PORT, ARGS, 1,	"<sp> b0, b1, b2, b3, b4" },
	{ "PASV", PASV, ARGS, 0,	"(set server in passive mode)" },
	{ "TYPE", TYPE, ARGS, 1,	"<sp> [ A | E | I | L ]" },
	{ "STRU", STRU, ARGS, 1,	"(specify file structure)" },
	{ "MODE", MODE, ARGS, 1,	"(specify transfer mode)" },
	{ "RETR", RETR, STR1, 1,	"<sp> file-name" },
	{ "STOR", STOR, STR1, 1,	"<sp> file-name" },
	{ "APPE", APPE, STR1, 1,	"<sp> file-name" },
	{ "MLFL", MLFL, OSTR, 0,	"(mail file)" },
	{ "MAIL", MAIL, OSTR, 0,	"(mail to user)" },
	{ "MSND", MSND, OSTR, 0,	"(mail send to terminal)" },
	{ "MSOM", MSOM, OSTR, 0,	"(mail send to terminal or mailbox)" },
	{ "MSAM", MSAM, OSTR, 0,	"(mail send to terminal and mailbox)" },
	{ "MRSQ", MRSQ, OSTR, 0,	"(mail recipient scheme question)" },
	{ "MRCP", MRCP, STR1, 0,	"(mail recipient)" },
	{ "ALLO", ALLO, ARGS, 1,	"allocate storage (vacuously)" },
	{ "REST", REST, STR1, 0,	"(restart command)" },
	{ "RNFR", RNFR, STR1, 1,	"<sp> file-name" },
	{ "RNTO", RNTO, STR1, 1,	"<sp> file-name" },
	{ "ABOR", ABOR, ARGS, 2,	"(abort operation)" },
	{ "DELE", DELE, STR1, 1,	"<sp> file-name" },
	{ "CWD",  CWD,  OSTR, 1,	"[ <sp> directory-name]" },
	{ "CDUP", XCUP, ARGS, 1,	"(change to parent directory)" },
	{ "XCWD", CWD,	OSTR, 1,	"[ <sp> directory-name ]" },
	{ "LIST", LIST, OSTR, 1,	"[ <sp> path-name ]" },
	{ "MKD",  XMKD, STR1, 1,	"<sp> path-name" },
	{ "NLST", NLST, OSTR, 1,	"[ <sp> path-name ]" },
	{ "PWD",  XPWD, ARGS, 1,	"(return current directory)" },
	{ "RMD",  XRMD, STR1, 1,	"<sp> path-name" },
	{ "SITE", SITE, STR1, 0,	"(get site parameters)" },
	{ "STAT", STAT, OSTR, 2,	"(get server status)" },
	{ "HELP", HELP, OSTR, 1,	"[ <sp> <string> ]" },
	{ "NOOP", NOOP, ARGS, 1,	"" },
	{ "XMKD", XMKD, STR1, 1,	"<sp> path-name" },
	{ "XRMD", XRMD, STR1, 1,	"<sp> path-name" },
	{ "XPWD", XPWD, ARGS, 1,	"(return current directory)" },
	{ "XCUP", XCUP, ARGS, 1,	"(change to parent directory)" },
#ifdef	vms
	{ "XEXC", XEXC, STR1, 0,	"execute command" },
#else
	{ "XEXC", XEXC, STR1, 1,	"execute command" },
#endif
	{ XNULL,   0,    0,    0,	0 }
};

struct tab *
lookup(cmd)
	char *cmd;
{
	register struct tab *p;

	for (p = cmdtab; p->name != XNULL; p++)
		if (xstrcmp(cmd, p->name) == 0)
			return (p);
	return (0);
}


/*
 * getline - a hacked up version of fgets to ignore TELNET escape codes.
 */
char *
getline(s, n, iop)
	char *s;
	register XFILE *iop;
{
	register c;
	register char *cs;

	cs = s;
	while (--n > 0 && (c = xgetc(iop)) >= 0) {
		while (c == IAC) {
			/* get IAC, it may be IAC IAC which is a legal data
			   byte. OR it may be IAC COMMAND PARAMETER which 
			   we should skip 
			*/
			c = xgetc(iop);	/* skip command */
			if (c == IAC) {
				break; /* data byte */
			} else {
				c = xgetc(iop);	/* skip parameter */
				c = xgetc(iop);	/* get next */
			};
		}
		*cs++ = c;
		if (c=='\n')
			break;
	}
	if (c < 0 && cs == s)
		return (XNULL);
	*cs++ = '\0';
	if (debug) {
		xoprintf(xstderr, "FTPD: command: %s", s);
		if (c != '\n')
			xputc('\n', xstderr);
		xfflush(xstderr);
	}
	return (s);
}

static int
toolong()
{
	long now;
	extern long xtime();

	reply(421,
	  "Timeout (%d seconds): closing control connection.", timeout);
	if (logging) {
		xoprintf(xstderr,
			"FTPD: User %s timed out after %d seconds at %ld",
			(username ? username : "unknown"), timeout,xtime());
		xfflush(xstderr);
	}
	xexit(1);
}

yylex()
{
	/*
	 * Don't use register variables -- Zilog S8000 setret() can't cope.
	 */
	static char cbuf[512];
	static int cpos, state;
	char *cp;
	struct tab *p;
	int n;
	int errcnt = 0;
	char c;

retry:
	for (;;) {
		switch (state) {

		case CMD:
			if( abortxfer )
				clearabort();
			if (getline(cbuf, sizeof(cbuf)-1, xstdin) == XNULL) {
				if( xferror( xstdin ) && (errcnt < 3) ) {
					++errcnt;
					goto retry;
				}
				reply(221, "You could at least say goodbye.");
				xexit(0);
			}
			if (cp = xstrchr(cbuf, '\r')) {
				cp[0] = '\n'; cp[1] = 0;
			}
			if (cp = xstrchr(cbuf, ' '))
				cpos = cp - cbuf;
			else if(cp = xstrchr(cbuf, '\n'))
				cpos = cp - cbuf;
			else
				cpos = 4;
			c = cbuf[cpos];
			cbuf[cpos] = '\0';
			upper(cbuf);
			p = lookup(cbuf);
			cbuf[cpos] = c;
			if (p != 0) {
				if (p->implemented == 0) {
					nack(p->name);
					xlongjmp(errcatch);
					/* NOTREACHED */
				}
				state = p->state;
				yylval = (YYSTYPE) p->name;
				return (p->token);
			}
			break;

		case OSTR:
			if (cbuf[cpos] == '\n') {
				state = CMD;
				return (CRLF);
			}
			/* FALL THRU */

		case STR1:
			if (cbuf[cpos] == ' ') {
				cpos++;
				state = STR2;
				return (SP);
			}
			break;

		case STR2:
			cp = &cbuf[cpos];
			n = xstrlen(cp);
			cpos += n - 1;
			/*
			 * Make sure the string is nonempty and \n terminated.
			 */
			if (n > 1 && cbuf[cpos] == '\n') {
				cbuf[cpos] = '\0';
				yylval = (YYSTYPE)copy(cp);
				cbuf[cpos] = '\n';
				state = ARGS;
				return (STRING);
			}
			break;

		case ARGS:
			if (isdigit(cbuf[cpos])) {
				cp = &cbuf[cpos];
				while (isdigit(cbuf[++cpos]))
					;
				c = cbuf[cpos];
				cbuf[cpos] = '\0';
				yylval = (YYSTYPE)xatoi(cp);
				cbuf[cpos] = c;
				return (NUMBER);
			}
			switch (cbuf[cpos++]) {

			case '\n':
				state = CMD;
				return (CRLF);

			case ' ':
				return (SP);

			case ',':
				return (COMMA);

			case 'A':
			case 'a':
				return (A);

			case 'B':
			case 'b':
				return (B);

			case 'C':
			case 'c':
				return (C);

			case 'E':
			case 'e':
				return (E);

			case 'F':
			case 'f':
				return (F);

			case 'I':
			case 'i':
				return (I);

			case 'L':
			case 'l':
				return (L);

			case 'N':
			case 'n':
				return (N);

			case 'P':
			case 'p':
				return (P);

			case 'R':
			case 'r':
				return (R);

			case 'S':
			case 's':
				return (S);

			case 'T':
			case 't':
				return (T);

			}
			break;

		default:
			fatal("Unknown state in scanner.");
		}
		state = CMD;
		yyerror( "lexical error" );
	}
}

upper(s)
	char *s;
{
	while (*s != '\0') {
		if (islower(*s))
			*s = _toupper(*s);
		s++;
	}
}

YYSTYPE
copy(s)
	char *s;
{
	char *p;
	extern char *xmalloc();

	p = xmalloc(xstrlen(s) + 1);
	if (p == XNULL)
		fatal("Ran out of memory.");
	xstrcpy(p, s);
	return ((YYSTYPE)p);
}

help(s)
	char *s;
{
	register struct tab *c;
	register int width, NCMDS;

	width = 0, NCMDS = 0;
	for (c = cmdtab; c->name != XNULL; c++) {
		int len = xstrlen(c->name);

		if (c->implemented == 0)
			len++;
		if (len > width)
			width = len;
		NCMDS++;
	}
	width = (width + 8) &~ 7;
	if (s == 0) {
		register int i, j, w;
		int columns, lines;

		lreply(214,
	  "The following commands are recognized (* =>'s unimplemented).");
		columns = 76 / width;
		if (columns == 0)
			columns = 1;
		lines = (NCMDS + columns - 1) / columns;
		for (i = 0; i < lines; i++) {
			xoprintf(xstdout,"   ");
			for (j = 0; j < columns; j++) {
				c = cmdtab + j * lines + i;
				xoprintf(xstdout,"%s%c", c->name,
					c->implemented ? ' ' : '*');
				if ((long)(c + lines) >= (long)&cmdtab[NCMDS])
					break;
				w = xstrlen(c->name);
				while (w < width) {
					xputchar(' ');
					w++;
				}
			}
			xoprintf(xstdout,"\r\n");
		}
		xfflush(xstdout);
		reply(214, "Direct comments to ftp-bugs@%s.", hostname);
		return;
	}
	upper(s);
	c = lookup(s);
	if (c == (struct tab *)0) {
		reply(504, "Unknown command %s.", s);
		return;
	}
	if (c->implemented)
		reply(214, "Syntax: %s %s", c->name, c->help);
	else
		reply(214, "%-*s\t%s; unimplemented.", width, c->name, c->help);
}
short yyexca[] ={
-1, 1,
	0, -1,
	-2, 0,
	};
# define YYNPROD 65
# define YYLAST 234
short yyact[]={

  29,  61, 116, 163, 161, 159, 118, 157, 155, 118,
 107,  85, 111,  96,  68,  66, 154,  64,   3,   4,
   5, 162,  28,   6, 160,  10,  11,  12,  14,  15,
  16, 158, 156, 135,  95,  94,  92,  91,  13, 153,
  31, 152,   9,  19,  20,  18,  17, 151,   7,  22,
  23,  24,  25,  26,  27,   8,  90,  89,  52,  51,
 150, 149, 148, 147, 146, 145, 144, 141, 137, 136,
 134, 129, 139, 121, 120, 119, 140, 113, 117, 105,
 104, 103, 100,  99,  59,  58,  53,  39,  36, 115,
 114, 102, 101,  98,  97,  93,  88,  87,  86,  83,
  84,  71,  70,  69,  43,  42,  41,  40,  82,  34,
  78,  33,  32,  73,  80,  79,  74, 138,  75,  76,
 108,  38, 109,  60,  30,  35, 110,  21,  81,  77,
  72, 106,  67,  37,  65,  63,   2,  45,  46,   1,
  44,  49,  50,  47,  48,   0,  54,  55,   0,  57,
   0,   0,  56,  62,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0, 112,   0,   0, 143,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0, 122, 123, 124,
   0,   0,   0, 125, 127, 126, 128,   0, 130, 131,
   0,   0, 132, 133,   0,   0,   0,   0,   0,   0,
   0,   0,   0, 142 };
short yypact[]={

-1000,-256,-1000,-157,-158,-160,-1000,-182,-1000,-183,
-162,-163,-164,-165,-1000,-1000,-1000,-1000,-1000,-1000,
-1000,-1000,-211,-184,-1000,-1000,-1000,-1000,-185,-186,
-296,-1000,-255,-257,-258,-166,-1000,-167,-168,-1000,
-144,-151,-159,-262,-171,-172,-173,-213,-233,-174,
-235,-1000,-259,-1000,-175,-176,-187,-188,-1000,-1000,
-1000,-177,-178,-189,-1000,-190,-1000,-191,-1000,-263,
-260,-260,-193,-179,-180,-1000,-267,-195,-1000,-1000,
-1000,-196,-1000,-1000,-1000,-197,-260,-260,-260,-1000,
-260,-1000,-260,-260,-1000,-260,-199,-260,-260,-1000,
-1000,-260,-260,-1000,-1000,-1000,-200,-238,-201,-1000,
-1000,-1000,-202,-1000,-192,-192,-264,-1000,-1000,-1000,
-1000,-1000,-204,-205,-206,-207,-208,-209,-210,-1000,
-223,-229,-231,-254,-1000,-265,-1000,-1000,-1000,-1000,
-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,
-1000,-1000,-1000,-1000,-1000,-239,-266,-240,-268,-247,
-269,-250,-270,-1000 };
short yypgo[]={

   0, 139, 136, 135, 134, 132, 125, 131, 120, 121,
 130, 129, 128, 122, 127,  78, 117, 126, 124, 123 };
short yyr1[]={

   0,   1,   1,   2,   2,   2,   2,   2,   2,   2,
   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
   2,   2,   2,   2,   2,   3,   4,   5,  15,   7,
  16,  16,  16,  10,  10,  10,  10,  10,  10,  10,
  10,  11,  11,  11,  12,  12,  12,   8,  13,  17,
  14,  18,  19,   6,   9 };
short yyr2[]={

   0,   0,   2,   4,   4,   4,   5,   2,   5,   5,
   2,   4,   4,   4,   4,   5,   5,   5,   3,   5,
   3,   5,   5,   3,   5,   1,   2,   4,   2,   5,
   5,   3,   3,   2,   2,   1,   1,   1,   1,  11,
   1,   1,   1,   1,   3,   1,   3,   1,   1,   3,
   2,   1,   1,   1,   1,   1,   1,   1,   1,   1,
   2,   5,   4,   0,   0 };
short yychk[]={

-1000,  -1,  -2, 274, 275, 276, 279, 304, 311, 298,
 281, 282, 283, 294, 284, 285, 286, 302, 301, 299,
 300, -14, 305, 306, 307, 308, 309, 310, 278, 256,
 -18, 296, 269, 269, 269,  -6, 270,  -6,  -9, 270,
 269, 269, 269, 269,  -6,  -9,  -9,  -6,  -6,  -9,
  -9, 270, 269, 270,  -9,  -9,  -6,  -9, 270, 270,
 -19, 297,  -9,  -3, 272,  -4, 272,  -5, 272, 269,
 269, 269, -10, 257, 260, 262, 263, -11, 261, 266,
 265, -12, 267, 258, 259, 273, 269, 269, 269, 270,
 269, 270, 269, 269, 270, 269, 272, 269, 269, 270,
 270, 269, 269, 270, 270, 270,  -7, 273,  -8, -13,
 -17, 272,  -8, 270, 269, 269, 269, -15, 273, 270,
 270, 270,  -8,  -8,  -8, -13, -13,  -8,  -8, 270,
  -8,  -8,  -8,  -8, 270, 271, 270, 270, -16, 264,
 268, 259, -16, -15, 270, 270, 270, 270, 270, 270,
 270, 270, 270, 270, 270, 273, 271, 273, 271, 273,
 271, 273, 271, 273 };
short yydef[]={

   1,  -2,   2,   0,   0,   0,  63,  63,  64,   0,
   0,   0,   0,   0,  63,  64,  64,  63,  63,  64,
  64,  25,   0,   0,  64,  64,  63,  64,   0,   0,
   0,  64,   0,   0,   0,   0,   7,   0,   0,  10,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,  26,   0,  28,   0,   0,   0,   0,  33,  34,
  60,   0,   0,   0,  35,   0,  36,   0,  37,   0,
   0,   0,   0,  43,  45,  47,  48,   0,  51,  52,
  53,   0,  54,  55,  56,   0,   0,   0,   0,  18,
   0,  20,   0,   0,  23,   0,   0,   0,   0,  31,
  32,   0,   0,   3,   4,   5,   0,   0,   0,  57,
  58,  59,   0,  11,   0,   0,   0,  50,  38,  12,
  13,  14,   0,   0,   0,   0,   0,   0,   0,  27,
   0,   0,   0,   0,   6,   0,   8,   9,  44,  40,
  41,  42,  46,  49,  15,  16,  17,  19,  21,  22,
  24,  29,  30,  62,  61,   0,   0,   0,   0,   0,
   0,   0,   0,  39 };
#ifndef lint
static char yaccpar_sccsid[] = "@(#)yaccpar	4.1	(Berkeley)	2/11/83";
#endif not lint

#
# define YYFLAG -1000
# define YYERROR goto yyerrlab
# define YYACCEPT return(0)
# define YYABORT return(1)

/*	parser for yacc output	*/

#ifdef YYDEBUG
int yydebug = 0; /* 1 for debugging */
#endif
YYSTYPE yyv[YYMAXDEPTH]; /* where the values are stored */
int yychar = -1; /* current input token number */
int yynerrs = 0;  /* number of errors */
short yyerrflag = 0;  /* error recovery flag */

yyparse() {

	short yys[YYMAXDEPTH];
	short yyj, yym;
	register YYSTYPE *yypvt;
	register short yystate, *yyps, yyn;
	register YYSTYPE *yypv;
	register short *yyxi;

	yystate = 0;
	yychar = -1;
	yynerrs = 0;
	yyerrflag = 0;
	yyps= &yys[-1];
	yypv= &yyv[-1];

 yystack:    /* put a state and value onto the stack */

#ifdef YYDEBUG
	if( yydebug  ) printf( "state %d, char 0%o\n", yystate, yychar );
#endif
		if( ++yyps> &yys[YYMAXDEPTH] ) { yyerror( "yacc stack overflow" ); return(1); }
		*yyps = yystate;
		++yypv;
		*yypv = yyval;

 yynewstate:

	yyn = yypact[yystate];

	if( yyn<= YYFLAG ) goto yydefault; /* simple state */

	if( yychar<0 ) if( (yychar=yylex())<0 ) yychar=0;
	if( (yyn += yychar)<0 || yyn >= YYLAST ) goto yydefault;

	if( yychk[ yyn=yyact[ yyn ] ] == yychar ){ /* valid shift */
		yychar = -1;
		yyval = yylval;
		yystate = yyn;
		if( yyerrflag > 0 ) --yyerrflag;
		goto yystack;
		}

 yydefault:
	/* default state action */

	if( (yyn=yydef[yystate]) == -2 ) {
		if( yychar<0 ) if( (yychar=yylex())<0 ) yychar = 0;
		/* look through exception table */

		for( yyxi=yyexca; (*yyxi!= (-1)) || (yyxi[1]!=yystate) ; yyxi += 2 ) ; /* VOID */

		while( *(yyxi+=2) >= 0 ){
			if( *yyxi == yychar ) break;
			}
		if( (yyn = yyxi[1]) < 0 ) return(0);   /* accept */
		}

	if( yyn == 0 ){ /* error */
		/* error ... attempt to resume parsing */

		switch( yyerrflag ){

		case 0:   /* brand new error */

			yyerror( "syntax error" );
		yyerrlab:
			++yynerrs;

		case 1:
		case 2: /* incompletely recovered error ... try again */

			yyerrflag = 3;

			/* find a state where "error" is a legal shift action */

			while ( yyps >= yys ) {
			   yyn = yypact[*yyps] + YYERRCODE;
			   if( yyn>= 0 && yyn < YYLAST && yychk[yyact[yyn]] == YYERRCODE ){
			      yystate = yyact[yyn];  /* simulate a shift of "error" */
			      goto yystack;
			      }
			   yyn = yypact[*yyps];

			   /* the current yyps has no shift onn "error", pop stack */

#ifdef YYDEBUG
			   if( yydebug ) printf( "error recovery pops state %d, uncovers %d\n", *yyps, yyps[-1] );
#endif
			   --yyps;
			   --yypv;
			   }

			/* there is no state on the stack with an error shift ... abort */

	yyabort:
			return(1);


		case 3:  /* no shift yet; clobber input char */

#ifdef YYDEBUG
			if( yydebug ) printf( "error recovery discards char %d\n", yychar );
#endif

			if( yychar == 0 ) goto yyabort; /* don't discard EOF, quit */
			yychar = -1;
			goto yynewstate;   /* try again in the same state */

			}

		}

	/* reduction by production yyn */

#ifdef YYDEBUG
		if( yydebug ) printf("reduce %d\n",yyn);
#endif
		yyps -= yyr2[yyn];
		yypvt = yypv;
		yypv -= yyr2[yyn];
		yyval = yypv[1];
		yym=yyn;
			/* consult goto table to find next state */
		yyn = yyr1[yyn];
		yyj = yypgo[yyn] + *yyps + 1;
		if( yyj>=YYLAST || yychk[ yystate = yyact[yyj] ] != -yyn ) yystate = yyact[yypgo[yyn]];
		switch(yym){
			
case 2:
# line 100 "ftpcmd.y"
{
		if( globargs )
			xdealglob( globargs );
		globargs = (char **)0;
		} break;
case 3:
# line 108 "ftpcmd.y"
 {
			int success;

			if( logged_in )
				{
				reply(531, "Already logged in.");
				xfree( yypvt[-1] );
				}
			else if ((success =
				xinit_env(yypvt[-1], (char *)0, (char *)0, 1))
				<= 0 
			) 
				{
				guest = 0;
				reply(331, "Password required for %s.", yypvt[-1]);
				if( username )
					xfree( username );
				username = yypvt[-1];
				}
			else if ( success < 0 )
				{
				/*
				Do we want to give out this informantion?
				*/
				reply(530, "User %s unknown.", yypvt[-1]);
				xfree(yypvt[-1]);
				if( username )
					xfree( username );
				username = (char *)0;
				}
			else
				{
				username = yypvt[-1];
				reply(230, "User %s logged in.", yypvt[-1]);
				logged_in = 1;
				guest = restricted( username );
				}
		} break;
case 4:
# line 147 "ftpcmd.y"
 {
			int success;

			if( !username )
				{
				reply(530, "Log in with user first.");
				xfree( yypvt[-1] );
				}
			else if( logged_in )
				{
				reply(531, "Already logged in.");
				xfree( yypvt[-1] );
				}
			else if ((success =
				xinit_env(username, yypvt[-1], (char *)0, 1))
				== 0 
			) 
				{
				guest = 0;
#ifdef	vms
				reply(331,"Secondary password required for %s.", username);
#else
				reply(331,"Account required for %s.", username);
#endif
				if( userpass )
					xfree( userpass );
				userpass = yypvt[-1];
				}
			else if ( success > 0 )
				{
				userpass = yypvt[-1];
				reply(230, "User %s logged in.", username);
				logged_in = 1;
				guest = restricted( username );
				}
			else		/* sucess < 0 (tricotomy) */
				{
				reply( 530, "Login failed." );
				xfree( yypvt[-1] );
				}
		} break;
case 5:
# line 189 "ftpcmd.y"
 {
			int success;

			if( !username )
				{
				reply(530, "Log in with user first.");
				xfree( yypvt[-1] );
				}
			else if( logged_in )
				{
				reply(531, "Already logged in.");
				xfree( yypvt[-1] );
				}
			else if ((success =
				xinit_env(username, userpass, yypvt[-1], 1))
				<= 0 
			) 
				{
				guest = 0;
				reply( 530, "Login incorrect." );
				xfree( yypvt[-1] );
				}
			else if ( success > 0 )
				{
				reply(230, "User %s logged in.", username);
				logged_in = 1;
#ifdef	vms
				if (userpass2)
					xfree(userpass2);
				userpass2 = yypvt[-1];
#endif
				guest = restricted( username );
				xfree( yypvt[-1] );
				}
		} break;
case 6:
# line 225 "ftpcmd.y"
 {
			usedefault = 0;
			ack(yypvt[-4]);
		} break;
case 7:
# line 230 "ftpcmd.y"
 {
			char cur[5];	/* current transfer parameter */

			cur[4] = '\0';
			switch (type) {
				case TYPE_A:	cur[0] = 'A';
						break;
				case TYPE_E:	cur[0] = 'E';
						break;
				case TYPE_I:	cur[0] = 'I';
						break;
				case TYPE_L:	cur[0] = 'L';
						break;
				default:	cur[0] = ' ';
						break;
			};
			switch (form) {
				case FORM_N:	cur[1] = 'N';
						break;
				case FORM_T:	cur[1] = 'T';
						break;
				case FORM_C:	cur[1] = 'C';
						break;
				default:	cur[1] = ' ';
						break;
			};
			switch (stru) {
				case STRU_F:	cur[2] = 'F';
						break;
				case STRU_R:	cur[2] = 'R';
						break;
				case STRU_P:	cur[2] = 'P';
						break;
				default:	cur[2] = ' ';
						break;
			};
			switch (mode) {
				case MODE_S:	cur[3] = 'S';
						break;
				case MODE_B:	cur[3] = 'B';
						break;
				case MODE_C:	cur[3] = 'C';
						break;
				default:	cur[3] = ' ';
						break;
			};

			if (type == TYPE_L) {
				reply(211, "%s%d. %s FTP server is alive.",
					cur, bytesize, hostname);
			} else {
				reply(211, "%s. %s FTP server is alive.",
					cur, hostname);
			};

		} break;
case 8:
# line 287 "ftpcmd.y"
 {
			struct xstatbuf info;
			char type[6];
			int rval;

			if (yypvt[-3] && yypvt[-1]) {
				rval = xstat( yypvt[-1], FILE_NAME, &info );
				if( rval < 0 ) {
					reply( 550, "%s:%s", yypvt[-1], 
						xrerror( rval ) );
				} else {
					if( info.x_mode & X_IFDIR ) {
						xstrcpy( type, "D" );
					} else {
						if ( info.x_mode & X_IFTEXT ) {
							xstrcpy( type, "ANFS" );
						} else {
							xstrcpy( type, "INFS" );
						};
						if ( info.x_mode & X_IFRECORD) 
							*(type + 2) = 'R';
					}
					reply(213, "%s %s",
						type, info.x_ncompo );
				}
			}
		} break;
case 9:
# line 315 "ftpcmd.y"
 {
			char **eargv;
			int madeargs = 0;
			int eargc;
			int rval;
			XFILE *fod;
			int od;
			int telod = -1;
			int i;

			if( !yypvt[-3] || !yypvt[-1] ) {
				/* reply( 500, "Sorry, you're not trusted." );
					(reply sent by check_login) */
				goto endxexc;
			}
			eargv = xmkarglist( yypvt[-1], &eargc );
			if( eargv == XNULL ) {
				reply( 500, "No memory in server." );
				goto endxexc;
			}
			madeargs = 1;
			fod = dataconn( "XEXC", (off_t)-1, "r" );
			if (fod == XNULL)
				goto endxexc;
			od = xfileno( fod );
			if( type == TYPE_A ) {
				telod = xtelopen( od, poption, pescape );
				if( telod < 0 ) {
					reply( 550, "%s:%s", yypvt[-2], xrerror(rval));
					xclose( od ), data = -1;
					goto endxexc;
				}
			} else {
				telod = od;
			}
			rval = xexec( eargc, eargv, telod, telod, telod );
			xclose( telod ), data = -1;
			if( rval < 0 ) {
				reply( 550, "%s:%s", yypvt[-2], xrerror( rval ) );
			} else {
				reply( 226, "Transfer Complete." );
			}
		endxexc:
			if( madeargs )
				xdealglob( eargv );
			;
		} break;
case 10:
# line 363 "ftpcmd.y"
 {
			if( data != -1 ) {
				xclose( data ), data = -1;
				reply( 226, "Transfer aborted." );
			} else {
				reply( 225, "No Transfer in progress." );
			}
		} break;
case 11:
# line 372 "ftpcmd.y"
 {
			switch (cmd_type) {

			case TYPE_A:
				if (cmd_form == FORM_N) {
					reply(200, "Type set to A.");
					type = cmd_type;
					form = cmd_form;
				} else
					reply(504, "Form must be N.");
				break;

			case TYPE_E:
				reply(504, "Type E not implemented.");
				break;

			case TYPE_I:
				reply(200, "Type set to I.");
				type = cmd_type;
				break;

			case TYPE_L:
				if (cmd_bytesz == 8) {
					reply(200,
					    "Type set to L (byte size 8).");
					type = cmd_type;
					bytesize = cmd_bytesz;
				} else
					reply(504, "Byte size must be 8.");
			}
		} break;
case 12:
# line 404 "ftpcmd.y"
 {
			switch ((int)yypvt[-1]) {

			case STRU_F:
				reply(200, "STRU F ok.");
				stru = STRU_F;
				break;

			case STRU_R:
				reply(200, "STRU R ok.");
				stru = STRU_R;
				break;

			default:
				reply(502, "Unimplemented STRU type.");
			}
		} break;
case 13:
# line 422 "ftpcmd.y"
 {
			switch ((int)yypvt[-1]) {

			case MODE_S:
				mode = MODE_S;
				reply(200, "MODE S ok.");
				break;

			default:
				reply(502, "Unimplemented MODE type.");
			}
		} break;
case 14:
# line 435 "ftpcmd.y"
 {
			ack(yypvt[-3]);
		} break;
case 15:
# line 439 "ftpcmd.y"
 {
			if (yypvt[-3] && yypvt[-1] != XNULL)
				retrieve(0, yypvt[-1]);
		} break;
case 16:
# line 444 "ftpcmd.y"
 {
			if (yypvt[-3] && yypvt[-1] != XNULL)
				store(yypvt[-1], "w");
		} break;
case 17:
# line 449 "ftpcmd.y"
 {
			if (yypvt[-3] && yypvt[-1] != XNULL)
				store(yypvt[-1], "a");
		} break;
case 18:
# line 454 "ftpcmd.y"
 {
			if (yypvt[-1])
				retrieve( LS, "");
		} break;
case 19:
# line 459 "ftpcmd.y"
 {
			if (yypvt[-3] && yypvt[-1] != XNULL)
				retrieve( LS_ARG, yypvt[-1]);
			if (yypvt[-1] != XNULL)
				xfree(yypvt[-1]);
		} break;
case 20:
# line 466 "ftpcmd.y"
 {
			if (yypvt[-1])
				retrieve( LSLONG, "");
		} break;
case 21:
# line 471 "ftpcmd.y"
 {
			if (yypvt[-3] && yypvt[-1] != XNULL)
				retrieve( LSLONG_ARG, yypvt[-1]);
			if (yypvt[-1] != XNULL)
				xfree(yypvt[-1]);
		} break;
case 22:
# line 478 "ftpcmd.y"
 {
			if (yypvt[-3] && yypvt[-1] != XNULL)
				delete(yypvt[-1]);
		} break;
case 23:
# line 483 "ftpcmd.y"
 {
			if (yypvt[-1])
				xchdir( (char *)0, HOME_DIR);
		} break;
case 24:
# line 488 "ftpcmd.y"
 {
			if (yypvt[-3] && yypvt[-1] != XNULL)
				cwd(yypvt[-1], FILE_NAME );
		} break;
case 26:
# line 494 "ftpcmd.y"
 {
			help(0);
		} break;
case 27:
# line 498 "ftpcmd.y"
 {
			help(yypvt[-1]);
		} break;
case 28:
# line 502 "ftpcmd.y"
 {
			ack(yypvt[-1]);
		} break;
case 29:
# line 506 "ftpcmd.y"
 {
			if (yypvt[-3] && yypvt[-1] != XNULL)
				makedir(yypvt[-1]);
		} break;
case 30:
# line 511 "ftpcmd.y"
 {
			if (yypvt[-3] && yypvt[-1] != XNULL)
				removedir(yypvt[-1]);
		} break;
case 31:
# line 516 "ftpcmd.y"
 {
			if (yypvt[-1])
				pwd();
		} break;
case 32:
# line 521 "ftpcmd.y"
 {
			if (yypvt[-1] && !inappropriate_request(PARENT_DIRECTORY))
				cwd(PARENT_DIRECTORY, FILE_NAME );
		} break;
case 33:
# line 526 "ftpcmd.y"
 {
			reply(221, "Goodbye.");
			xexit(0);
		} break;
case 34:
# line 531 "ftpcmd.y"
 {
			yyerrok;
		} break;
case 39:
# line 550 "ftpcmd.y"
 {
			register char *a, *p;

			a = (char *)&data_dest.sin_addr;
			a[0] = (int)yypvt[-10]; a[1] = (int)yypvt[-8];
			a[2] = (int)yypvt[-6]; a[3] = (int)yypvt[-4];
			p = (char *)&data_dest.sin_port;
			p[0] = (int)yypvt[-2]; p[1] = (int)yypvt[-0];
			data_dest.sin_family = AF_INET;
		} break;
case 40:
# line 563 "ftpcmd.y"
 {
		yyval = (YYSTYPE)FORM_N;
	} break;
case 41:
# line 567 "ftpcmd.y"
 {
		yyval = (YYSTYPE)FORM_T;
	} break;
case 42:
# line 571 "ftpcmd.y"
 {
		yyval = (YYSTYPE)FORM_C;
	} break;
case 43:
# line 577 "ftpcmd.y"
 {
		cmd_type = TYPE_A;
		cmd_form = FORM_N;
	} break;
case 44:
# line 582 "ftpcmd.y"
 {
		cmd_type = TYPE_A;
		cmd_form = (int)yypvt[-0];
	} break;
case 45:
# line 587 "ftpcmd.y"
 {
		cmd_type = TYPE_E;
		cmd_form = FORM_N;
	} break;
case 46:
# line 592 "ftpcmd.y"
 {
		cmd_type = TYPE_E;
		cmd_form = (int)yypvt[-0];
	} break;
case 47:
# line 597 "ftpcmd.y"
 {
		cmd_type = TYPE_I;
	} break;
case 48:
# line 601 "ftpcmd.y"
 {
		cmd_type = TYPE_L;
		cmd_bytesz = 8;
	} break;
case 49:
# line 606 "ftpcmd.y"
 {
		cmd_type = TYPE_L;
		cmd_bytesz = (int)yypvt[-0];
	} break;
case 50:
# line 612 "ftpcmd.y"
 {
		cmd_type = TYPE_L;
		cmd_bytesz = (int)yypvt[-0];
	} break;
case 51:
# line 619 "ftpcmd.y"
 {
		yyval = (YYSTYPE)STRU_F;
	} break;
case 52:
# line 623 "ftpcmd.y"
 {
		yyval = (YYSTYPE)STRU_R;
	} break;
case 53:
# line 627 "ftpcmd.y"
 {
		yyval = (YYSTYPE)STRU_P;
	} break;
case 54:
# line 633 "ftpcmd.y"
 {
		yyval = (YYSTYPE)MODE_S;
	} break;
case 55:
# line 637 "ftpcmd.y"
 {
		yyval = (YYSTYPE)MODE_B;
	} break;
case 56:
# line 641 "ftpcmd.y"
 {
		yyval = (YYSTYPE)MODE_C;
	} break;
case 57:
# line 647 "ftpcmd.y"
 {
		char *argv[2];

		argv[0] = (char *)yypvt[-0];
		argv[1] = (char *)0;
		globargs = nglob(argv, 1);
		if (globerr != XNULL) {
			reply(550, globerr);
			yyval = (YYSTYPE)XNULL;
		} else if( globargs == XNULL || *globargs == XNULL ) {
			reply(550, "No file name matches.");
			yyval = (YYSTYPE)XNULL;
		} else {
			yyval = (YYSTYPE)*globargs;
		}
		if (inappropriate_request(yyval))
			yyval = (YYSTYPE)XNULL;
		xfree(yypvt[-0]);
	} break;
case 58:
# line 669 "ftpcmd.y"
 {
		if (yypvt[-0] && inappropriate_request(yypvt[-0])) {
			yyval = (YYSTYPE)XNULL;
			xfree(yypvt[-0]);
		} else
			yyval = yypvt[-0];
	} break;
case 60:
# line 682 "ftpcmd.y"
 {
		if (yypvt[-1] && yypvt[-0])
			renamecmd(yypvt[-1], yypvt[-0]);
		else if ( !yypvt[-1] && yypvt[-0] )
			reply(503, "Bad sequence of commands.");
		/*
		  Otherwise ...
		  (Presumably, one of the previous reductions has already
		  sent the bad news. )
		*/
		/*
		 * Since two path names are involved, we should delalocate
		 * space for the first one, as globargs contains the result
		 * of the second globbing, and will be dealocated when
		 * the reduction to cmd takes place.
		 */
		if (rnf_glob)
			xdealglob(rnf_glob);
	} break;
case 61:
# line 704 "ftpcmd.y"
 {
		char *from = 0, *renamefrom();

		if (yypvt[-3] && yypvt[-1])
			from = renamefrom(yypvt[-1]);
		rnf_glob = globargs;
		yyval = (YYSTYPE)from;
	} break;
case 62:
# line 715 "ftpcmd.y"
 {
		yyval = yypvt[-1];
	} break;
case 63:
# line 721 "ftpcmd.y"
 {
		if (logged_in)
			yyval = (YYSTYPE)1;
		else {
			reply(530, "Please login with USER and PASS.");
			yyval = (YYSTYPE)0;
		}
	} break;
case 64:
# line 732 "ftpcmd.y"
 {
		if (logged_in) {
			if( guest ) {
				reply(550, "Action not permitted guest users.");
				yyval = (YYSTYPE)0;
			} else {
				yyval = (YYSTYPE)1;
			}
		} else {
			reply(530, "Please login with USER and PASS.");
			yyval = (YYSTYPE)0;
		}
	} break;
		}
		goto yystack;  /* stack new state and value */

	}
