/*	Copyright (c) 1985,1986,1987  EXCELAN, INC. 	*/
/*	  All Rights Reserved.                         	*/

/*	The copyright notice above does not evidence any 	*/
/*	actual or intended publication. 			*/

/*	THIS IS UNPUBLISHED COMPUTER SOFTWARE CONTAINING TRADE SECRETS 	*/
/*	AND CONFIDENTIAL INFORMATION PROPRIETARY TO EXCELAN, INC. 	*/

/* $Header: netstat.c,v 1.3 87/05/15 10:30:11 davidb Exp $ */
/* %W% %G% */

#include "netstat.h"

struct	nlist86v7 nl[] = {
#define	N_RCSID		0
 	{ "_rcsid" },		/* Filler for what used to be _mbstat */
#define	N_IPSTAT	1
	{ "_ipstat" },
#define	N_TCB		2
	{ "_tcb" },
#define	N_TCPSTAT	3
	{ "_tcpstat" },
#define	N_UDB		4
	{ "_udb" },
#define	N_UDPSTAT	5
	{ "_udpstat" },
#define	N_RAWCB		6
	{ "_rawcb" },
#define	N_IFNET		7
	{ "_ifnet" },
#define	N_RTHOST	8
	{ "_rthost" },
#define	N_RTNET		9
	{ "_rtnet" },
#define	N_SLEEPHEAD	10
	{ "_sleephe" },
#define	N_RUNHEAD	11
	{ "_runhead" },
#define	N_MSG_START	12
	{ "_msg_sta" },
#define	N_PROC_START	13
	{ "_proc_st" },
#define	N_TSSTAT	14
	{ "_tsstat" },
#define	N_IDMAP		15
	{ "_idmap" },
#define N_ECB		16
	{ "_ecb" },
#define N_MBPOOL	17
	{ "_mbpool" },
#define N_XMBPOOL	18
	{ "_xmbpool" },
#define N_PMBPOOL	19
	{ "_pmbpool" },
	{ "" },
};

extern	int protopr(), protopr_eth();
extern	int tcp_stats(), udp_stats(), ip_stats();
extern  long xlseek();

char	*system = NMFILE;
char	*exosf = DLDEV;
int	notxmem = 0;
char	*myname = "";
int	exos = 0;

int	aflag = 0;
int	cflag = 0;	/* print PCB information */
int	dflag = 0;
int	eflag = 0;
int	iflag = 0;
int	kflag = 0;
int	mflag = 0;
int	nflag = 0;
int	pflag = 0;	/* host request process/message info */
int	rflag = 0;
int	sflag = 0;
int	tflag = 0;	/* telnet server info */
int	lflag = 0;	/* datalink socket display */
int	interval = 0;
/* char	usage[] = "[ -ademnpst ] [ interval ] [ system ] [ core ]"; */
#ifdef	vms
char	usage[] = "[ [-a] [-b n] [-c] [-d] [-l] [-n] [-s] |\n\t -e | -m | \
 -p | -t ] [ net_module [ exos_image ]]";
#else
char	usage[] = "[ [-a] [-b n] [-c] [-d] [-l] [-n] [-s] |\n\t -e | -m | \
 -p | -t ] [ net_module [ exos_image ]]";
#endif

xmain(argc, argv)
	int argc;
	char *argv[];
{
	int i;
	char *cp, *name;
	int boardno;		/* board number */
/*	register struct protoent *p; */

	boardno = 0;
	myname = name = argv[0];
	argc--, argv++;
  	while (argc > 0 && **argv == '-') {
		for (cp = &argv[0][1]; *cp; cp++)
		switch(argv[0][1]) {

		case 'b':
		case 'B':
			if (argc < 2) {
				xoprintf(xstdout, "usage: %s %s\n", name, 
					usage);
				xexit(1);
			};
    			boardno = xatoi(argv[1]);
    			argc--;
    			argv++;
    			break;
		case 'c':
		case 'C':
			cflag++;
			break;

		case 'a':
		case 'A':
			aflag++;
			break;

		case 'd':
		case 'D':
			dflag++;
			break;

		case 'e':
		case 'E':
			eflag++;
			break;

		case 'i':
		case 'I':
			iflag++;
			break;

		case 'm':
		case 'M':
			mflag++;
			break;

		case 'n':
		case 'N':
			nflag++;
			break;
		case 'k':
		case 'K':
			kflag++;
			break;

		case 'p':
		case 'P':
			pflag++;
			break;

		case 'r':
		case 'R':
			rflag++;
			break;

		case 's':
		case 'S':
			sflag++;
			break;

		case 't':
		case 'T':
			tflag++;
			break;

		case 'l':
		case 'L':
			lflag++;
			break;

		default:
use:
			xoprintf(xstdout, "usage: %s %s\n", name, usage);
			xexit(1);
		}
		argv++, argc--;
	}
	if (argc > 0 && isdigit(argv[0][0])) {
		interval = xatoi(argv[0]);
		if (interval <= 0)
			goto use;
		argv++, argc--;
		iflag++;
	}
	if (argc > 0) {
		system = *argv;
		argv++, argc--;
	}
	if (argc > 0) {
		notxmem = 1;
		exosf = *argv;
		argv++, argc--;
	}

	nlist(system, nl);
	if (nl[0].n_type == 0) {
		xoprintf(xstderr, "%s: no namelist\n", system);
		xexit(1);
	}

	if (notxmem)
		exos = xdopen(exosf, XFREAD | XRANDOM, FILE_NAME);
	else
		exos = xbrdopen(boardno, 1);

	if (exos < 0) {
		xoprintf(xstderr, "cannot open %s", exosf);
		xexit(1);
	}

	if (eflag) {
		struct exosopt exosopt;

		klseek(exos, 0, 0);
		klread(exos, &exosopt, sizeof(struct exosopt));
		showopts(&exosopt);
		xexit(0);
	}
	if (mflag) {
		mbpr(nl[N_MBPOOL].n_value, nl[N_XMBPOOL].n_value, 
		     nl[N_PMBPOOL].n_value);
		xexit(0);
	}
	if(kflag) {
#ifndef	vms
		int adm_fd;

		adm_fd = open( "/dev/EXOS/admin", 0, 0 );
		xoprintf( xstderr, "active context buffers:\n" );
		if( adm_fd < 0 ) {
			xoprintf( xstderr, "cann't open xmem\n" );
			xexit( 1 );
		}
		xioctl( adm_fd, SOSEND, (char *)0 );
		close( adm_fd );
		xexit( 0 );
#else
		xoprintf(xstderr, "-k option not supported.\n");
#endif
	}
	if (tflag) {
		tspr(nl[N_TSSTAT].n_value, nl[N_IDMAP].n_value);
		xexit(0);
	}
	if (pflag) {
		nsproc(nl[N_PROC_START].n_value, nl[N_MSG_START].n_value,
		  nl[N_SLEEPHEAD].n_value, nl[N_RUNHEAD].n_value);
		xexit(0);
	}
	if (sflag) {
		tcp_stats(nl[N_TCPSTAT].n_value, "tcp");
		udp_stats(nl[N_UDPSTAT].n_value, "udp");
		ip_stats(nl[N_IPSTAT].n_value, "ip");
	}
	if (lflag) 
		protopr_eth(nl[N_ECB].n_value, "eth");
	protopr(nl[N_TCB].n_value, "tcp");
	protopr(nl[N_UDB].n_value, "udp");

	xfflush(xstdout);
/*
	endprotoent();
*/
	xexit( 0 );
}

char *
plural(n)
	int n;
{
	return (n != 1 ? "s" : "");
}

clientinit()
{
	int cowscomehome = 0;

	if(cowscomehome)	/* fake-out linker */
		xmodname();
}

klread(fd, bp, n)
	char *bp;
{
	return xread(fd, bp, n);
}

klseek(fd, xaddr, how)
unsigned xaddr;
{
	u_long anxaddr = xaddr;
	int status;

	if (notxmem) {
		if ((status = xlseek(exos, anxaddr, how)) < 0) {
			xoprintf(xstderr, "error location: %x\n", anxaddr);
			xperror(status, "lseek failed");
			xexit(1);
		}
	} else
		xioctl(fd, BRDADDR, &anxaddr);
}

u_short
xtohs(s)
u_short s;
{
	u_char *ucp = (u_char *)&s;

	return( (*ucp&0xFF) | ((*(ucp+1))<<8) );
}

u_long
xtohl(l)
u_long l;
{
	u_short *usp = (u_short *)&l;
	u_long result;

	result = (((u_long)xtohs(*usp))<<16) | (xtohs(*(usp+1)));
	return result;
}

showopts(xo)
struct exosopt *xo;
{
	xoprintf(xstdout, "exosopt:\n");
	xoprintf(xstdout,
		"\tARP %s\n", xo->xo_doarp ? "enabled" : "disabled");
	xoprintf(xstdout,"\tchecksums %s\n",
		xo->xo_docksum ? "enabled" : "disabled");
	xoprintf(xstdout,
		"\t%s\n", xo->xo_useaddr ? "use ENET addr below" :
		"use given ENET addr");
	xoprintf(xstdout,"\ttelnet connections = %d\n", xo->xo_ntsconn);
	xoprintf(xstdout,"\tinternet address = %x.%x.%x.%x\n",
		xo->xo_iaddr[0]&0xFF,
		xo->xo_iaddr[1]&0xFF,
		xo->xo_iaddr[2]&0xFF,
		xo->xo_iaddr[3]&0xFF);
	xoprintf(xstdout,"\tethernet address = %x-%x-%x-%x-%x-%x\n",
		xo->xo_eaddr[0]&0xFF, xo->xo_eaddr[1]&0xFF,
		xo->xo_eaddr[2]&0xFF, xo->xo_eaddr[3]&0xFF,
		xo->xo_eaddr[4]&0xFF, xo->xo_eaddr[5]&0xFF);
	xoprintf(xstdout,"\ttelnet options offered = %x\n",
		xo->xo_tsoffer & 0xFF);
	xoprintf(xstdout,"\ttelnet options permitted = %x\n",
		xo->xo_tspermit & 0xFF);
	xoprintf(xstdout,"\thost link mode access %s\n",
		xo->xo_dolink ? "enabled" : "disabled");
	xoprintf(xstdout,"\tNumber of extended memory buffers = %d\n",
		xo->xo_nxmbufs);
	xoprintf(xstdout,"\tUDP broadcast addr = %s\n",
		(xo->xo_udpba ? "net.0xff.0xff.0xff" : "net.0.0.0"));
	xoprintf(xstdout,"\tLoopback Address = %s\n",
		(xo->xo_lb ? "127.0.0.1" : "127.0.0.0"));
	xoprintf(xstdout,"\tNumber of retransmits before timeout = %d\n",
		xo->xo_ntcprxmt );
	xoprintf(xstdout,"\tsubnet mask = %x.%x.%x.%x\n", 
		xo->xo_snetmask[0]&0xFF,
		xo->xo_snetmask[1]&0xFF,
		xo->xo_snetmask[2]&0xFF,
		xo->xo_snetmask[3]&0xFF);
	xoprintf(xstdout,"\ttelnet options server requests = %x\n",
		xo->xo_tsdo & 0xFF);
	xoprintf(xstdout,"\ttelnet options the client can update = %x\n",
		xo->xo_tsagree & 0xFF);
}
