/*	Copyright (c) 1985,1986,1987  EXCELAN, INC. 	*/
/*	  All Rights Reserved.                         	*/

/*	The copyright notice above does not evidence any 	*/
/*	actual or intended publication. 			*/

/*	THIS IS UNPUBLISHED COMPUTER SOFTWARE CONTAINING TRADE SECRETS 	*/
/*	AND CONFIDENTIAL INFORMATION PROPRIETARY TO EXCELAN, INC. 	*/

/* $Header: rlogin.c,v 1.2 87/04/24 15:17:31 davidb Exp $ */
/*
 - code modified by AA to send localuser, remoteuser 
   in the initial packet. (thu 19 april)
*/
/*
 * rlogin host [ -ex ] [ -l username ] [ -8 ]
 *	- remote login to host
 */

static char sccsId[] = "@(#)rlogin.c	1.9 7/3/85";

#include <stdio.h>
#include <errno.h>
#include <pwd.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <ex_errno.h>

#ifdef SYSTEM5
#include <sys/termio.h>
#endif
#ifdef SYSTEM3
#include <termio.h>
#ifdef xenix286
#include <sys/ioctl.h>
#endif
#endif


/*
   index and rindex used to be mapped in include/EXOS/exos/misc.h.
   dab 861120.
*/

#if !( V7 || BSD4dot2 )
#define index strchr
#define rindex strrchr
#endif

extern char *index();

#ifndef V7
#ifndef BSD4dot2

/* if not V7 and not BSD4dot2 */
struct	termio defterm;
#endif /* BSD4dot2 */

#else /* iff V7 is defined */
#include <sgtty.h>
struct	sgttyb defflags;

struct	tchars deftc;
struct tchars notc = { 0377, 0377, 0377, 0377, 0377, 0377 };
#ifdef	NTTYDISC
struct	ltchars ldeftc;
struct	ltchars lnotc;
#endif

#endif	/* V7 */

#ifdef BSD4dot2
#include <sgtty.h>
extern char *index();
struct sgttyb defflags;

struct tchars deftc;
struct tchars notc = { 0377, 0377, 0377, 0377, 0377, 0377 };
struct ltchars ldeftc;
struct ltchars lnotc = { 0377, 0377, 0377, 0377, 0377, 0377 };
#endif

#ifdef TRACE
#define IN_TRACE "in_trace"
#define OUT_TRACE "out_trace"
FILE *infp;
FILE *outfp;
extern FILE *fopen();
#endif /* TRACE */

char killchar, erasechar, eofchar;
extern	struct passwd *getpwuid();
extern	int errno;
extern  kill(), getpid();

int	lostpeer(), done(), exit();

char	*name;			/* name of user */
char	cmdchar = '~';		/* default command char */
short	eight;			/* non-zero if 8 bit keyboard */
int	remote;			/* fd of remote (socket) */
short	child;			/* pid of reader() process */
char	*av0;			/* pointer to contents of argv[0] */
short   parent;			/* pid of writer() [parent] porcess */

main(argc, argv)
	int argc;
	char *argv[];
{
	register short i;
	char *host;
	struct passwd *pwd;
	int uid;
#ifdef TRACE

	infp = fopen( IN_TRACE, "w" );
	outfp = fopen( OUT_TRACE, "w" );
	if( infp == (FILE *)NULL || outfp == (FILE *)NULL ) {
		printf( "couldn't open trace files.\n" );
		exit( 1 );
	}
#endif /* TRACE */

    /* process command arguments */

	av0 = argv[0];
	host = NULL;
	for (i = 1; i < argc; i++) {
		if (argv[i][0] == '-') {
			switch (argv[i][1]) {
			  case 'l':
				if (i == (argc - 1))
					goto usage;
				name = argv[++i];
				break;
			  case 'e':
				cmdchar = argv[i][2];
				break;
			  case '8':
				eight = 1;
				break;
			  default:
usage:				fprintf(stderr,
		    "Usage: rlogin host [ -ex ] [ -l username ] [ -8 ]\n");
				exit(1);
			}
		} else {
			if (host)
				goto usage;
			else
				host = argv[i];
		}
	}
	if (host == NULL)
		goto usage;

	pwd = getpwuid(getuid());
	if (pwd == 0) {
		fprintf(stderr, "rlogin: Who are you?\n");
		exit(1);
	}

	signal(SIGPIPE, lostpeer);
#ifdef TRACE
	fprintf( outfp, "Calling remote.\n" );
	fflush( outfp );
#endif
        remote = myrcmd(&host, IPPORT_LOGINSERVER, pwd->pw_name,
			     name ? name : pwd->pw_name, "\n\n", (int *)0);
        if (remote < 0)
                exit(1);
	uid = getuid();
	if (setuid(uid) < 0) {
		experror("rlogin: setuid");
		exit(1);
	}
#ifdef TRACE
	fprintf( outfp, "Saving terminal state.\n" );
	fflush( outfp );
#endif
	ttysave();
	signal(SIGINT, exit);
	signal(SIGHUP, exit);
	signal(SIGQUIT, exit);

    /* get process for reader half */

	parent = getpid();
	child = fork();
	if (child == -1) {
		experror("rlogin: fork");
		exit(errno);
	}
	signal(SIGINT, SIG_IGN);
	signal(SIGQUIT, SIG_IGN);
	if (child == 0) {
#ifdef TRACE
		fprintf( infp, "Starting reader.\n" );
		fflush( infp );
#endif
		strcpy(av0, "rlognr");
		reader();
		kill(parent,SIGPIPE);
		exit(3);
	}
	strcpy(av0, "rlognw");
	ttymode(1);
#ifdef TRACE
	fprintf( outfp, "Starting writer.\n" );
	fflush( outfp );
#endif
	writer();
	telluser("Disconnected.");
	done(child);
}

/*
 * special version of rcmd, which sends no noise
 */
myrcmd(ahost, rport, locuser, remuser, cmd, fd2p)
	char **ahost;
	int rport;
	char *locuser, *remuser, *cmd;
	int *fd2p;
{
	int s, timo = 1;	/* Zilog uses 2 for timo... */
	long addr;
	struct sockaddr_in sin, sin2, from;
	char c;
	short port;
	extern long rhost();

	addr = rhost(ahost);
	if (addr == -1) {
		fprintf(stderr, "%s: unknown host\n", *ahost);
		return (-1);
	}
retry:
	s = myrresvport(SO_KEEPALIVE);

#ifdef DEBUG
fprintf(stderr, "myrcmd: s=%d, addr=%lx\n", s, addr);
#endif

	if (s < 0)
		return (-1);
	sin.sin_family = AF_INET;
	sin.sin_addr.s_addr = addr;
	sin.sin_port = rport;
	sin.sin_port = htons(sin.sin_port);
#ifdef	DEBUG
fprintf(stderr, "myrcmd: connecting on port %d\n", sin.sin_port);
dumpsocket(&sin, "myrcmd: before connect");
#endif
	if (connect(s, &sin) < 0) {
		if (errno == ECONNREFUSED && timo <= 16) {
#ifdef DEBUG
fprintf(stderr, "Connection refused\n");
#endif
			close(s);
			sleep(timo);
			timo *= 2;
			goto retry;
		}
		experror(*ahost);
		return (-1);
	}
	if (fd2p == 0) {
		write(s, "", 1);
#ifdef	DEBUG
	fprintf(stderr,"myrcmd: wrote a NULL\n");
#endif
		port = 0;
	} else {
		char num[8];
		int s2 = myrresvport(SO_ACCEPTCONN);
		extern errno;
#ifdef	DEBUG
fprintf(stderr, "myrcmd: s2=%d\n", s2);
#endif
		if (s2 < 0) {
			close(s);
			return (-1);
		}
		if ((socketaddr(s2, &sin2)) < 0) {
			experror("myrcmd");
			fprintf (stderr, "error=%d\n", errno);
			exit(1);
		}
		port = sin2.sin_port;
		port = htons((unsigned short)port);
		sprintf(num, "%d", port);
		write(s, num, strlen(num)+1);
		if (accept(s2, &from) < 0) {
			experror("accept");
			goto bad;
		}
		from.sin_port = ntohs(from.sin_port);
		if (from.sin_family != AF_INET ||
		    from.sin_port >= IPPORT_RESERVED) {
			fprintf(stderr,
			    "socket: protocol failure in circuit setup.\n");
			fprintf(stderr, "family=%d, port=%d\n",
			    from.sin_family, from.sin_port);
			goto bad;
		}
		*fd2p = s2;
	}
/* foo */
	write(s, locuser, strlen(locuser)+1);
	write(s, remuser, strlen(remuser)+1);
	write(s, cmd, strlen(cmd)+1);
#ifdef	DEBUG
	fprintf(stderr,"myrcmd: about to read from net\n");
	{
		int foo;
		foo = read(s, &c, 1);
		fprintf(stderr, "myrcmd: c=%02x\n", c);
		if (foo != 1) {
			fprintf (stderr,"myrcmd, tried to read 1, got 0x%x\n",
					       foo);
			experror(*ahost);
			goto bad;
		}
	}
#else
	read(s, &c, 1);
#endif
	if (c != 0) {
		while (read(s, &c, 1) == 1) {
			write(2, &c, 1);
			if (c == '\n')
				break;
		}
		goto bad;
	}
#ifdef	DEBUG
	fprintf(stderr,"returning from myrcmd\n");
#endif
	return (s);
bad:
	if (port)
		close(*fd2p);
	close(s);
	return (-1);
}

myrresvport(options)
	int options;
{
	struct sockaddr_in sin;
	static short lport = IPPORT_RESERVED - 1;
	int s;

	for (;;) {
		sin.sin_family = AF_INET;
		sin.sin_port = lport;
		sin.sin_addr.s_addr = 0;
		sin.sin_port = htons(sin.sin_port);
		s = socket(SOCK_STREAM, (struct sockproto *)0, &sin,
		  options|SO_SMALL);
		if (s >= 0)
			return (s);
		if (errno != EADDRINUSE && errno != EADDRNOTAVAIL) {
			experror("socket");
			return (-1);
		}
		lport--;
		if (lport == IPPORT_RESERVED/2) {
			fprintf(stderr, "socket: All ports in use\n");
			return (-1);
		}
	}
}

#ifdef	DEBUG
dumpsocket(sp, msg)
	register struct sockaddr_in *sp;
	char *msg;
{
	printf("Dumping socket '%s':\n", msg);
	printf("family:  %5d (0x%x)\n", sp->sin_family, sp->sin_family);
	printf("port:    %5d (0x%x)\n", sp->sin_port, sp->sin_port);
	printf("addr:    %d.%d.%d.%d (0x%x.0x%x.0x%x.0x%x)\n",
			 (sp->sin_addr.s_addr>>24)&0xff,
			 (sp->sin_addr.s_addr>>16)&0xff,
			 (sp->sin_addr.s_addr>>8 )&0xff,
			 (sp->sin_addr.s_addr    )&0xff,
			 (sp->sin_addr.s_addr>>24)&0xff,
			 (sp->sin_addr.s_addr>>16)&0xff,
			 (sp->sin_addr.s_addr>>8 )&0xff,
			 (sp->sin_addr.s_addr    )&0xff);
}
#endif

/*
 * writer:
 *	- Write to remote.  "cmdchar." will terminate input
 */
writer()
{
	char buffer[1024], ch;
	register char *pointer;
	short islocal;

top:
	pointer = buffer;
	while (read(0, &ch, 1) > 0) {
#ifdef TRACE
		fprintf( outfp, "read %x %c.\n", ch, ch );
		fflush( outfp );
#endif
		if( pointer >= &buffer[1023] ) {
			/*
			 * Don't allow buffer to over-flow.
			 */
			pointer = &buffer[1022];
		}
		if (eight == 0)
			ch &= 0177;
		if (pointer == buffer)
			islocal = (ch == cmdchar);
		if (pointer == buffer + 1 && *buffer == cmdchar)
			islocal = (ch != cmdchar);
		if (!islocal) {
#ifdef TRACE
			fprintf( outfp, "writing %x %c.\n", ch, ch );
			fflush( outfp );
#endif
			if (write(remote, &ch, 1) <= 0) {
				telluser("line gone");
				return;
			} else {
			}
			if (eight == 0)
				ch &= 0177;
		} else {
			if (ch == 0177)
				ch = killchar;
			if (ch == '\r' || ch == '\n') {
				char cmdc = buffer[1];

				/* termination? */
				if (cmdc == '.' || cmdc == eofchar) {
#ifdef TRACE
			fprintf( outfp, "echoing <cr><lf>.\n", ch, ch );
			fflush( outfp );
#endif
					write(1, "\r\n", sizeof("\r\n"));
					return;
				}
				/* shell escape stuff */
				/* null terminate the command string */

				*pointer = 0;
				if (cmdc == '!') {
				    int stat, proc;
#ifdef TRACE
			fprintf( outfp, "echoing <cr><lf>.\n", ch, ch );
			fflush( outfp );
#endif
				    write(1, "\r\n", sizeof("\r\n"));
				    proc = fork();
				    if (proc == 0) {
					    extern char *getenv();
					    char *shell = getenv("SHELL");
					    signal(SIGINT, SIG_DFL);
					    if (shell == 0) shell = "/bin/sh";
					    close(1);
					    close(2);
					    dup(0);
					    dup(0);
					    ttymode(0);
					    if (buffer[2] == 0)
					      execl(shell,shell,"-i",0);
					    else
					      execl(shell,shell,"-c",buffer+2,0);
					    telluser("Can't execute shell");
					    exit(-1);
				    }
				    if (proc!=(-1))
					    while (wait(&stat)!=proc);
				    ttymode(1);
#ifdef TRACE
			fprintf( outfp, "echoing !<cr><lf>.\n", ch, ch );
			fflush( outfp );
#endif
				    write(1, "!\r\n", 3);
				    goto top;
				}
				*pointer++ = ch;
#ifdef TRACE
			fprintf( outfp, "writing buffer.\n", ch, ch );
			fflush( outfp );
#endif
				write(remote, buffer, pointer - buffer);
				goto top;
			}
#ifdef TRACE
			fprintf( outfp, "echoing %x %c.\n", ch, ch );
			fflush( outfp );
#endif
			write(1, &ch, 1);
		}
		*pointer++ = ch;
		if (ch == erasechar) {
			pointer -= 2; 
			if (pointer < buffer)
				goto top;
		}
		if (ch == killchar || ch == 0177 || ch == eofchar ||
		    ch == '\r' || ch == '\n')
			goto top;
	}
}

/*
 * reader:
 *	- read from remote, write to stdout
 */
reader()
{
	char rb[BUFSIZ];
	register int cnt;
#ifdef pcxenix
	register char *pt;
	register int i;
#endif	/* pcxenix */
#ifdef TRACE
	int tcount;
#endif


	/*
	signal(SIGHUP, SIG_IGN);
	signal(SIGPIPE, SIG_IGN);
	*/
	signal(SIGQUIT, SIG_IGN);
	signal(SIGINT, SIG_IGN);
	signal(SIGHUP, exit);
	signal(SIGPIPE, exit);

	for (;;) {
		cnt = read(remote, rb, sizeof (rb));
#ifdef TRACE
		for( tcount = 0 ; tcount < cnt ; ++tcount ) {
			fprintf(infp,"read %x %c.\n", rb[tcount], rb[tcount] );
		}
		fflush( infp );
#endif
		if (cnt == 0)
			break;
		if (cnt < 0) {
			if (errno == EINTR)
				continue;
			break;
		}
#ifdef pcxenix
		for( i = cnt, pt = rb ; i ; --i, ++pt ) {
			*pt &= 0x7f;
		}
#endif	/* pcxenix */
#ifdef TRACE
		fprintf( infp, "writeing buffer.\n" );
		fflush( infp );
#endif
		write(1, rb, cnt);
	}
}

/*
 * done:
 *	- complete an rlogin session, killing the child (or parent) as
 *	  appropriate
 */
done(child)
	int child;
{
	ttymode(0);
	if (child > 0)
		kill(child, SIGKILL);
	exit(0);
}

/*
 * telluser:
 *	- write a msg to stderr, in raw mode
 */
telluser(msg)
	char *msg;
{
	fprintf(stderr, "%s\r\n", msg);
}

/*
 * lostpeer:
 *	- used to catch pipe signal, sent when writer() attempts to write
 *	  on a shutdown socket
 */
lostpeer()
{
	signal(SIGPIPE, SIG_IGN);
	telluser("\007Connection closed.");
	done(child);
}

/*
 * The following code is dependent on which version of unix is being
 * used.  See the Makefile for more information.
 */

#if  BSD4dot2 || V7
/*
 * ttysave:
 *	- save initial state of tty
 */
ttysave()
{
	register i;

	gtty(0, &defflags);
	defflags.sg_flags &= ECHO | CRMOD;
	killchar  = defflags.sg_kill;
	erasechar = defflags.sg_erase;
	ioctl(0, TIOCGETC, (char *)&deftc);
	eofchar = deftc.t_eofc;
	notc.t_startc = deftc.t_startc;
	notc.t_stopc = deftc.t_stopc;
#ifdef	NTTYDISC
	ioctl(0, TIOCGLTC, (char *)&ldeftc);
#endif	/* NTTYDISC */
}

ttymode(f)
{
	struct tchars *tc1;
#ifdef	NTTYDISC
	struct ltchars *tc2;
#endif	/* NTTYDISC */
	struct sgttyb current;

	gtty(0, &current);
	switch (f) {

	case 0: /* called during exit (and others) to put back conditions */
		current.sg_flags &= ~(CBREAK | RAW);
		current.sg_flags |= defflags.sg_flags;
		tc1 = &deftc;
#ifdef	NTTYDISC
		tc2 = &ldeftc;
#endif
		break;

	case 1: /* called during rlogin to set special conditions */
		current.sg_flags |= (eight )? RAW : CBREAK;
		current.sg_flags &= ~defflags.sg_flags;
		tc1 = &notc;
#ifdef	NTTYDISC
		tc2 = &lnotc;
#endif
		break;

	default:
		return;
	}
	stty(0, &current);
	ioctl(0, TIOCSETC, (char *)tc1);
#ifdef	NTTYDISC
	ioctl(0, TIOCSLTC, (char *)tc2);
#endif
}

#else	/* V7 */

/* SYSTEM3 and SYSTEM5 versions */

ttysave()
{
	ioctl(0, TCGETA, &defterm);
	killchar  = defterm.c_cc[VKILL];
	erasechar = defterm.c_cc[VERASE];
	eofchar = defterm.c_cc[VEOF];
}

ttymode(f)
{
	struct termio current;

	switch (f) {

	case 0:
		ioctl(0, TCSETAW, &defterm);
		return;

	case 1:
		ioctl(0, TCGETA, &current);
		if( !eight ) {
			current.c_lflag &= ~(ICANON|ECHO|ISIG);
			current.c_iflag &= ~(ICRNL); 
			current.c_iflag |= IXON; 
			current.c_oflag &= ONLCR;
			current.c_cc[VMIN] = 1;
#ifdef zilog
			/*
		 	* GAP 5/7/85: On Zilog S8000, setting this to 1
		 	* would cause tty read() to return immediately!
		 	*/
			current.c_cc[VTIME] = 0;
#else
			current.c_cc[VTIME] = 1;
#endif
		} else {
			/*
			Emulate Raw mode
			*/
			current.c_lflag &= ~(ICANON | ECHO | ISIG);
			current.c_iflag &= ~(INLCR | ICRNL | BRKINT);
			current.c_iflag &= ~IXON;
			current.c_oflag |= OPOST;
			current.c_oflag &= ~(OLCUC | ONLCR | OCRNL
				| ONOCR | ONLRET);
			current.c_cc[VMIN] = '\01';
			current.c_cc[VTIME] ='\0';
		}
		ioctl(0, TCSETA, &current);

	default:
		return;
	}
}
#endif	/* V7 */
