/*	Copyright (c) 1985,1986,1987  EXCELAN, INC. 	*/
/*	  All Rights Reserved.                         	*/

/*	The copyright notice above does not evidence any 	*/
/*	actual or intended publication. 			*/

/*	THIS IS UNPUBLISHED COMPUTER SOFTWARE CONTAINING TRADE SECRETS 	*/
/*	AND CONFIDENTIAL INFORMATION PROPRIETARY TO EXCELAN, INC. 	*/

/* $Header: rshd.c,v 1.5 87/05/15 10:34:05 davidb Exp $ */
/*

$Header: rshd.c,v 1.5 87/05/15 10:34:05 davidb Exp $

$Project: RSHD server $

$Creator: $

$Locker:  $

$Source: /a/8000/8000S/sdist/src/bin/netser/rshd.c,v $

----------------------------------------------------------------------------

(C) Copyright 1984,1985,1986 by Excelan Inc. All Rights Reserved

This software is furnished under contract and may be used and copied
only in accordance with the terms of such contract and with the
inclusion of the above copyright notice. This software or any other
copies thereof may not be provided or otherwise made available to
any other person. No title to and ownership of the software is hereby 
transferred.
----------------------------------------------------------------------------

$Abstract: 
$


$Includes: <OPTIONAL>
$


$Dependencies: <OPTIONAL>
$


$Files: <OPTIONAL>
<releated files if any> 
$


$Implementation Notes: 
$



$Log:	rshd.c,v $
 * Revision 1.5  87/05/15  10:34:05  davidb
 * PMR002078: fix #ifdefs on the VMS side.
 * 
 * Revision 1.19  87/05/14  00:23:18  alexl
 * *** empty log message ***
 * 
 * Revision 1.19  87/05/13  23:58:21  alexl
 * *** empty log message ***
 * 
 * Revision 1.18  87/05/11  15:14:39  davidb
 * PMR002071. New copyright message
 * 
 * Revision 1.17  87/05/11  14:09:22  davidb
 * Add 5 lines to be replaced by new copyright message.
 * 
 * Revision 1.16  87/03/17  17:46:12  grant
 * generizied rshd and rsh
 * 


$EndLog$ 


*/

#ifdef vms
#include <stdxln.h>
#include <xstdio.h>
#include <netdb.h>
#include <xerrno.h>
#include <xsetjmp.h>
#include <socket.h>
#include <in.h>
#include <exosqios.h>
#include <uafdef.h>
#include <xoslibio.h>
#include <soioctl.h>
#include <itemdef.h>
#include <telnet.h>
#include <xspecial.h>
#endif	/* vms */

#ifdef UNIX
#include <xstdio.h>
#include <xerrno.h>
#include <sys/socket.h>
#include <netinet/in.h>

/*
 * Make modula 2 fanatics happy.
 */
#define IMPORT extern
#define PRIVATE static
#define EXPORT
#endif	/* UNIX */


/* Data structures */
/* --------------- */



/* Variables */
/* --------- */

IMPORT char *xraddr();
EXPORT int sock2;		/* socket for stderr */




/* Functions */
/* --------- */


/*
$Name: xmain - main program for RSHD server $
*/

EXPORT int xsmain(sock, remote)

	struct sockaddr_in *remote;	/* remote socket information	*/
	int	sock;		/* socket I/O descriptor	*/

/* 

$Description: 
	See module description.
$ 

$Return: <OPTIONAL>
	0 - success
	1 - error
$

$Bugs: <OPTIONAL>
$


$Method: 
$
*/

{

char cmdbuf[256];			/* buffer for command */
char locuser[16],remuser[16];	/* buffers for user name(s) */


int	how;
int	status;			/* status	*/
char	c,*rhost;
short 	port = 0;
long 	ready;

/*
 * first validate the remote address
 */
	remote->sin_port = xntohs((unsigned short)remote->sin_port);
	if (remote->sin_family != AF_INET ||
		remote->sin_port >= IPPORT_RESERVED)
		xexit(1);
		
/*
 *	We now need to read the socket descriptor to see if
 *	we need to create an stderr socket
 */
	for(;;) {
		ready = (1<<sock);
		status = xselect(32,&ready,(long *)0,1000L);
		if (status <0)
			xexit(status);
		if (status == 0)
			continue;
		status = xread(sock,&c,1);
		if (status <= 0 ){
			if(status == XEWOULDBLOCK)
				continue;
			xexit(status);
		}
		if(c == 0) break;
		port = port*10 + c - '0';	/* accumulate port num */
	}
	if(port != 0) {
		sock2 = rresvport(0);
		if (sock2 < 0) xexit(sock2);
		if (port >= IPPORT_RESERVED) xexit(1);
		remote->sin_port = xntohs(port);
 		if (xconnect(sock2,remote) <0 ) xexit(1);
	}
/*
 *	now determine the name of the remote host
 */
	rhost = xraddr(remote->sin_addr.s_addr);
	if (rhost == 0) {
		error("Host name for your address unknown\n");
		xexit(1);
	}
	getstr(sock,remuser,sizeof(remuser),"remuser");
	getstr(sock,locuser,sizeof(locuser),"locuser");
	getstr(sock,cmdbuf,sizeof(cmdbuf),"command");
/*
 *	now make sure user exists on this system and set up
 *	user environment
 */
	if(xinit_env(locuser,(char *)0,(char *)0,0) <= 0){
		error("rshd:permission denied\n");
		xexit(1);
	}

/*
 *	now validate the remote user against .rhost file 
 */
	if(xruserok(rhost,remuser,locuser) <0){
		error("rshd:permission denied\n");
		xexit(1);
	}
/*	now tell remote that everything is ok
 *
 */
	xwrite(sock,"\0",1);
/*
 *	now execute the command
 */
	status = xrshd_exec(cmdbuf,sock,sock,sock2);
	xexit(0);
	

} /*xsmain*/
error(fmt, val)
	char *fmt;
{
	char buf[80];

	buf[0] = 1;
	 xsprintf(buf+1, fmt, val);
	 xwrite(sock2, buf, xstrlen(buf));
}

getstr(sock, buf, cnt, err)
	int sock;
	char *buf;
	int cnt;
	char *err;
{
	char c=1;
	int status;

	do {
		status = xread(sock, &c, 1);
		if (status <= 0){
			if (status == XEWOULDBLOCK)
				continue;
			xexit(1);
		}
		*buf++ = c;
		if (--cnt == 0) {
			error("%s too long\n", err);
			xexit(1);
		}
	} while (c != 0);
}
