/*	Copyright (c) 1985,1986,1987  EXCELAN, INC. 	*/
/*	  All Rights Reserved.                         	*/

/*	The copyright notice above does not evidence any 	*/
/*	actual or intended publication. 			*/

/*	THIS IS UNPUBLISHED COMPUTER SOFTWARE CONTAINING TRADE SECRETS 	*/
/*	AND CONFIDENTIAL INFORMATION PROPRIETARY TO EXCELAN, INC. 	*/

/* $Header: clientinit.c,v 1.4 87/04/24 15:19:58 davidb Exp $ */
/*
@(#)clientinit.c	1.4 4/11/85

Unix specific initialization of telnet client.
*/
#include "telnetc.h"
#include <signal.h>
#include <stdio.h>

extern char hisopts[];
extern char myopts[];
extern int _syskill;


static FILE *inter_fd = 0;

resync()

{
	sendflag( RESYNC );
}


clientinit()

{
	/*
	 * open a file descriptor for IPC
	 */
	inter_fd = fopen( "/dev/null", "r" );
	/*
	make sure terminal state gets saved.
	ignore signals, for starters.
	*/
	signal( SIGQUIT, SIG_IGN );
	xrestore_term();
	/*
	prefer fair scheduling to shared memory
	*/
	_syskill = 1;
}


extern long ftell();
/*
 * On systems which implement telnet as a single process
 * recvflags will not have to do anything,
 * but on Unix we use it to retrieve flags sent by the
 * net_write (the user).
*/
recvflag()
{
#ifdef TWO_PROCESSES
	long value;

	value = ftell(inter_fd);
	switch( value & 0xffL ) {
		case UPDATE:
			return;
		case RESYNC:
			/*
			* Need do nothing in shared memory implementations.
			*/
			if( nochange )
				return;
			value = UPDATE;
			if( hisopts[TELOPT_BINARY] ) {
				value |= BINHISOPT;
			}
			if( hisopts[TELOPT_ECHO] ) {
				value |= ECHOHISOPT;
			}
			if( hisopts[TELOPT_SGA] ) {
				value |= SGAHISOPT;
			}
			if( myopts[TELOPT_BINARY] ) {
				value |= BINMYOPT;
			}
			if( myopts[TELOPT_ECHO] ) {
				value |= ECHOMYOPT;
			}
			if( myopts[TELOPT_SGA] ) {
				value |= SGAMYOPT;
			}
			if( localecho ) {
				value |= LECHOBIT;
			}
			sendflag( value );
			nochange = 1;
			return;
		case NORMAL:
			break;
		case FLUSH:
			++flushing;
			break;
		case PAUSE:
			pause_flag = 1;
			break;
		case PAUSE_CLEAR:
			pause_flag = 0;
			break;
		case SETMYOPT:
			myopts[ (value & 0xff00L) >> 8 ] = OPT_ENABLE;
			break;
		case CLEARMYOPT:
			myopts[ (value & 0xff00L) >> 8 ] = OPT_DISABLE;
			break;
		case NEGOHISOPT:
			hisopts[ (value & 0xff00L) >> 8 ] |= OPT_NEGOTIATE;
			break;
		case NEGOMYOPT:
			myopts[ (value & 0xff00L) >> 8 ] |= OPT_NEGOTIATE;
			break;
		default:
			break;
	}
	if( value != NORMAL ) {
		/*
		 * Acknowledge reciept of flag.
		 */
		sendflag( NORMAL );
	}
#endif /* TWO_PROCESSES */
}

/*
 * On most systems, this function will simply set the value
 * of some global variable
 */
sendflag( value )
	long value;
{
	long ovalue;
	int retries = 0;

#ifdef TWO_PROCESSES

	if( value == RESYNC ) {
		signal( SIGALRM, resync );
		alarm( 15 );
	} else if ( value == SYNCOFF ) {
		alarm( 0 );
		return;
	}
	if( value != NORMAL && (value & 0xf) != UPDATE ) {
		/*
		 * Wait for acknowledgement, but not too long.
		 */
		do {
			ovalue = ftell(inter_fd);
			if( ovalue == -1L )
				break;
			if( (ovalue & 0xf) == UPDATE ) {
				/*
				 * get updated values from other process
				 */
			/*	printf( "UPDATE %x\n", ovalue ); */
				hisopts[TELOPT_BINARY] = 
					(ovalue & BINHISOPT)? 1 : 0;
				hisopts[TELOPT_ECHO] = 
					(ovalue & ECHOHISOPT)? 1 : 0;
				hisopts[TELOPT_SGA] = 
					(ovalue & SGAHISOPT)? 1 : 0;
				myopts[TELOPT_BINARY] = 
					(ovalue & BINMYOPT)? 1 : 0;
				myopts[TELOPT_ECHO] = 
					(ovalue & ECHOMYOPT)? 1 : 0;
				myopts[TELOPT_SGA] = 
					(ovalue & SGAMYOPT)? 1 : 0;
				localecho = 
					(ovalue & LECHOBIT)? 1 : 0;
				break;
			} else if ( ovalue == RESYNC && value != RESYNC) {
				/*
				 * reduce chance of loosing an update
				 * to either side
				 */
				sendflag(NORMAL);
			} else if ( retries < 1 ) {
				++retries;
				sleep( 1 );
			} else {
				break;
			}
		} while ( ovalue != RESYNC && ovalue != NORMAL );
	}
#endif /* TWO_PROCESSES */
	switch( value & 0xffL ) {
#ifndef TWO_PROCESSES
		case NORMAL:
			break;
		case FLUSH:
			++flushing;
			break;
		case PAUSE:
			pause_flag = 1;
			break;
		case PAUSE_CLEAR:
			pause_flag = 0;
			break;
#endif	/* TWO_PROCESSES */
		case SETMYOPT:
			myopts[ (value & 0xff00L) >> 8 ] = OPT_ENABLE;
			break;
		case CLEARMYOPT:
			myopts[ (value & 0xff00L) >> 8 ] = OPT_DISABLE;
			break;
		case NEGOHISOPT:
			hisopts[ (value & 0xff00L) >> 8 ] |= OPT_NEGOTIATE;
			break;
		case NEGOMYOPT:
			myopts[ (value & 0xff00L) >> 8 ] |= OPT_NEGOTIATE;
			break;
		default:
			break;
	}
#ifdef TWO_PROCESSES
	fseek(inter_fd, value, 0);
#endif	/* TWO_PROCESSES */
}
