/*	Copyright (c) 1985,1986,1987  EXCELAN, INC. 	*/
/*	  All Rights Reserved.                         	*/

/*	The copyright notice above does not evidence any 	*/
/*	actual or intended publication. 			*/

/*	THIS IS UNPUBLISHED COMPUTER SOFTWARE CONTAINING TRADE SECRETS 	*/
/*	AND CONFIDENTIAL INFORMATION PROPRIETARY TO EXCELAN, INC. 	*/

/* $Header: net_write.c,v 1.3 87/05/15 10:46:25 davidb Exp $ */
static char sccsId[] = "@(#)net_write.c	1.13 8/29/85";

/*
 * User telnet program.
 */
#define	connected	cnctd
#include "telnetc.h"

#define	ctrl(x)		((x) & 037)
#define	strip(x)	((x)&0177)
#define	INFINITY	((long)10000000)
/*
Telnet is supposed to represent end of lines as <cr><lf>.
We need to recognize the local end of line sequence and
convert it to this pair if the other side is not doing the
echoing.
The problem is that this process doesn't know what the other
side wants (the other side's requests are read by net_read, and
the only communication between the net_read process and this
is through the tty driver).
Unix systems strongly prefer to do the echo remotely, and in
general, it seems the neater solution.
Thus, remote echo is assumed the default state.
If this is not the case, the user may manually set the handling
of EOL.
*/

extern char	*hostname;
extern char	hisopts[];
extern char	*telopts[];
int	tcc = 0;
char	tibuf[XBUFSIZ] = {0}, *tbp = 0;
char	netobuf[XBUFSIZ] = {0}, *nfrontp = netobuf, *nbackp = netobuf;

extern int	connected;
extern int	net;
extern char	prompt[];
extern int	showoptions;
int	net_pid = 0;
char	escape = ctrl(']');
#ifdef	vms
int	flusho = ctrl('c');
#else
int	flusho = ctrl('o');		/* character that flushes output */
#endif
int	retcrlf = 1;

extern char	line[];
extern int	crnull;

extern	char **xmkarglist();

int	tn(), quit(), bye(), help();
int	setescape(), status(), sendcrlf();
int	setflusho();
int	shell();
int	rvi();
int	iac();
int	wbinary();
int	decho();
int	wsga();

static int	chmode();

#define HELPINDENT 	sizeof( "connect" )

struct cmd {
	char	*name;
	char	*help;
	int	(*handler)();
};

char	opt_state[15];
char	ngaopt[] = "Do suppress";
char	gaopt[] = "Do not suppress";
char	lecho[] = "Local";
char	recho[] = "Remote";
char	bmode[] = "Binary";
char	amode[] = "Ascii";
char	lmode[] = "Line mode";
char	cmode[] = "Character mode";
char	bhelp[] = "toggle 8-bit character mode";
char	sgahelp[] = "toggle full duplex communication mode";
char	qhelp[] = "exit telnet";
char	echohelp[] = "toggle remote echo mode";
char	ehelp[] = "set escape character";
char	shelp[] = "print status information";
char	lhelp[] = "toggle sending <cr><lf> on end of line";
char	hhelp[] = "print help information";
char	cmhelp[] = "toggle between character and line mode";
char 	shhelp[] = 
	"execute a command locally or escape\n\t\t\tinto local command\
 intepreter";
char	ohelp[] = "set character for interrupting remote process";
#ifdef REI
char	rvihelp[] = "rvi filename  -- run remote vi";
#endif	/* REI */
char	iachelp[] =
	"iac nnn nnn ... -- \n\t\t\tsend telnet IAC followed by decimal bytes";

struct cmd cmdtab[] = {
	{ "binary",	bhelp,		wbinary },
	{ "echo",	echohelp,	decho },
	{ "escape",	ehelp,		setescape },
	{ "setip",	ohelp,		setflusho },
	{ "quit",	qhelp,		quit },
	{ "sga",	sgahelp,	wsga },
	{ "status",	shelp,		status },
	{ "sendcrlf",	lhelp,		sendcrlf },
	{ "charmode",	cmhelp,		chmode},
	{ "?",		hhelp,		help },
	{ "!",		shhelp,		shell },
#ifdef REI
	{ "rvi",	rvihelp,	rvi },
#endif	/* REI */
	{ "iac",	iachelp,	iac },
	0
};

char optsga[] = { IAC, 0, TELOPT_SGA, 0 };
char optbin[] = { IAC, 0, TELOPT_BINARY, 0 };
char altbin[] = { IAC, 0, TELOPT_BINARY, 0 };
char optecho[] = { IAC, 0, TELOPT_ECHO, 0 };

struct cmd *getcmd();
char *control();

static int chmode(argc, argv)
int	argc;
char	*argv[];
{	/* toggles between character and line mode */

	if (!localecho) {
		/* remote echo, always in character mode */
		xoprintf(xstdout, 
			"Can only in character mode if remote echoes.\n");
		return;
	};

	if (charmode) {
		charmode = OPT_DISABLE;
	} else {
		charmode = OPT_ENABLE;
	};
	xoprintf(xstdout, "%s.\n", charmode ? cmode : lmode);
}

wsga( argc, argv )
int	argc;
char *argv[];
{	/* this routine toggles the SGA option */
char	*opt;

	/* sendflag( SYNCOFF ); */
	if (myopts[TELOPT_SGA] & OPT_ENABLE) {
		optsga[1] = WONT;
		opt = "WONT";
	} else {
		optsga[1] = WILL;
		opt = "WILL";
	};
	sendflag( NEGOMYOPT| ((long)TELOPT_SGA << 8) );
	if (showoptions)
		xoprintf( xstdout, "%s SGA sent.\n", opt);
	xwrite( net, optsga, sizeof( optsga ) - 1);
	/* sendflag( RESYNC ); */
}

wbinary( argc, argv )
int	argc;
char 	*argv[];
{
char *opt;
char *altopt;

	/* sendflag(SYNCOFF); */
	if (myopts[TELOPT_BINARY] & OPT_ENABLE) {
		optbin[1] = DONT;
		altbin[1] = WONT;
		altopt = "WONT";
		opt = "DONT";
	} else {
		altbin[1] = WILL;
		optbin[1] = DO;
		altopt = "WILL";
		opt = "DO";
	};
	sendflag( NEGOMYOPT | ((long)TELOPT_BINARY << 8) );
	if (showoptions) {
		xoprintf( xstdout, "%s BINARY sent.\n", altopt);
		xoprintf( xstdout, "%s BINARY sent.\n", opt);
	};		
	xwrite( net, optbin, sizeof( optbin ) - 1);
	sendflag( NEGOHISOPT | ((long)TELOPT_BINARY << 8) );
	xwrite( net, altbin, sizeof( altbin ) - 1);
	/* sendflag( RESYNC ); */
}

extern int localecho;	/* local echo mode	*/

decho( argc, argv )
int	argc;
char 	*argv[];
{


	/* sendflag( SYNCOFF ); */
	if (localecho) {
		optecho[1] = DO;
	} else {
		optecho[1] = DONT;
	};
	sendflag( NEGOHISOPT | ((long)TELOPT_ECHO << 8) );
	if (showoptions)
		xoprintf( xstdout, "%s ECHO sent.\n", 
			localecho ? "DO" : "DONT");
	xwrite( net, optecho, sizeof( optecho )  - 1);
	/* sendflag( RESYNC ); */
}

#ifdef REI
extern char *xstrchr();

rvi(argc, argv)
    char *argv[];
{
	char sockno[12];
	register char *sep;
	register char *r_hostname, *fname;
	int rvipid, kidpid;
	static char edcmd[] =
	    "\nstty -echo -icanon -onlcr; /bin/ed; stty echo icanon onlcr\n";

	if (argv[1] == NULL)
		argv[1] = "";

	if(argc > 2) {
		r_hostname = argv[1];
		fname = argv[2];
	} else {
		fname = xstrchr(argv[1], ':');
		if(fname != NULL) {
			*fname = '\0';	/* It's the host name, null-terminate */
			fname++;	 /* File name follows the ':' */
			r_hostname = argv[1];
		} else {
			r_hostname = hostname;
			fname = argv[1];
		}
	}
	xsprintf(sockno, "%d", (int)_xiob[net]._sys_id);
	sendflag( PAUSE );		/* Tell our reader process to wait */
	if(&netobuf[XBUFSIZ] - nfrontp < sizeof edcmd)
		netflush(net);
	xstrcpy(nfrontp, edcmd);
	nfrontp += sizeof edcmd;
	netflush(net);
	if ((rvipid = fork()) == 0) {

#ifdef DEBUG
	    {
		int infd = atoi(sockno), outfd = atoi(sockno);
		int logfd = creat("clog", 0666);
		register int i;
		extern int errno;
		char line[40];
		char msg[80];

		sprintf(msg, "infd %d, outfd %d\n", infd, outfd);
		write(logfd, msg, strlen(msg));

		i = write(outfd, "=\n", 2);
		sprintf(msg, "write -> %d (%d)\n", i, errno);
		write(logfd, msg, strlen(msg));

		line[0] = '\0';
		i = read(infd, line, sizeof line);
		if(i > 0) line[i] = '\0';
		sprintf(msg, "read -> `%s' %d (%d)\n", line, i, errno);
		write(logfd, msg, strlen(msg));
	    }
#endif	/* DEBUG */
		execlp("rvi_bin", "rvi_bin", sockno, sockno, fname, NULL);
		execl("/usr/lbin/rvi_bin", "rvi_bin", sockno, sockno, fname, NULL);
		execl("/u/aek/bin/rvi", "rvi", sockno, sockno, fname, NULL);
		perror("exec rvi_bin");
		_exit(1);
	} else {
		/* The original process loops,
		 * waiting for rvi to finish.
		 * The ed subprocess can take care of itself.
		 */
		while((kidpid = wait(0)) != rvipid && kidpid != -1)
			;
		xoprintf(xstderr, "Done -- press RETURN to resume session.\n.");
	}
	sendflag( PAUSE_CLEAR );
}
#endif	/* REI */


/*
 * Send raw telnet commands -- for debugging.
 */
iac(argc, argv)
    char *argv[];
{
	register int i;
	int command;		/* telnet command	*/
	int option;		/* telnet option */
	int data;		/* data	*/
	char *cmdstr;		/* command string */

	while((nfrontp - nbackp) > 0)
		netflush(net);
	*nfrontp++ = IAC;
	command = 0;
	option = TELOPT_SUPDUP;
	
	for(i = 1; i < argc; i++) {
		data = xatoi(argv[i]);	
		*nfrontp++ = data;
		switch (i) {
			case 1: command = data;
				break;
			case 2: option = data;
				break;
			default:
				break;
		};	
	};
	netflush(net);

	if (showoptions && (command != 0) && (option < TELOPT_SUPDUP)) {
		switch (command) {
			case DO: 
				cmdstr = "DO";
				sendflag ( NEGOHISOPT | (option << 8) );
				break;
			case DONT:
				cmdstr = "DONT";
				sendflag ( NEGOHISOPT | (option << 8) );
				break;
			case WILL:
				cmdstr = "WILL";
				sendflag ( NEGOMYOPT | (option << 8) );
				break;
			case WONT:
				sendflag ( NEGOMYOPT | (option << 8) );
				cmdstr = "WONT";
				break;
			default:
				cmdstr = "????";
				break;
		};
		xoprintf(xstdout, "SENT %s %s (reply)\n", cmdstr, 
			telopts[option]);
	};
}

/*
 * execute a local command
 */

shell( argc, argv)
	char *argv[];
{
	if( argc > 1 ) {
		++argv;
		--argc;
	}
	xexec( argc, argv, 0, 1, 2 );
	xoprintf( xstderr, "!\n" );
}


/*
 * Print status about the connection.
 */
/*VARARGS*/
status()
{
	static int first_stat = 1;

	if (connected)
		xoprintf(xstdout, "Connected to %s.\n", hostname);
	else
		xoprintf(xstdout, "No connection.\n");
	xoprintf(xstdout, "Escape character is '%s'.\n", control(escape));
	xoprintf(xstdout,
		"Interrupt remote process character is '%s'.\n",
		control(flusho));
			
	if( first_stat ) {
		first_stat = 0;
		return;
	}
	if (myopts[TELOPT_SGA] == OPT_ENABLE) {
		xstrcpy(opt_state, ngaopt);
	} else {
		xstrcpy(opt_state, gaopt);
	}	
	xoprintf(xstdout,"%s go aheads (GAs).\n",opt_state);
	if (localecho) {
		xstrcpy(opt_state, lecho);
	} else {
		xstrcpy(opt_state, recho);
	}	
	xoprintf(xstdout,"%s echo.\n",opt_state);
	if (localecho) {
		xoprintf(xstdout, "%s.\n", charmode ? cmode : lmode);
	};
	if (myopts[TELOPT_BINARY] == OPT_ENABLE) {
		xstrcpy(opt_state, bmode);
	} else {
		xstrcpy(opt_state, amode);
	}	
	xoprintf(xstdout,"%s mode.\n",opt_state);
}


/*VARARGS*/
bye()
{
	int how = 2;	/* GAP 8/7/85: close down read and write */
	register char *op;

	xrestore_term();
	if (connected) {
		xioctl(net, SIOCDONE, &how);
		xoprintf(xstdout, "Connection closed.\n");
		xclose(net);
		connected = 0;
	}
}

/*VARARGS*/
quit()
{
	call(bye, "bye", 0);
	xkill( net_pid );
	xexit(0);
}

/*
 * Help command.
 * Call each command handler with argc == 0 and argv[0] == name.
 */
help(argc, argv)
	int argc;
	char *argv[];
{
	register struct cmd *c;

	if (argc == 1) {
		xoprintf(xstdout,
			"Commands may be abbreviated.  Commands are:\n\n");
		for (c = cmdtab; c->name; c++)
			xoprintf(xstdout, "\t%-*s\t%s\n",
				HELPINDENT, c->name, c->help);
		return;
	}
	while (--argc > 0) {
		register char *arg;
		arg = *++argv;
		c = getcmd(arg);
		if (c == (struct cmd *)-1)
			xoprintf(xstdout,"?Ambiguous help command %s\n", arg);
		else if (c == (struct cmd *)0)
			xoprintf(xstdout,"?Invalid help command %s\n", arg);
		else
			xoprintf(xstdout,"%s\n", c->help);
	}
}

/*
 * Call routine with argc, argv set from args (terminated by 0).
 * VARARGS2
 */
call(routine, args)
	int (*routine)();
	int args;
{
	register int *argp;
	register int argc;

	for (argc = 0, argp = &args; *argp++ != 0; argc++)
		;
	(*routine)(argc, &args);
}

static intr_flag = 0;

ip_forward()
{
	xint_term( ip_forward );
	intr_flag = 1;
}

do_ip()
{
	/* Actually do the work of the interrupt.
	 * We don't want to do this in the signal routine.
	 */
	static char Interrupt[] = { IAC, DO, TELOPT_TM, IAC, IP };

	/* Communicate with receiver process, tell it to begin
	 * flushing its virtual circuit.
	 * Discard any pending output to network
	 * and send an IP down the line.
	 */
	
	sendflag( FLUSH );
	nfrontp = nbackp = netobuf;
	xstrncpy(nfrontp, Interrupt, sizeof Interrupt);
	nfrontp += sizeof Interrupt;
	netflush(net);
	if (showoptions)
		xoprintf(xstdout, "DO TIMING_MARK SENT\n");
	intr_flag = 0;
}

net_write( pid, tin, s )

int tin;	/* terminal descriptor */
int s;		/* network descriptor */
{
static int first_time = 1;
int	newchar;

if( first_time )
	{
	/*
	setup, if any.
	*/
	connected = 1;
	xint_term( ip_forward );
	net_pid = pid;
	net = s;
	sendflag( RESYNC );
	first_time = 0;
	}
/* loop to read from tty-to-net channel */
tcc = xread(tin, tibuf, sizeof(tibuf));
if( intr_flag ) {
	do_ip();
}
if (tcc <= 0) return;
tbp = tibuf;
while (tcc > 0) {
	register int c;
	if ((&netobuf[XBUFSIZ] - nfrontp) < 2)
		break;
	c = *tbp++ & 0377; --tcc;
	newchar = myopts[TELOPT_BINARY] & OPT_ENABLE ? c : strip(c);
	if (newchar == escape) {
		command(0);
		break;
	}
	if( newchar == flusho ) {
		do_ip();
		break;
	}
	if ( !(myopts[TELOPT_BINARY] & OPT_ENABLE) )
	    {
	    if( eolseq( newchar ))
		{
		*nfrontp++ = '\r';
		*nfrontp++ = '\n';
		}
	    else if( newchar == '\r' )
		{
		*nfrontp++ = '\r';
		*nfrontp++ = crnull ? '\0' : '\n';
		}
	    else
		{
		*nfrontp++ = c;
		}
	    }
	    else {
		*nfrontp++ = c;	    
/*	Not sure telnet server support this so comment it out 
		if (newchar == '\r')
			*nfrontp++ = '\0';	/+ follow telnet standard +/
*/
		};
}
while ((nfrontp - nbackp) > 0)
	netflush(s);
}

extern int (*xgetintterm())();

ign_intr()
{
/*
 * Ignore keyboard interupts while in command mode.
 */

	xint_term( ign_intr );
}

command(top)
	int top;
{
/*	Note: We should save whatever the interrupt handler currently is and
	      then use whatever the default operating system interrupt
	      handler when you are in this function.  Currently, this is only
	      conditional defined using a new XLIB routine called 
	      xgetintterm() that returns the address of the interrupt handler.
*/

	int	(*int_handler)();		/* interrupt handler	*/

	register struct cmd *c;
	int oldecho;		/* echo mode on entry */
	int oldle;		/* line edit mode on entry */
	char **argv;
	int argc;

	int_handler = xgetintterm();
	xint_term( ign_intr );

	oldecho = xsetterm( XECHO, XON_STERM );
	oldle = xsetterm( XLINE_EDIT, XON_STERM );
	xputchar('\n');
	sendflag( SYNCOFF );
	for (;;) {
		xoprintf(xstdout,"%s> ", prompt);
		if (xgets(line) == 0)
			break;
		if (line[0] == 0)
			break;
		argv = xmkarglist( line, &argc );
		c = getcmd(argv[0]);
		if (c == (struct cmd *)-1) {
			xoprintf(xstdout,"?Ambiguous command\n");
			xdealglob( argv );
			continue;
		}
		if (c == 0) {
			xoprintf(xstdout, "?Invalid command\n");
			xdealglob( argv );
			continue;
		}
		(*c->handler)(argc, argv);
		xdealglob( argv );
		if (c->handler != help)
			break;
	}
	if (!top) {
		if (!connected) {
			xexit( 1 );
		}
	}
	/*
	restore terminal's previous state
	*/
	oldecho = xsetterm( XECHO, oldecho );
	if (localecho)	{	/* set line edit mode based on setting of charmode */
		xsetterm( XLINE_EDIT, charmode ? XOFF_STERM : XON_STERM);
	} else {
		oldle = xsetterm( XLINE_EDIT, oldle );
	};
	xint_term(int_handler);
	sendflag( RESYNC );
}


/*
 * Set the escape character.
 */
setescape(argc, argv)
	int argc;
	char *argv[];
{
	register char *arg;
	char buf[50];

	if (argc > 1)
		arg = argv[1];
	else {
		xoprintf(xstdout, "New escape character: ");
		xgets(buf);
		arg = buf;
	}
	if (arg[0] != '\0')
		escape = encontrol(arg);
	xoprintf(xstdout, "Escape character is '%s'.\n", control(escape));
}

/*
 * Set the escape character.
 */
setflusho(argc, argv)
	int argc;
	char *argv[];
{
	register char *arg;
	char buf[50];

	if (argc > 1)
		arg = argv[1];
	else {
		xoprintf(xstdout, "New interrupt remote process character: ");
		xgets(buf);
		arg = buf;
	}
	if (arg[0] != '\0')
		flusho = encontrol(arg);
	xoprintf(xstdout, "Interrupt remote process character is '%s'.\n", control(flusho));
}

/*
 * Parse escape character specification.
 */
encontrol(s)
	register char *s;
{
	int v;

	if(s[1] == '\0')
		return(s[0]);

	if(s[0] == '^' && s[1] != '\0') {
		return(s[1] == '?' ? 0177 : s[1] & 0x1f);
	}
	if( *s == '\\' )
		++s;
	v = xatoi( s );
	if( v ) {	/* since it can be an int, do not mask off top 8 bits*/
		return(v);
	}
	return(-1);
}

/*
 * Construct a control character sequence
 * for a special character.
 */
char *
control(c)
	register int c;
{
	static char buf[3];

	if (c == 0177)
		return ("^?");
	if (c >= 040) {
		buf[0] = c;
		buf[1] = 0;
	} else {
		buf[0] = '^';
		buf[1] = '@'+c;
		buf[2] = 0;
	}
	return (buf);
}

struct cmd *
getcmd(name)
	register char *name;
{
	register char *p, *q;
	register struct cmd *c, *found;
	register int nmatches, longest;

	if (name == (char *) XNULL)
		return (-1);
	for( p = name ; *p ; ++p )
		*p = _tolower( *p );
	longest = 0;
	nmatches = 0;
	found = 0;
	for (c = cmdtab; p = c->name; c++) {
		for (q = name; *q == *p++; q++)
			if (*q == 0)		/* exact match? */
				return (c);
		if (!*q) {			/* the name was a prefix */
			if (q - name > longest) {
				longest = q - name;
				nmatches = 1;
				found = c;
			} else if (q - name == longest)
				nmatches++;
		}
	}
	if (nmatches > 1)
		return ((struct cmd *)-1);
	return (found);
}

netflush(fd)
{
	int n;

	if ((n = nfrontp - nbackp) > 0)
		n = xwrite(fd, nbackp, n);
	if (n < 0) {
		if ( n != XENOBUFS && n != XEWOULDBLOCK &&
			n != XEINTR ) {
			/*
			should close connection to kill off
			other side.
			*/
			VOID mode(0);
			xperror( n, hostname);
			xclose(fd);
			quit();
			/*NOTREACHED*/
		}
		n = 0;
	}
	nbackp += n;
	if (nbackp == nfrontp)
		nbackp = nfrontp = netobuf;
}


eolseq( c )

int c;
{

if( !retcrlf )
	return( 0 );
if( c == '\n' )
	return( 1 );
return( 0 );
}

sendcrlf( )
{

retcrlf = !retcrlf;
xoprintf(xstdout,  "sending of <cr><lf> on end of line is " );
if( retcrlf )
	xoprintf(xstdout,  "on.\n" );
else
	xoprintf(xstdout,  "off.\n" );
}
