/*	Copyright (c) 1985,1986,1987  EXCELAN, INC. 	*/
/*	  All Rights Reserved.                         	*/

/*	The copyright notice above does not evidence any 	*/
/*	actual or intended publication. 			*/

/*	THIS IS UNPUBLISHED COMPUTER SOFTWARE CONTAINING TRADE SECRETS 	*/
/*	AND CONFIDENTIAL INFORMATION PROPRIETARY TO EXCELAN, INC. 	*/

/* $Header: ud.c,v 1.2 87/04/24 15:24:27 davidb Exp $ */
/*
 * @(#)ud.c	1.12 10/14/85
 *  the udaemon program.
 *	- basically opens a pseudo port, reads a unix command,
 *	  execs the command after redirecting stdin and stdout
 *	  from and to the pseudo port as input to the command.
 *	- another proc waits on the pseudo tty (since the com-
 *	  mand is really only going to be 'rlogin') and after
 *	  it determines the pseudo port is finished being used,
 *	  signals the unix command process which then exits.
 *	- written by michael swan
 *	- to make, cc -O -o ud ud.c
 */
/*
 *  Modified to use the standard socket interface.
 *  Modified to use the xty driver for Excelan, Inc.
 *  Michael Swan, TMAC, Inc. (...!zehntel!normac!swan).
 */
#define	UDPORT	600

#ifdef  zilog
#define UNAME "/zeus"
#else
#ifdef  xenix286
#define UNAME "/xenix"
#else
#if	SYSTEM3 || SYSTEM5
#define UNAME "/unix"
#else
#define ISOPEN TS_ISOPEN
#define UNAME "/vmunix"
#endif
#endif
#endif


#include <stdio.h>

#ifdef zilog
#include <s.out.h>
#define	NLIST	s_nlist
#define	n_name	sn_name
#define	n_value	sn_value
#else
#ifdef	BSD4dot2
#include <nlist.h>
#else	/* BSD4dot2 */
#ifdef	tower
#include <nlist.h>
#else	/* tower */
#ifdef S5vax750
#include <nlist.h>
#else	/* S5vax750 */
#include <a.out.h>
#endif	/* S5vax750 */
#endif	/* tower */
#endif	/* BSD4dot2 */
#define	NLIST	nlist
#endif	/* zilog */

#include <ctype.h>
#include <sys/types.h>
#ifdef BSD4dot2
#include <sys/ioctl.h>
#endif
#include <sys/tty.h>
#include <signal.h>
#include <errno.h>
#include <sys/socket.h>
#include <netinet/in.h>

int	xtyfd;		/* file descriptor for the xty port */
int	daddy;		/* root program pid */
int	terminate();
char	unixname[25], hbuffer[256];
char	*av0;		/* pointer to contents of argv[0] */
struct	NLIST nl[2];
struct	sockaddr_in sinme = { AF_INET };
struct	sockaddr_in sinhim = { AF_INET };

main(argc, argv)
	int argc;
	char *argv[];
{
	char *arg;
	register int i;

	sprintf(unixname, UNAME);

	av0 = argv[0];
	for (i = 1; i < argc; i++) {
		arg = argv[i];
		if (*arg == '-') {
			switch (*++arg) {
				case 'n': 	/* name of namelist file */
				    if (*++arg == 0)
					arg = argv[++i];
				    strcpy(unixname, arg);
				    break;
				default:
					goto usage;
			}
		}
		else
			goto usage;
	}

#ifndef	DEBUG
	if (fork())
		exit(0);
#endif

#ifdef S5vax750
	nl[0].n_name = "_xt_tty";
#else
#ifdef tower
	nl[0].n_name = "_xt_tty";
#else
#if	SYSTEM3 || SYSTEM5
	(void)strcpy(nl[0].n_name, "_xt_tty");
#else	
    /* n_name is a pointer not an array. So strcpy won't work */
#ifdef	BSD4dot2
	nl[0].n_name = "_xt_tty";
#else	/* BSD4dot2 */
	nl[0].n_un.n_name = "_xt_tty";
#endif	/* BSD4dot2 */
#endif
#endif
#endif


	/*
	 *  ignore signals
	 */
#ifndef	DEBUG
	(void)signal(SIGINT, SIG_IGN);
	(void)signal(SIGHUP, SIG_IGN);
	(void)signal(SIGTERM, SIG_IGN);
	(void)signal(SIGQUIT, SIG_IGN);
#endif	/* DEBUG */

	for (;;) {
		daddy = getpid();
#ifndef DEBUG
		if (fork() != 0) {
			/* parent waits for child */
			(void) wait(0);
			sleep(5);
		}
		else
#endif
		{

		    /* connect to rlogin server */
#ifdef DEBUG
fprintf( stderr, "board_connect\n" );
#endif
			board_connect();

		    /* get the hostname */
#ifdef DEBUG
fprintf( stderr, "read_host\n" );
#endif 
			read_host();
#ifdef DEBUG
fprintf(stderr, "udaemon:  host = '%s'\n", hbuffer);
#endif
			rlogin(hbuffer);
			exit(0);
		}
	}
usage:
	fprintf(stderr, "Usage: ud [-n system_name].\n");
	exit(1);
}

/*
 *  read_host
 *	- read chars from pseudo port and form
 *	  host name
 */
read_host()
{
	char buf[2];
	char *bp = hbuffer;
	int n;

#ifdef DEBUG
fprintf(stderr, "About to start reading command...\n");
#endif
	while (((n = read(xtyfd, buf, 1)) != -1) &&
		((*buf & 0177) != '\r') && ((*buf & 0177) != '\n')) {
#ifdef DEBUG
fprintf(stderr, "Read character %c, %x\n", *buf, *buf);
#endif
		if (n == 0) {
			/* 
			 * We believe 0 is end of file.
			 */
			exit( 1);
		}
		*buf &= 0177;
		*bp++ = *buf;
	}
}

extern char *index();

extern	int errno;
extern  kill(), getpid();

int	lostpeer(), done(), exit();

char	*name;			/* name of user */
char	cmdchar = '~';		/* default command char */
short	eight;			/* non-zero if 8 bit keyboard */
int	remote;			/* fd of remote (socket) */
short	child;			/* pid of reader() process */
short   parent;			/* pid of writer() [parent] porcess */

rlogin(host)
	char *host;
{
	register short i;
	int uid;

	signal(SIGPIPE, lostpeer);
        remote = rcmd(&host, IPPORT_LOGINSERVER, "nomead",
			     "daemon", "\n\n", (int *)0);
        if (remote < 0) {
		fprintf( stderr, "rcmd failed.\n" );
		/*
		kill(daddy, SIGKILL);
		*/
                exit(1);
	}
	uid = getuid();
	if (setuid(uid) < 0) {
		experror("rlogin: setuid");
		kill(daddy, SIGKILL);
		exit(1);
	}
	/* get process for reader half */
	parent = getpid();
	child = fork();
	if (child == -1) {
		experror("rlogin: fork");
		kill(daddy, SIGKILL);
		exit(errno);
	}
	if (child == 0) {
		strcpy(av0, "ud-reader");
		reader();
		kill(parent,SIGPIPE);
		exit(3);
	}
	strcpy(av0, "ud-writer");
	writer();
	done(child);
}

/*
 * writer:
 */
writer()
{
	char wb[BUFSIZ];
	int n;

	while (1) {
		switch (n = read(xtyfd, wb, sizeof(wb))) {
			case 0:
				/* We believe 0 is end of file. */
				return;
			case -1:
				if (errno == EINTR)
					continue;
				else
					return;
			default:
				if (write(remote, wb, n) != n)
					return;
		}
	}
}


/*
 * reader:
 *	- read from remote, write to stdout
 */
reader()
{
	char rb[BUFSIZ];
	register int cnt;

	signal(SIGHUP, exit);
	signal(SIGPIPE, exit);

	for (;;) {
		cnt = read(remote, rb, sizeof (rb));
		if (cnt == 0)
			break;
		if (cnt < 0) {
			if (errno == EINTR)
				continue;
			break;
		}
		write(xtyfd, rb, cnt);
	}
}

/*
 * done:
 *	- complete an rlogin session, killing the child (or parent) as
 *	  appropriate
 */
done(child)
	int child;
{
	if (child > 0)
		kill(child, SIGKILL);
	wait(0);
	exit(0);
}

/*
 * lostpeer:
 *	- used to catch pipe signal, sent when writer() attempts to write
 *	  on a shutdown socket
 */
lostpeer()
{
	signal(SIGPIPE, SIG_IGN);
	done(child);
}

/*
 *  board_connect
 *	- socket and connect to board, set xtyfd.
 *	- this, in the xty model, will pass a known
 *	  local port (UDPORT) which the xty driver
 *	  recognizes as the udaemon connection.
 *	- the reading and writing of nulls is re-
 *	  quired by the EXOS on-board rlogin daemon.
 */
board_connect()
{
	long host_addr, rhost();
	char *hostname;
	char buf[2];
	register int i;

    /* find our own address */
	hostname = "lb";
	host_addr = rhost(&hostname);
	if (host_addr == -1) {
		fprintf(stderr, "lb: unknown host\n");
		return (-1);
	}
	sinhim.sin_family = AF_INET;
	sinhim.sin_addr.s_addr = host_addr;

    /* designate the *local* port number */
	sinme.sin_port = htons(UDPORT);

	if ((xtyfd = socket(SOCK_STREAM, 0, &sinme, 0)) < 0) {
		experror("udaemon:socket");
		kill(daddy, SIGKILL);
		exit(-1);
	}

	sinhim.sin_port = htons(IPPORT_LOGINSERVER);
	if (connect(xtyfd, &sinhim) < 0) {
		experror("connect");
		exit(-1);
	}

#ifdef	DEBUG
fprintf(stderr, "successful socket and connect.\n");
#endif
	*buf = (char)0;
	for (i = 0; i < 4; i++) {
		if (write(xtyfd, buf, 1) < 0) {
			experror("null write failure");
			exit(-1);
		}
	}
	if (read(xtyfd, buf, 1) < 0) {
		experror("null read failure\n");
		exit(-1);
	}
}
