/*	Copyright (c) 1985,1986,1987  EXCELAN, INC. 	*/
/*	  All Rights Reserved.                         	*/

/*	The copyright notice above does not evidence any 	*/
/*	actual or intended publication. 			*/

/*	THIS IS UNPUBLISHED COMPUTER SOFTWARE CONTAINING TRADE SECRETS 	*/
/*	AND CONFIDENTIAL INFORMATION PROPRIETARY TO EXCELAN, INC. 	*/

/* $Header: ex_xmem.c,v 1.2 87/04/24 15:59:42 davidb Exp $ */
static char sccsId[] = "	@(#)ex_xmem.c	2.3	5/8/85	";

/*
 * EXOS Memory/Download Driver
 *
 * This driver is used to:
 *	configure board
 *	download code to board
 *	start up code on board
 *	read/write board memory after startup
 */

/*
 12/12/86 dab	Changed code to refer to kl_error field for errors, instead
		of kl_reply. See ex_subr.c.
*/

#define PULLIN
#include "config.h"

#ifdef BSD4dot2
#define	U_OFFSET uio->uio_offset
#define	IOMOV_W	UIO_WRITE
#define	IOMOV_R	UIO_READ
#else
#define	U_OFFSET u.u_offset
#define	IOMOV_W	B_WRITE
#define	IOMOV_R	B_READ
#endif

EXbtype *ex_getbuf();

struct	msg *ex_findmsg();
struct	context *ex_send();
extern	struct exctrl ex_db;

#ifdef BSD4dot2
xmread(dev, uio)
	dev_t dev;
	struct uio *uio;
#else
xmread(dev)
	dev_t dev;
#endif
{
	register EXbatype baddr;
	register int amount;
	register long dladdr;
	register int mdev = minor(dev);
	EXbtype *dlbuf;		/* pointer to buf containing memory */
#ifdef BSD4dot2
	/*
	compensate for fact that u.u_count is a relic from before
	scatter-gather io.
	*/
	register int uiocnt;
	register struct iovec *iov;

	if (ex_db.ex_init == 0) 
		return (u.u_error = ENXIO );
	for (u.u_count = 0, iov = uio->uio_iov, uiocnt = 0; 
	     uiocnt < uio->uio_iovcnt; ++uiocnt, ++iov ) {
		u.u_count += iov->iov_len;
	}
#endif
#ifdef	DEBUG
	printf("xmread(%x): u.u_count=%d\n", dev, u.u_count);
#endif
	EXgetsblk( baddr, dlbuf, BSIZE );

	while (u.u_count) {
		amount = MIN(EXBSIZE, u.u_count);
		dladdr = U_OFFSET;	/* do this BEFORE iomove */
#ifdef	DEBUG_NOISE
		printf("xmread: reading %d bytes from %x to %x\n", amount,
			dladdr, baddr);
#endif
		if (xmrw(mdev, baddr, dladdr, amount, NET_ULOAD, dlbuf))
			break;
#ifdef BSD4dot2
		uiomove(EXioaddr(baddr,dlbuf), amount, IOMOV_R, uio);
		u.u_count -= amount;
#else
		iomove(EXioaddr(baddr,dlbuf), amount, IOMOV_R);
#endif
		EXmapout( dlbuf );
		if (u.u_error)
			break;
	}
	EXbrelse(dlbuf, BSIZE);
#ifdef BSD4dot2
	uio->uio_resid = u.u_count;
	uio->uio_iov->iov_len = u.u_count;
#endif
	return(u.u_error);
}

#ifdef BSD4dot2
xmwrite(dev, uio)
	dev_t dev;
	struct uio *uio;
#else
xmwrite(dev)
	dev_t dev;
#endif
{
	register EXbatype baddr;
	register int amount;
	register long dladdr;
	register int mdev = minor(dev);
	EXbtype *dlbuf;		/* pointer to buf containing memory */
#ifdef BSD4dot2
	/*
	compensate for fact that u.u_count is a relic from before
	scatter-gather io.
	*/
	register int uiocnt;
	register struct iovec *iov;

	if (ex_db.ex_init == 0) 
		return (u.u_error = ENXIO );
	for (u.u_count = 0, iov = uio->uio_iov, uiocnt = 0; 
	     uiocnt < uio->uio_iovcnt; ++uiocnt, ++iov ) {
		u.u_count += iov->iov_len;
	}
#endif
#ifdef	DEBUG
	printf("xmwrite(%x): u.u_count=%d\n", dev, u.u_count);
#endif
	if (!suser())
		return(u.u_error = EPERM);

	EXgetsblk( baddr, dlbuf, BSIZE );

	while (u.u_count) {
		amount = MIN(EXBSIZE, u.u_count);
		dladdr = U_OFFSET;	/* do this BEFORE iomove */
#ifdef BSD4dot2
		uiomove(EXioaddr(baddr, dlbuf ), amount, IOMOV_W, uio);
		u.u_count -= amount;
#ifdef DEBUG
		if ( u.u_count < 0 ) {
			printf( "bad guess on handling of u.u_count\n" );
			u.u_count = 0;
		}
#endif
#else
		iomove(EXioaddr(baddr, dlbuf ), amount, IOMOV_W);
#endif
		EXmapout( dlbuf );
		if (u.u_error)
			break;
#ifdef	DEBUG_NOISE
		printf("xmwrite: sending %d bytes from %x to %x\n", amount,
			baddr, dladdr);
#endif
		if (xmrw(mdev, baddr, dladdr, amount, NET_DLOAD, dlbuf))
			break;
#ifdef  DEBUG3
		printf( "got to end of loop resid=%d iov_cnt=%d\n",
			uio->uio_resid, uio->uio_iov->iov_len );
#endif
	}
	EXbrelse(dlbuf, BSIZE);
#ifdef BSD4dot2
	uio->uio_resid = u.u_count;
	uio->uio_iov->iov_len = u.u_count;
#endif
	return(u.u_error);
}

xmrw(mdev, baddr, dladdr, amount, net_cmd, bp)
int mdev;
EXbatype	baddr;
long	dladdr;
EXbtype *bp;
{
	register struct net_dload *net_dload;
	register struct context *kp;

	if (ex_db.ex_init == 0) 
		return (u.u_error = ENXIO );
	/*
	 * get message buffer; send download message
	 */
	net_dload = (struct net_dload *)ex_findmsg();
	net_dload->nm_length = amount;
	net_dload->nm_source = (long)EXvtop(baddr,bp,0);
	net_dload->nm_xmbyte = *(char *)baddr;	/* for 1-character writes */
	net_dload->nm_dest = dladdr;
	kp = ex_send(net_cmd, mdev, net_dload, 0);
	kp->kl_state = KL_FREE;
	if (ex_db.ex_state & ST_WAITING)
		wakeup((caddr_t)&ex_db);
	*(char *)baddr = kp->kl_achar;		/* for 1-character reads */
	if (kp->kl_error) {
#ifdef  DEBUG
		printf( "error in reply %x\n", kp->kl_reply );
#endif
		return(u.u_error = EIO);
	}
	return 0;
}

/*
 * Ioctls are used only by netload program,
 * typically in the following sequence:
 * 	
 *	EXIOCRESET
 *	seek(start of code)
 *	write, write, write...
 *	seek(start of initialized data)
 *	write, write, write...
 *	EXIOCSTART
 *
 */
/*ARGSUSED*/
xmioctl(dev, cmd, addr, flag)
	dev_t dev;
	int cmd, flag;
	EXioctltype addr;
{
	register struct net_start *net_start;
	register struct context *kp;
	register int mdev = minor(dev);
	long staddr;
	int i;
	int dotimo;

#ifdef  DEBUG
	printf( "xmioctl: dev=%x cmd=%x, addr=%x, flag=%x\n",
		dev, cmd, addr, flag );
#endif

#ifdef BSD4dot2
	/* IO_VOID passes a pointer to the original argument */
	addr = (caddr_t)(*((long *)addr));
	cmd = map_ioctl_cmd( cmd );
#ifdef  DEBUG
	printf( "xmioctl: dev=%x cmd=%x, addr=%x, *addr=%x flag=%x\n",
		dev, cmd, addr, (caddr_t)(*((long *)addr)), flag );
#endif
#endif

	switch (cmd) {
	case map_ioctl_cmd(EXIOCRESET):	/* reset and configure EXOS */
		if (!suser())
			return(u.u_error = EPERM);
		if (copyin(addr, (caddr_t)&dotimo, sizeof(dotimo))) {
			u.u_error = EFAULT;
			break;
		}

		/*NOTE: RESET BOARD SO IT NO LONGER INTERRUPTS US
			WITH REPLYS WE DONT WANT
		*/
		if (ex_db.ex_init == 0)
			exinit();	/* one-time-only initialization */

		for (i = 0 ; i < MAXDEVS ; ++i) {
			if (so_state[i] != SOS_FREE)
			/* should wake him up, but don't know where he is */
				so_state[i] = SOS_RESET;
		}

		/*
		 * Blow away anything waiting on socket.
		 */
		for (kp = context; kp < &context[NET_CONTEXTS]; kp++) {
			if ((kp->kl_state != KL_FREE) && (kp->kl_baddr)) {
				EXbrelse(kp->kl_baddr, BSIZE);
				kp->kl_baddr = (EXbtype *)0;
			}
			if (kp->kl_state & KL_WAITING) {
				wakeup((caddr_t)kp);
				psignal(kp->kl_proc, SIGKILL);
			}
			kp->kl_state = KL_FREE;
		}

#ifdef XTY
		xtyinit();		/* xty housekeeping */
#endif
		if (exsetup(EXOS_HOSTLOAD, dotimo))
			u.u_error = EIO;
		break;
	  case map_ioctl_cmd(EXIOCGCONF):/* return configuration message */
		/* might want to assure that ex_init, first */
		if (copyout(EXiocpaddr(ex_db.ex_imsg, imsgbuf),
			addr, sizeof(struct init_msg))) {
			u.u_error = EFAULT;
		}
		EXmapout( imsgbuf );
		break;
	  case map_ioctl_cmd(EXIOCSTART):	/* start program running */
		if (!suser())
			return(u.u_error = EPERM);
		if (copyin(addr, (caddr_t)&staddr, sizeof(staddr))) {
			u.u_error = EFAULT;
			break;
		}
#ifdef	DEBUG
printf("xmioctl: start address=%x\n", staddr);
#endif
		net_start = (struct net_start *)ex_findmsg();
		*((long *)&net_start->nm_sa1) = staddr;
		kp = ex_send(NET_START, mdev, net_start, 0);
#ifdef	DEBUG_NOISE
printf("xmioctl: START message sent\n");
#endif
		if (kp->kl_error)
			u.u_error = EIO;

		kp->kl_state = KL_FREE;
		break;

	    case map_ioctl_cmd(EXBDSTATRESET):
		if (ex_db.ex_init == 0) 
			return (u.u_error = ENXIO );
		if( !suser() ) {
			return( u.u_error = EPERM );
		}
	    case map_ioctl_cmd(EXBDSTAT):
		{
			if (ex_db.ex_init == 0) 
				return (u.u_error = ENXIO );
			exdoioctl(cmd,addr,0);
			return(u.u_error);
		}
	     case map_ioctl_cmd(EXIOCADDRT):
	     case map_ioctl_cmd(EXIOCDELRT):
			if (!suser())
			    return(u.u_error = EPERM);
	     case map_ioctl_cmd(EXIOCSHOWRT):
	     case map_ioctl_cmd(EXIOCDISPRT):

			/* send ROUTE operation to the board */

			if (ex_db.ex_init == 0) 
				return (u.u_error = ENXIO );
			exdoioctl(cmd,addr,2);
			return(u.u_error);
	     case map_ioctl_cmd(EXIOCSARP):
	     case map_ioctl_cmd(EXIOCDARP):
			/* check permission */
			if( !(u.u_ruid == 0 || u.u_uid == 0 ) )
				{
				u.u_error = EACCES;
				return( u.u_error );
				}
			/* absence of break here is diliberate */
	     case map_ioctl_cmd(EXIOCGARP):
			/* send ARP operation to the board */
		{
			if (ex_db.ex_init == 0) 
				return (u.u_error = ENXIO );
			exdoioctl(cmd,addr,1);
			return(u.u_error);
		}
	default:
		u.u_error = EINVAL;
	}
	return(u.u_error);
}


/* 
 * exdoioctl() --- send a random "ioctl" to the board.
*/
exdoioctl(cmd, addr, in_interesting)
int cmd;
EXioctltype addr;
int in_interesting;		/* flag to copy in ioctl structure */
{
	register struct msg *mp;
	register struct context *kp;
	register long sopaddr;
	register int amount;
	register EXbatype baddr;
	EXbtype *bp;
	struct Sock_pkt *admin_pkt; 

	/* get buffer where data will be kept */ 

	EXgetblk( baddr, bp, BSIZE );
	sopaddr = ((long)EXvtop(baddr,bp,0)); 

	/*
	If appropriate,
	copy ioctl structure to buffer
	*/

	if ( in_interesting  == 1)
		{
		copyin(addr, EXiocpaddr(baddr,bp), sizeof(struct EXarp_ioctl));
		EXmapout(bp);
		}
	if (in_interesting  == 2){
		copyin( addr, EXiocpaddr(baddr,bp), sizeof(struct rtentry) );
		EXmapout(bp);
	}

	/* send command to board */

	mp = (struct msg *)ex_findmsg();
	kp = mp->msg_context;
	kp->kl_baddr = bp;
	admin_pkt = (struct Sock_pkt *)mp;
	admin_pkt->nm_bufaddr = sopaddr;
	kp = ex_send(cmd, 1, mp, 0);
	if (u.u_error = kp->kl_error)
		goto out;

	/* copy data to user space */

	switch ( cmd ) {
		case map_ioctl_cmd(EXBDSTAT):
		case map_ioctl_cmd(EXBDSTATRESET):
			if (copyout(EXiocpaddr(baddr,bp),
				addr, sizeof(struct EXbdstats))) {
				u.u_error = EFAULT;
			}
			EXmapout( bp );
			break;
		case map_ioctl_cmd(EXIOCSARP):
		case map_ioctl_cmd(EXIOCGARP):
		case map_ioctl_cmd(EXIOCDARP):
			if (copyout(EXiocpaddr(baddr,bp),
				addr, sizeof(struct EXarp_ioctl))) {
				u.u_error = EFAULT;
			}
			EXmapout( bp );
			break;
		case map_ioctl_cmd(EXIOCADDRT):
		case map_ioctl_cmd(EXIOCDELRT):
		case map_ioctl_cmd(EXIOCDISPRT):
		case map_ioctl_cmd(EXIOCSHOWRT):
			if (copyout(EXiocpaddr(baddr,bp),
				addr, sizeof(struct rtentry))) {
				u.u_error = EFAULT;
			}
			EXmapout( bp );
			break;
		default :
			u.u_error = EIO;
			break;
		}
out:	kp->kl_state = KL_FREE;
	if (ex_db.ex_state & ST_WAITING)
		wakeup((caddr_t)&ex_db);
	EXbrelse(bp, BSIZE);
}
