/*	Copyright (c) 1985,1986,1987  EXCELAN, INC. 	*/
/*	  All Rights Reserved.                         	*/

/*	The copyright notice above does not evidence any 	*/
/*	actual or intended publication. 			*/

/*	THIS IS UNPUBLISHED COMPUTER SOFTWARE CONTAINING TRADE SECRETS 	*/
/*	AND CONFIDENTIAL INFORMATION PROPRIETARY TO EXCELAN, INC. 	*/

/* $Header: rcmd.c,v 1.3 87/05/15 11:18:45 davidb Exp $ */
#include <stdio.h>
#include <sys/types.h>
#include <ex_errno.h>
#include <sys/soioctl.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <errno.h>
static char sccsId[] = "@(#)rcmd.c	1.4 5/8/85";

#undef	DEBUG


/*
   index and rindex used to be mapped in include/EXOS/exos/misc.h.
   dab 861120.
*/

#if !( V7 || BSD4dot2 )
#define index strchr
#define rindex strrchr
#endif

extern char *index();

extern	errno;
int	rcmdoptions;

rcmd(ahost, rport, locuser, remuser, cmd, fd2p)
	char **ahost;
	int rport;
	char *locuser, *remuser, *cmd;
	int *fd2p;
{
	int s, timo = 1;	/* Zilog uses 2 for timo... */
	long addr;
	struct sockaddr_in sin, sin2, from;
	char c;
	short port;
	extern long rhost();

	addr = rhost(ahost);
	if (addr == -1) {
		fprintf(stderr, "%s: unknown host\n", *ahost);
		return (-1);
	}
retry:
	s = rresvport(rcmdoptions|SO_KEEPALIVE);

#ifdef DEBUG
fprintf(stderr, "rcmd: s=%d\n", s);
#endif

	if (s < 0)
		return (-1);
	sin.sin_family = AF_INET;
	sin.sin_addr.s_addr = addr;
	sin.sin_port = rport;
	sin.sin_port = htons(sin.sin_port);
#ifdef	DEBUG
fprintf(stderr, "rcmd: connecting on port %d\n", sin.sin_port);
dumpsocket(&sin, "rcmd: before connect");
#endif
	if (connect(s, &sin) < 0) {
		if (errno == ECONNREFUSED && timo <= 16) {
			close(s);
			sleep(timo);
			timo *= 2;
			goto retry;
		}
		experror(*ahost);
		return (-1);
	}
	if (fd2p == 0) {
		write(s, "", 1);
#ifdef	DEBUG
	fprintf(stderr,"rcmd: wrote a NULL\n");
#endif
		port = 0;
	} else {
		char num[8];
		long readfd;
		int p1,nbio, ret;
		int s2 = rresvport(rcmdoptions|SO_ACCEPTCONN);
		extern errno;
#ifdef	DEBUG
fprintf(stderr, "rcmd: s2=%d\n", s2);
#endif
		if (s2 < 0) {
			close(s);
			return (-1);
		}
		if ((socketaddr(s2, &sin2)) < 0) {
			experror("rcmd");
			fprintf (stderr, "error=%d\n", errno);
			exit(1);
		}
		port = sin2.sin_port;
		port = htons((unsigned short)port);
		sprintf(num, "%d", port);
		write(s, num, strlen(num)+1);
#ifndef NOSELECT
reselect:
		p1=1;
		nbio=1;
		readfd = (p1<<s2);
		if((ret=ioctl(s2,FIONBIO,&nbio)) < 0) {
			experror("ioctl/FIONBIO");
			goto bad;
		}
		if (select(20,&readfd,(long *)0,100000) <= 0) {
			experror("select - host failed to connect");
			close(s2);
			port=0;
			*fd2p=0;
			goto printerr;
		}
#endif
		if ((ret = accept(s2, &from)) < 0) {
			if(errno == EWOULDBLOCK)
				goto reselect;
			else {
				experror("accept");
				goto bad;
			}
		}
		nbio = 0;
		if((ret=ioctl(s2,FIONBIO,&nbio)) < 0) {
			experror("ioctl/FIONBIO");
			goto bad;
		}
		from.sin_port = ntohs(from.sin_port);
		if (from.sin_family != AF_INET ||
		    from.sin_port >= IPPORT_RESERVED) {
			fprintf(stderr,
			    "socket: protocol failure in circuit setup.\n");
			fprintf(stderr, "family=%d, port=%d\n",
			    from.sin_family, from.sin_port);
			goto bad;
		}
		*fd2p = s2;
	}
	write(s, locuser, strlen(locuser)+1);
	write(s, remuser, strlen(remuser)+1);
	write(s, cmd, strlen(cmd)+1);
printerr:
#ifdef	DEBUG
	fprintf(stderr,"rcmd: about to read from net\n");
	{
		int foo;
		foo = read(s, &c, 1);
		fprintf(stderr, "rcmd: c=%02x\n", c);
		if (foo != 1) {
			fprintf (stderr,"rcmd, tried to read 1, got 0x%x\n",
					       foo);
			experror(*ahost);
			goto bad;
		}
	}
#else
	read(s, &c, 1);
#endif
	if (c != 0) {
		while (read(s, &c, 1) == 1) {
			write(2, &c, 1);
			if (c == '\n')
				break;
		}
		goto bad;
	}
#ifdef	DEBUG
	fprintf(stderr,"returning from rcmd\n");
#endif
	return (s);
bad:
	if (port)
		close(*fd2p);
	close(s);
	return (-1);
}

rresvport(options)
	int options;
{
	struct sockaddr_in sin;
	static short lport = IPPORT_RESERVED - 1;
	int s;

	for (;;) {
		sin.sin_family = AF_INET;
		sin.sin_port = lport;
		sin.sin_addr.s_addr = 0;
		sin.sin_port = htons(sin.sin_port);
		s = socket(SOCK_STREAM, (struct sockproto *)0, &sin, options);
		if (s >= 0)
			return (s);
		if (errno != EADDRINUSE && errno != EADDRNOTAVAIL) {
			experror("socket");
			return (-1);
		}
		lport--;
		if (lport == IPPORT_RESERVED/2) {
			fprintf(stderr, "socket: All ports in use\n");
			return (-1);
		}
	}
}

char * firstwhite();
char * skipwhite();
ruserok(rhost, ruser, luser)
	char *rhost, *ruser, *luser;
{
	FILE *hostf;
	char ahost[32];
	int first = 1;

	hostf = fopen(HOSTSEQUIV, "r");
again:
	if (hostf) {
		while (fgets(ahost, sizeof (ahost), hostf)) {
			char *user, *buf;
			buf = ahost;
			if (index(buf, '\n'))
				*index(buf, '\n') = 0;
			buf = firstwhite(buf, ' ');
			if (buf)
				*buf++ = 0;
			buf = skipwhite(buf, ' ');
			user = buf;
			buf = firstwhite(buf, ' ');
			if(buf)
				*buf = 0;
			if (!strcmp(rhost, ahost) &&
			    !strcmp(ruser, user ? user : luser))
			    /*
			    be paranoid about giving root privledges
			    */
				if( !first || 
					strcmp( "root", user ? user: luser) )
				goto ok;
		}
		fclose(hostf);
	}
	if (first == 1) {
		first = 0;
		hostf = fopen(".rhosts", "r");
		goto again;
	}
	return (-1);
ok:
	fclose(hostf);
	return (0);
}

#ifdef	DEBUG
dumpsocket(sp, msg)
	register struct sockaddr_in *sp;
	char *msg;
{
	printf("Dumping socket '%s':\n", msg);
	printf("family:  %5d (%4x)\n", sp->sin_family, sp->sin_family);
	printf("port:    %5d (%4x)\n", sp->sin_port, sp->sin_port);
	printf("addr:    %d-%d (%x-%x)\n",
			 sp->sin_addr.s_host, sp->sin_addr.s_net,
			 sp->sin_addr.s_host, sp->sin_addr.s_net);
}
#endif
