/*	Copyright (c) 1985,1986,1987  EXCELAN, INC. 	*/
/*	  All Rights Reserved.                         	*/

/*	The copyright notice above does not evidence any 	*/
/*	actual or intended publication. 			*/

/*	THIS IS UNPUBLISHED COMPUTER SOFTWARE CONTAINING TRADE SECRETS 	*/
/*	AND CONFIDENTIAL INFORMATION PROPRIETARY TO EXCELAN, INC. 	*/

/* $Header: efsopen.c,v 1.4 87/04/24 16:10:58 davidb Exp $ */
/*
$Header: efsopen.c,v 1.4 87/04/24 16:10:58 davidb Exp $
$Log:	efsopen.c,v $
 * Revision 1.4  87/04/24  16:10:58  davidb
 * Fixing copyright message
 * 
 * Revision 1.3  87/03/26  19:33:42  grant
 * Updating source from Generic trees
 * 
 * Revision 1.1  86/10/08  10:18:45  mark
 * merging in changes for new ftp
 * 
 * Revision 1.4  86/09/22  10:01:32  albert
 * Need to watch out for the fact that remote file system cannot be opened due
 * to wrong password.
 * 
 * Revision 1.3  86/09/22  09:47:21  albert
 * Need to watch out for the fact that remote file system cannot be opened
 *  (e.g., wrong password).
 * 
 * Revision 1.2  86/09/19  12:52:33  albert
 * Updating source from Generic trees
 * 
 * Revision 1.3  86/09/09  11:50:52  mark
 * Updating source from Generic trees
 * 
 * Revision 1.2  86/09/04  20:38:48  mark
 * Updating source from Generic trees
 * 
 * Revision 1.2  86/08/25  17:23:32  mark
 * syncing revision level
 * 
 * Revision 1.1  86/04/18  19:08:02  mark
 * Initial revision
 * 
*/

#include "elib.h"

extern char *xmalloc();
extern struct filesystem fstable[];
extern struct filesystem *end_fstable;

struct filesystem *
efsopen( protocol, system, user, password, account )
	int protocol;		/* code for protocol */
	char *system;		/* name of host */
	char *user;		/* name of user on remote */
	char *password;		/* any authentication data really */
	char *account;		/* for the book keeper? */
{
	struct filesystem *fspt;
	struct filesystem *newfspt;
	int status;

	/*
	Search filesystem table for an entry which matches `protocol'.
	*/
	for( fspt = fstable ; fspt != end_fstable ; ++fspt ) {
		if( fspt->type == protocol ) {
			/*
			Ok, we found it.   Now, let's do the real work.
			*/
			newfspt = (struct filesystem *)
				xmalloc( sizeof( struct filesystem ) );
			if( newfspt == (struct filesystem *)XNULL )
				return( (struct filesystem *)XNULL );
			xbcopy( (char *)fspt, (char *)newfspt,
				sizeof(struct filesystem ) );
			if( newfspt->xfsopen )
				status = (*newfspt->xfsopen) (
					protocol,
					system,
					user,
					password,
					account,
					newfspt );
			if (status < 0) {
				xfree(newfspt);
				return (XNULL);
			};
			return( newfspt );
		}
	}
	return( (struct filesystem *)XNULL );
}
