/*	Copyright (c) 1985,1986,1987  EXCELAN, INC. 	*/
/*	  All Rights Reserved.                         	*/

/*	The copyright notice above does not evidence any 	*/
/*	actual or intended publication. 			*/

/*	THIS IS UNPUBLISHED COMPUTER SOFTWARE CONTAINING TRADE SECRETS 	*/
/*	AND CONFIDENTIAL INFORMATION PROPRIETARY TO EXCELAN, INC. 	*/

/* $Header: xcopy.c,v 1.5 87/05/18 11:45:19 davidb Exp $ */
/* $Header: xcopy.c,v 1.5 87/05/18 11:45:19 davidb Exp $
   $Log:	xcopy.c,v $
 * Revision 1.5  87/05/18  11:45:19  davidb
 * PMR002059: ftp tree copy fix
 * 
 * Revision 1.10  87/05/11  15:19:55  davidb
 * PMR002071. New copyright message
 * 
 * Revision 1.9  87/05/07  17:59:41  davidb
 * PMR002059. Fixed bug in recursive tree copy
 * 
 * Revision 1.3  87/03/26  19:35:38  grant
 * Updating source from Generic trees
 * 
 * Revision 1.8  86/11/10  19:02:58  mark
 * open existing files for writing and truncation, else get
 * extra bytes when a file shrinks.
 * 
 * Revision 1.3  86/11/05  08:24:51  alexl
 * Updating source from Generic trees
 * 
 * Revision 1.7  86/11/03  17:43:58  mark
 * close connections that are implicitly opened, but we have no
 * success with
 * 
 * Revision 1.6  86/10/29  17:47:24  albert
 * if -g flag is specified, it should copy the file to tname (target) not
 * to the name expanded from the source.
 * 
 * Revision 1.4  86/10/23  17:52:41  albert
 * 1. display success message when copy completes successfully
 * 2. handle cases that the source file specification contains path name.
 *
 * Revision 2.8  86/10/24  17:31:42  albert
 * if target is not a directory, return XENOTDIR error.
 * 
 * Revision 2.6  86/10/23  17:47:50  albert
 * handle cases that the source file specification contains a path.
 * 
 * Revision 2.5  86/10/18  15:10:55  albert
 * Updating source from Generic trees
 * 
 * Revision 1.3  86/10/15  19:58:16  mark
 * globbing nolonger generates error message
 * 
 * Revision 1.2  86/10/15  15:48:37  albert
 * 1. For VMS, need to extract the name of the directory from a file spec.
 * 2. Need to set force flag ON when file is opened in both source and target,
 *    this makes them consistent and use whatever mode is agreed upon.
 * 3. If transfer fails for any reason, the file in target system is deleted.
 * 
 * Revision 2.4  86/10/13  18:07:43  albert
 * delete the target file if transfer failed.
 * 
 * Revision 2.3  86/10/09  16:16:08  albert
 * 1. For VMS, we need to extract the directory name from the directory specification
 *   for use in the tree-copy operation.
 * 2. Force flag should be on when file is acccess on source and target so
 *    that the same attributes obtained from the file status can be used
 *    to open the file.
 * 
 * Revision 2.1  86/10/08  21:52:28  albert
 * 1. For VMS, we need to extract the directory name from the directory
 * specification for use in the tree-copy operation.
 * 2. When creating file on the target system, we need to turn on the
 *    force flag so that the files are opened using the same attributes that
 *    the source file is opened.
 * 3. When opening file on the source system, the force flag should be turned
 *    on so that the file is opened in the same mode it is supposed to be.
 * 
 * Revision 1.2  86/09/19  12:53:12  albert
 * Updating source from Generic trees
 * 
 * Revision 1.3  86/09/09  11:52:07  mark
 * Updating source from Generic trees
 * 
 * Revision 1.2  86/09/04  20:39:57  mark
 * Updating source from Generic trees
 * 
 * Revision 1.2  86/08/25  17:29:26  mark
 * syncing revision level
 * 
 * Revision 1.1  86/04/18  19:09:30  mark
 * Initial revision
 * 
*/

#include "copy.h"


char	usage[] = "[-rgabf] source [source...] destination";
char	buf[1024] = {0};

xcopy(argc, argv)
	int argc;
	char *argv[];
{
	int i;
	char *cp, *name;
	char *myname;
	int notnetimage;
	char *target;
	int rval;
	int file;
	int flags = 0;

	myname = name = argv[0];
	argc--, argv++;
  	while (argc > 0 && **argv == '-') {
		for (cp = &argv[0][1]; *cp; cp++)
		switch( *cp ) {

		case 'r':
		case 'R':
			flags |= IAMRECURSIVE | TOPLEVEL;
			break;
		case 'g':
		case 'G':
			flags |= DOGLOB | TARGETMUSTBEDIR;
			break;
		case 'f':
		case 'F':
			flags |= TRANSLATE;
			break;
		case 'b':
		case 'B':
			flags |= USEIMAGE;
			break;
		case 'a':
		case 'A':
			flags |= USEASCII;
			break;
		default:
			xoprintf( xstderr, "usage: %s %s\n", myname, usage );
			return(XEINVAL);
		}
		argv++, argc--;
	}
	if (argc < 2) {
		xoprintf( xstderr, "usage: %s %s\n", myname, usage );
		return(XEINVAL);
	}
	target = argv[ argc - 1 ];
	if( argc > 2 ) {
		flags |= TARGETMUSTBEDIR;
	}
	while ( argc > 1 ) {
		rval = xcopy1( *argv, target, flags );
		if( rval < 0 ) {
			return( rval );
		}
		--argc, ++argv;
	}
	xoprintf(xstdout, "Copy completed successfully.\n");
	return( 0 );
}

/*

$Implementation:

	For implementation details of this module, please see:
	lalk:/a/8000/generic/d_notes/xcopy.txt

$
*/

extern char *xmalloc();
extern struct filesystem *xgetfs();

xcopy1( source, target, flags )
	char *source;
	char *target;
	int flags;
{
	int slen;
	char *nsource;
	char *ssystem;
	char *suser;
	char *spass;
	char *saccount;
	char *sname;
	int tlen;
	char *ntarget;
	char *tsystem;
	char *tuser;
	char *tpass;
	char *taccount;
	char *tname;
	struct filesystem *srcfs;
	struct filesystem *trgfs;
	struct xstatbuf tstatb;	/* target's status buffer */
	char pwdsave[PWDLEN];
	int pwdrval;
	int rval;
	int globod;
	char nambuf[PWDLEN];
	char *argv[2];
	int soldconn = 0;
	int toldconn = 0;

	slen = xstrlen( source ) + 1;
	nsource = xmalloc( slen );
	if( nsource == (char *)XNULL ) {
		xperror( XENOMEM, "xcopy1" );
		return ( XENOMEM );
	}
	tlen = xstrlen( target ) + 1;
	ntarget = xmalloc( tlen );
	if( ntarget == (char *)XNULL ) {
		xperror( XENOMEM, "xcopy1" );
		xfree( nsource );
		return ( XENOMEM );
	}
	xbcopy( source, nsource, slen );
	xbcopy( target, ntarget, tlen );
	xflocate( nsource, &ssystem, &suser, &spass, &saccount, &sname );
	xflocate( ntarget, &tsystem, &tuser, &tpass, &taccount, &tname );
	/*
	see if a server is available for both source and target
	*/
	srcfs = xgetfs( ssystem, suser, spass, saccount, 1 );
	if( srcfs != XNULL ) {
		soldconn = 1;
	} else {
		srcfs = xgetfs( ssystem, suser, spass, saccount, 0 );
	}
	trgfs = xgetfs( tsystem, tuser, tpass, taccount, 1 );
	if( trgfs != XNULL ) {
		toldconn = 1;
	} else {
		trgfs = xgetfs( tsystem, tuser, tpass, taccount, 0 );
	}
	if( srcfs == XNULL || trgfs == XNULL ) {
		xperror( XEHOSTUNREACH, "xcopy1" );
		xrelsfs( srcfs, 0 );
		xrelsfs( trgfs, 0 );
		xfree( nsource );
		xfree( ntarget );
	}
	if( flags & USEASCII ) {
		argv[0] = "ascii";
		argv[1] = 0;
		ecmd( 1, argv, srcfs );
		ecmd( 1, argv, trgfs );
	}
	if( flags & USEIMAGE ) {
		argv[0] = "binary";
		argv[1] = 0;
		ecmd( 1, argv, srcfs );
		ecmd( 1, argv, trgfs );
	}
	/*
	save current directory on target filesystem,
	see if target is a directory by trying to echdir to it
	*/
	pwdrval = epwd( pwdsave, sizeof( pwdsave ), PWD, trgfs );
	if( pwdrval >= 0 ) {
		rval = estat(tname, FILE_NAME, &tstatb, trgfs);
		if (rval >= 0) {
			/* estat is successful */
			if (tstatb.x_mode & X_IFDIR) {
				/* is a directory */
				if (echdir(tname, FILE_NAME, trgfs) < 0) {
					/* error in echdir */
					xoprintf(xstderr, "name=%s, cd=%s\n",
						tname, pwdsave);
					rval = XEINVAL;
					goto cleanup;
				};
			};
		} else {	/* estat fails */
			tstatb.x_mode = 0;
			rval = echdir( tname, FILE_NAME, trgfs );
			if (rval >= 0) {	/* target is directory */
				tstatb.x_mode = X_IFDIR;
			};
		};

		if (tstatb.x_mode & X_IFDIR) {
			flags |= TARGETISDIR;
			tname = (char *) 0;
		} else if (flags & TARGETMUSTBEDIR) {
			/* target not a directory */
			xperror(XENOTDIR, "xcopy1");
			xoprintf(xstderr, "name = %s, cd = %s\n",
				tname, pwdsave);
			rval = XENOTDIR;
			goto cleanup;
		};
	}
	/*
	now copy the files
	*/
	if( flags & DOGLOB ) {
		globod = eglobopen( sname, FILE_NAME, srcfs );
		if( globod < 0 ) {
			xperror( globod, "copy(eglobopen)" );
			xoprintf( xstderr, "cann't expand %s.\n", sname );
			rval = globod;
			goto cleanup;
		}
		while ( (rval = xread( globod, nambuf, sizeof(nambuf))) > 0 ){
			rval = xcopy2( srcfs, nambuf, trgfs, tname, flags );
			if( rval < 0 ) {
				xperror( rval, "xcopy1(xcopy2)" );
				xclose( globod );
				goto cleanup;
			}
		}
		if( rval == XEOF ) {
			rval = 0;
		} else if( rval < 0 ) {
			xperror( rval, "xcopy1(xread)" );
		}
		xclose( globod );
	} else {
		rval = xcopy2( srcfs, sname, trgfs, tname, flags );
	}
cleanup:
	/*
	restore old directory on target filesystem and otherwise cleanup
	*/
	if( pwdrval >= 0 ) {
		echdir( pwdsave, FILE_NAME, trgfs );
	}
	if( !soldconn && rval < 0 ) {
		xrelsfs( srcfs, 1 );	/* close it, it's probably useless */
	} else {
		xrelsfs( srcfs, 0 );
	}
	if( !toldconn && pwdrval < 0 && rval < 0 ) {
		xrelsfs( trgfs, 1 );	/* close it, it's probably useless */
	} else {
		xrelsfs( trgfs, 0 );
	}
	xfree( nsource );
	xfree( ntarget );
	return( rval );
}


xcopy2( srcfs, sname, trgfs, tname, flags )
	struct filesystem *srcfs;
	char *sname;
	struct filesystem *trgfs;
	char *tname;
	int flags;
{
	/* note that if tname is 0, write to current directory on
	   target system */

	int rval;
	struct xdirect nxtfile;
	struct xstatbuf xstatb;
	char savepwd[PWDLEN];
	char spwdsave[PWDLEN];
#ifdef	vms
	char dirname[PWDLEN];	/* name portion of the directory */
#endif
	char nameonly[PWDLEN];	/* name portion */
	int inod;
	int dirod;
	int outod;
	int mode;

	/*
	see if file type information is available on source
	*/
	rval = estat( sname, FILE_NAME, &xstatb, srcfs );
	if (rval >= 0) {
		if (!(xstatb.x_mode & X_IFDIR))
			xstrcpy(nameonly, xstatb.x_ncompo);
		else 
			xstrcpy(nameonly, sname);
	} else
		xstrcpy(nameonly, sname);

	/*
	Assume file is a plain file in the absense
	of other information.
	*/
	if( (rval >= 0) && (xstatb.x_mode & X_IFDIR) ) {
		if( (flags & IAMRECURSIVE) && (flags & TARGETISDIR) ) {
			/*
			save current directory,
			make a new directory with
			source's name (if necessary), cd there,
			then copy the files in source there,
			restore current directory.
			*/
#ifdef	vms
			/* FOR VMS, just extract the filename portion */
			if (tname != 0) {
				extdir(tname, dirname);	/* extract directory portion */
				tname =	dirname;
			}
#endif	/* vms */
			rval = epwd( savepwd, sizeof( savepwd ), PWD, trgfs );
			if( rval < 0 ) {
				xperror( rval, "xcopy2(epwd)" );
				return( rval );
			}

			if (tname != (char *) 0) {
				/* has target directory specified */
				rval = echdir( tname, CD_RELATIVE, trgfs );
				if( rval < 0 ) {
					rval = emkdir( tname, CD_RELATIVE, trgfs);
					rval = echdir( tname, CD_RELATIVE, trgfs);
					if( rval < 0 ) {
						xperror(rval, "xcopy2(echdir)");
						xoprintf( xstderr, 
							"target file = %s\n",
							tname );
						return( rval );
					};
				}
			}

			dirod = ediropen( sname, FILE_NAME, srcfs );
			if( dirod < 0 ) {
				xperror( dirod, "xcopy2(ediropen)" );
				return( dirod );
			}
			rval = epwd( spwdsave, sizeof(spwdsave), PWD, srcfs );
			if( rval < 0 ) {
				xperror( rval, "xcopy2(epwd)" );
				return( rval );
			}
		/* If this is the top level of a tree copy, the argument of
		   the first chdir must be considered an absolute path. Lower
		   levels should consider the argument relative to the	
		   current directory. dab 870417. */
			rval = echdir( sname, 
				flags & TOPLEVEL ? FILE_NAME : CD_RELATIVE,
				srcfs );
			if( rval < 0 ) {
				xperror( rval, "xcopy2(echdir)" );
				xoprintf( xstderr, "source file = %s\n", sname);
				xclose( dirod );
				return( rval );
			}
			while(
			    (rval = xread( dirod, &nxtfile, sizeof(nxtfile) ))
			    > 0 ) {
			/* Turn off the top level bit on recursive calls. dab
			   860417. */
				rval = xcopy2( srcfs, nxtfile.d_name,
						trgfs, nxtfile.d_name, 
						flags & ~TOPLEVEL );
				if( rval < 0 ) {
					xperror( rval, "xcopy2(xcopy2)" );
					xclose( dirod );
					return( rval );
				}
			}
			if (rval == XEOF)
				rval = 0;	/* end of file is perfectly
						   legal and is not an error */
			xclose( dirod );
			echdir( spwdsave, FILE_NAME, srcfs );
			echdir( savepwd, FILE_NAME, trgfs );
			if( rval < 0 ) {
				xperror( rval, "xcopy2(xread)" );
			}
			return( rval );
		} else if ( !(flags & TARGETISDIR) ) {
			xperror( XENOTDIR, "xcopy2" );
			xoprintf( xstderr, "target file: %s.\n", tname );
			return( XENOTDIR );
		} else {
			xperror( XEISDIR, "xcopy2" );
			xoprintf( xstderr, "source file: %s.\n", sname );
			return( XEISDIR );
		}
	}
	mode = XFREAD | XFFORCE;
	tname = tname ? tname : nameonly;

	if( flags & TRANSLATE ) {
		rval = estat( "", SERVICE_PARA, &xstatb, srcfs );
		if( rval < 0 ) {
			return( rval );
		}
	}
	inod = eopen( sname, mode, FILE_NAME, &xstatb, srcfs );
	if( inod < 0 ) {
		xperror( inod, "xcopy2(eopen)" );
		xoprintf( xstderr, "source file %s\n", sname );
		return( inod );
	}
	mode = XFWRITE | XFCREAT  | XFTRUNC | XFFORCE;
	outod = eopen( tname, mode, FILE_NAME, &xstatb, trgfs );
	if( outod < 0 ) {
		xperror( outod, "xcopy2(eopen)" );
		xoprintf( xstderr, "target file %s\n", sname );
		xclose( inod );
		return( outod );
	}
	rval = epassthru( inod, outod, 0, srcfs );
	xclose( inod );
	xclose( outod );
	if (rval < 0) {	/* error in transfer */
		xoprintf(xstderr, "transfer failed.  File %s deleted in target system.\n", 
			tname);
		eunlink(tname, FILE_NAME, trgfs);
	};
	return( rval );
}
