/*	Copyright (c) 1985,1986,1987  EXCELAN, INC. 	*/
/*	  All Rights Reserved.                         	*/

/*	The copyright notice above does not evidence any 	*/
/*	actual or intended publication. 			*/

/*	THIS IS UNPUBLISHED COMPUTER SOFTWARE CONTAINING TRADE SECRETS 	*/
/*	AND CONFIDENTIAL INFORMATION PROPRIETARY TO EXCELAN, INC. 	*/

/* $Header: xexec.c,v 1.4 87/04/24 16:14:10 davidb Exp $ */
/*
$Header: xexec.c,v 1.4 87/04/24 16:14:10 davidb Exp $
*/

#include <pwd.h>
#include <xstdio.h>
#include <xerrno.h>
#include <errno.h>
#include <ex_errno.h>	/* Contains constants used by XMAPERRNO(). */
#include <UnixXos.h>	/* Contains XMAPERRNO(). dab 861219. */
#include <signal.h>
#include <stdio.h>
#include <sys/soioctl.h>

#ifndef BSD4dot2
#include <fcntl.h>
#define dup2(f,n) { close(n); fcntl(f, F_DUPFD, n); }
#endif

extern struct passwd *getpwuid();
extern int errno;
extern char *xstrrchr();

extern char *xogets();
extern XFILE *xodopen();


xexec( argc, argv, inod, outod, errod )
	int argc;
	char *argv[];
	int inod;
	int outod;
	int errod;
{
	struct passwd *pwd;
	int pid;
	int i;
	char **nargv;
	char *cmdbuf;
	int cmdlen;
	int rval;
	int infd;
	int outfd;
	int errfd;
	char *cp;
	char buf[1024];
	int pv[2];
	int pid2 = 0;
	int cnt;
	int rpipe1;
	int wpipe1;
	int rpipe2;
	int wpipe2;
	int nextfd = 0;
	int oerrno;
	long readmask;
	long mask;
	short on = 1;
	short off = 1;
	short how = 2;
	long ntoread;


	if( !xisatty( inod ) ) {
		/* setup filtering */
		if( pipe(pv) < 0 )
 			return( XMAPERRNO(errno) );
		rpipe1 = pv[0];
		wpipe1 = pv[1];
		if( pipe(pv) < 0 ) {
			close( rpipe1 );
			close( wpipe1 );
 			return( XMAPERRNO(errno) );
		}
		rpipe2 = pv[0];
		wpipe2 = pv[1];
	}
	/*
	get total length of argv's
	*/
	for( i = 0, cmdlen = 0 ; i < argc ; ++i ) {
		cmdlen += xstrlen( argv[i] ) + 1;
	}
	++cmdlen;
	/*
	we have to add some arguments. So, allocate space for
	a new argv.
	*/
	nargv = (char **)xmalloc( (4 * sizeof( char *)) + cmdlen );
	if( nargv == (char **)-1 ) {
		return( XENOMEM );
	}
	cmdbuf = (char *)nargv + (4 * sizeof( char *));
	*cmdbuf = 0;
	cp = cmdbuf;
	for( i = 0 ; i < argc ; ++i ) {
		xstrcat( cp, argv[i] );
		cp += xstrlen( argv[i] );
		*cp++ = ' ';
		*cp = 0;
	}
	if( (pid = fork()) < 0 ) {
		xfree( nargv );
 		return( XMAPERRNO(errno) );
	}
	if( pid ) {
		xfree( nargv );
		if( !xisatty( inod ) ) {
			/*
		 	We make another child to read from the new
		 	process and write to the network
		 	while we do the reverse
			*/
			pid2 = fork();
			if( pid2 < 0 ) {
				kill( 9, pid );
 				return( XMAPERRNO(errno) );
			} else if ( !pid2 ) {
				XFILE *inop;

				inop = xodopen( inod, "r" );
				signal( SIGPIPE, SIG_DFL );
				close( rpipe1 );
				close( rpipe2 );
				close( wpipe2 );
				readmask = 1L << (long)inod;
				readmask |= 1L << (long)errod;
				mask = readmask;
				while ( mask ) {
					rval = xselect(
						_XNFILE,&mask,
						(long *)0, 100000L );
					if( (mask & ( 1L << errod )) &&
						errod != inod ) {
						xioctl(inod,FIONREAD,&ntoread);
						if( ntoread > 0 ) {
							cnt = xread(errod,
								buf, 1);
							if( cnt == 1 ) {
								/*
								Let outputters
								die on a SIGPIPE
								*/
						        	xioctl(outod,
							   	SIOCDONE,
							   	&how);
								break;
							}
						}
					}
					if( mask & ( 1L << inod ) ) {
						cnt = sizeof(buf);
						if( cnt > 0 &&
						    (cnt = xread(inod,buf,cnt))
							> 0
						){
							cnt = write( wpipe1,
								buf, cnt);
							if( cnt < 0 )
								break;
						} else {
							break;
						}
					}
					mask = readmask;
				}
				while( (cnt = 
					xread(inod, buf, sizeof( buf))) >= 0 ){
					if( cnt )
						write( wpipe1, buf, cnt );
				}
				exit( 0 );	/* xexit would be a mistake
						since for some types of
						objects it results in
						connection termination,
						and there's nothing to flush.
						*/
			} else {
				/*
			 	* This is the original process.
			 	* When the program stops, it cleans up and
				* returns to the user.
			 	*/
				close( rpipe1 );
				close( wpipe1 );
				close( wpipe2 );
		 		while((cnt = read(rpipe2,buf,sizeof(buf)-1))>0){
					buf[cnt] = 0;
					cnt = xwrite( outod, buf, cnt );
				}
				close( rpipe2 );
			}
		} /*if !isatty */
		/*
		wait for completion of children
		*/
		do {

			wait( &rval );
			oerrno = errno;
			if ( pid2 )
				kill( pid2, SIGKILL );
		} while( oerrno != ECHILD );
		return( 0 );
	}
	/*
	Ok, we're the child.
	*/
	if( !xisatty( inod ) ) {
		/*
		setup filtering
		*/
		infd = rpipe1;
		outfd = wpipe2;
	} else {
		/*
		take our chances with the native terminal
		handling code
		*/
		infd = getfd( inod );
		if( infd < 0 ) {
			xperror( infd, "infd" );
			exit(1);
		}
		outfd = getfd( outod );
		if( outfd < 0 ) {
			xperror( outfd, "outfd" );
			exit(1);
		}
	}
	errfd = getfd( errod );
	if( errfd < 0 ) {
		xperror( errfd, "infd" );
		exit(1);
	} 
	nextfd = 3;
	if ( errfd < 2 ) {
		/*
		 * get error descriptor out of the way
		 */
		while( nextfd == infd || nextfd == outfd )
			++nextfd;
		dup2( errfd, nextfd);
		errfd = nextfd;
	}
	if( outfd < 1 ) {
		/*
		 * get write descriptor out of the way
		 */
		while( nextfd == infd || nextfd == errfd )
			++nextfd;
		dup2( outfd, nextfd );
		outfd = nextfd;
	}
	if( infd != 0 ) {
		dup2( infd, 0 );
		if( infd != outfd && infd != errfd )
			close( infd );
	}
	if( outfd != 1 ) {
		dup2( outfd, 1 );
		if( outfd != errfd )
			close( outfd );
	}
	if( errfd != 2 ) {
		dup2( errfd, 2 );
		close( errfd );
	}
	/*
	its a problem if outfd or errfd == 0 and if errod == 1
	Let's hope that doesn't happen.
	*/
	for( i = 3; i < 20 ; ++i ) {
		close( i );
	}
	 signal(SIGINT, SIG_DFL);
	 signal(SIGQUIT, SIG_DFL);
	 signal(SIGTERM, SIG_DFL);
	pwd = getpwuid( getuid() );
	if( !pwd ) {
		experror( "getpwuid" );
		exit( 1 );
	}
	if (*pwd->pw_shell == '\0')
		pwd->pw_shell = "/bin/sh";
	cp = xstrrchr(pwd->pw_shell, '/');
	if (cp)
		cp++;
	else
		cp = pwd->pw_shell;
	nargv[0] = cp;
	if( xstrcmp( argv[0], "!" ) ) {
		nargv[1] = "-c";
		nargv[2] = cmdbuf;
		nargv[3] = 0;
	} else {
		nargv[1] = "-i";
		nargv[2] = 0;
	}
	execv(pwd->pw_shell, nargv );
	experror( pwd->pw_shell );
	exit( 1 );
}
