/*	Copyright (c) 1985,1986,1987  EXCELAN, INC. 	*/
/*	  All Rights Reserved.                         	*/

/*	The copyright notice above does not evidence any 	*/
/*	actual or intended publication. 			*/

/*	THIS IS UNPUBLISHED COMPUTER SOFTWARE CONTAINING TRADE SECRETS 	*/
/*	AND CONFIDENTIAL INFORMATION PROPRIETARY TO EXCELAN, INC. 	*/

/* $Header: xftpcmd.c,v 1.4 87/04/24 16:15:00 davidb Exp $ */
/*
$Header: xftpcmd.c,v 1.4 87/04/24 16:15:00 davidb Exp $
$Log:	xftpcmd.c,v $
 * Revision 1.4  87/04/24  16:15:00  davidb
 * Fixing copyright message
 * 
 * Revision 1.3  87/03/26  19:36:22  grant
 * Updating source from Generic trees
 * 
 * Revision 1.5  86/11/08  10:44:58  albert
 * 1. do not need to show the active connection (shown by xfsstatus)
 * 2. clarify unstructured file.
 * 
 * Revision 2.8  86/11/06  15:04:02  albert
 * If transfer structure is FILE, show that it is FILE which also means unstructure.
 * 
 * Revision 2.6  86/11/04  14:24:01  albert
 * Updating source from Generic trees
 * 
 * Revision 1.4  86/11/03  19:55:50  mark
 * added remotestatus command
 * 
 * Revision 1.2  86/10/28  17:44:21  alexl
 * Updating source from Generic trees
 * 
 * Revision 1.3  86/10/15  17:57:32  mark
 * cleaned up some of the status messages
 * 
 * Revision 1.1  86/10/10  12:31:58  mark
 * Updating source from Generic trees
 * 
 * Revision 1.1  86/10/08  10:42:27  mark
 * merging in changes for new ftp
 * 
 * Revision 1.7  86/10/03  17:30:48  mark
 * added defaults command
 * 
 * Revision 1.6  86/09/24  16:56:04  albert
 * make command table alphabetical.
 * 
 * Revision 2.1  86/09/24  16:43:20  albert
 * make the command list in alphabetical order
 * 
 * Revision 1.4  86/09/19  12:53:27  albert
 * Updating source from Generic trees
 * 
 * Revision 1.4  86/09/12  14:10:00  albert
 * use the correct argument table in processing transfer parameter commands.
 * 

$Implementation:

	I modified this module in the following ways:
1. Routines are declared as static as much as possible.
2. A new function, xftpparam, is used to change the transfer parameter.
   It is very similar to the old xftptype.  See implementation note for
   that module.
3. Semantics for the xftpcmdtab is changed:
	a. If the command is a specialized transfer parameter (e.g., record,
	   file, ascii, binary, image), c_conn shows the parameter type and 
	   c_flag2 shows the transfer parameter.  xftpparam handles the 
	   command.
	b. If the command is a generalized transfer parameter command (e.g.,
	   type, form, etc.), c_conn shows what kind of parameter it is 
	   and the corresponding xftpxxx function handles it.
*/

#include "ftplib.h"

extern struct cmd *xgetcmd();
extern char **xmkarglist();
static short toggle();
extern char line[];

#define TYPE_OP 1		/* command related to type */
#define FORM_OP 2		/* command related to format */
#define STRU_OP 3		/* command related to structure */
#define MODE_OP 4		/* command related to mode */

#define LOCALBYTESIZE	8

static char *transcmd[] = {	/* depends on above */
	XNULL,
	"TYPE",
	"FORM",
	"STRU",
	"MODE"};

/* declare handler routines in here */
static int	xftpparam();	/* handle transfer parameters */
static int	xftpmode();	/* handle mode change	*/
static int	xftpstruct();	/* handle stru change	*/
static int	xftpform();	/* handle form change	*/
static int	xftptype();	/* handle type change	*/
static int	xprocparam();	/* process parameters 	*/
static int	xftpdebug();
static int	xftpdflt();	/* restore default flag settings */
static int	xftpexec();
static int	xftphelp();
static int	xftpport();
static int	xftpquote();
static int	xftprmthelp();
static int	xftprstat();
static int	xftpcstatus();
static int	xftptenex();
static int	xftpverbose();
/* static int	xftptranslate();	*/
static int	xftplocal();
/* static int	xftptrace();	*/

/*	help messages	*/

static char	asciihelp[] =	"set ascii transfer type";
static char	binaryhelp[] =	"set binary transfer type";
static char	debughelp[] =	"show what is sent to FTP server";
static	char	dflthelp[] =
	"return debug, verbose, and sendport to default settings";
static char	exechelp[] =	"execute a command on remote";
static char	filehelp[] =	"set transfer structure to FILE";
static char	formhelp[] =	"set FTP file transfer format";
static char	modehelp[] =	"set FTP file transfer mode";
static char	porthelp[] ="toggle use of PORT cmd for each data connection";
static char	quotehelp[] =	"send arbitrary ftp command";
static char	recordhelp[] =	"set transfer structure to RECORD";
static char	remotehelp[] =	"get help from remote FTP server";
static char	remshelp[] =	"get status from remote FTP server";
static char	statushelp[] =	"show current status";
static char	structhelp[] =	"set FTP file transfer structure";
static char	tenexhelp[] =	"set tenex file transfer type";
/* static char	tracehelp[] =	"toggle packet tracing"; */
/*static char	transhelp[] =	"toggle file translation"; */
static char	typehelp[] =	"set FTP file transfer type";
static char	verbosehelp[] =	"show FTP server responses";

static
struct cmd xftpcmdtab[] = {
	{ "ascii", 	asciihelp, TYPE_OP, 	RT_ASCII,	xftpparam },
	{ "binary", 	binaryhelp,TYPE_OP,	RT_IMAGE,	xftpparam },
	{ "debug",	debughelp,	0,	0,	xftpdebug },
	{ "defaults",	dflthelp,	0,	0,	xftpdflt },
	{ "exec",	exechelp,	0,	0,	xftpexec },
	{ "file",	filehelp,  STRU_OP,	IS_FILE,	xftpparam },
	{ "format",	formhelp,  FORM_OP,	0,	xftpform },
	{ "help",	"",		0,	1,	xftphelp },
	{ "mode",	modehelp,  MODE_OP,	0,	xftpmode },
	{ "quote",	quotehelp,	1,	1,	xftpquote },
	{ "record",	recordhelp,STRU_OP,	IS_RECORD,	xftpparam },
	{ "remotehelp",	remotehelp,	0,	1,	xftprmthelp },
	{ "remotestatus",	remshelp,	0,	1,	xftprstat },
	{ "sendport",	porthelp,	0,	0,	xftpport },
	{ "status",	statushelp,	0,	0,	xftpcstatus },
	{ "structure",	structhelp, STRU_OP,	0,	xftpstruct },
	{ "tenex",	tenexhelp,	0,	1,	xftptenex },
/*	{ "trace",	tracehelp,	0,	0,	xftptrace }, */
/*	{ "translate",  transhelp, 	1, 	0, 	xftptranslate }, */
	{ "type",	typehelp,   TYPE_OP,	0,	xftptype },
	{ "verbose",	verbosehelp,	0,	0,	xftpverbose },
	{ 0, "", 0, 0, 0 }
};
static
struct cmd typetab[] = {
	/* table for known keywords in transfer commands 
	   c_conn:	parameter type
	   c_flag2:	parameter value
	   c_handler:	routine that writes it out 
	*/

	/*
	Supported types
	*/
	{ "ascii",	0,	TYPE_OP,	RT_ASCII,	xftpparam },
	{ "binary", 	0, 	TYPE_OP, 	RT_IMAGE,	xftpparam },
	{ "image", 	0, 	TYPE_OP, 	RT_IMAGE,	xftpparam },
	{ "localbyte",  0, 	TYPE_OP, 	RT_LOCALBYTE,	xftplocal },
	/*
	Unsupported types
	*/
	{ "ebcdic", 	0, 	TYPE_OP, 	RT_EBCDIC,	0 },
	{ 0,		0,	0,		0, 		0 }
	};

struct cmd formtab[] = {
	/*
	Supported Formats
	*/
	{ "nonprint",	0, 	FORM_OP, 	TF_NONPRINT,	xftpparam },
	/*
	Unsupported Formats
	*/
	{ "telnet", 	0,	FORM_OP,	TF_TELNET, 	0 },
	{ "fortran", 	0, 	FORM_OP,	TF_FORTRAN, 	0 },
	{ 0,		0,	0,		0, 		0 }
	};

struct cmd strutab[] = {
	/*
	Supported Structures
	*/
	{ "file", 	0,	STRU_OP,	IS_FILE, 	xftpparam },
	{ "record", 	0, 	STRU_OP, 	IS_RECORD,	xftpparam },
	/*
	Unsupported Structures
	*/
	{ "page", 	0,	STRU_OP,	IS_PAGE, 	0 },
	{ 0,		0,	0,		0, 		0 }
	};

struct cmd modetab[] = {
	/*
	Supported Modes
	*/
	{ "stream", 	0, 	MODE_OP, 	TM_STREAM,	xftpparam },
	/*
	Unsupported Modes
	*/
	{ "block", 	0, 	MODE_OP, 	TM_BLOCK,	0 },
	{ "compressed", 0, 	MODE_OP, 	TM_COMPRESSED,	0 },
	{ 0, 		0, 0, 0, 0 }
};

/*
	start of code
*/

/* $Function: get the command parameter for a transfer type $*/
static char *getparam(type, value)
int	type;		/* class of parameters */
int	value;		/* value of the parameter */
{
	switch (type) {
		case MODE_OP:
			switch (value) {
				case TM_STREAM:	return ("S");
				case TM_COMPRESSED: return ("C");
				case TM_BLOCK: return ("B");
				default:
					break;
				};
			break;

		case TYPE_OP:
			switch (value) {
				case RT_IMAGE: return ("I");
				case RT_ASCII: return ("A");
				case RT_LOCALBYTE: return ("L");
				case RT_EBCDIC: return ("E");
				default:
					break;
				};
			break;
		
		case STRU_OP:
			switch (value) {
				case IS_FILE: return ("F");
				case IS_RECORD: return ("R");
				case IS_PAGE: return ("P");
				default:
					break;
				};
			break;
		
		case FORM_OP:
			switch (value) {
				case TF_NONPRINT: return ("N");
				case TF_FORTRAN: return ("C");
				case TF_TELNET: return ("T");
				default:
					break;
				};
			break;
		default:
			break;
		};
	return ("");
}

/* $Function: xftpparam - set a transfer parameter $*/

static int xftpparam(argc, argv, table, context)
int	argc;		/* argument count	*/
char	*argv[];	/* argument list, used to get transfer parameter */
struct cmd *table;	/* command table */
struct filesystem *context;	/* current context */
{
struct cmd *cmd_pt;	
struct ftp_attr *attribute;
int	*curvalue;	/* current value of parameter */
int	rval;

	cmd_pt = xgetcmd(argv[0], table);	/* find the command */
	attribute = &((struct ftp_conn_state *) context->conn_state)->ftp_type;
	switch (cmd_pt->c_conn) {	/* get the current parameter */
		case MODE_OP:
			curvalue =  &attribute->trans_mode;
			break;
		case STRU_OP:
			curvalue = &attribute->structure;
			break;
		case FORM_OP:
			curvalue = &attribute->format;
			break;
		case TYPE_OP:
			curvalue = &attribute->rep_type;
			break;
		default:
			return (XEINVAL);
	};
	if (*curvalue != cmd_pt->c_flag2) {	/* change state */
		rval = _ftpcmd( (struct ftp_conn_state *)context->conn_state,
			"%s %s", transcmd[cmd_pt->c_conn], 
			getparam(cmd_pt->c_conn, cmd_pt->c_flag2));
		if (rval == COMPLETE)
			*curvalue = cmd_pt->c_flag2;
		else
			rval = 0;	/* it's good anyway as the reply 
					   processing displays the error */
	};
	return (rval);
}	/* xftpparam */

static	
ex_read( pid, rod, wod )
	int pid;
	int rod;
	int wod;
{
	char buf[XBUFSIZ];
	int rval;
	int cnt;

	cnt = xread( rod, buf, sizeof( buf ) );
	if( cnt <= 0 ) {
		if( cnt != XEINTR && cnt != XEWOULDBLOCK ) {
			xkill( pid );
			if( cnt == XEOF ) {
				return( 0 );
			}
			return( cnt );
		}
		return( cnt );
	}
	while ( cnt > 0 ) {
		rval = xwrite( wod, buf, cnt );
		if( rval < 0 ) {
			if( rval != XEINTR && rval != XEWOULDBLOCK ) {
				xkill( pid );
				return( rval );
			}
			rval = 0;
		}
		cnt -= rval;
	}
	return( rval );
}


static int xftpexec( argc, argv, table, context )
	int argc;
	char *argv[];
	struct cmd *table;
	struct filesystem *context;
{
	int rval = XEINVAL;
	int madeargs = 0;
	int rcode;
	struct ftp_conn_state *ftp_pt;
	struct ftp_ofile *file_pt;

	ftp_pt = (struct ftp_conn_state *)context->conn_state;
	file_pt = ftp_pt->file_state;
	if (argc < 2) {
		xstrcat(line, " ");
		xoprintf(xstdout,"(command line to send) ");
		xfflush( xstdout );
		xgets(&line[xstrlen(line)]);
		argv = xmkarglist( line, &argc );
		madeargs = 1;
	}
	if (argc != 2) {
		xoprintf(xstdout,"usage: %s \"<command> <arguments>\"\n",
			argv[0]);
		goto endexec;
	}
	/*
	Should probably put the connection in ascii mode.
	*/
	if( initconn( ftp_pt ) ) {
		xclose( file_pt->od );
		file_pt->od = -1;
		return( XEIO );
	}
	rcode = _ftpcmd( ftp_pt, "XEXC %s", argv[1] );
	if( rcode != PRELIM ) {
		return( XEIO );
	}
	rval = dataconn( ftp_pt, _XIORW, XFREAD | XFWRITE );
	xmux_io( "ftp exec", ex_read, rval, 1, ex_read, 0, rval );
	xclose( rval );
	file_pt->od = -1;
endexec:
	if( madeargs )
		xdealglob( argv );
	return( rval );
}

static int xftphelp( argc, argv, table, context )
	int argc;
	char *argv[];
	struct cmd *table;
	struct filesystem *context;
{
	argv[0] = (char *)table;
	return( 0 );
}

static int xftpform( argc, argv, table, context )
	int argc;
	char *argv[];
	struct cmd *table;
	struct filesystem *context;
{
/*
$Function: change the transfer format$

$Description:
	argv[0]: the command "format"
	argv[1]: parameter to be changed.
		If argv[1] does not exist, display current transfer format.
$

*/	
	struct ftp_conn_state *ftp_pt;
	int rval = 0;

	ftp_pt = (struct ftp_conn_state *)context->conn_state;
	if (argc == 1) {	/* display current transfer type */
		xoprintf(xstdout, "Current transfer format is ");
		switch (ftp_pt->ftp_type.format) {
			case TF_NONPRINT: 
				xoprintf( xstdout, "nonprint.\n");
				break;
			case TF_TELNET:
				xoprintf( xstdout, "telnet print control.\n");
				break;
			case TF_FORTRAN:
				xoprintf( xstdout, 
					"fortran style print control.\n");
				break;
			default:
				xoprintf( xstdout, "unknown.\n");
				break;
			};
		return (0);
	};
	return(xprocparam(argc, argv, table, context, formtab));
}

/*
$Function: determine how to change the transfer parameters $

$Description:
	argv[0]: the command 
	argv[1]: parameters to be changed. 

$

*/	
static int xprocparam(argc, argv, table, context, argutab)
int argc;
char *argv[];
struct cmd *table;
struct filesystem *context;
struct cmd *argutab;		/* argument table	*/
{
struct	cmd 	*cur_cmd;
struct	cmd	*cmd_pt;
int		rval;

	rval  = 0;
	cur_cmd = xgetcmd (argv[0], table);
	cmd_pt = xgetcmd (argv[1], argutab);
	if (cmd_pt == (struct cmd *) -1) {
		xoprintf(xstdout, "?Ambiguous argument: %s\n", argv[1]);
		return (rval);
	};
	if ( (cmd_pt != (struct cmd *) XNULL) && 
	     (cur_cmd->c_conn == cmd_pt->c_conn)) {
		if (cmd_pt->c_handler) {
			rval = (*cmd_pt->c_handler) (argc-1, &argv[1], argutab,
							context);
		} else {
			xoprintf(xstdout, "%s %s not supported.\n",
				cur_cmd->c_name, cmd_pt->c_name);
		}
	} else {
		xoprintf(xstdout, "unknown %s: %s\n", cur_cmd->c_name, argv[1]);
	};
	return (rval);
}	/* xprocparam	*/

static int xftpstruct( argc, argv, table, context )
	int argc;
	char *argv[];
	struct cmd *table;
	struct filesystem *context;
{
/*
$Function: change the transfer structure $

$Description:
	argv[0]: the command "struct"
	argv[1]: parameter to be changed.
		If argv[1] does not exist, display current transfer struct.
$

*/	
	struct ftp_conn_state *ftp_pt;
	int rval = 0;

	ftp_pt = (struct ftp_conn_state *)context->conn_state;
	if (argc == 1) {	/* display current transfer struct */
		xoprintf(xstdout, "Current file structure is ");
		switch (ftp_pt->ftp_type.structure) {
			case IS_RECORD:
				xoprintf( xstdout, "record.\n");
				break;
			case IS_FILE:
				xoprintf( xstdout, "unstructured (file).\n");
				break;
			case IS_PAGE:
				xoprintf( xstdout, "page.\n");
				break;
			default:
				xoprintf( xstdout, "unknown.\n");
				break;
			};
		return (0);
	};
	return(xprocparam(argc, argv, table, context, strutab));
}

static int xftpmode( argc, argv, table, context )
	int argc;
	char *argv[];
	struct cmd *table;
	struct filesystem *context;
{
/*
$Function: change the transfer mode $

$Description:
	argv[0]: the command "mode"
	argv[1]: parameter to be changed.
		If argv[1] does not exist, display current transfer mode.
$

*/	
	struct ftp_conn_state *ftp_pt;
	int rval = 0;

	ftp_pt = (struct ftp_conn_state *)context->conn_state;
	if (argc == 1) {	/* display current transfer mode */
		xoprintf(xstdout, "Current transfer mode is ");
		switch (ftp_pt->ftp_type.trans_mode) {
			case TM_STREAM:
				xoprintf( xstdout, "stream.\n");
				break;
			case TM_BLOCK:
				xoprintf( xstdout, "block.\n");
				break;
			case TM_COMPRESSED:
				xoprintf( xstdout, "compressed.\n");
				break;
			default:
				xoprintf( xstdout, "unknown.\n");
				break;
			};
		return (0);
	};
	return(xprocparam(argc, argv, table, context, modetab));
}

static int xftptype( argc, argv, table, context )
	int argc;
	char *argv[];
	struct cmd *table;
	struct filesystem *context;
{
/*
$Function: change the transfer type $

$Description:
	argv[0]: the command type
	argv[1]: parameter to be changed.
		If argv[1] does not exist, display current transfer type.
$

*/	
	struct ftp_conn_state *ftp_pt;
	int rval = 0;

	ftp_pt = (struct ftp_conn_state *)context->conn_state;
	if (argc == 1) {	/* display current transfer type */
		xoprintf(xstdout, "Current transfer type is ");
		switch (ftp_pt->ftp_type.rep_type) {
			case RT_ASCII: 
				xoprintf( xstdout, "ascii.\n");
				break;
			case RT_IMAGE:
				xoprintf( xstdout, "image (binary).\n");
				break;
			case RT_LOCALBYTE:
				xoprintf( xstdout, "local, byte size: %d.\n",
					ftp_pt->ftp_type.byte_sz);
				break;
			default:
				xoprintf( xstdout, "unknown.\n");
				break;
			};
		return (0);
	};
	return(xprocparam(argc, argv, table, context, typetab));
}

static int xftplocal( argc, argv, table, context )
	int argc;
	char *argv[];
	struct cmd *table;
	struct filesystem *context;
{
	struct ftp_conn_state *ftp_pt;
	int rval = 0;
	int bsize;

	if (argc < 2) {
		xoprintf(xstdout, "Need to specify local byte size\n");
		return (0);	/* since error message is displayed */
	};
	bsize = xatoi(argv[1]);
	if (bsize != LOCALBYTESIZE) {
		xoprintf(xstdout, "Byte size %d not supported.\n", bsize);
		return (0);	/* since error message is displayed */
	};
	
	ftp_pt = (struct ftp_conn_state *)context->conn_state;
	if( ftp_pt->ftp_type.rep_type != RT_LOCALBYTE) {
		rval = _ftpcmd( ftp_pt, "TYPE %s %d", 
				getparam(TYPE_OP, RT_LOCALBYTE), LOCALBYTESIZE);
		if( rval != COMPLETE ) {
			rval = XEIO;
		} else {
			ftp_pt->ftp_type.rep_type = RT_LOCALBYTE;
			ftp_pt->ftp_type.byte_sz = bsize;
		}
	}
	return( rval );
}

/*
static int xftptranslate( argc, argv, table, context )
	int argc;
	char *argv[];
	struct cmd *table;
	struct filesystem *context;
{
	struct ftp_conn_state *ftp_pt;
	int rval = 0;

	ftp_pt = (struct ftp_conn_state *)context->conn_state;
	ftp_pt->flags1 = toggle( ftp_pt->flags1, F_TRANSLATE );
	return( rval );
}
*/

static int xftpverbose( argc, argv, table, context )
	int argc;
	char *argv[];
	struct cmd *table;
	struct filesystem *context;
{
	struct ftp_conn_state *ftp_pt;
	int rval = 0;

	ftp_pt = (struct ftp_conn_state *)context->conn_state;
	ftp_pt->flags1 = toggle( ftp_pt->flags1, F_VERBOSE );
	return( rval );
}

static int xftpdebug( argc, argv, table, context )
	int argc;
	char *argv[];
	struct cmd *table;
	struct filesystem *context;
{
	struct ftp_conn_state *ftp_pt;
	int rval = 0;

	ftp_pt = (struct ftp_conn_state *)context->conn_state;
	ftp_pt->flags1 = toggle( ftp_pt->flags1, F_DEBUG );
	return( rval );
}

static int xftpdflt( argc, argv, table, context )
	int argc;
	char *argv[];
	struct cmd *table;
	struct filesystem *context;
{
	struct ftp_conn_state *ftp_pt;
	int rval = 0;

	ftp_pt = (struct ftp_conn_state *)context->conn_state;
	ftp_pt->flags1 &= ~(F_DEBUG|F_VERBOSE);
	ftp_pt->flags1 |= F_SENDPORT;
	return( rval );
}

static int xftpport( argc, argv, table, context )
	int argc;
	char *argv[];
	struct cmd *table;
	struct filesystem *context;
{
	struct ftp_conn_state *ftp_pt;
	int rval = 0;

	ftp_pt = (struct ftp_conn_state *)context->conn_state;
	ftp_pt->flags1 = toggle( ftp_pt->flags1, F_SENDPORT );
	return( rval );
}

/*
static int xftptrace( argc, argv, table, context )
	int argc;
	char *argv[];
	struct cmd *table;
	struct filesystem *context;
{
	struct ftp_conn_state *ftp_pt;
	int rval = 0;

	ftp_pt = (struct ftp_conn_state *)context->conn_state;
	ftp_pt->flags1 = toggle( ftp_pt->flags1, F_TRACE );
	return( rval );
}
*/

static int xftptenex( argc, argv, table, context )
	int argc;
	char *argv[];
	struct cmd *table;
	struct filesystem *context;
{
	return (XEOPNOTSUPP);			
}

static int xftpquote( argc, argv, table, context )
	int argc;
	char *argv[];
	struct cmd *table;
	struct filesystem *context;
{
	struct ftp_conn_state *ftp_pt;
	int i;
	char buf[XBUFSIZ];
	int madeargs = 0;
	int rval = XEINVAL;
	short oldflag;

	ftp_pt = (struct ftp_conn_state *)context->conn_state;
	if (argc < 2) {
		xstrcat(line, " ");
		xoprintf(xstdout,"(command line to send) ");
		xfflush( xstdout );
		xgets(&line[xstrlen(line)]);
		argv = xmkarglist( line, &argc );
		madeargs = 1;
	}
	if (argc < 2) {
		xoprintf(xstdout,"usage: %s line-to-send\n", argv[0]);
		goto endquote;
	}
	xstrcpy(buf, argv[1]);
	for (i = 2; i < argc; i++) {
		xstrcat(buf, " ");
		xstrcat(buf, argv[i]);
	}
	oldflag = ftp_pt->flags1;
	ftp_pt->flags1 |= F_VERBOSE;
	rval = _ftpcmd(ftp_pt,buf);
	ftp_pt->flags1 = oldflag;
endquote:
	if( madeargs )
		xdealglob( argv );
	return( rval );
}


static int xftpcstatus( argc, argv, table, context )
	int argc;
	char *argv[];
	struct cmd *table;
	struct filesystem *context;
{
/* $Implementation:
	For simplicity, we just emulate the commands type, mode, stru and
	format to get the current connection status.  This can be done by
	forming fake command line and call the appropriate routines.
$
*/

	struct ftp_conn_state *ftp_pt;
	int rval = 0;
	char *stargv[2];	/* used in getting the current status */

	ftp_pt = (struct ftp_conn_state *)context->conn_state;
	xoprintf( xstdout, "Flags:\n\t" );
	if( P_VERBOSE( ftp_pt ) )
		xoprintf( xstdout, "verbose\t" );
	if( P_DEBUG( ftp_pt ) )
		xoprintf( xstdout, "debug\t" );
	if( P_SENDPORT( ftp_pt ) )
		xoprintf( xstdout, "sendport\t" );
	xoprintf( xstdout, "\n\n");
	stargv[0] = (char **) XNULL;
	stargv[1] = (char **) XNULL;

	/* call routines to get current transfer parameters */
	
	xftptype(1, stargv, table, context);
	xftpform(1, stargv, table, context);
	xftpstruct(1, stargv, table, context);
	xftpmode(1, stargv, table, context);
	return( rval );
}

static int xftprmthelp( argc, argv, table, context )
	int argc;
	char *argv[];
	struct cmd *table;
	struct filesystem *context;
{
	struct ftp_conn_state *ftp_pt;
	int rval = 0;
	int rcode;
	short oldflag;

	ftp_pt = (struct ftp_conn_state *)context->conn_state;
	oldflag = ftp_pt->flags1;
	ftp_pt->flags1 |= F_VERBOSE;
	rcode = _ftpcmd( ftp_pt, (argc == 1)? "HELP" : "HELP %s", argv[1] );
	ftp_pt->flags1 = oldflag;
	return( rval );
}

static int xftprstat( argc, argv, table, context )
	int argc;
	char *argv[];
	struct cmd *table;
	struct filesystem *context;
{
	struct ftp_conn_state *ftp_pt;
	int rval = 0;
	int rcode;
	short oldflag;

	ftp_pt = (struct ftp_conn_state *)context->conn_state;
	oldflag = ftp_pt->flags1;
	ftp_pt->flags1 |= F_VERBOSE;
	rcode = _ftpcmd( ftp_pt, (argc == 1)? "STAT" : "STAT %s", argv[1] );
	ftp_pt->flags1 = oldflag;
	return( rval );
}

static short
toggle( flagset, flag )
	short flagset;
	int flag;
{
	if( flagset & flag ) {
		flagset &= ~flag;
	} else {
		flagset |= flag;
	}
	return( flagset );
}



xftpcmd( argc, argv, context )
	int argc;
	char *argv[];
	struct filesystem *context;
{
	struct cmd *cmd_pt;
	int rval = XEOPNOTSUPP;

	cmd_pt = xgetcmd( argv[0], xftpcmdtab );
	if (cmd_pt == (struct cmd *) -1) {
		xoprintf(xstdout, "?Ambiguous command\n");
		rval = 0;
	} else if( cmd_pt != XNULL ) {
		rval = (*cmd_pt->c_handler)( argc, argv, xftpcmdtab, context );
	}
	return( rval );
}
