/*	Copyright (c) 1985,1986,1987  EXCELAN, INC. 	*/
/*	  All Rights Reserved.                         	*/

/*	The copyright notice above does not evidence any 	*/
/*	actual or intended publication. 			*/

/*	THIS IS UNPUBLISHED COMPUTER SOFTWARE CONTAINING TRADE SECRETS 	*/
/*	AND CONFIDENTIAL INFORMATION PROPRIETARY TO EXCELAN, INC. 	*/

/* $Header: xftpfsopen.c,v 1.4 87/04/24 16:15:37 davidb Exp $ */
/*
$Header: xftpfsopen.c,v 1.4 87/04/24 16:15:37 davidb Exp $
$Log:	xftpfsopen.c,v $
 * Revision 1.4  87/04/24  16:15:37  davidb
 * Fixing copyright message
 * 
 * Revision 1.3  87/03/26  19:36:33  grant
 * Updating source from Generic trees
 * 
 * Revision 1.4  86/10/23  14:45:18  mark
 * xftpstat returns name of file, stripped of directory component
 * 
 * Revision 1.3  86/10/15  18:32:17  mark
 * return better error codes/messages
 * 
 * Revision 1.2  86/10/15  15:53:50  albert
 * 1. ABOR command is sent only when transfer in progress.
 * 2. abort shutdowns both read/write directions.
 * 3. change semantics of xftpls
 * 4. send RNTO even if RNFR fails
 * 5. xftpdopen change dir to directory before it performs xftpls.
 * 
 * Revision 2.7  86/10/14  11:05:23  albert
 * For abort transfer, must shutdown both read and write.
 * 
 * Revision 2.4  86/10/09  16:24:49  albert
 * 1. semantics of xftpls is changed to add a new argument that shows if
 *    directory file should be treated as a file.
 * 2. For xftpdopen, it saves the current directory, chdir to the desired
 *    directory and then call xftpgopen to the new directory to get all
 *    file specifications.  This way only the file name (not the full path)
 *    is returned in xftpdread.
 * 3. For xftpgopen, if the name parameter is NULL, do a ls on the current
 *    directory.
 * 
 * Revision 2.2  86/10/08  22:00:45  albert
 * 1. semantics of xftpls is changed to add a new argument that shows if the
 *   directory file should be treated as a file.
 * 2. For xftpdopen, it saves the current directory, chdir to the desired
 *    directory and then call xftpgopen to the new directory to get all
 *    file specification.  This way only the file name (not the full path)
 *    is returned in xftpdread.
 * 3. For xftpgopen, if the name parameter is NULL, do a ls on the current
 *    directory.
 * 
 * Revision 2.1  86/09/30  16:31:31  albert
 * update from generic software.
 * 
 * Revision 1.10  86/10/03  17:33:33  mark
 * 1) print server greating
 * 2) drain data connection for error case
 *
 * Revision 1.9  86/09/29  16:22:09  mark
 * moved xftpclose into this file due to reference to getreply
 * 
 * Revision 1.8  86/09/19  09:49:27  albert
 * 1. if sendport is off, data connection should use the same port number as
 *    the control connection.
 * 2. Should consider the case that reply to PWD has no double quote
 * 3. Should call xpassthru with 4 arguments (instead of 3).
 * 4. Use a symbolic name FTP_OBJECT to denote FTP object (instead of a 
 *    hardcoded number).
 * 
 * Revision 1.7  86/09/18  17:09:27  mark
 * no longer closes standard in when an attempt is made to open
 * a connection to an unknown host.
 * 
 * Revision 1.6  86/09/18  14:51:40  albert
 * 1. If sendport is off, use the same port number for both control and data
 *    connections.
 * 2. Use a symbol (rather than a hard-coded number) to represent FTP object.
 * 
 * Revision 1.5  86/09/12  14:10:49  albert
 * change the way that transfer parameters are saved and restored in a 
 * ls operation.
 * 
*/

#include "ftplib.h"

static char repsave[80] = { 0 };/* for storing text of server response */
static char temp[16] = { 0 };
/*
 * data structures to support rfc 959 directory commands or 4.2 BSD ones
 */
#define CDUPI	0	/* index for CDUP command */
#define MKDI	1	/* index for MKD command */
#define PWDI	2	/* index for PWC command */
#define RMDI	3	/* index for RMD command */
static char *newcmds[] = {
	"CDUP",
	"MKD",
	"PWD",
	"RMD",
};
static char *oldcmds[] = {
	"XCUP",
	"XMKD",
	"XPWD",
	"XRMD",
};
static char **cmdstrs = &newcmds[0];
extern char *xstrchr();
extern char *xstrrchr();
extern char *xrerror();

static
poption( state, command, option )
	struct tel_state *state;
	int command;
	int option;
{
	/*
	For now, do nothing.
	*/
}

static
pescape( state )
	struct tel_state *state;
{
	/*
	No escape processing
	*/
}

xftpfsopen( protocol, system, user, password, account, context )
	int protocol;
	char *system;
	char *user;
	char *password;
	char *account;
	struct filesystem *context;
{
	struct ftp_conn_state *ftp_pt;
	struct ftp_ofile *file_pt;
	struct ftp_attr *attr_pt;
	int rval;
	int s;
	int rcode;
	struct sockaddr hisctladdr;
	char *cp;
	char *cp2;

	/*
	allocate space for saving this ftp connection's state
	*/
	ftp_pt =(struct ftp_conn_state *)
	    xmalloc(sizeof(struct ftp_conn_state) + sizeof(struct ftp_ofile));
	if( ftp_pt == (struct ftp_conn_state *) XNULL ) {
		return( XENOMEM );
	}
	context->conn_state = (char *)ftp_pt;
	xbzero( context->conn_state,
		sizeof(struct ftp_conn_state) + sizeof(struct ftp_ofile) );
	ftp_pt->ftp_fs = context;
	file_pt = ftp_pt->file_state = (struct ftp_ofile *)
		(context->conn_state + sizeof(struct ftp_conn_state));
	file_pt->od = -1;
	file_pt->server_info = ftp_pt;
	ftp_pt->flags1 |= F_SENDPORT;
	/*
	check if "system" is the local system
	*/
	if( 0 ) {
		/*
		for now its not
		*/
	} else {
		/*
		open connection to server and
		fill in the state information
		*/
		rval = xgetaddr( XFILE_SERVICE, FTP, &system, &hisctladdr );
		if( rval < 0 ) {
			xoprintf( xstderr, "%s:%s\n", system, xrerror(rval) );
			goto bad2;
		}
		xstrcpy(ftp_pt->hostname, system);
		ftp_pt->od = rval = xsocket(SOCK_STREAM, (struct sockproto *)0,
			(struct sockaddr *)0, SO_KEEPALIVE);
		if (rval < 0) {
			xperror(rval,"xftpfsopen(socket)");
			goto bad;
		}
		if (( rval = xconnect(ftp_pt->od,(char *)&hisctladdr)) < 0){
			xperror(rval, "xftpfsopen(connect)");
			goto bad;
		}
		/*
		insert telnet processing filter
		*/
		s = xtelopen( ftp_pt->od, poption, pescape );
		xdup2( s, ( rval = xnewod() ) );
		ftp_pt->cin = xodopen(s, "r");
		ftp_pt->cout = xodopen(rval, "w");
		ftp_pt->flags1 |= F_CONNECTED;
		if (ftp_pt->cin == XNULL || ftp_pt->cout == XNULL) {
			xoprintf(xstderr, "ftp: fdopen failed.\n");
			if( s >= 0 )
				xclose( s );
			if (ftp_pt->cin)
				xclose(xfileno(ftp_pt->cin));
			if (ftp_pt->cout)
				xclose(xfileno(ftp_pt->cout));
			goto bad;
		}
		if (P_VERBOSE(ftp_pt))
			xoprintf(xstdout,"Connected to %s.\n", system );
		/*
		read startup message from server.
		this is our opertunity to identify whether the server
		is one of ours or not.
		*/
		ftp_pt->flags1 |= F_VERBOSE;
		rcode = getreply(0,ftp_pt);
		if( rcode != COMPLETE ) {
			xftpfsclose( context );
			return( XEIO );
		}
		ftp_pt->flags1 &= ~F_VERBOSE;
		cp = xstrchr( repsave, '(' );
		if( cp != XNULL ) {
			++cp;
			cp2 = xstrchr( cp, ' ' );
			if( cp2 != XNULL ) {
				*cp2 = 0;
				if( !xstrcmp( cp, "EXOS" ) ) {
					/*
					its one of ours
					*/
					ftp_pt->flags1 |= F_EXOSFTP;
				}
			}
		}
		/*
		check for interactive use
		*/
		if( xisatty( xfileno(xstdin) ) ) {
			ftp_pt->flags1 |= F_FROMATTY;
		}
		/*
		Now, login.
		Esendident is used so that alternate authentication schemes
		may be used.
		*/
		rval = esendident( user, password, account, context );
		if( rval <= 0 ) {
			/*
			Authenication has failed, but we'll let the
			server refuse subsequent requests, or the user
			to re-try.
			*/
		}
		/*
		fill in default file attributes
		*/
		attr_pt = &ftp_pt->ftp_type;
		attr_pt->rep_type = RT_ASCII;
		attr_pt->format = TF_NONPRINT;
		attr_pt->structure = IS_FILE;
		attr_pt->trans_mode = TM_STREAM;
		attr_pt->byte_sz = 8;
		return( 0 );
bad:
		if( ftp_pt->od >= 0 )
			xclose(ftp_pt->od);
bad2:
		xfree( ftp_pt );
	}
	return( rval );
}

xftpfsclose( context )
	struct filesystem *context;
{
	register struct ftp_conn_state *ftp_pt;
	int rcode;

	ftp_pt = (struct ftp_conn_state *)context->conn_state;
	/*
	say goodbye to server
	*/
	rcode = _ftpcmd(ftp_pt, "QUIT");
	/*
	dealocate things
	*/
	if( ftp_pt->cin )
		xclose( xfileno( ftp_pt->cin ) );
	if( ftp_pt->cout )
		xclose( xfileno( ftp_pt->cout ) );
	if( ftp_pt->od )
		xclose( ftp_pt->od );
	xfree( ftp_pt );
	return( 0 );
}



xftpabort( context )
	struct filesystem *context;
{
	int how = 0;
	int rval;
	struct ftp_conn_state *ftp_pt;
	struct ftp_ofile *file_pt;

	ftp_pt = (struct ftp_conn_state *)context->conn_state;
	file_pt = ftp_pt->file_state;
	if (file_pt->od == -1)
		return (0);	/* no data transfer in progress */
	rval = xioctl( xfileno( ftp_pt->cout ), IP, &how );
	if( rval < 0 ) {
		return( rval );
	}
	if (P_DEBUG(ftp_pt)) {
		xoprintf(xstdout, "---> ABOR\n");
		xfflush(xstdout);
	};

	xoprintf( ftp_pt->cout, "ABOR\n" );
	xfflush( ftp_pt->cout );
	/*
	now close down the data connection for read/writing, in case the other
	side is waiting for us to send something.
	*/
	how = 2;		/* for read and write */
	xioctl( file_pt->od, SIOCDONE, &how );
	getreply( 0, ftp_pt );
	/*
	close data connection, if any
	*/
	if( ftp_pt->file_state->od != -1 ) {
		xclose( ftp_pt->file_state->od );
	}
	return( 0 );
}

xftpopen( name, mode, special, statb, context )
	char *name;
	int mode;
	int special;
	struct xstatbuf *statb;
	struct filesystem *context;
{
	int rval;
	struct ftp_conn_state *ftp_pt;
	struct ftp_ofile *file_pt;
	int flagbits;
	char *cmd;
	int rcode;

	rval = 0;
	ftp_pt = (struct ftp_conn_state *)context->conn_state;
	file_pt = ftp_pt->file_state;
	if( mode & (XFCREAT | XFFORCE)) {
		/*
		check for file types that cann't be supported.
		*/
	}
	if( P_LOCAL( ftp_pt ) ) {
		/*
		Special handling for local files
		*/
	} else {
		if( (mode & XFREAD) && (mode & XFWRITE) ) {
			return( XEINVAL );
		} else if( mode & XFREAD ) {
			cmd = "RETR";
			flagbits = _XIOREAD;
		} else if( (mode & XFWRITE) && (mode & XFCREAT)) {
			cmd = "STOR";
			flagbits = _XIOWRT;
		} else if( (mode & XFWRITE) && (mode & XFAPPEND)) {
			cmd = "APPE";
			flagbits = _XIOWRT;
		} else {
			return( XEINVAL );
		}
		if( !(mode & (XFCREAT | XFFORCE)) ) {
			xftpstat( name, special, statb, context );
		}
		xftpchattr( name, SERVICE_PARA, statb, context );
		if( initconn( ftp_pt ) ) {
			xclose( file_pt->od );
			file_pt->od = -1;
			return( XEIO );
		}
		rcode = _ftpcmd( ftp_pt, "%s %s", cmd, name );
		if( rcode != PRELIM ) {
			xclose( file_pt->od );
			file_pt->od = -1;
			return( XEIO );
		}
		rval = dataconn( ftp_pt, flagbits, mode );
		if( rval < 0 ) {
			xperror( rval, "xftpopen(dataconn)" );
			xclose( file_pt->od );
			file_pt->od = -1;
		} else {
			/*
			Ok, data connection is established.
			Fill in data on file.
			*/
		}
	}
	return( rval );
}

struct xftpgstr {
	int od;		/* file containing list of names */
	XFILE *ftemp;
};


xftpdread( dirpt, buf, len )
struct xftpgstr *dirpt;
struct xdirect *buf;
int len;
{
	register struct xdirect *buf_dp = (struct xdirect *)buf;
	int rval;

	if( len < sizeof( struct xdirect ) ) {
		xperror( XEGRANULARITY, "xdirread(gran)" );
		return( XEGRANULARITY );
	}
	rval = xftpgread( dirpt, &buf_dp->d_name[0], sizeof(buf_dp->d_name) );
	if( rval <= 0 ) {
		return( rval );
	}
	/*
	fill in information on file
	*/
	buf_dp->d_namelen = xstrlen( &buf_dp->d_name[0] );
	buf_dp->d_reclen = ( (int)(&buf_dp->d_name[0]) - (int)buf_dp) + 
		buf_dp->d_namelen;
	return( buf_dp->d_reclen );
}

xftpdiropen( name, special, context )
	char *name;
	int special;
	struct filesystem *context;
{
/* 
$Implementation:
	For a true directory open, we first confirm that the name specified
is a directory.  If it is, we save the current directory,  change the default
directory to the specified one, use xftpgopen to get the data. Then restore
the current default directory.
$
*/
	int rval;
	struct xstatbuf info;
	char curdir[PWDLEN];	/* current directory information */
	XFILE *file;

	rval = xftpstat( name, FILE_NAME, &info, context );
	if( rval >= 0 && (info.x_mode & X_IFDIR) ) {
		rval = xftppwd(curdir, sizeof curdir, FILE_NAME, context);
		if (rval < 0) 
			return rval;
		rval = xftpchdir(name, special, context);
		if (rval < 0)
			return rval;
		rval = xftpgopen( 0, FILE_NAME, context );
		xftpchdir(curdir, FILE_NAME, context);	/* restore directory */
		file = &_xiob[rval];
		file->_read = xftpdread;	/* to twiddle parameters */
	} else if ( rval >= 0 ) {
		rval = XENOTDIR;
	}
	return( rval );
}


xftpgread( sys_id, buf, len )
	struct xftpgstr *sys_id;
	char *buf;
	int len;
{
	char *cp;

	if (xogets(buf, len, sys_id->ftemp) == XNULL) {
		return ( 0 );
	}
	if ((cp = xstrchr(buf, '\n')) != XNULL) {
		*cp = '\0';
	} else {
		/*
		We should try to rewind the file back to the
		start of the line.
		but, for now...
		*/
		return( XEGRANULARITY );
	}
	return( xstrlen( buf ) );
}

xftpgclose( sys_id )
	struct xftpgstr *sys_id;
{
	xclose( sys_id->od );
	xfree( sys_id );
	return( 0 );
}

xftpgopen( name, special, context )
	char *name;
	int special;
	struct filesystem *context;
{
	/* Note:
		Since this module calls xftpls to get the list of files
	anyway.  It assumes that xftpls will save the current transfer
	parameters, sets them to ASCII and byte stream, get the list and
	then restore the transfer parameters.  So nothing is done in here.

	If name is NULL, get all the files in current directory.
	*/

	int rval;
	struct ftp_conn_state *ftp_pt;
	register struct _xiobuf *file;
	struct xftpgstr *sys_id;

	ftp_pt = (struct ftp_conn_state *)context->conn_state;
	sys_id = (struct xftpgstr *)xmalloc( sizeof( struct xftpgstr ) );
	if( sys_id == (struct xftpgstr *) XNULL ) {
		return( XENOMEM );
	}
	xstrcpy(temp, SCRATCHFILE );
	xmktemp(temp);
	rval = xdopen( temp, XFWRITE | XFCREAT | XFASCII, FILE_NAME );
	if( rval < 0 ) {
		xfree( sys_id );
		return( rval );
	}
	if (name) {
		xftpls( rval, name, LS_ARG, 0, context );
	} else
		xftpls( rval, 0, LS, 0, context);

	xclose( rval );
	sys_id->od = xdopen(temp, XFREAD | XFASCII, FILE_NAME );
	xunlink(temp, FILE_NAME );
	sys_id->ftemp = xodopen( sys_id->od, "r" );
	if (sys_id->ftemp == XNULL) {
		xoprintf(xstdout,
			"can't find list of remote files, oops\n");
		xfree( sys_id );
		return (XNULL);
	}
	rval = xnewod();
	if( rval < 0 ) {
		xclose( sys_id->od );
		xfree( sys_id );
		return( rval );
	}
	file = &_xiob[ rval ];
	file->_sys_id = (char *)sys_id;
	file->_flag |= _XIOREAD | _XIOSTR;
	file->_read = xftpgread;
	file->_close = xftpgclose;
	return( rval );
}

static char ncompo[ PWDLEN + 1];

xftpstat( name, special, info, context )
	char *name;
	int special;
	struct xstatbuf *info;
	struct filesystem *context;
{
	int rval;
	struct ftp_conn_state *ftp_pt;
	char pwdsave[ PWDLEN ];
	char *c_pt;
	char *c_pt2;
	char ch;

	rval = 0;
	ftp_pt = (struct ftp_conn_state *)context->conn_state;
	xbzero( info, sizeof(struct xstatbuf) );
	info->x_ptype = FTP;
	if( P_EXOSFTP( ftp_pt ) && special != SERVICE_PARA ) {
		info->x_mode = X_PREAD | X_PWRITE | X_IREAD | X_IWRITE |
			X_GREAD | X_OREAD;
		/*
		send an EXOS STAT command.
		*/
		rval = _ftpcmd( ftp_pt, "STAT %s", name );
		if( rval == COMPLETE ) {
			c_pt = repsave;
			switch( *c_pt ) {
				case 'a':
				case 'A':
					info->x_mode |= X_IFTEXT;
					info->p_data.ftp.rep_type = RT_ASCII;
					++c_pt;
					break;
				case 'i':
				case 'I':
					info->x_mode |= X_IFBIN;
					info->p_data.ftp.rep_type = RT_IMAGE;
					++c_pt;
					break;
				case 'l':
				case 'L':
					info->p_data.ftp.rep_type =RT_LOCALBYTE;
					++c_pt;
					info->p_data.ftp.byte_sz = xatoi(c_pt);
					while( isdigit( *c_pt ) )
						++c_pt;
					break;
				case 'd':
				case 'D':
					info->x_mode |= X_IFDIR;
					++c_pt;
					break;
				case 'e':
				case 'E':
					info->p_data.ftp.rep_type = RT_EBCDIC;
					++c_pt;
					break;
				default:
					break;
			}
			switch( *c_pt ) {
				case 'n':
				case 'N':
					info->p_data.ftp.format = TF_NONPRINT;
					++c_pt;
					break;
				case 't':
				case 'T':
					info->p_data.ftp.format = TF_TELNET;
					++c_pt;
					break;
				case 'c':
				case 'C':
					info->p_data.ftp.format = TF_FORTRAN;
					++c_pt;
					break;
				default:
					break;
			}
			switch( *c_pt ) {
				case 'f':
				case 'F':
					info->p_data.ftp.structure = IS_FILE;
					++c_pt;
					break;
				case 'r':
				case 'R':
					info->p_data.ftp.structure = IS_RECORD;
					info->x_mode |= X_IFRECORD;
					++c_pt;
					break;
				case 'p':
				case 'P':
					info->p_data.ftp.structure = IS_PAGE;
					++c_pt;
					break;
				default:
					break;
			}
			switch( *c_pt ) {
				case 's':
				case 'S':
					info->p_data.ftp.trans_mode =TM_STREAM;
					++c_pt;
					break;
				case 'b':
				case 'B':
					info->p_data.ftp.trans_mode =TM_BLOCK;
					++c_pt;
					break;
				case 'c':
				case 'C':
					info->p_data.ftp.trans_mode =
						TM_COMPRESSED;
					++c_pt;
					break;
				default:
					break;
			}
			/*
			 * Return name of file stripped of its directory
			 * component.
			 * We cann't assume that the name returned is the tail
			 * of the name passed, because expansion may have
			 * occured.
			 */
			++c_pt;
			c_pt2 = xstrchr( c_pt, '\n' );
			if( c_pt2 )
				*c_pt2 = 0;
			xstrncpy( ncompo, c_pt, PWDLEN );
			info->x_ncompo = &ncompo[0];
		}
	} else {
		/*
		make a best guess about mode flags
		*/
		xbcopy(&ftp_pt->ftp_type, &info->p_data.ftp, 
			sizeof (struct ftp_attr));
		info->x_mode = X_PREAD | X_PWRITE | X_IREAD | X_IWRITE |
			X_GREAD | X_OREAD;
		if( ftp_pt->ftp_type.rep_type == RT_ASCII ) {
			info->x_mode |= X_IFTEXT;
		}
		if( ftp_pt->ftp_type.rep_type == RT_IMAGE ) {
			info->x_mode |= X_IFBIN;
		}
		if (ftp_pt->ftp_type.structure == IS_RECORD) {
			info->x_mode |= X_IFRECORD;
		};	
		if( special != SERVICE_PARA ) {
			/*
			just check if its a directory by trying to cd to it
			also see if we can find a directory component.
			*/
			rval = xftppwd(pwdsave, sizeof(pwdsave), PWD, context );
			if( rval >= 0 ) {
				rval = xftpchdir( name, special, context );
				if( rval >= 0 ) {
					info->x_mode |= X_IFDIR;
					info->x_ncompo = name;
					rval = xftpchdir(
						pwdsave, FILE_NAME, context );
				} else {
					/*
					See if there is a directory
					component to the name.
					*/
					if( c_pt2 = xstrrchr( name, '/')) {
					/*
					Assume Unix file specifier.
					*/
						*c_pt2 = 0;
						rval = xftpchdir( 
							name, FILE_NAME,
							context );
						*c_pt2 = '/';
						if( rval >= 0 ) {
							c_pt = c_pt2 + 1;
							goto ncfound;
						}
					}
					if( c_pt2 = xstrrchr( name, '\\')) {
					/*
					Assume DOS file specifier.
					*/
						*c_pt2 = 0;
						rval = xftpchdir( 
							name, FILE_NAME,
							context );
						*c_pt2 = '\\';
						if( rval >= 0 ) {
							c_pt = c_pt2 + 1;
							goto ncfound;
						}
					}
					if( c_pt2 = xstrrchr( name, ']')) {
					/*
					Assume VMS file specifier.
					*/
						++c_pt2;
						ch = *c_pt2;
						*c_pt2 = 0;
						rval = xftpchdir( 
							name, FILE_NAME,
							context );
						*c_pt2 = ch;
						if( rval >= 0 ) {
							c_pt = c_pt2;
							goto ncfound;
						}
					}
					if( c_pt2 = xstrrchr( name, '>')) {
					/*
					Assume VMS file specifier.
					*/
						++c_pt2;
						ch = *c_pt2;
						*c_pt2 = 0;
						rval = xftpchdir( 
							name, FILE_NAME,
							context );
						*c_pt2 = ch;
						if( rval >= 0 ) {
							c_pt = c_pt2;
							goto ncfound;
						}
					}
					if( c_pt2 = xstrrchr( name, ':')) {
					/*
					Assume VMS file specifier.
					*/
						++c_pt2;
						ch = *c_pt2;
						*c_pt2 = 0;
						rval = xftpchdir( 
							name, FILE_NAME,
							context );
						*c_pt2 = ch;
						if( rval >= 0 ) {
							c_pt = c_pt2;
							goto ncfound;
						}
					}
					info->x_ncompo = name;
					return( 0 );
				ncfound:
					xstrncpy( ncompo, c_pt, PWDLEN );
					info->x_ncompo = &ncompo[0];
					rval = xftpchdir(
						pwdsave, FILE_NAME, context );
				}
			}
		}
	}
	return( rval );
}

xftpchdir( name, special, context )
	char *name;
	int special;
	struct filesystem *context;
{
	int rval;
	struct ftp_conn_state *ftp_pt;

	rval = 0;
	ftp_pt = (struct ftp_conn_state *)context->conn_state;
	rval = _ftpcmd( ftp_pt, "CWD %s", name );
	if( rval != COMPLETE )
		return( XENOTDIR );
	return( 0 );
}

xftpchattr( name, special, statb, context )
	char *name;
	int special;
	struct filesystem *context;
	struct xstatbuf *statb;
{
	int rval;
	struct ftp_conn_state *ftp_pt;
	char *argu;
	int rcode;

	rval = 0;
	ftp_pt = (struct ftp_conn_state *)context->conn_state;
	if( special == SERVICE_PARA ) {
		/*
		Unless user has specified not to,
		set the ftp file attributes according to "statb"
		*/
		if( !P_TRANSLATE(ftp_pt) ) {
			if( statb->x_mode & X_IFBIN ) {
				statb->p_data.ftp.rep_type = RT_IMAGE;
			} else if ( statb->x_mode & X_IFTEXT ) {
				statb->p_data.ftp.rep_type = RT_ASCII;
			} else if (statb->x_ptype != FTP) {
				statb->p_data.ftp.rep_type = 
					ftp_pt->ftp_type.rep_type;
				statb->p_data.ftp.byte_sz =
					ftp_pt->ftp_type.byte_sz;
			}
			statb->x_ptype = FTP;
			if( statb->p_data.ftp.rep_type !=
				ftp_pt->ftp_type.rep_type ){
				switch (statb->p_data.ftp.rep_type) {
					case RT_IMAGE:
						argu = "I";
						break;
					case RT_ASCII:
						argu = "A";
						break;
					case RT_LOCALBYTE:
						break;
					default:
						return (XEINVAL);
					};
				if (statb->p_data.ftp.rep_type == RT_LOCALBYTE)
					rcode = _ftpcmd( ftp_pt, "TYPE L %d",
						statb->p_data.ftp.byte_sz);
				else
					rcode = _ftpcmd( ftp_pt, "TYPE %s",
						argu);
				if( rcode == COMPLETE ) {
					ftp_pt->ftp_type.rep_type =
						statb->p_data.ftp.rep_type;
				} else
					return (XEINVAL);
			};
			statb->p_data.ftp.structure = 
				(statb->x_mode & X_IFRECORD) ? IS_RECORD :
							       IS_FILE;
			if( statb->p_data.ftp.structure !=
				ftp_pt->ftp_type.structure ){
				rcode = _ftpcmd( ftp_pt,
			    		"STRU %s",
					(statb->x_mode & X_IFRECORD ? 
						"R" : "F"));
				if( rcode == COMPLETE ) {
					ftp_pt->ftp_type.structure =
						statb->p_data.ftp.structure;
				} else
					return (XEINVAL);
			}
		}
	} else {
		rval = XEINVAL;
	}
	return( rval );
}

xftpmkdir( name, special, context )
	char *name;
	int special;
	struct filesystem *context;
{
	int rval;
	struct ftp_conn_state *ftp_pt;

	rval = 0;
	ftp_pt = (struct ftp_conn_state *)context->conn_state;
	rval = _ftpcmd( ftp_pt, "%s %s", cmdstrs[MKDI], name );
	if( rval == ERROR ) {
		/*
		 * Well, maybe it understands the other style of command
		 */
		cmdstrs = (cmdstrs == &newcmds[0])? &oldcmds[0] : &newcmds[0];
		xprintf( "Retrying...\n" );
		rval = _ftpcmd( ftp_pt, "%s %s", cmdstrs[MKDI], name );
	}
	if( rval != COMPLETE ) {
		rval = XEMKDIR;
	}
	return( rval );
}

xftprmdir( name, special, context )
	char *name;
	int special;
	struct filesystem *context;
{
	int rval;
	struct ftp_conn_state *ftp_pt;

	rval = 0;
	ftp_pt = (struct ftp_conn_state *)context->conn_state;
	rval = _ftpcmd( ftp_pt, "%s %s", cmdstrs[RMDI], name );
	if( rval == ERROR ) {
		/*
		 * Well, maybe it understands the other style of command
		 */
		cmdstrs = (cmdstrs == &newcmds[0])? &oldcmds[0] : &newcmds[0];
		xprintf( "Retrying...\n" );
		rval = _ftpcmd( ftp_pt, "%s %s", cmdstrs[RMDI], name );
	}
	if( rval != COMPLETE ) {
		rval = XERMDIR;
	}
	return( rval );
}

xftprename( from, fspecial, to, tspecial, context )
	char *from;
	int fspecial;
	char *to;
	int tspecial;
	struct filesystem *context;
{
	int rval;
	struct ftp_conn_state *ftp_pt;

	rval = 0;
	ftp_pt = (struct ftp_conn_state *)context->conn_state;
	if( _ftpcmd( ftp_pt, "RNFR %s", from ) == CONTINUE ) {
		rval = _ftpcmd( ftp_pt, "RNTO %s", to );
		if( rval != COMPLETE )
			rval = XEIO;
	} else {
		VOID _ftpcmd( ftp_pt, "RNTO  " );  /* keep server happy */
		rval = XEINVAL;
	}
	return( rval );
}

xftpls( od, name, code, dircheck, context )
	int od;
	char *name;
	int code;
	int dircheck;	/* flag to show if we should treat a directory as 
			   a file.  If 1 - treat directory as a file */
	struct filesystem *context;
{
	/* Note:
		This module should save the current transfer parameters,
	set it to ASCII and byte stream before the transfer.  Finally, it
	should restore them.
	*/

	int rval;
	struct ftp_conn_state *ftp_pt;
	struct ftp_ofile *file_pt;
	struct xstatbuf statb;	/* current status	*/
	struct xstatbuf newstatb;	/* new status 	*/
	int rcode;
	char *cmd;
	int noarg = 0;

	rval = 0;
	switch( code ) {
		case LS:
			noarg++;
			cmd = "NLST";
			break;
		case LS_ARG:
			cmd = "NLST";
			break;
		case LSLONG:
			noarg++;
			cmd = "LIST";
			break;
		case LSLONG_ARG:
			cmd = "LIST";
			break;
		default:
			return( XEINVAL );
	}
	ftp_pt = (struct ftp_conn_state *)context->conn_state;
	file_pt = ftp_pt->file_state;

	/* get current transfer parameter */
	xftpstat("", SERVICE_PARA, &statb, context);
	xbcopy(&statb, &newstatb, sizeof statb);
	newstatb.x_mode &= ~(X_IFBIN | X_IFRECORD); /* turn off binary,record*/
	newstatb.x_mode |= X_IFTEXT;	/* set to ASCII mode */
	/* set transfer parameter */
	rval = xftpchattr("", SERVICE_PARA, &newstatb, context); 
	if (rval < 0) 
		return (rval);

	if( initconn( ftp_pt ) ) {
		xclose( file_pt->od );
		file_pt->od = -1;
		/* restore context */
		xftpchattr("", SERVICE_PARA, &statb, context);	
		return( XEIO );
	}
	if( noarg ) {
		rcode = _ftpcmd( ftp_pt, "%s", cmd );
	} else {
		rcode = _ftpcmd( ftp_pt, "%s %s", cmd, name );
	}
	if( rcode != PRELIM ) {
		/* restore context */
		xftpchattr("", SERVICE_PARA, &statb, context);	
		xclose( file_pt->od );
		file_pt->od = -1;
		return( XEIO );
	}
	rval = dataconn( ftp_pt, _XIOREAD, XFREAD );
	if( rval < 0 ) {
		xperror( rval, "xftpls(dataconn)" );
		xclose( file_pt->od );
		file_pt->od = -1;
	} else {
		xpassthru( rval, od, 0, context);
		xclose( rval );
		file_pt->od = -1;
	}
	/* restore context */
	xftpchattr("", SERVICE_PARA, &statb, context);	
	return( rval );
}

xftppwd( buf, len, code, context )
	char *buf;
	int len;
	int code;
	struct filesystem *context;
{
	int rval;
	struct ftp_conn_state *ftp_pt;
	char *pwdstart;
	char *pwdend;

	ftp_pt = (struct ftp_conn_state *)context->conn_state;
	rval = _ftpcmd( ftp_pt, "%s", cmdstrs[PWDI] );
	if( rval == ERROR ) {
		/*
		 * Well, maybe it understands the other style of command
		 */
		cmdstrs = (cmdstrs == &newcmds[0])? &oldcmds[0] : &newcmds[0];
		xprintf( "Retrying...\n" );
		rval = _ftpcmd( ftp_pt, "%s", cmdstrs[PWDI] );
	}
	if( rval == COMPLETE ) {
		pwdstart = xstrchr( repsave, '"' );
		if( !pwdstart ) {
			return( XEOPNOTSUPP );
		}
		pwdstart++;
		pwdend = xstrchr( pwdstart, '"' );
		if( !pwdend ) {
			return( XEOPNOTSUPP );
		}
		*pwdend = 0;
		if( len < ((int)pwdend - (int)pwdstart) ) {
			return( XEGRANULARITY );
		}
		xstrcpy( buf, pwdstart );
		rval = 0;
	} else {
		return( XEPWD );
	}
	return( rval );
}

xftpunlink( name, special, context )
	char *name;
	int special;
	struct filesystem *context;
{
	int rval;
	struct ftp_conn_state *ftp_pt;

	rval = 0;
	ftp_pt = (struct ftp_conn_state *)context->conn_state;
	rval = _ftpcmd( ftp_pt, "DELE %s", name );
	if( rval != COMPLETE ) {
		rval = XEIO;
	}
	return( rval );
}


/*VARARGS 1*/
#ifdef zilog
/*
 * Pick parameters from registers, and put them in an honest-looking
 * stack frame.
 */
_ftpcmd( context, fmt, a1, a2, a3, a4, a5, a6)
	struct ftp_conn_state *context;
	char *fmt;
	int a1, a2, a3, a4, a5, a6;
{
	int args=a1, aa2=a2, aa3=a3, aa4=a4, aa5=a5, aa6=a6;
#else
_ftpcmd( context, fmt, args)
	struct ftp_conn_state *context;
	char *fmt;
{
#endif
	int how;		/* something for xioctl args to point to */
	XFILE *cin = context->cin;
	XFILE *cout = context->cout;

	if ( P_DEBUG(context) ) {
		xoprintf(xstdout,"---> ");
		_mydoprnt(fmt, &args, xstdout);
		xoprintf(xstdout,"\n");
		VOID xfflush(xstdout);
	}
	if (cout == XNULL || !P_CONNECTED( context )) {
		if( P_DEBUG( context ) )
			xperror (0, "No control connection for command");
		return ( ERROR );
	}
	if( !empty( cin ) ) {
		/*
		 * Since we are sending a new command,  it is expected
		 * that all replies to previous commands have been
		 * processed.  Thus, if there is any data in the command
		 * stream, we are out of sync with the server, and
		 * the data that is now present should be flushed.
		 */
		 how = 1;
		 xioctl( xfileno( cout ), FIONBIO, &how );
		 if( P_VERBOSE(context) )
		 	xoprintf( xstderr, "Old reply in command stream:\n" );
		 VOID getreply( 0, context );
		 how = 0;
		 xioctl( xfileno( cout ), FIONBIO, &how );
	}
	_mydoprnt(fmt, &args, cout);
	xoprintf(cout, "\n");
	VOID xfflush(cout);
	return (getreply(!xstrcmp(fmt, "QUIT"), context));
}

empty(f)
	XFILE *f;
{
	long mask;
	int rval;
	int od;

	if( f->_cnt > 0 )
		return( 0 );
#ifndef NOSELECT
	xioctl( xfileno( f ), XREAL_OD, &od );
	mask = ( 1 << od );
	rval = xselect( 20, &mask, (long *)0, 0L );
	return ( mask == 0 );
#else
	return( 1 );
#endif	/* NOSELECT */
}




getreply(expecteof, context)
	int expecteof;
	struct ftp_conn_state *context;
{
	XFILE *cin = context->cin;
	register int c, n;
	register int code, dig;
	int originalcode = 0, continuation = 0;
	int savecnt = 0;
	char *savept = repsave;

	for (;;) {
		dig = n = code = 0;
		while ((c = xgetc(cin)) != '\n') {
			dig++;
			if (c == XEOF) {
				if( xfeof(cin) ) {
					if (expecteof)
						return (0);
					xoprintf(xstdout,"lost connection.\n");
					xlostfs( context->ftp_fs );
					context->flags1 &= ~F_CONNECTED;
					*savept = 0;
					return( 5 );
				} else {
					xoprintf(xstdout, "error on read.\n" );
					*savept = 0;
					return( n - '0' );
				}
			}
			if (P_VERBOSE(context) && c != '\r' ||
			    (n == '5' && dig > 4))
				xputchar(c);
			if (dig < 4 && isdigit(c))
				code = code * 10 + (c - '0');
			if ((dig == 4)  && (code != 0))
				continuation = (c == '-');
			if (n == 0)
				n = c;
			/*
			save the text of the response
			*/
			if( (dig > 4) && (savecnt < (sizeof( repsave ) - 1))) {
				*savept++ = c;
				++savecnt;
			}
		}
		if (P_VERBOSE(context) || n == '5') {
			xputchar(c);
			VOID xfflush (xstdout);
		}
		if (continuation && code != originalcode) {
			if (originalcode == 0)
				originalcode = code;
			continue;
		}
		if ( !continuation ) {
			*savept = 0;
			return (n - '0');
		}
	}
}


_mydoprnt(format, argp, FILEp)
char *format;
int *argp;
XFILE *FILEp;
{
	xoprintf(FILEp, format, *argp, *(argp+1), *(argp+2), *(argp+3),
		*(argp+4), *(argp+5));
}


initconn( ftp_pt )
	struct ftp_conn_state *ftp_pt;
{
	register char *p, *a;
	int result, len;
	int options = SO_KEEPALIVE | SO_ACCEPTCONN;
	int retry;
	int rval;
	struct sockaddr_in data_addr;
	struct ftp_ofile *file_pt = ftp_pt->file_state;
	static int swaitmax = SWAITMAX;
	static int swaitint = SWAITINT;

	if ((rval = xsktaddr( ftp_pt->od, (char *)&data_addr)) < 0) {
		xperror(rval, "initconn(xsktaddr)");
		goto bad;
	}
noport:
	if (P_SENDPORT(ftp_pt))
		data_addr.sin_port = 0;	/* let system pick one */ 
/*	else
		data_addr.sin_port = xhtons( 20 );
*/
	if (file_pt->od != -1)
		VOID xclose (file_pt->od);
	for (retry = 0; retry < swaitmax; xsleep (swaitint), retry += swaitint)
		{
		file_pt->od = xsocket(SOCK_STREAM, (struct sockproto *)0,
			&data_addr, options);
		if (file_pt->od >= 0 ||
			(file_pt->od != XEADDRINUSE && file_pt->od != XENOBUFS))
			break;
		}
	if (file_pt->od < 0) {
		xperror(file_pt->od, "initconn(socket)");
		return (1);
	}
	len = sizeof (data_addr);
	if ((rval = xsktaddr(file_pt->od, (char *)&data_addr)) < 0) {
		xperror(rval, "initconn(xsktaddr)");
		goto bad;
	}
	if (P_SENDPORT(ftp_pt)) {
		a = (char *)&data_addr.sin_addr;
		p = (char *)&data_addr.sin_port;
#define	UC(b)	(((int)b)&0xff)
		result =
		    _ftpcmd(ftp_pt,"PORT %d,%d,%d,%d,%d,%d",
		      UC(a[0]), UC(a[1]), UC(a[2]), UC(a[3]),
		      UC(p[0]), UC(p[1]));
		if (result == ERROR && P_SENDPORT(ftp_pt)) {
			ftp_pt->flags1 &= ~F_SENDPORT;
			goto noport;
		}
		return (result != COMPLETE);
	}
	return (0);
bad:
	if( file_pt->od >= 0 ) {
		VOID xclose(file_pt->od);
		file_pt->od = -1;
	}
	return (1);
}


dataconn(ftp_pt, flagbits, mode)
	struct ftp_conn_state *ftp_pt;
	int flagbits;
	int mode;
{
	struct sockaddr_in from;
	int s, fromlen = sizeof (from);
	struct ftp_ofile *file_pt = ftp_pt->file_state;
	int rval;
	register struct _xiobuf *file;

	s = xaccept(file_pt->od, &from);
	if (s < 0) {
		xperror(s, "dataconn(xaccept)");
		VOID xclose(file_pt->od), file_pt->od = -1;
		return ( s );
	}
	file_pt->flag2 |= F_ACCEPTED;
	/*
	makeup a file descriptor to return to the user
	*/
	rval = xnewod();
	if( rval < 0 ) {
		return( rval );
	}
	file = &_xiob[rval];
	file->_flag |= flagbits;
	file->_sys_id = (char *)file_pt;
	file->_read = xftpread;
	file->_write = xftpwrite;
	file->_ioctl = xftpioctl;
	file->_lseek = xftplseek;
	file->_close = xftpclose;
	file->_odtype = FTP_OBJECT;
	/*
	copy ftp typing information from connection data to
	data on file
	*/
	file_pt->flag1 = ftp_pt->flags1;
	file_pt->flag2 = ftp_pt->flags2;
	file_pt->open_mode = mode;
	file_pt->flag2 |= F_ACCEPTED;	/* since we just clobbered it */
	xbcopy( &ftp_pt->ftp_type,
		&file_pt->below_type, sizeof(struct ftp_attr) );
	xbcopy( &ftp_pt->ftp_type,
		&file_pt->above_type, sizeof(struct ftp_attr) );
	return (rval);
}


xftpclose( sys_id )
	struct ftp_ofile *sys_id;
{
	int rval;
static char eof_sequence[] = {RECORD_ESCAPE, END_OF_FILE};

	if (sys_id->open_mode & (XFCREAT | XFAPPEND | XFWRITE)) {
		/* open for write, check if it is in record mode */
		if (sys_id->below_type.structure == IS_RECORD) {
			/* write out end-of-file sequence */
			xwrite(sys_id->od, eof_sequence, sizeof eof_sequence);
		};
	};
	if( sys_id->r_state.buf ) {
		xfree( sys_id->r_state.buf );
		sys_id->r_state.state_v = 0;
		sys_id->r_state.count = 0;
		sys_id->r_state.buf = (char *)0;
		sys_id->r_state.size = 0;
	}
			
	if( sys_id->open_mode & XFREAD ) {
		char buf[XBUFSIZ];
		/*
		drain the pipe
		*/
		while ( xread( sys_id->od, buf, sizeof( buf )) >= 0 )
			;
	}
	xclose( sys_id->od );
	rval = 0;
	if( O_ACCEPTED( sys_id ) ) {
		rval = getreply( 0, sys_id->server_info );
		if( rval != COMPLETE ) {
			rval = XEIO;
		}
	}
	sys_id->od = -1;
	sys_id->r_state.state_v = 0;
	sys_id->w_state.prev_return = 0;
	return( rval );
}
