/*	Copyright (c) 1985,1986,1987  EXCELAN, INC. 	*/
/*	  All Rights Reserved.                         	*/

/*	The copyright notice above does not evidence any 	*/
/*	actual or intended publication. 			*/

/*	THIS IS UNPUBLISHED COMPUTER SOFTWARE CONTAINING TRADE SECRETS 	*/
/*	AND CONFIDENTIAL INFORMATION PROPRIETARY TO EXCELAN, INC. 	*/

/* $Header: xgetfs.c,v 1.4 87/04/24 16:17:18 davidb Exp $ */
/*
$Header: xgetfs.c,v 1.4 87/04/24 16:17:18 davidb Exp $
$Log:	xgetfs.c,v $
 * Revision 1.4  87/04/24  16:17:18  davidb
 * Fixing copyright message
 * 
 * Revision 1.3  87/03/26  19:37:26  grant
 * Updating source from Generic trees
 * 
 * Revision 1.2  86/11/08  10:45:52  albert
 * add in xfsstatus() to show all active and inactive connections.
 * 
 * Revision 2.5  86/11/06  10:44:53  albert
 * add in xfsstatus() to show status of all file systems opened with a 
 * certain protocol.
 * 
 * Revision 2.4  86/11/04  14:28:45  albert
 * Updating source from Generic trees
 * 
 * Revision 1.1  86/10/08  10:46:05  mark
 * merging in changes for new ftp
 * 
 * Revision 1.3  86/09/18  13:54:14  mark
 * added function xlostfs() to mark connections as no longer valid
 * This is necessary as it is not a good idea to clean up a connection
 * state block except from the highest level routine which is using it.
 * 
 * Revision 1.2  86/09/04  20:40:55  mark
 * Updating source from Generic trees
 * 
 * Revision 1.2  86/08/25  17:33:39  mark
 * syncing revision level
 * 
 * Revision 1.1  86/04/18  19:10:36  mark
 * Initial revision
 * 
*/

#include "elib.h"

#define FS_VALID 1	/* structure contains valid information */
#define FS_RELEASED  2	/* caller has released file system (no active
			   file transfer) */
#define	FS_LOSTCONN  4	   /* session seems to have vanished mysteriously */
#define MAXFS 10	/* maximum number of active filesystems */

struct fs {
	char host[36];
	struct filesystem *context;
	long flags;
};

static struct fs fstab[ MAXFS ] = { 0 };
static struct fs *end_fstab = &fstab[ MAXFS ];


extern struct filesystem *efsopen();

struct filesystem *
xgetfs( system, user, pass, account, cacheonly )
	/*
	This has the potential of being a very sophisticated
	routine.  Its purpose is to find a connection to the filesystem
	of "system".  It may use a previously opened connection,
	or may determine which protocol to use and open a new
	connection.  It may also make policy discisions about closing
	unused connections.
	For now, it simply calls efsopen for the local filesystem.
	*/
	char *system;
	char *user;
	char *pass;
	char *account;
	int cacheonly;		/* don't make any new connections */
{
	struct filesystem *rfs;
	struct fs *fs_pt;
	int proto;
	int found;

	/*
	See if we've cached an idle connection
	*/
	for( fs_pt = fstab ; fs_pt < end_fstab ; ++fs_pt ) {
		if((fs_pt->flags & FS_VALID ) && (fs_pt->flags & FS_RELEASED)) {
			if( !xstrcmp( system, fs_pt->host) ) {
				/*
				We've found it.
				*/
				if( fs_pt->flags & FS_LOSTCONN ) {
					/*
					Connection was lost, clean up.
					*/
					fs_pt->flags = 0;
					efsclose( fs_pt->context );
					continue;
				}
				fs_pt->flags &= ~FS_RELEASED;
				return( fs_pt->context );
			}
		}
	}
	if( cacheonly ) {
		return( (struct filesystem *)XNULL );
	}
	/*
	We need to open a new connection.  So, find a free structure.
	*/
	for( fs_pt = fstab, found = 0 ; fs_pt < end_fstab ; ++fs_pt ) {
		if( !(fs_pt->flags & FS_VALID) ) {
			found = 1;
			break;
		}
	}
	if( !found ) {
		return( (struct filesystem *)XNULL );
	}
	proto = xgetfsid( system );
	if( proto < 0 ) {
		return( (struct filesystem *)XNULL );
	}
	rfs = efsopen( proto, system, user, pass, account );
	if( rfs != (struct filesystem *)XNULL ) {
		fs_pt->flags = FS_VALID;
		fs_pt->context = rfs;
		xstrncpy( fs_pt->host, system, sizeof(fs_pt->host) - 1);
	}
	return( rfs );
}

struct filesystem *
xgetfsp( context )
/*
given a context pointer, return the cached entry
*/
	struct filesystem *context;
{
	struct fs *fs_pt;
	char null = 0;
	char *null_pt = &null;

	for( fs_pt = fstab ; fs_pt < end_fstab ; ++fs_pt ) {
		if( (fs_pt->flags & FS_VALID) && (fs_pt->context == context) ) {
			return( xgetfs( fs_pt->host,
				null_pt, null_pt, null_pt, 1 ));
		}
	}
	return( 0 );
}

xrelsfs( context, andclose )
/*
release file system
*/
	int andclose;
	struct filesystem *context;
{
	struct fs *fs_pt;

	for( fs_pt = fstab ; fs_pt < end_fstab ; ++fs_pt ) {
		if( fs_pt->context == context ) {
			if( andclose ) {
				fs_pt->flags = 0;
				efsclose( context );
			} else {
				fs_pt->flags |= FS_RELEASED;
			}
		return( 0 );
		}
	}
	return( XENODEV );
}



xlostfs( context )
/*
mark file system as lost
*/
	struct filesystem *context;
{
	struct fs *fs_pt;

	for( fs_pt = fstab ; fs_pt < end_fstab ; ++fs_pt ) {
		if( fs_pt->context == context ) {
			fs_pt->flags |= FS_LOSTCONN;
			return( 0 );
		}
	}
	return( XENODEV );
}

xfsexit()
/*
Close down all file systems.
*/
{
	struct fs *fs_pt;

	for( fs_pt = fstab ; fs_pt < end_fstab ; ++ fs_pt ) {
		if( fs_pt->flags & FS_VALID ) {
			efsclose( fs_pt->context );
		}
	}
}

xfsstatus(protocol, outod)
int	protocol;		/* protocol to match	*/
XFILE	*outod;			/* XLIB I/O object for printing out status*/
/*
   List all connections that matches the protocol.  This is done by two loops:
the first loop search for the active connection which has FS_VALID set but
FS_RELEASED and FS_LOSTCONN clear.  The second loop search for the inactive
connections which has FS_VALID set but FS_RELEASED set.  If FS_LOSTCONN
is set, we need to mark it as connection lost
*/
{
struct	fs	*fs_pt;
int	found;

	found = 0;

	/* first loop for the active connection	*/

	for (fs_pt = fstab; fs_pt < end_fstab; ++fs_pt) {
		/* search each one */
		if (fs_pt->flags & FS_VALID) {
			if (fs_pt->context->type != protocol)
				continue;
			if (!(fs_pt->flags & (FS_LOSTCONN | FS_RELEASED))) {
				/* must be active connection */
				xoprintf(outod, "Connected to %s\n", 
					fs_pt->host);
				found = 1;
				break;
			};
		};
	};

	if (!found) 
		xoprintf(outod, "No active connection.\n");
				

	/* Now search for the inactive connections */
	found = 0;

	for (fs_pt = fstab; fs_pt < end_fstab; ++fs_pt) {
		/* search each one */
		if (fs_pt->flags & FS_VALID) {
			if (fs_pt->context->type != protocol)
				continue;
			if (fs_pt->flags & (FS_LOSTCONN | FS_RELEASED)) {
				if (!found) {
					xoprintf(outod, 
						"Inactive connections to:\n");
				};
				xoprintf(outod,"      %s", fs_pt->host);
				if (fs_pt->flags & FS_LOSTCONN)
					xoprintf(outod,
						" (connection lost)\n");
				else
					xoprintf(outod, "\n");
				found = 1;
			};
		};
	};
}
