/*	Copyright (c) 1985,1986,1987  EXCELAN, INC. 	*/
/*	  All Rights Reserved.                         	*/

/*	The copyright notice above does not evidence any 	*/
/*	actual or intended publication. 			*/

/*	THIS IS UNPUBLISHED COMPUTER SOFTWARE CONTAINING TRADE SECRETS 	*/
/*	AND CONFIDENTIAL INFORMATION PROPRIETARY TO EXCELAN, INC. 	*/

/* $Header: xmkarglist.c,v 1.2 87/04/24 16:18:24 davidb Exp $ */
/*
@(#)xmkarglist.c	1.3 3/29/85

Xmkarglist from xglob(3X) for Unix.
This file belongs in Xoslib, but is here to keep the linker happy.
*/
#define ARGPOINTERSP	200	/* bytes for storing argument pointers */
#define ARGSPACE	400	/* bytes for storing arguments */

static char *argbase;
static char *stringbase;

extern char *xmalloc();

char **
xmkarglist( line, count )

char *line;		/* IN */
int *count;		/* OUT */
{
char **argp;
char *slurpstring();
char *argvsp;
int margc;

margc = 0;
/*
Allocate space for argv and tokens in line
*/
if( xstrlen( line ) > ARGSPACE )
	{
	return( (char **)0 );
	}
argvsp = xmalloc( ARGPOINTERSP + ARGSPACE );
if( argvsp == (char *)-1 )
	{
	return( (char **)0 );
	}
argbase = &argvsp[ARGPOINTERSP];	/* store from first of buffer */
stringbase = line;			/* scan from first of buffer */
argp = (char **)argvsp;
while (*argp++ = slurpstring())
	margc++;
*count = margc;
return( (char **)argvsp );
}

/*
 * Parse string into argbuf;
 * implemented with FSM to
 * handle quoting and strings
 */
char *
slurpstring()
{
	int got_one = 0;
	register char *sb = stringbase;
	register char *ap = argbase;
	char *tmp = argbase;		/* will return this if token found */

	/*
	Used to return '!' for shell event processing...
	Ignore significance of '!'.
	*/
S0:
	switch (*sb) {

	case '\0':
		goto OUT;

	case ' ':
	case '\t':
		sb++; goto S0;

	default:
		goto S1;
	}

S1:
	switch (*sb) {

	case ' ':
	case '\t':
	case '\0':
		goto OUT;	/* end of token */

	case '\\':
		sb++; goto S2;	/* slurp next character */

	case '"':
		sb++; goto S3;	/* slurp quoted string */

	default:
		*ap++ = *sb++;	/* add character to token */
		got_one = 1;
		goto S1;
	}

S2:
	switch (*sb) {

	case '\0':
		goto OUT;

	default:
		*ap++ = *sb++;
		got_one = 1;
		goto S1;
	}

S3:
	switch (*sb) {

	case '\0':
		goto OUT;

	case '"':
		sb++; goto S1;

	default:
		*ap++ = *sb++;
		got_one = 1;
		goto S3;
	}

OUT:
	if (got_one)
		*ap++ = '\0';
	argbase = ap;			/* update storage pointer */
	stringbase = sb;		/* update scan pointer */
	if (got_one)
		return(tmp);
	return((char *)0);
}

xdealglob( pt )
/*
Free space allocated by either xglob or xmkarglist
*/

char **pt;
{

xfree( (char *)pt );
}
