/*	Copyright (c) 1985,1986,1987  EXCELAN, INC. 	*/
/*	  All Rights Reserved.                         	*/

/*	The copyright notice above does not evidence any 	*/
/*	actual or intended publication. 			*/

/*	THIS IS UNPUBLISHED COMPUTER SOFTWARE CONTAINING TRADE SECRETS 	*/
/*	AND CONFIDENTIAL INFORMATION PROPRIETARY TO EXCELAN, INC. 	*/

/* $Header: xperror.c,v 1.2 87/04/24 16:19:27 davidb Exp $ */
/*
@(#)xperror.c	1.5 6/5/85

Xperror(3X) and xrerror.
*/
#include "xgenlib.h"

char *x_errlist[] = {
" No Error ",
" Not sufficient privilege for operation ",
" No such file or directory ",
" No such process ",
" interrupted system call ",
" I/O error ",
" No such device or address ",
" Arg list too long ",
" Exec format error ",
" Bad file number ",
" No children ",
" No more processes ",
" Not enough core ",
" Permission denied ",
" Bad address ",
" Block device required ",
" Mount device busy ",
" File exists ",
" Cross-device link ",
" No such device ",
" Not a directory ",
" Is a directory ",
" Invalid argument ",
" File table overflow ",
" Too many open files ",
" Not a typewriter ",
" Text file busy ",
" File too large ",
" No space left on device ",
" Illegal seek ",
" Read only file system ",
" Too many links ",
" Broken pipe ",
" Argument too large ",
" Result too large ",
" Operation would block",
" Operation now in progress",
" Operation already in progress",
" Socket operation on non-socket",
" Destination address required",
" Message too long",
" Protocol wrong type for socket",
" Protocol not available",
" Protocol not supported",
" Socket type not supported",
" Operation not supported on socket",
" Protocol family not supported",
" Address family not supported by protocol family",
" Address already in use",
" Can't assign requested address",
" Network is down",
" Network is unreachable",
" Network dropped connection on reset",
" Software caused connection abort",
" Connection reset by peer",
" No buffer space available",
" Socket is already connected",
" Socket is not connected",
" Can't send after socket shutdown",
" Too many references: can't splice",
" Connection timed out",
" Connection refused",
" Too many levels of symbolic links",
" File name too long",
" Host is down",
" No route to host",
" File name expansion yielded wrong number of arguments",
" Unknown host name",
" Mismatch between file type and transfer parameters",
" Directory not created",
" Directory not removed",
" Working directory unknown",
};

static char bad_err[] = "UNKNOWN ERROR";

#define EOF_ERR "End of file encountered"
#define GRAN_ERR "Record bigger than request"
#define POS_ERR "Position in file unknown"
#define LOST_ERR "Data lost in lower layer"

char *xrerror();
extern char *xsyserr();

xperror( eval, rname )

int eval;
char *rname;
{
int len;
int olderrno;
char *estring;

olderrno = -eval;
len = xstrlen( rname );
if ( len > 0 )
	{
	if (xwrite( 2, rname, len ) != len )
		return;
	if (xwrite( 2, ":", 1 ) != 1 )
		return;
	}
estring = xrerror( eval );
len = xstrlen( estring  );
xwrite( 2, estring , len );
xwrite( 2, "\n", 1 );
}


char *
xrerror( eval )

int eval;
{
int olderrno;

olderrno = -eval;
if( eval == XEOF ) {
	/*
	not an error really
	*/
	return( EOF_ERR );
} else if( eval == XEGRANULARITY ) {
	return( GRAN_ERR );
} else if( eval == XENOPOSSITION ) {
	return( POS_ERR );
} else if ( eval == XELOSTDATA ) {
	return( LOST_ERR );
} else if ( eval <= XSYSERR ) {
	return( xsyserr() );
} else if( olderrno < XMINEXERR || olderrno > XMAXEXERR )
	{
	/*
	bad error number
	*/
	return( bad_err );
	}
return( x_errlist[ olderrno - XMINEXERR ] );
}
