/*	Copyright (c) 1985,1986,1987  EXCELAN, INC. 	*/
/*	  All Rights Reserved.                         	*/

/*	The copyright notice above does not evidence any 	*/
/*	actual or intended publication. 			*/

/*	THIS IS UNPUBLISHED COMPUTER SOFTWARE CONTAINING TRADE SECRETS 	*/
/*	AND CONFIDENTIAL INFORMATION PROPRIETARY TO EXCELAN, INC. 	*/

/* $Header: xraddr.c,v 1.5 87/04/27 10:29:18 davidb Exp $ */
/*
$Project: XGENLIB $

$Creator: Albert Leung $

$Locker:  $

$Source: /a/8000/8000S/sdist/src/lib/xlib/xgenlib/xraddr.c,v $

$Abstract: 
	This module tries to obtina the offical host name based on the 
internet address.

return value : 0 - host name not found
	       others - to a dynamically allocated buffer that contains the
	       official host name.

	The accepted form of internet address are:
	a.b.c.d	- 8.8.8.8 bits 
	a.b.c	- 8.8.16 bits 
	a.b	- 8.24 bits 
	a	- 32 bits
$


$Includes: 
	Xgenlib.h
$


$Dependencies: 
	This routine is system independent.  However, it relies on two
global constants, HOSTS and HOSTLOCAL, to represent where the host files
are.
$


$Files: 
$


$Implementation Notes: 
	Use XLIB to read the host files.
$



$Log:	xraddr.c,v $
 * Revision 1.5  87/04/27  10:29:18  davidb
 * Fixing copyright message
 * 
 * Revision 1.4  87/04/27  10:26:37  davidb
 * Added old copyright message
 * 
 * Revision 1.3  87/03/26  19:39:04  grant
 * Updating source from Generic trees
 * 
 * Revision 1.4  86/12/24  14:36:53  alexl
 * Allow gnaddr function to read a blank line correctly.
 * 
 * Revision 1.3  86/11/17  10:13:07  albert
 * gnaddr.c should return int instead of char *.
 * 
 * Revision 1.2  86/11/14  18:21:43  mark
 * corrected typing
 * 
 * Revision 1.1  86/11/13  13:34:52  albert
 * Initial revision
 * 


$EndLog$ 


*/


#include "xgenlib.h"

#define	NAMEBUFSIZE	255		/* size of host name buffer	*/
#define	NULL		0

extern char 		*xmalloc();
extern unsigned long 	rnumber();
extern char		*firstspace();
extern char		*xstrchr();

static int		gnaddr();

/* Data structures */
/* --------------- */


/* Variables */
/* --------- */


/* Functions */
/* --------- */


/*
$Name: xraddr - read host name from internet address $
*/

char *xraddr(iaddr)
long	iaddr;		/* internet address	*/

/* Returns official host name.

$Description: 
	See module description above.
$ 

$Return: 
	0:	error
	others: pointer to host name.
$

$Bugs: 
$


$Method: 
	If a good address is found, dynamic memory is allocated to store
the official host name.
$
*/

{

char buff[NAMEBUFSIZE];
int	status;
char	*cp;

	if ( (status = gnaddr(iaddr, buff, sizeof buff)) < 0) {
		return (char *)0;
	};

	cp = xmalloc(xstrlen(buff)+1);
	if( cp ==(char *)0 ) {
		xperror(XENOMEM, "xraddr");
		return (char *) 0;
	}
	xstrcpy(cp, buff);
	return cp;
}

/*
$Name: gnaddr - get host name from internet address $ 
*/

static int gnaddr(iaddr, name, nchars)
long	iaddr;		/* internet address */
char	*name;		/* buffer to store the official host name */
int	nchars;		/* size of the buffer	*/

/* Returns official host name.

$Description: 
	Try to parse a string and see if it is an internet address.
If it is, return the internet address.  Otherwise, return error code.
	
	The accepted form of internet address are:
	a.b.c.d	- 8.8.8.8 bits 
	a.b.c	- 8.8.16 bits 
	a.b	- 8.24 bits 
	a	- 32 bits
$ 

$Return: 
	<0 - error
	0 - no error
$

$Bugs: 
$


$Method: 
	Each number is the dot notation is evaluated independently.  Then we
form the final address based on how many numbers that we encountered.
$
*/

{
char		linebuf[NAMEBUFSIZE];	/* line buffer	*/
char 		*cp;
int 		first = 1;
long		addr;
int		od;
XFILE		*hostf;
char		*host;

	od = xdopen(HOSTS, XFREAD | XFASCII, FILE_NAME);
	if (od < 0) {
		return od;
	};

	hostf = xodopen(od, "r");
	if (hostf == (XFILE *) 0) {
		xoprintf(xstderr, "xraddr: error in opening %s for read.\n",
			HOSTS);
		return XEBADF;
	};
top:
	while (xogets(linebuf, sizeof linebuf, hostf)) {
		cp = xstrchr(linebuf, '\n');
		if (cp)
			*cp = '\0';
		if (linebuf[0] == '#')
			continue;
		if ((addr = rnumber(linebuf)) == -1)
			continue;
		if (addr != iaddr)
			continue;
		host = firstspace(linebuf);
		if(host == NULL)
			continue;
		while (isspace(*host))
		    host++;    
		cp = firstspace(host);
		if (cp)
			*cp = 0;
		if( nchars < xstrlen(host)+1 ) {
			xoprintf(xstderr,"xraddr: name %s too long.\n",
				host);
			return XENAMETOOLONG;
		}
		xstrcpy(name, host);
		xclose(xfileno(hostf));
		return 0;
	}
	if (first == 1) {
		first = 0;
		xclose(xfileno(hostf));
		od = xdopen(HOSTSLOCAL, XFREAD | XFASCII, FILE_NAME);
		if (od < 0) {
			return od;
		};

		hostf = xodopen(od, "r");
		if (hostf == (XFILE *) 0) {
			xoprintf(xstderr, 
			 "xrhost: error in opening %s for read.\n", 
			HOSTSLOCAL);
			return XEBADF;
		};
		goto  top;
	}
	xclose(xfileno(hostf));
	return XEHOSTUNKNOWN;
}

