/*	Copyright (c) 1985,1986,1987  EXCELAN, INC. 	*/
/*	  All Rights Reserved.                         	*/

/*	The copyright notice above does not evidence any 	*/
/*	actual or intended publication. 			*/

/*	THIS IS UNPUBLISHED COMPUTER SOFTWARE CONTAINING TRADE SECRETS 	*/
/*	AND CONFIDENTIAL INFORMATION PROPRIETARY TO EXCELAN, INC. 	*/

/* $Header: xrcmd.c,v 1.4 87/05/15 11:06:46 davidb Exp $ */
/*

$Header: xrcmd.c,v 1.4 87/05/15 11:06:46 davidb Exp $

$Project: xrcmd $

$Creator: $

$Locker:  $

$Source: /a/8000/8000S/sdist/src/lib/xlib/xgenlib/xrcmd.c,v $

----------------------------------------------------------------------------

(C) Copyright 1984,1985,1986 by Excelan Inc. All Rights Reserved

This software is furnished under contract and may be used and copied
only in accordance with the terms of such contract and with the
inclusion of the above copyright notice. This software or any other
copies thereof may not be provided or otherwise made available to
any other person. No title to and ownership of the software is hereby 
transferred.
----------------------------------------------------------------------------

$Abstract: 

$


$Dependencies: 
	Except for conditional includes this module is generic.
$


$Implementation Notes: 
	Apart from the fact that c-library routines and unix system
	calls are replaced by their xlib equivalents, the code is
	identical to the original bsd code.
$



$Log:	xrcmd.c,v $
 * Revision 1.4  87/05/15  11:06:46  davidb
 * PMR002078: fixed #ifdefs on the VMS side.
 * 
 * Revision 1.4  87/05/14  00:29:57  alexl
 * *** empty log message ***
 * 
 * Revision 1.4  87/05/13  23:42:16  alexl
 * *** empty log message ***
 * 
 * Revision 1.3  87/05/11  15:23:19  davidb
 * PMR002071. New copyright message
 * 
 * Revision 1.2  87/05/11  14:16:33  davidb
 * Add 5 lines to be replaced by new copyright message.
 * 
 * Revision 1.1  87/03/17  17:47:02  grant
 * Initial revision
 * 

$EndLog$ 


*/



/* Functions */
/* --------- */


/*
$Name: $
*/

/* 

$Description: 
$ 

$Return: 
	-1 on error
	socket descriptor on success.
$

$Bugs: 
$


$Method: 
$
*/

#ifdef	vms
#include	<xstdio.h>
#include	<xctype.h>
#include	<in.h>
#include	<socket.h>
#include	<xerrno.h>
#include	<xspecial.h>
#include	<xstat.h>
#include	<xdir.h>
#endif /* vms */

#ifdef DOS
#include <xstdio.h>
#include <xctype.h>
#include <sys\types.h>
#include <sys\socket.h>
#include <exos\misc.h>
#include <netinet\in.h>
#include <errno.h>
#include <xerrno.h>
#endif

#ifdef UNIX
#include <xstdio.h>
#include <xctype.h>
#include <xerrno.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <sys/soioctl.h>
#endif	/* UNIX */

extern long xrhost();

int	rcmdoptions = 0;

xrcmd(ahost, rport, locuser, remuser, cmd, fd2p)
char **ahost;			/* pointer to host name	*/
int rport;			/* port to use	*/
char *locuser;			/* local user name	*/
char *remuser;			/* remote user name	*/
char *cmd;			/* command		*/
int *fd2p;			/* ptr. to file descriptor for socket*/
{
	int s;				/* desc. for socket	*/
	int s2;				/* socket 2		*/

	int timo = 1;	/* Zilog uses 2 for timo... */
	long addr;
	struct sockaddr_in sin, sin2, from;
	int foo;
	char c;
	short port;
	int status;
	char num[8];
	int ret;
	int nbio;
	int p1;
	long readfd;

	addr = xrhost(ahost);		/* get internet address of remote host*/
	if (addr == -1) {
		xoprintf(xstderr, "%s: unknown host\n", *ahost);
		return (-1);
	}

	/* set up the port for listen	*/
retry:
	s = rresvport(rcmdoptions|SO_KEEPALIVE);

#ifdef DEBUG
	xoprintf(xstderr, "xrcmd: s=%d\n", s);
#endif

	if (s < 0)
		return (-1);
	sin.sin_family = AF_INET;
	sin.sin_addr.s_addr = addr;
	sin.sin_port = rport;
	sin.sin_port = xhtons(sin.sin_port);
#ifdef	DEBUG
	xoprintf(xstderr, "xrcmd: connecting on port %d\n", sin.sin_port);
	dumpsocket(&sin, "xrcmd: before connect");
#endif
	while ((status = xconnect(s, &sin)) < 0) 
	{
		if ((status == XECONNREFUSED) && (timo <= 16))
		{
			xclose(s);
			xsleep(timo);
			timo *= 2;
			goto retry;
		};
		/* error	*/
		xclose(s);
		xperror(status, "connect");
		return (-1);
	}

	/* connect successful	*/
	if (fd2p == 0) {
		xwrite(s, "", 1);
		port = 0;
	} 
	else {
		s2 = rresvport(rcmdoptions|SO_ACCEPTCONN);
#ifdef	DEBUG
		xoprintf(xstderr, "xrcmd: s2=%d\n", s2);
#endif
		if (s2 < 0) {	/* failed to open second port	*/
			xclose(s);
			return (-1);
		}
		if ((status = xsktaddr(s2, &sin2)) < 0) {
			xperror(status, "xrcmd");
			xexit(1);
		}
		port = sin2.sin_port;
		port = xhtons((unsigned short)port);
		xsprintf(num, "%d", port);
		xwrite(s, num, xstrlen(num)+1);
#ifndef NOSELECT
reselect:
		p1=1;
		nbio=1;
		readfd = (p1<<s2);
		if((ret=xioctl(s2,FIONBIO,&nbio)) < 0) {
			xperror(ret,"ioctl/FIONBIO");
			goto bad;
		}
		if ((ret = xselect(20,&readfd,(long *)0,100000L)) <= 0) {
			xperror(ret, "select - host failed to connect");
			xclose(s2);
			port=0;
			*fd2p=0;
			goto printerr;
		}
#endif
		if ((status = xaccept(s2, &from)) < 0) {
			xperror(status, "accept");
			goto bad;
		}
		from.sin_port = xntohs(from.sin_port);
		if (from.sin_family != AF_INET ||
		    from.sin_port >= IPPORT_RESERVED) {
			xoprintf(xstderr,
			"socket: protocol failure in circuit setup.\n");
			xoprintf(xstderr, "family=%d, port=%d\n",
			from.sin_family, from.sin_port);
			goto bad;
		}
		*fd2p = s2;
	}
	xwrite(s, locuser, xstrlen(locuser)+1);
	xwrite(s, remuser, xstrlen(remuser)+1);
	xwrite(s, cmd, xstrlen(cmd)+1);
printerr:
#ifdef	DEBUG
	xoprintf(xstderr,"xrcmd: about to read from net\n");
	foo = xread(s, &c, 1);
	xoprintf(xstderr, "xrcmd: c=%02x\n", c);
	if (foo != 1) {
		xoprintf (xstderr,"xrcmd, tried to read 1, got 0x%x\n",
		foo);
		xperror(*ahost);
		goto bad;
	}
#else
	xread(s, &c, 1);
#endif
	if (c != 0) {
		while (xread(s, &c, 1) == 1) {
			xwrite(xfileno(xstderr), &c, 1);
			if (c == '\n')
				break;
		}
		goto bad;
	}
#ifdef	DEBUG
	xoprintf(xstderr,"returning from xrcmd\n");
#endif
	return (s);
bad:
	if (port)
		xclose(*fd2p);
	xclose(s);
	return (-1);
}

rresvport(options)
int options;
{
	struct sockaddr_in sin;
	static short lport = IPPORT_RESERVED - 1;
	int s;

	for (;;) {
		sin.sin_family = AF_INET;
		sin.sin_port = lport;
		sin.sin_addr.s_addr = 0;
		sin.sin_port = xhtons(sin.sin_port);
		s = xsocket(SOCK_STREAM, (struct sockproto *)0, &sin, options);
		if (s >= 0)
			return (s);
		if ((s != XEADDRINUSE) && (s != XEADDRNOTAVAIL)) {
			xperror(s, "socket");
			return (-1);
		}
		lport--;
		if (lport == IPPORT_RESERVED/2) {
			xoprintf(xstderr, "socket: All ports in use\n");
			return (-1);
		}
	}
}

#ifdef	DEBUG
dumpsocket(sp, msg)
register struct sockaddr_in *sp;
char *msg;
{
	xoprintf(xstderr, "Dumping socket '%s':\n", msg);
	xoprintf(xstderr, "family:  %5d (%4x)\n", sp->sin_family, sp->sin_family);
	xoprintf(xstderr, "port:    %5d (%4x)\n", sp->sin_port, sp->sin_port);
	xoprintf(xstderr, "addr:    %d-%d (%x-%x)\n",
	sp->sin_addr.s_host, sp->sin_addr.s_net,
	sp->sin_addr.s_host, sp->sin_addr.s_net);
}
#endif

