/*	Copyright (c) 1985,1986,1987  EXCELAN, INC. 	*/
/*	  All Rights Reserved.                         	*/

/*	The copyright notice above does not evidence any 	*/
/*	actual or intended publication. 			*/

/*	THIS IS UNPUBLISHED COMPUTER SOFTWARE CONTAINING TRADE SECRETS 	*/
/*	AND CONFIDENTIAL INFORMATION PROPRIETARY TO EXCELAN, INC. 	*/

/* $Header: xrhost.c,v 1.5 87/04/27 10:32:47 davidb Exp $ */
/*
$Project: XGENLIB $

$Creator: Albert Leung $

$Locker:  $

$Source: /a/8000/8000S/sdist/src/lib/xlib/xgenlib/xrhost.c,v $

$Abstract: 
	This module tries to translate the input host name into an internet
address in network byte order.  The exports from this module are:

return value : -1 (host unknown or error)
	       others - internet address
nam:	       points to a dynamically allocated buffer that contains the
	       official host name.

	The original host name that is passed as the input parameter is 
'lost'.

	The accepted form of internet address are:
	a.b.c.d	- 8.8.8.8 bits 
	a.b.c	- 8.8.16 bits 
	a.b	- 8.24 bits 
	a	- 32 bits
$


$Includes: 
	Xgenlib.h
$


$Dependencies: 
	This routine is system independent.  However, it relies on two
global constants, HOSTS and HOSTLOCAL, to represent where the host files
are.
$


$Files: 
$


$Implementation Notes: 
	Use XLIB to read the host files.
$



$Log:	xrhost.c,v $
 * Revision 1.5  87/04/27  10:32:47  davidb
 * Fixing copyright message
 * 
 * Revision 1.4  87/04/27  10:26:55  davidb
 * Added old copyright message
 * 
 * Revision 1.3  87/03/26  19:39:19  grant
 * Updating source from Generic trees
 * 
 * Revision 1.5  86/12/22  16:56:28  mark
 * made rnumber static
 * 
 * Revision 1.2  86/12/22  12:40:58  mark
 * Updating source from Generic trees
 * 
 * Revision 1.4  86/12/04  10:20:24  davin
 * Fix of incorrect return of IP address per PMR1701.
 * 
 * Revision 1.3  86/11/17  10:58:22  albert
 * do not print error messages if host is not found.
 * 
 * Revision 1.2  86/11/14  18:28:38  mark
 * corrected typing
 * 
 * Revision 1.1  86/11/13  13:34:28  albert
 * Initial revision
 * 


$EndLog$ 


*/


#include "xgenlib.h"

#define	NAMEBUFSIZE	255		/* size of host name buffer	*/
#define	NULL		0

extern char 		*xmalloc();
static unsigned long 	rnumber();
extern char		*firstspace();

long xhtonl();
static long 		gnasyn();
static char		*lastspace();

/* Data structures */
/* --------------- */


/* Variables */
/* --------- */


/* Functions */
/* --------- */


/*
$Name: xrhost - read internet address from host name $
*/
extern char *xstrrchr();
extern char *xstrchr();

long xrhost(ahost)
char	**ahost;	/* host name buffer */

/* Returns internet address and the official host name.

$Description: 
	See module description above.
$ 

$Return: 
	-1:	error
	others:	internet address
$

$Bugs: 
	1. Cannot distinguish host with internet address 255.255.255.255
$


$Method: 
	If a good address is found, dynamic memory is allocated to store
the official host name.
$
*/

{

char buff[NAMEBUFSIZE];
long	iaddr;

	if ( -1 == (iaddr = gnasyn(*ahost,buff, sizeof buff)) ) {
		return -1;
	}

	*ahost = xmalloc(xstrlen(buff)+1);
	if( *ahost==(char *)0 ) {
		xperror(XENOMEM, "xrhost");
		return -1;
	}
	xstrcpy(*ahost,buff);
	return iaddr;
}

/*
$Name: gnasyn - get internet address $
*/

static long gnasyn(ahost, name, nchars)
char	*ahost;		/* host name	*/
char	*name;		/* buffer to store the official host name */
int	nchars;		/* size of the buffer	*/

/* Returns internet address and the official host name.

$Description: 
	Try to parse a string and see if it is an internet address.
If it is, return the internet address.  Otherwise, return -1.
	
	The accepted form of internet address are:
	a.b.c.d	- 8.8.8.8 bits 
	a.b.c	- 8.8.16 bits 
	a.b	- 8.24 bits 
	a	- 32 bits
$ 

$Return: 
	-1:	error
	others:	internet address
$

$Bugs: 
$


$Method: 
	Each number is the dot notation is evaluated independently.  Then we
form the final address based on how many numbers that we encountered.
$
*/


{
char		linebuf[NAMEBUFSIZE];	/* line buffer	*/
char 		*cp;
int 		first = 1;
unsigned long	addr;
int		od;
XFILE		*hostf;

	if (isdigit(*ahost) && (addr = rnumber(ahost)) != -1) {
		xstrcpy(name, ahost);
		return (addr);
	}

	od = xdopen(HOSTS, XFREAD | XFASCII, FILE_NAME);
	if (od < 0) {
		xperror(od, "xrhost");
		return -1;
	};

	hostf = xodopen(od, "r");
	if (hostf == (XFILE *) 0) {
		xoprintf(xstderr, "xrhost: error in opening %s for read.\n",
			HOSTS);
		return -1;
	};
top:
	while (xogets(linebuf, sizeof linebuf, hostf)) {
		cp = xstrchr(linebuf, '\n');
		if (cp)
			*cp = '\0';
		if (linebuf[0] == '#')
			continue;
		for (;;) {
			cp = lastspace(linebuf);
			if (cp == NULL)
				break;
			if (xstricmp(cp+1, ahost) == 0) {
				if ((addr = rnumber(linebuf)) == -1) {
					goto bad;
				};
				xclose(xfileno(hostf));
				ahost = firstspace(linebuf);
    				while (isspace(*ahost))
	    				ahost++;	/* skip more space*/
				cp = firstspace(ahost);
				if (cp)
					*cp = 0;
				if( nchars < xstrlen(ahost)+1 ) {
					xoprintf(xstderr, "xrhost: name %s too long\n",
						ahost);
					return(-1);
				}
				xstrcpy(name, ahost);
				return (addr);
			}
			*cp = 0;
		}
	}
	if (first == 1) {
		first = 0;
		xclose(xfileno(hostf));
		od = xdopen(HOSTSLOCAL, XFREAD | XFASCII, FILE_NAME);
		if (od < 0) {
			return -1;
		};

		hostf = xodopen(od, "r");
		if (hostf == (XFILE *) 0) {
			xoprintf(xstderr, 
			 	"xrhost: error in opening %s for read.\n", 
				HOSTSLOCAL);
			return -1;
		};
		goto  top;
	}
bad:
	xclose(xfileno(hostf));
	return -1;
}

static
unsigned long
rnumber(cp)
	register char *cp;
{

	 int	base;		/* base for the conversion */
unsigned long	parts[4];	/* the four parts of the internet address */
unsigned long	*pptr;		/* pointer to the parts array */
unsigned long	val;		/* current value */
	 int	npart;		/* no. of parts */
	 char	c;		/* current character */

	pptr = parts;

	/* loop for each part of the dot notation */
again:
	base = 10;
	val  = 0;

	if (*cp == '0')
		base = 8, cp++;
	if (*cp == 'x' || *cp == 'X')
		base = 16, cp++;

	while (c = *cp) {
		if (isdigit(c)) {
			val = (val * base) + (c - '0');
			cp++;
			continue;
		}
		if (base == 16 && isxdigit(c)) {
			val = (val << 4) + (c + 10 - (islower(c) ? 'a' : 'A'));
			cp++;
			continue;
		}
		break;
	}
	if (*cp == '.') {
		/*
		 * Internet format:
		 *	a.b.c.d
		 *	a.b.c	(c is 16 bits)
		 *	a.b	(b is 24 bits)
		 */
		if (pptr >= (parts + 4))
			return (-1);
		*pptr++ = val, cp++;
		goto again;
	}

	/* check for trailing characters which is not hex nor a dot.
	if (*cp && !isspace(*cp)) 
			return (-1);

	if (pp >= pplim)
		return (-1);

	/* get to last portion of the dot notation */

	*pptr++ = val;

	/* now form the final address */

	npart = pptr - parts;
	switch (npart) {
		case 1:		/* all 32 bits in number */
			val = parts[0];
			break;

		case 2:		/* a.b  as 8.32 bits */
			val = (parts[0] << 24) | (parts[1] & 0xffffff);
			break;

		case 3:		/* a.b.c as 8.8.16 bits */
			val = (parts[0] << 24) | ((parts[1] & 0xff) << 16) |
				(parts[2] & 0xffff);
			break;

		case 4:		/* a.b.c.d as 8.8.8.8 bits */
			val = (parts[0] << 24) | ((parts[1] & 0xff) << 16) |
			      ((parts[2] & 0xff) << 8) | (parts[3] & 0xff);
			break;

		default:
			return (-1);
		};
	
	return (xhtonl(val));
}
char *firstspace(buf)
char	*buf;
{
    while (*buf && (!isspace(*buf)))
	buf++;
    if (*buf == '\0')
	return(0);	    
    return(buf);
}	    

static char *lastspace(buf)
char	*buf;
{
char	*last;

    last = buf + xstrlen(buf) - 1;
    for (; last >= buf; last--)
	if (isspace(*last))
	    return(last);	    
    return(0);
}    		
