/*	Copyright (c) 1985,1986,1987  EXCELAN, INC. 	*/
/*	  All Rights Reserved.                         	*/

/*	The copyright notice above does not evidence any 	*/
/*	actual or intended publication. 			*/

/*	THIS IS UNPUBLISHED COMPUTER SOFTWARE CONTAINING TRADE SECRETS 	*/
/*	AND CONFIDENTIAL INFORMATION PROPRIETARY TO EXCELAN, INC. 	*/

/* $Header: xrshio.c,v 1.3 87/04/27 10:33:01 davidb Exp $ */
/*
$Project: rsh,data transfer control$

$Creator: $

$Locker:  $

$Source: /a/8000/8000S/sdist/src/lib/xlib/xgenlib/xrshio.c,v $

$Abstract: 
	This module performs the control functions required
	for rsh data transfer after a protocol connection between
	the local rsh and remote rshd has been established.
$


$Dependencies: 
	This module is OS dependent.
$



$Implementation Notes: 
	When xrshio gets control the socket connections between
	rsh and rshd have been established. The responsibility of
	this module is to read any input from stdin and write to
	the "stdio" socket, read any input from "stdio" and "stderr"
	sockets and write the same to the current process' stdout and
	stderr respectively and to handle any "abort" interrupt from the 
	terminal. The inputs to this routine provide addresses of
	routines to be called to perform the actual data transfer. When to
	call these routines is a decision to be made by this module.

		xrshio first sets up the terminal interrupt handler.
	If the stdin is a terminal input from stdin is done in this
	module itself. Carriage control information is translated
	to unix style line terminator upon reading a line from the
	terminal. Specifically, CR is replaced by LF.

		If the stdin is not a terminal the routine specified
	by the input parameter readstdin is called.Calling this routine
	or reading from terminal is bypassed if stdin_eof is 1.

		A xselect is performed on the two network objects
	rem and rfd2 . If either or both get selected then the 
	routine specified by readnet parameter is called passing it
	the selected mask and the original select mask. The called
	routine(readnet) can modify the original select mask and
	thus terminate the loop.
$



$Log:	xrshio.c,v $
 * Revision 1.3  87/04/27  10:33:01  davidb
 * Fixing copyright message
 * 
 * Revision 1.2  87/04/27  10:27:01  davidb
 * Added old copyright message
 * 
 * Revision 1.1  87/03/26  19:39:29  grant
 * Updating source from Generic trees
 * 
 * Revision 1.1  87/03/17  17:47:30  grant
 * Initial revision
 * 

$EndLog$ 


*/



/* Functions */
/* --------- */


/*
$Name: $
*/

/* 

$Description: 
$ 

$Return: 
$

$Bugs: 
$


$Method: 
$
*/
#include <xstdio.h>
#include <sys/soioctl.h>
#include <xerrno.h>
#include <signal.h>

static int	abort1();
static int	cpid = -1;
extern int errno;
int	(*abort)();

xrshio(remio, remerr,readnet,readstdin,rshabort,stdin_eof)
int	remio;		/* socket descriptor for I/O	*/
int	remerr;		/* socket descriptor for error	*/
int (*readnet)(),(*readstdin)(),(*rshabort)(),stdin_eof;
{
int	one = 1;
int	rval;
long	ready;
long	readfrom;


    	xioctl(remerr, FIONBIO, &one); /* set non-blocking i/o */
    	xioctl(remio, FIONBIO, &one);
	abort = rshabort;
	xint_term(abort1); /* no way to pass a param yet */

    readfrom = (1 << remio) | (1 << remerr); /* original select mask */

	if(!stdin_eof) {	/* no -n was on cmd line */
	    cpid = fork();
	    if( cpid < 0 ) {
		xperror( -errno, "rsh(fork)" );
		xexit( 1 );
	    }
    	    if ( !cpid ) {
		for( ; ; ) {
			if( !(*readstdin)() )
				break;
		}
		xioctl(remio, SIOCDONE, &one);
			/* flush output buffer	*/
		xioctl(remio, FIONBIO, &one);
		xexit( 0 );
	    }
	}
	do {
	/* now select from network */

	ready = readfrom; /* make copy of original select mask */
	rval = xselect(32, &ready, (long *) 0, 1000L); /* sel w/1sec timeout */
	if (rval < 0)
	    xperror(rval, "select");
	if (rval == 0) /* nothing selected, keep trying */
	    continue;
	(*readnet)(ready,&readfrom); /* transfer data from selected socket(s)*/

    } while (readfrom);
    kill( cpid, SIGKILL );
}
clientinit()
{
}

/***
	abort1-- intermediate interrupt handling routine
	so that a param could be passed to the actual rshabort
	routine. 
***/
static abort1()
{
	char byte = 9;

	if( cpid && cpid != -1 )
		kill( cpid, SIGKILL ); 
	(*abort)(byte);
	kill( getpid(), SIGKILL );
}
