/*	Copyright (c) 1985,1986,1987  EXCELAN, INC. 	*/
/*	  All Rights Reserved.                         	*/

/*	The copyright notice above does not evidence any 	*/
/*	actual or intended publication. 			*/

/*	THIS IS UNPUBLISHED COMPUTER SOFTWARE CONTAINING TRADE SECRETS 	*/
/*	AND CONFIDENTIAL INFORMATION PROPRIETARY TO EXCELAN, INC. 	*/

/* $Header: xruserok.c,v 1.4 87/05/15 11:07:01 davidb Exp $ */
/*

$Header: xruserok.c,v 1.4 87/05/15 11:07:01 davidb Exp $

$Project: xruserok$

$Creator: $

$Locker:  $

$Source: /a/8000/8000S/sdist/src/lib/xlib/xgenlib/xruserok.c,v $

----------------------------------------------------------------------------

(C) Copyright 1984,1985,1986 by Excelan Inc. All Rights Reserved

This software is furnished under contract and may be used and copied
only in accordance with the terms of such contract and with the
inclusion of the above copyright notice. This software or any other
copies thereof may not be provided or otherwise made available to
any other person. No title to and ownership of the software is hereby 
transferred.
----------------------------------------------------------------------------

$Abstract: 

$


$Dependencies: 
	Except for conditional includes this module is generic.
$


$Implementation Notes: 
	Apart from the fact that c-library routines and unix system
	calls are replaced by their xlib equivalents, the code is
	identical to the original bsd code.
$



$Log:	xruserok.c,v $
 * Revision 1.4  87/05/15  11:07:01  davidb
 * PMR002078: fixed #ifdefs on the VMS side.
 * 
 * Revision 1.4  87/05/14  00:30:04  alexl
 * *** empty log message ***
 * 
 * Revision 1.4  87/05/13  23:47:14  alexl
 * *** empty log message ***
 * 
 * Revision 1.3  87/05/11  15:23:52  davidb
 * PMR002071. New copyright message
 * 
 * Revision 1.2  87/05/11  14:16:43  davidb
 * Add 5 lines to be replaced by new copyright message.
 * 
 * Revision 1.1  87/03/17  17:47:44  grant
 * Initial revision
 * 
 * Revision 1.1  86/12/09  15:16:49  rajeev
 * Initial revision
 * 

$EndLog$ 


*/



/* Functions */
/* --------- */


/*
$Name: $
*/

/* 

$Description: 
$ 

$Return: 
	-1 on error
	0 on success
$

$Bugs: 
$


$Method: 
$
*/

#ifdef	vms
#include	<xstdio.h>
#include	<xctype.h>
#include	<in.h>
#include	<socket.h>
#include	<xerrno.h>
#include	<xspecial.h>
#include	<xstat.h>
#include	<xdir.h>
#include	<soioctl.h>
#define	NUMSOCKETS 20
#define HOSTSEQUIV "EXOS$ETC:HOSTS.EQUIV"
#define SUPERUSER "SYSTEM"
#endif /* vms */

#ifdef DOS
#include <xstdio.h>
#include <xctype.h>
#include <sys\types.h>
#include <sys\socket.h>
#include <exos\misc.h>
#include <netinet\in.h>
#include <errno.h>
#include <xerrno.h>
#define	NUMSOCKETS 16
#endif	/* DOS */

#ifdef UNIX
#include <xstdio.h>
#include <xctype.h>
#include <xerrno.h>
#include <xspecial.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <sys/soioctl.h>
#define	NUMSOCKETS 20
#define HOSTSEQUIV "/etc/hosts.equiv"
#define SUPERUSER "root"
#endif	/* UNIX */

extern long xrhost();




char	*xsprintf();

char * firstwhite();
char * skipwhite();
extern char *xstrchr();
#define NULL	0

xruserok(rhost, ruser, luser)
	char *rhost, *ruser, *luser;
{
	XFILE *hostf;
	int fd;
	char ahost[128];
	int first = 1; 

	fd = xdopen(HOSTSEQUIV,XFREAD|XFASCII,FILE_NAME);
	if (fd <0) 
		goto try_rhost;
	hostf = xodopen(fd,"r");
	if (hostf == (XFILE *)NULL) return (-1);
again:
		while (xogets(ahost, sizeof (ahost), hostf)) {
			char *user, *buf;
			buf = ahost;
			if (xstrchr(buf, '\n'))
				*xstrchr(buf, '\n') = 0;
			buf = firstwhite(buf, ' ');
			if (buf)
				*buf++ = 0;
			buf = skipwhite(buf, ' ');
			user = buf;
			buf = firstwhite(buf, ' ');
			if(buf)
				*buf = 0;
			if (!xstrcmp(rhost, ahost) &&
			    !xstrcmp(ruser, user ? user : luser))
			    /*
			    be paranoid about giving system privleges
			    */
				if( !first || 
					xstrcmp( SUPERUSER, user ? user: luser) )
				goto ok;
		}
		xclose(hostf);

try_rhost:

	if (first == 1) {
		first = 0;
		fd = xdopen(".rhosts",XFREAD|XFASCII,FILE_NAME);
		if (fd <0) 
			return (-1);
		hostf = xodopen(fd,"r");
		if (hostf == (XFILE *)NULL) return (-1);
		goto again;
	}

	return (-1);
ok:
	xclose(hostf);
	return (0);
}


static char *
skipwhite( cpt )

char *cpt;
{

	while( cpt && ( *cpt == ' ' || *cpt == '\t' ))
		++cpt;
	return ( cpt );
}


static char *
firstwhite( cpt, ch )
/*
find first white space
*/

char *cpt;
char ch;
{

	while( cpt && *cpt && *cpt != ' ' && *cpt != '\t' )
		++cpt;
	if ( cpt && *cpt ) {
		return( cpt );
	}
	return ( NULL );
}
