/*	Copyright (c) 1985,1986,1987  EXCELAN, INC. 	*/
/*	  All Rights Reserved.                         	*/

/*	The copyright notice above does not evidence any 	*/
/*	actual or intended publication. 			*/

/*	THIS IS UNPUBLISHED COMPUTER SOFTWARE CONTAINING TRADE SECRETS 	*/
/*	AND CONFIDENTIAL INFORMATION PROPRIETARY TO EXCELAN, INC. 	*/

/* $Header: xtelioctl.c,v 1.4 87/04/24 16:47:22 davidb Exp $ */


/*
$Header: xtelioctl.c,v 1.4 87/04/24 16:47:22 davidb Exp $
$Log:	xtelioctl.c,v $
 * Revision 1.4  87/04/24  16:47:22  davidb
 * Fixing copyright message
 * 
 * Revision 1.3  87/03/26  19:40:05  grant
 * Updating source from Generic trees
 * 
 * Revision 1.2  87/01/19  16:49:19  grant
 * davidb's cleanup. header stuff.
 * 
 * Revision 1.7  86/12/19  18:00:35  davidb
 * Updating source from Generic trees
 * 
 * Revision 1.3  86/11/05  08:27:54  alexl
 * Updating source from Generic trees
 * 
 * Revision 1.1  86/10/08  10:50:22  mark
 * merging in changes for new ftp
 * 
 * Revision 1.3  86/09/19  10:15:34  albert
 * allow Excelan's standard include file specification.
 * 
 * Revision 1.2  86/09/10  10:44:47  albert
 * use Excelan's standard style of include specification.
 * 
 * Revision 1.1  86/09/04  16:19:33  albert
 * first working version
 * 
 * Revision 1.2  86/08/25  17:46:51  mark
 * syncing revision level
 * 
 * Revision 1.1  86/04/18  19:13:01  mark
 * Initial revision
 * 
*/

#ifdef	vms
#include "h_xlib/xstdio.h"
#include "h_xlib/xerrno.h"
#include "h_xlib/telnet.h"
#include "h_xlib/soioctl.h"
#else	/* vms */
#include <xstdio.h>
#include <xerrno.h>
#include <xtelnet.h> 	/* Xlib specific stuff. Used to be in */
#include <arpa/telnet.h> /* include/EXOS/telnet.h. dab 861125. */
#include <sys/soioctl.h>
#endif	/* vms */

xtelioctl( sys_id, cmd, param )
register struct tel_state *sys_id;
int cmd;
char *param;
{
	char buf[3];		/* for ouput on telnet socket */
	int amount;		/* to output to telnet socket */
	int rval = 0;

	if( !sys_id )
		return( XEBADF );
	/*
	we assume that we are going to do option negotation.
	if this is not the case, we correct for it in the
	switch below.
	*/
	buf[0] = IAC;
	buf[1] = cmd;
	buf[2] = *param;
	amount = 3;
	switch( cmd ) {
		case DO:
			break;
		case DONT:
			break;
		case WILL:
			break;
		case WONT:
			break;
		case XREAL_OD:
			/*
			return underlying object descriptor
			*/
			*((int *)param) = sys_id->od;
			amount = 0;
			break;
		case XSTELESC:
			/*
			set escape character
			*/
			sys_id->escape = *param;
			amount = 0;
			break;
		case XGTELESC:
			/*
			get escape character
			*/
			*param = sys_id->escape;
			amount = 0;
			break;
		/*
		Need to add code for sending IP, and perhaps other telnet
		commands of interest.
		*/
		case IP:
			buf[1] = IP;
			rval = xwrite( sys_id->od, buf, 2 );
			if( rval < 0 )
				return( rval );
			/*
			send DM as OOB byte
			*/
			buf[0] = DM;
			rval = xioctl( sys_id->od, SIOCSENDOOB, buf );
			if( rval < 0 )
				return( rval );
			amount = 0;
			break;
		case SIOCRCVOOB:
			rval = xioctl( sys_id->od, SIOCRCVOOB, buf );
			if( rval < 0 )
				return( rval );
			*param = buf[0];
			if( (buf[0] & 0xff) == DM ) {
				(*sys_id->nvt_action)(sys_id, DM, DM);
			} else {
				_xtelstate( sys_id, buf[0] & 0xff );
			}
			amount = 0;
			break;
		default:
			/*
			command may be intended for a lower level xioctl,
			let the lower level decide what to do.
			*/
			rval = xioctl( sys_id->od, cmd, param );
			amount = 0;
			break;
	}
	if( amount )
		rval = xwrite( sys_id->od, buf, amount );
	return( rval );
}
