/*	Copyright (c) 1985,1986,1987  EXCELAN, INC. 	*/
/*	  All Rights Reserved.                         	*/

/*	The copyright notice above does not evidence any 	*/
/*	actual or intended publication. 			*/

/*	THIS IS UNPUBLISHED COMPUTER SOFTWARE CONTAINING TRADE SECRETS 	*/
/*	AND CONFIDENTIAL INFORMATION PROPRIETARY TO EXCELAN, INC. 	*/

/* $Header: xaccess.c,v 1.2 87/04/24 16:48:58 davidb Exp $ */
/*
@(#)xaccess.c	1.4 3/29/85

Unix version of routine to check access rights.
*/

#include <xspecial.h>
#include <xerrno.h>
#include <ex_errno.h>	/* Contains constants used by XMAPERRNO(). */
#include <UnixXos.h>	/* Contains XMAPERRNO(). dab 861219. */

#include <sys/types.h>
#include <sys/stat.h>

extern int errno;

xaccess( name, special, mode )

char *name;
int special;
int mode;
{
register int rval;
char buf[ MXNAMELEN + 1 ];

/*
modify name (if necessary) for special meanings
*/
rval = xmodname( &name, special, buf, sizeof( buf ) );
if ( rval < 0 )
	return( rval );
/*
special handling for permission to change directory to.
*/
if( mode & 0x8 )
	{
	/*
	first check that file is directory, then check if it
	is executable.
	*/
	struct stat statbuf;

	if( stat( name, &statbuf ) < 0 )
		return( XMAPERRNO(errno) );
	if( statbuf.st_mode & 0040000 )
		{
		/*
		file is a directory
		*/
		mode = 1;	/* Unix for check execute permission */
		}
	else
		{
		return( XENOTDIR );
		}
	}
else
	{
	mode &= 0x6;	/* just pass read/write mode settings on */
	}
rval = access( name, mode );
if( rval < 0 )
	return( XMAPERRNO(errno) );
return( rval );
}
