/*	Copyright (c) 1985,1986,1987  EXCELAN, INC. 	*/
/*	  All Rights Reserved.                         	*/

/*	The copyright notice above does not evidence any 	*/
/*	actual or intended publication. 			*/

/*	THIS IS UNPUBLISHED COMPUTER SOFTWARE CONTAINING TRADE SECRETS 	*/
/*	AND CONFIDENTIAL INFORMATION PROPRIETARY TO EXCELAN, INC. 	*/

/* $Header: xpsuedof.c,v 1.2 87/04/24 16:52:26 davidb Exp $ */
/*
@(#)xpsuedof.c	1.4 3/29/85

Unix implementation of Psuedo file generation.\
At the moment xls and xpwd.
*/
#include <xstdio.h>
#include <xspecial.h>
#include <xerrno.h>
#include <ex_errno.h>	/* Contains constants used by XMAPERRNO(). */
#include <UnixXos.h>	/* Contains XMAPERRNO(). dab 861219. */
#include <stdio.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>

extern FILE *popen();

extern int errno;

#ifdef SYSTEM5
static char lslong_flags[] = "-l";
static char lsdlong_flags[] = "-ld";
#else
static char lsdlong_flags[] = "-ld";
static char lslong_flags[] = "-lg";
#endif

xls( od, name, code, dircheck )

int od;
char *name;
int code;
int dircheck;	/* if true, list directory not contents */
{
char *arg;
struct stat stbuf;
int rval;

if( od < 0 || od >= _XNFILE )
	return( XEBADF );
switch( code ) {
	case LS:
		arg = (char *)0;
		break;
	case LS_ARG:
		/*
		Just return the name of plain files
		*/
		if( name )
			{
			if ( (rval = stat( name, &stbuf )) < 0 )
				{
				return( XMAPERRNO(errno) );
				}
			if( !( stbuf.st_mode & 040000 ) || dircheck )
				{
				/*
				is not a directory
				*/
				xwrite( od, name, xstrlen( name ) );
				xwrite( od, "\n", 1 );
				return( 0 );
				}
			}
		arg = (char *)0;
		break;
	case LSLONG:
	case LSLONG_ARG:
		arg = (dircheck)? lsdlong_flags : lslong_flags;
		break;
	default:
		return( XEINVAL );
	}
return( xpfdump( (int)(_xiob[od]._sys_id), "/bin/ls", arg, name ));
}

xpwd( path, pathlen, code )

char *path;
int pathlen;
int code;
{
char *arg;
char *p;
char *pend;
extern char *getwd();

switch( code ) {
	case PWD:
		arg = (char *)0;
		break;
	default:
		return( XEINVAL );
	}
#ifdef SIGH
	p = getwd(path);
#else
	/* mumble */
	p = path;
	pend = &path[ pathlen ];
	{
		FILE *f;
		int c;

		if ((f = popen("/bin/pwd", "r")) == NULL) {
			p = NULL;
			strcpy("can't find /bin/pwd\n", path);
		}
		else {
			while ((c = getc(f)) != EOF)
				{
				if( p != pend )
					*p++ = c;
				}
			*(--p) = 0;
			pclose(f);
		}
	}
#endif
return( 0 );
}

xpfdump( fd, cmd, flags, arg1 )

int fd;
char *cmd;
char *flags;
char *arg1;
{
char *av[5];
int i;
int pid;
int status;
int rval;

if( (pid = fork()) < 0 )
	return( XMAPERRNO(errno) );
if( !pid )
	{
	/*
	make netword std* for command.
	*/
	if( fd != 0 )
		{
		close( 0 );
		dup( fd, 0 );
		}
	if( fd != 1 )
		{
		close( 1 );
		dup( fd, 1 );
		}
	if( fd != 2 )
		{
		close( 2 );
		dup( fd, 2 );
		}
	/*
	close all other files
	*/
	for( i = 3; i < 20 ; ++i )
		close( i );
	i = 0;
	av[i++] = cmd;
	if( flags )
		av[i++] = flags;
	if( arg1 )
		av[i++] = arg1;
	av[i++] = (char *)0;
	execv( cmd, av );
	}
do {
	rval = wait( &status );
	} while( errno != ECHILD );
return( 0 );
}
