/*	Copyright (c) 1985,1986,1987  EXCELAN, INC. 	*/
/*	  All Rights Reserved.                         	*/

/*	The copyright notice above does not evidence any 	*/
/*	actual or intended publication. 			*/

/*	THIS IS UNPUBLISHED COMPUTER SOFTWARE CONTAINING TRADE SECRETS 	*/
/*	AND CONFIDENTIAL INFORMATION PROPRIETARY TO EXCELAN, INC. 	*/

/* $Header: xselect.c,v 1.3 87/04/24 16:52:42 davidb Exp $ */
/*
@(#)xselect.c	1.8 7/15/85

Xselect(3X) for Unix.
*/
#include <xstdio.h>
#include <xerrno.h>
#include <ex_errno.h>	/* Contains constants used by XMAPERRNO(). */
#include <UnixXos.h>	/* Contains XMAPERRNO(). dab 861219. */
#include <sys/socket.h>

extern int errno;

xselect( nfds, readfds, writefds, timeout )

int nfds;
long *readfds;
long *writefds;
long timeout;
{
int rval;
long rreadfds = 0;
long rwritefds = 0;
long oreadfds = (readfds)? *readfds : 0 ;
long owritefds = (writefds)? *writefds : 0;
register XFILE *file;
int fd;
int i, j;

/*
Form real select masks.
*/
for ( i = 0 ; i < _XNFILE ; ++i )
	{
	if( readfds && ( *readfds & ( 1 << i )) )
		{
		fd = getfd( i );
		if( fd < 0 )
			return( XEBADF );
		rreadfds |= 1L << (long)fd;
		}
	if( writefds && ( *writefds & ( 1 << i )) )
		{
		fd = getfd( i );
		if( fd < 0 )
			return( XEBADF );
		rwritefds |= 1L << (long)fd;
		}
	}
rval = select( nfds, (rreadfds)? &rreadfds : (long *)0,
	(rwritefds)? &rwritefds : (long *)0, timeout );
if( readfds )
	*readfds = 0;
if( writefds )
	*writefds = 0;
if ( rval < 0 )
 	return( XMAPERRNO(errno) );
if( rval == 0 )
	return( rval );
/*
Form masks to return to user.
*/
rval = 0;
for ( i = 0 ; i < 20 ; ++i )
	{
	if( rreadfds & ( 1 << i ) )
		{
		for( j = 0 ; j < _XNFILE ; j++ )
			{
			file = &_xiob[j];
			if( (file->_flag & _XUsed) &&
				getfd( j ) == i &&
				(oreadfds & ( 1L << (long)j)) )
				{
				*readfds |= 1 << j;
				++rval;
				}
			}
		}
	if( rwritefds & ( 1 << i ) )
		{
		for( j = 0 ; j < _XNFILE ; j++ )
			{
			file = &_xiob[j];
			if( (file->_flag & _XUsed) &&
				getfd( j ) == i &&
				(owritefds & ( 1L << (long)j)) )
				{
				*writefds |= 1 << j;
				++rval;
				}
			}
		}
	}
return( rval );
}
