#
# $Revision:   1.30  $
#	$Author:   ctaylor  $
#	  $Date:   18 Feb 1992 18:27:36  $
#
# 	Makefile for the Kernel Projects
#

### 	Common Defines that can be overridden	 ###

## To Do:
#		Allow the PATH in the env to be used
#		echoing path breaks DOS.  Line too long.

.MEMSWAP

.INIT:
	%do setFlags
	%do showFlags

ARCH		=	386
PENPOINT_PATH = \$(ARCH)\penpoint
GO_PATH		=	\$(ARCH)\go
KERNEL_PATH	=	\kernel.$(ARCH)

SDK			=	$(PENPOINT_PATH)\sdk
BOOT		=	$(PENPOINT_PATH)\boot

INC			=	$(SDK)\inc
LIBR		=	$(SDK)\lib

PINC		=	$(GO_PATH)\pinc
PLIB		=	$(GO_PATH)\plib
PLIB_OUT	=	$(GO_PATH)\plib

WCC			=	c:\w9.0

MSC			=	c:\msc6.0

# CT specials
%if %exists(\kbuild)
PATH		=	$(WCC)\bin;c:\dos;c:\mks\bin;c:\polymake;c:\masm6.0
%endif

# CT specials
%if %exists(\kbuild)
  KBUILD	= \kbuild
%else
  KBUILD	= $(GO_PATH)\kbuild
%endif

%if "$(MODE)" == "production"
 KLIB		= 	$(KBUILD)\obj
 OBJ        =	relobj
 OBJ_OUT	=	$(OBJ)
 TST_OUT	=	relexe
 OPT		=	-D1 -Otaxf+ -Fpc
 ASM_OPT	=
%elseif "$(MODE)" == "debug"
 KLIB		= 	$(KBUILD)\dbgobj
 DOBJ    	=	obj
 OBJ_OUT	=	$(DOBJ)
 TST_OUT	=	exe
 OPT		=	-D1 -Otaxf+ -Fpc -En -DDEBUG
 ASM_OPT	=	-DDEBUG
%else
 KLIB		= 	$(KBUILD)\dbgobj
 OBJ_OUT	=	obj
 TST_OUT	=	exe
 OPT		=	-D1 -Otaxf+ -Fpc -En -DDEBUG -DNO_GRANDFATHER
 ASM_OPT	=	-DDEBUG
%endif

### 	Derived names	###

EXPORTS		=	$(SDK_INCS) $(GO_INCS) $(KBUILD_IMP)

VCS_INCS	=	$(SDK_INCS) $(GO_INCS) $(PVT_INCS) $(TST_INCS)

VCS_SRCS	=	$(R3_SRCS) $(R0_SRCS) $(TST_SRCS) $(VCS_OT_SRCS)

LIB3_OBJS	=	$[f,$(OBJ_OUT),$(R3_SRCS) $(R3_OT_SRCS),obj]
LIB0_OBJS	=	$[f,$(OBJ_OUT),$(R0_SRCS) $(R0_OT_SRCS),obj]

TST_OBJS	=	$[f,$(TST_OUT),$(TST_SRCS) $(TST_OT_SRCS),obj]

INCLUDE		=	.;$(PINC);$(INC)

FL386		=	-3s -Sg $(OPT) -W3 -We -Zc -Zq $(C_DEFINES)
#FL386		=	-3s -Za -Sg $(OPT) -W3 -We -Zc -Zq $(C_DEFINES)
ASM_FLAGS	=	$(ASM_OPT) -W3 -Cx -c -nologo -Zm $(ASM_DEFINES)

CC386		= 	wcc386p
LIB386		=	wlib
LINK386		=	wlink

CLDOS		=	/c /Alfw /G2sc /W3 /Zp /Oxw /nologo
CCDOS		= 	cl


#
# Rules
#

local:: exports libs

%if "$(EXPORTS)" != "  "		#FX
exports:: $(EXPORTS)
%else
exports:
%endif

everything release:: libs

showFlags:
#CT special
%if %exists(\kbuild)
	@echo PATH=$(PATH)
	@echo WCC386=$(FL386)
	@echo INCLUDE=$(INCLUDE)
%endif

setFlags:
	@%setenv PATH=$(PATH)
	@%setenv WCC386=$(FL386)
	@%setenv INCLUDE=$(INCLUDE)

copyq: $(KBUILD_LIB3) $(KBUILD_LIB0) $(KBUILD_IMP)
	!cp -pf $? q:\transit\kbuild\dbgobj

copyn:
	cp -p $(KBUILD_LIB3) $(KBUILD_LIB0) n:\public\go\386\go\plib
	%if "$(SDK_INCS)" != ""
	  cp -p $(SDK_INCS) n:\public\go\386\penpoint\inc
	%endif
	%if "$(GO_INCS)" != ""
	  cp -p $(GO_INCS) n:\public\go\386\go\pinc
	%endif

checkout: $(VCS_INCS) $(VCS_SRCS) $(SUPPORT_FILES)
	!-n:\public\tools\pvcs\get -Cvcs.cfg -l ($?)

#checkin: $(VCS_INCS) $(VCS_SRCS) $(SUPPORT_FILES)
#	w:kanban $(VCSID) Yes -c <@<
#		$[s,"\n",$(VCS_INCS) $(VCS_SRCS) $(SUPPORT_FILES)]
#<

checkin: $(VCS_INCS) $(VCS_SRCS) $(SUPPORT_FILES)
	!-n:\public\tools\pvcs\put -Cvcs.cfg -Vrelease -M"-" -Y ($?)

checknew: $(VCS_INCS) $(VCS_SRCS) $(SUPPORT_FILES)
	!-n:\public\tools\pvcs\vcs -Cvcs.cfg -T"New src for 386" -I ($?)

diff: $(VCS_INCS) $(VCS_SRCS) $(SUPPORT_FILES)
	!-n:\public\tools\pvcs\vdiff -Cvcs.cfg -R $?

latest: $(VCS_INCS) $(VCS_SRCS) $(SUPPORT_FILES)
	!-n:\public\tools\pvcs\get -Cvcs.cfg $?

clean: rmlibs
	-@rm -f $(OBJ_OUT)\*.*
	-@rm -f $(TST_OUT)\*.*
	-@rm -f *.i *.cod *.tmp *.lst *.err s_*.c
	%do ot_clean

rmlibs:				# Force new libs to be built from scratch
	-@rm -f $(KBUILD_LIB3) $(KBUILD_LIB0) $(KBUILD_IMP)

touch t:
	%foreach file in $(LIB3_OBJS) $(LIB0_OBJS) $(KBUILD_LIB3) $(KBUILD_LIB0) \
					 $(OT_SRCS) asm.upd $(TST_OBJS)
	touch -c $(file)
	%endfor

#
#	Dependencies
#

libs: $(KBUILD_LIB3) $(KBUILD_LIB0)

$(KBUILD_LIB3): $(LIB3_OBJS)
	$(LIB386) -b -q $(KBUILD_LIB3) <@<
	-+$[s,"\n	-+",$?]
<

$(KBUILD_LIB0): $(LIB0_OBJS)
	$(LIB386) -b -q $(KBUILD_LIB0) <@<
	-+$[s,"\n	-+",$?]
<


###		Implicit rules		###

.tbl.obj:
	@%setenv INCLUDE=$(INCLUDE)
	@%setenv PENPOINT_PATH=$(PENPOINT_PATH)
	$(SDK)\util\clsmgr\mt $(MT_FLAGS) $< -Fo=$*.obj

## Generate table only
.tbl.tc:
	@%setenv INCLUDE=$(INCLUDE)
	@%setenv PENPOINT_PATH=$(PENPOINT_PATH)
	$(SDK)\util\clsmgr\mt $(MT_FLAGS) /I $< -Fo=$*.tc

.asm.obj:
	ml $(ASM_FLAGS) -Fo$@ $[r,$*].asm

.c.obj:
	$(CC386) -Fo=$*.obj $<

.c.cpp:
	$(CC386) /p -Fo=$*.cpp $[r,$*].c

.c.cod:
	@%echo WCC386=$(FL386)
	$(CC386) -Fo=$*.obj $<
	wdisasm $*.obj /s > $[r,$*].cod
	rm -f $*.obj

# Use the .lbc file if it exists
%if %exists(\kbuild)
.lib : .lbc   # This screws up the build's builtins.mak
%endif

.lbc.lib:
	$(LIB386) -b -q -n $@ @$<

.obj.lib:
	$(LIB386) -b -q $@ <@<
	-+$[s,"\n	-+",$?]
<

#----------------------------------------------------------------------
